/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dods;

import dods.dap.BaseType;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.DString;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.Slice0DataSet;
import org.virbo.dataset.TrimDataSet;
import org.virbo.dataset.WritableDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DodsVarDataSet
implements WritableDataSet {
    int rank;
    int[] dimSizes = new int[4];
    HashMap properties;

    public DodsVarDataSet(DArray array) {
        int idim = 0;
        Enumeration enumm = array.getDimensions();
        while (enumm.hasMoreElements()) {
            DArrayDimension dd = (DArrayDimension)enumm.nextElement();
            this.dimSizes[idim++] = dd.getSize();
        }
        this.rank = array.numDimensions();
        this.properties = new HashMap();
        if (this.rank > 1) {
            this.properties.put("QUBE", Boolean.TRUE);
        }
        this.properties.put("NAME", array.getName());
    }

    public String toString() {
        StringBuffer dimStr = new StringBuffer("" + this.dimSizes[0]);
        for (int i = 1; i < this.rank; ++i) {
            dimStr.append("," + this.dimSizes[i]);
        }
        String u = String.valueOf(this.properties.get("UNITS"));
        if (u.equals("null") || u == "") {
            u = "dimensionless";
        }
        return "dataSet[" + dimStr.toString() + "] (" + u + ")";
    }

    public int rank() {
        return this.rank;
    }

    public abstract double value(int var1);

    public abstract double value(int var1, int var2);

    public abstract double value(int var1, int var2, int var3);

    public abstract double value(int var1, int var2, int var3, int var4);

    public void putValue(int i0, int i1, int i2, int i3, double v) {
        throw new IllegalArgumentException("rank limit");
    }

    public Object property(String name) {
        return this.properties.get(name);
    }

    public Object property(String name, int i) {
        return this.property(name);
    }

    public Object property(String name, int i0, int i1) {
        return this.property(name);
    }

    public Object property(String name, int i0, int i1, int i2) {
        return this.property(name);
    }

    public Object property(String name, int i0, int i1, int i2, int i3) {
        return this.property(name);
    }

    public void putProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void putProperty(String name, int i, Object value) {
        this.putProperty(name, value);
    }

    public void putProperty(String name, int i0, int i1, Object value) {
        this.putProperty(name, value);
    }

    public void putProperty(String name, int i0, int i1, int i2, Object value) {
        this.putProperty(name, value);
    }

    public void putProperty(String name, int i0, int i1, int i2, int i3, Object value) {
        this.putProperty(name, value);
    }

    public int length() {
        return this.dimSizes[0];
    }

    public int length(int i) {
        return this.dimSizes[1];
    }

    public int length(int i0, int i1) {
        return this.dimSizes[2];
    }

    public int length(int i0, int i1, int i2) {
        throw new IllegalArgumentException("rank limit");
    }

    public <T> T capability(Class<T> clazz) {
        return null;
    }

    public QDataSet slice(int i) {
        return new Slice0DataSet((QDataSet)this, i);
    }

    public QDataSet trim(int start, int end) {
        return new TrimDataSet((QDataSet)this, start, end);
    }

    static DodsVarDataSet newDataSet(DArray z, HashMap properties) {
        Object o = z.getPrimitiveVector().getInternalStorage();
        if (o instanceof double[]) {
            DDataSet.wrap((double[])((double[])o));
            return new DoubleArray(z, properties);
        }
        if (o instanceof float[]) {
            return new FloatArray(z, properties);
        }
        if (o instanceof short[]) {
            return new Int16Array(z, properties);
        }
        if (o instanceof int[]) {
            return new Int32Array(z, properties);
        }
        if (o instanceof BaseType[]) {
            BaseType[] bta = (BaseType[])o;
            BaseType bt1 = bta[0];
            if (bt1 instanceof DString) {
                if (properties.get("UNITS") == null) {
                    return new NominalStringArray(z, properties);
                }
                return new EpochStringArray(z, properties);
            }
            throw new IllegalArgumentException("not supported: " + o);
        }
        throw new IllegalArgumentException("not supported: " + o);
    }

    public static class EpochStringArray
    extends DodsVarDataSet {
        BaseType[] back;
        Units u;

        public EpochStringArray(DArray array, HashMap properties) {
            super(array);
            this.back = (BaseType[])array.getPrimitiveVector().getInternalStorage();
            this.properties.putAll(properties);
            this.u = Units.us2000;
            this.properties.put("UNITS", this.u);
        }

        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public double value(int i) {
            try {
                return this.u.parse(((DString)this.back[i]).getValue()).doubleValue(this.u);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }

        public double value(int i0, int i1) {
            throw new IllegalArgumentException("not supported");
        }

        public double value(int i0, int i1, int i2) {
            throw new IllegalArgumentException("not supported");
        }

        public double value(int i0, int i1, int i2, int i3) {
            throw new IllegalArgumentException("not supported");
        }

        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public void putValue(int i0, double d) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void putValue(int i0, int i1, double d) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void putValue(int i0, int i1, int i2, double d) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class NominalStringArray
    extends DodsVarDataSet {
        BaseType[] back;
        EnumerationUnits u;

        public NominalStringArray(DArray array, HashMap properties) {
            super(array);
            this.back = (BaseType[])array.getPrimitiveVector().getInternalStorage();
            this.properties.putAll(properties);
            this.u = new EnumerationUnits("dods");
            for (int i = 0; i < this.back.length; ++i) {
                DString bt1 = (DString)this.back[i];
                this.u.createDatum((Object)bt1.getValue());
            }
            this.properties.put("UNITS", this.u);
        }

        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public double value(int i) {
            return this.u.createDatum((Object)((DString)this.back[i]).getValue()).doubleValue((Units)this.u);
        }

        public double value(int i0, int i1) {
            throw new IllegalArgumentException("not supported");
        }

        public double value(int i0, int i1, int i2) {
            throw new IllegalArgumentException("not supported");
        }

        public double value(int i0, int i1, int i2, int i3) {
            throw new IllegalArgumentException("not supported");
        }

        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public void putValue(int i0, double d) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void putValue(int i0, int i1, double d) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void putValue(int i0, int i1, int i2, double d) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class DoubleArray
    extends DodsVarDataSet {
        double[] back;

        public DoubleArray(DArray array, HashMap properties) {
            super(array);
            this.back = (double[])array.getPrimitiveVector().getInternalStorage();
            this.properties.putAll(properties);
        }

        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public double value(int i) {
            return this.back[i];
        }

        public double value(int i0, int i1) {
            return this.back[i0 * this.dimSizes[1] + i1];
        }

        public double value(int i0, int i1, int i2) {
            return this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2];
        }

        public double value(int i0, int i1, int i2, int i3) {
            return this.back[i0 * this.dimSizes[1] * this.dimSizes[2] * this.dimSizes[3] + i1 * this.dimSizes[1] * this.dimSizes[2] + i2 * this.dimSizes[2] + i3];
        }

        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public void putValue(int i0, double d) {
            this.back[i0] = d;
        }

        public void putValue(int i0, int i1, double d) {
            this.back[i0 * this.dimSizes[1] + i1] = d;
        }

        public void putValue(int i0, int i1, int i2, double d) {
            this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2] = d;
        }
    }

    public static class FloatArray
    extends DodsVarDataSet {
        float[] back;
        double validMin;
        double validMax;

        public FloatArray(DArray array, HashMap properties) {
            super(array);
            this.back = (float[])array.getPrimitiveVector().getInternalStorage();
            this.validMin = Double.NEGATIVE_INFINITY;
            this.validMax = Double.POSITIVE_INFINITY;
            if (properties.get("VALID_MIN") != null) {
                this.validMin = (Double)properties.get("VALID_MIN");
            }
            if (properties.get("VALID_MAX") != null) {
                this.validMax = (Double)properties.get("VALID_MAX");
            }
            if (properties.get("valid_range") != null) {
                String s = (String)properties.get("valid_range");
                String[] ss = s.split(",");
                this.validMin = Double.parseDouble(ss[0]);
                this.validMax = Double.parseDouble(ss[1]);
            }
            this.properties.putAll(properties);
        }

        private final double doubleValue(float val) {
            double r = val;
            return r >= this.validMin && r <= this.validMax ? r : Units.dimensionless.getFillDouble();
        }

        private final float putFloatValue(double val) {
            return (float)val;
        }

        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public double value(int i) {
            return this.doubleValue(this.back[i]);
        }

        public double value(int i0, int i1) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] + i1]);
        }

        public double value(int i0, int i1, int i2) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2]);
        }

        public double value(int i0, int i1, int i2, int i3) {
            int index = i0 * this.dimSizes[1] * this.dimSizes[2] * this.dimSizes[3] + i1 * this.dimSizes[2] * this.dimSizes[3] + i2 * this.dimSizes[3] + i3;
            return this.doubleValue(this.back[index]);
        }

        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public void putValue(int i0, double d) {
            this.back[i0] = this.putFloatValue(d);
        }

        public void putValue(int i0, int i1, double d) {
            this.back[i0 * this.dimSizes[1] + i1] = this.putFloatValue(d);
        }

        public void putValue(int i0, int i1, int i2, double d) {
            this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2] = this.putFloatValue(d);
        }
    }

    public static class Int16Array
    extends DodsVarDataSet {
        short[] back;
        double scaleFactor = 1.0;
        double addOffset = 0.0;
        double validMin;
        double validMax;

        public Int16Array(DArray array, HashMap properties) {
            super(array);
            this.back = (short[])array.getPrimitiveVector().getInternalStorage();
            if (properties.get("add_offset") != null) {
                this.addOffset = (Double)properties.get("add_offset");
            }
            if (properties.get("scale_factor") != null) {
                this.scaleFactor = (Double)properties.get("scale_factor");
            }
            this.validMin = Double.NEGATIVE_INFINITY;
            this.validMax = Double.POSITIVE_INFINITY;
            if (properties.get("VALID_MIN") != null) {
                this.validMin = (Double)properties.get("VALID_MIN");
            }
            if (properties.get("VALID_MAX") != null) {
                this.validMax = (Double)properties.get("VALID_MAX");
            }
            if (properties.get("valid_range") != null) {
                String s = (String)properties.get("valid_range");
                String[] ss = s.split(",");
                this.validMin = Double.parseDouble(ss[0]);
                this.validMax = Double.parseDouble(ss[1]);
            }
            this.properties.putAll(properties);
        }

        private final double doubleValue(short val) {
            double r = (double)val * this.scaleFactor + this.addOffset;
            return r >= this.validMin && r <= this.validMax ? r : Units.dimensionless.getFillDouble();
        }

        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public double value(int i) {
            return this.doubleValue(this.back[i]);
        }

        public double value(int i0, int i1) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] + i1]);
        }

        public double value(int i0, int i1, int i2) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2]);
        }

        public double value(int i0, int i1, int i2, int i3) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] * this.dimSizes[3] + i1 * this.dimSizes[1] * this.dimSizes[2] + i2 * this.dimSizes[2] + i3]);
        }

        private final short putIntValue(double val) {
            return (short)((val - this.addOffset) / this.scaleFactor);
        }

        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public void putValue(int i0, double d) {
            this.back[i0] = this.putIntValue(d);
        }

        public void putValue(int i0, int i1, double d) {
            this.back[i0 * this.dimSizes[1] + i1] = this.putIntValue(d);
        }

        public void putValue(int i0, int i1, int i2, double d) {
            this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2] = this.putIntValue(d);
        }
    }

    public static class Int32Array
    extends DodsVarDataSet {
        int[] back;
        double scaleFactor = 1.0;
        double addOffset = 0.0;
        double validMin;
        double validMax;

        public Int32Array(DArray array, HashMap properties) {
            super(array);
            this.back = (int[])array.getPrimitiveVector().getInternalStorage();
            if (properties.get("add_offset") != null) {
                this.addOffset = (Double)properties.get("add_offset");
            }
            if (properties.get("scale_factor") != null) {
                this.scaleFactor = (Double)properties.get("scale_factor");
            }
            this.validMin = Double.NEGATIVE_INFINITY;
            this.validMax = Double.POSITIVE_INFINITY;
            if (properties.get("VALID_MIN") != null) {
                this.validMin = (Double)properties.get("VALID_MIN");
            }
            if (properties.get("VALID_MAX") != null) {
                this.validMax = (Double)properties.get("VALID_MAX");
            }
            if (properties.get("valid_range") != null) {
                String s = (String)properties.get("valid_range");
                String[] ss = s.split(",");
                this.validMin = Double.parseDouble(ss[0]);
                this.validMax = Double.parseDouble(ss[1]);
            }
            this.properties.putAll(properties);
        }

        private final double doubleValue(int val) {
            double r = (double)val * this.scaleFactor + this.addOffset;
            return r >= this.validMin && r <= this.validMax ? r : Units.dimensionless.getFillDouble();
        }

        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public double value(int i) {
            return this.doubleValue(this.back[i]);
        }

        public double value(int i0, int i1) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] + i1]);
        }

        public double value(int i0, int i1, int i2) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2]);
        }

        public double value(int i0, int i1, int i2, int i3) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] * this.dimSizes[3] + i1 * this.dimSizes[1] * this.dimSizes[2] + i2 * this.dimSizes[2] + i3]);
        }

        private final int putIntValue(double val) {
            return (int)((val - this.addOffset) / this.scaleFactor);
        }

        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        public void putValue(int i0, double d) {
            this.back[i0] = this.putIntValue(d);
        }

        public void putValue(int i0, int i1, double d) {
            this.back[i0 * this.dimSizes[1] + i1] = this.putIntValue(d);
        }

        public void putValue(int i0, int i1, int i2, double d) {
            this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2] = this.putIntValue(d);
        }
    }
}

