/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dods;

import dods.dap.BaseType;
import dods.dap.BaseTypeFactory;
import dods.dap.DArray;
import dods.dap.DDS;
import dods.dap.DDSException;
import dods.dap.DSequence;
import dods.dap.DefaultFactory;
import dods.dap.NoSuchVariableException;
import dods.dap.Server.InvalidParameterException;
import dods.dap.parser.DDSParser;
import dods.dap.parser.ParseException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;

public class MyDDSParser {
    DDS myDDS;

    public void parse(InputStream in) throws ParseException, DDSException {
        DDSParser p = new DDSParser(in);
        this.myDDS = new DDS();
        DefaultFactory factory = new DefaultFactory();
        p.Dataset(this.myDDS, (BaseTypeFactory)factory);
    }

    public int[] getRecDims(String variable) throws NoSuchVariableException {
        BaseType t = this.myDDS.getVariable(variable);
        if (t instanceof DSequence) {
            return null;
        }
        DArray darray = (DArray)t;
        int[] result = new int[darray.numDimensions()];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = darray.getDimension(i).getStop();
                continue;
            }
            catch (InvalidParameterException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    String[] getVariableNames() {
        Enumeration en = this.myDDS.getVariables();
        ArrayList<String> result = new ArrayList<String>();
        while (en.hasMoreElements()) {
            result.add(((BaseType)en.nextElement()).getName());
        }
        return result.toArray(new String[result.size()]);
    }
}

