/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.das2.components.propertyeditor.PropertyTreeNode;
import org.das2.util.DasExceptionHandler;

class IndexedPropertyItemTreeNode
extends PropertyTreeNode {
    private IndexedPropertyDescriptor indexedPropertyDescriptor;
    private int index;

    IndexedPropertyItemTreeNode(PropertyTreeNode parent, IndexedPropertyDescriptor indexedPropertyDescriptor, int index) {
        super(Array.get(parent.value, index));
        this.setTreeModel(parent.treeModel);
        this.index = index;
        this.parent = parent;
        this.propertyDescriptor = indexedPropertyDescriptor;
        this.indexedPropertyDescriptor = indexedPropertyDescriptor;
    }

    public boolean getAllowsChildren() {
        return this.indexedPropertyDescriptor.getPropertyEditorClass() == null;
    }

    public String getDisplayName() {
        return this.propertyDescriptor.getName() + "[" + this.index + "]";
    }

    public void flush() {
        try {
            if (this.dirty) {
                Method writeMethod = this.indexedPropertyDescriptor.getIndexedWriteMethod();
                writeMethod.invoke(this.parent.parent.value, this.index, this.value);
                this.dirty = false;
            }
            if (this.childDirty) {
                for (PropertyTreeNode child : this.children) {
                    child.flush();
                }
                this.childDirty = false;
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InvocationTargetException e) {
            DasExceptionHandler.handle((Throwable)e);
        }
    }

    protected Object read() {
        Object[] parentValue = (Object[])this.parent.read();
        return parentValue[this.index];
    }

    public void refresh() {
        boolean allowsChildren;
        Object newValue = this.read();
        boolean foldMe = false;
        if (newValue != this.value && (allowsChildren = this.getAllowsChildren())) {
            foldMe = true;
        }
        if (newValue != this.value && newValue != null && !newValue.equals(this.value)) {
            this.value = newValue;
        }
        if (foldMe) {
            this.children = null;
            this.treeModel.nodeStructureChanged(this);
        } else if (this.getAllowsChildren() && this.children != null) {
            for (PropertyTreeNode child : this.children) {
                child.refresh();
            }
        }
    }
}

