/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.das2.components.DatumEditor;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.components.propertyeditor.FloatingPointFormatter;
import org.das2.components.propertyeditor.PropertyCellRenderer;
import org.das2.components.propertyeditor.PropertyTreeNodeInterface;
import org.das2.components.treetable.TreeTableModel;
import org.das2.dasml.CommandBlock;
import org.das2.dasml.CommandBlockEditor;
import org.das2.dasml.ListOption;
import org.das2.dasml.OptionListEditor;
import org.das2.datum.Datum;
import org.das2.util.DasExceptionHandler;

class PropertyCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
CellEditorListener {
    private static Map enumerationMap = new HashMap();
    private JFormattedTextField integerField = new JFormattedTextField(new Integer(0));
    private JFormattedTextField floatField;
    private JTextField stringField;
    private DatumEditor datumEditor;
    private JCheckBox booleanBox;
    private JComboBox enumerationChoice;
    private CommandBlockEditor commandBlockEditor;
    private OptionListEditor optionListEditor;
    private static final int INTEGER = 1;
    private static final int LONG = 2;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 8;
    private static final int STRING = 16;
    private static final int BOOLEAN = 32;
    private static final int EDITABLE = 64;
    private static final int ENUMERATION = 128;
    private static final int DATUM = 256;
    private static final int COMMAND_BLOCK = 512;
    private static final int LIST_OPTION = 1024;
    private int editorState = 1;
    private Object currentValue = null;
    private int currentRow;
    private JTree propertyTree;

    static Object[] getEnumerationList(Class type) {
        Object[] list = (Object[])enumerationMap.get(type);
        if (list != null) {
            return list;
        }
        Field[] fields = type.getFields();
        int count = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getType() != type || !Modifier.isStatic(fields[i].getModifiers())) continue;
            ++count;
        }
        list = new Object[count];
        int index = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getType() != type || !Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                list[index] = fields[i].get(null);
                ++index;
                continue;
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        enumerationMap.put(type, list);
        return list;
    }

    public PropertyCellEditor(JTree propertyTree) {
        this.integerField.addActionListener(this);
        FloatingPointFormatter floatFormatter = new FloatingPointFormatter();
        this.floatField = new JFormattedTextField(floatFormatter);
        this.floatField.addActionListener(this);
        this.stringField = new JTextField();
        this.stringField.addActionListener(this);
        this.datumEditor = new DatumEditor();
        this.datumEditor.addActionListener(this);
        this.booleanBox = new JCheckBox();
        this.booleanBox.addActionListener(this);
        this.propertyTree = propertyTree;
        this.enumerationChoice = new JComboBox();
        this.enumerationChoice.setRenderer(new PropertyCellRenderer());
        this.enumerationChoice.addActionListener(this);
        this.commandBlockEditor = new CommandBlockEditor();
        this.commandBlockEditor.addCellEditorListener(this);
        this.optionListEditor = new OptionListEditor();
        this.optionListEditor.addCellEditorListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        this.fireEditingStopped();
        if (e.getSource() instanceof JButton) {
            if (this.propertyTree.isCollapsed(this.currentRow)) {
                this.propertyTree.expandRow(this.currentRow);
            } else {
                this.propertyTree.collapseRow(this.currentRow);
            }
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentValue = value;
        this.currentRow = row;
        TreeTableModel model = (TreeTableModel)table.getModel();
        PropertyTreeNodeInterface node = (PropertyTreeNodeInterface)model.getNodeForRow(row);
        PropertyDescriptor pd = node.getPropertyDescriptor();
        if (value instanceof Enumeration) {
            this.editorState = 128;
            Object[] list = PropertyCellEditor.getEnumerationList(pd.getPropertyType());
            this.enumerationChoice.setModel(new DefaultComboBoxModel<Object>(list));
            this.enumerationChoice.setSelectedItem(value);
            return this.enumerationChoice;
        }
        if (value instanceof Integer) {
            this.editorState = 1;
            this.integerField.setValue(value);
            return this.integerField;
        }
        if (value instanceof Long) {
            this.editorState = 2;
            this.integerField.setValue(value);
            return this.integerField;
        }
        if (value instanceof Float) {
            this.editorState = 4;
            this.floatField.setValue(value);
            return this.floatField;
        }
        if (value instanceof Double) {
            this.editorState = 8;
            this.floatField.setValue(value);
            return this.floatField;
        }
        if (value instanceof Boolean) {
            this.editorState = 32;
            this.booleanBox.setSelected((Boolean)value);
            this.booleanBox.setText(value.toString());
            return this.booleanBox;
        }
        if (value instanceof Datum) {
            this.editorState = 256;
            Datum d = (Datum)value;
            this.datumEditor.setValue(d);
            return this.datumEditor.getCustomEditor();
        }
        if (pd.getPropertyType().equals(CommandBlock.class)) {
            this.editorState = 512;
            return this.commandBlockEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        if (pd.getPropertyType().equals(ListOption[].class)) {
            this.editorState = 1024;
            return this.optionListEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        this.editorState = 16;
        this.stringField.setText(value.toString());
        return this.stringField;
    }

    public Object getCellEditorValue() {
        if (this.editorState == 128) {
            return this.enumerationChoice.getSelectedItem();
        }
        if (this.editorState == 1) {
            Object value = this.integerField.getValue();
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof Number) {
                return new Integer(((Number)value).intValue());
            }
            throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
        }
        if (this.editorState == 2) {
            Object value = this.integerField.getValue();
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof Number) {
                return new Long(((Number)value).longValue());
            }
            throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
        }
        if (this.editorState == 4) {
            Object value = this.floatField.getValue();
            if (value instanceof Float) {
                return value;
            }
            if (value instanceof Number) {
                return new Float(((Number)value).floatValue());
            }
            throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
        }
        if (this.editorState == 8) {
            Object value = this.floatField.getValue();
            if (value instanceof Double) {
                return value;
            }
            if (value instanceof Number) {
                return new Double(((Number)value).doubleValue());
            }
            throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
        }
        if (this.editorState == 64) {
            return this.currentValue;
        }
        if (this.editorState == 32) {
            return this.booleanBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.editorState == 256) {
            try {
                return this.datumEditor.getValue();
            }
            catch (IllegalArgumentException iae) {
                DasExceptionHandler.handle((Throwable)iae);
                return this.currentValue;
            }
        }
        if (this.editorState == 512) {
            return this.commandBlockEditor.getCellEditorValue();
        }
        if (this.editorState == 1024) {
            return this.optionListEditor.getCellEditorValue();
        }
        return this.stringField.getText();
    }

    public void editingCanceled(ChangeEvent e) {
        this.fireEditingCanceled();
    }

    public void editingStopped(ChangeEvent e) {
        this.fireEditingStopped();
    }
}

