/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components.propertyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyDescriptor;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.das2.components.propertyeditor.ColorCellRenderer;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.IndexedPropertyTreeNode;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.components.propertyeditor.PropertyTreeNodeInterface;
import org.das2.components.treetable.TreeTableModel;

class PropertyCellRenderer
extends JLabel
implements TableCellRenderer,
TreeCellRenderer,
ListCellRenderer {
    private static DecimalFormat expFormat = new DecimalFormat("0.#######E0");
    JCheckBox booleanRenderer;
    private TableCellRenderer colorRenderer = new ColorCellRenderer();

    public PropertyCellRenderer() {
        super("Label");
        this.setFont(this.getFont().deriveFont(0));
        this.booleanRenderer = new JCheckBox();
        this.booleanRenderer.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    private boolean isWritable(JTable table, int row) {
        TreeTableModel model = (TreeTableModel)table.getModel();
        PropertyTreeNodeInterface node = (PropertyTreeNodeInterface)model.getNodeForRow(row);
        PropertyDescriptor pd = node.getPropertyDescriptor();
        return !(node instanceof IndexedPropertyTreeNode) && pd.getWriteMethod() != null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c;
        boolean writable = table == null || this.isWritable(table, row);
        this.setEnabled(writable);
        if (value == PropertyEditor.MULTIPLE) {
            this.setText("multi-value");
            c = this;
        } else if (value instanceof Color) {
            c = this.colorRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        } else if (value instanceof Boolean) {
            this.booleanRenderer.setSelected((Boolean)value);
            this.booleanRenderer.setText(value.toString());
            this.booleanRenderer.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            c = this.booleanRenderer;
        } else {
            if (value instanceof Double || value instanceof Float) {
                double doubleValue = ((Number)value).doubleValue();
                double mag = Math.abs(doubleValue);
                if (doubleValue != 0.0 && mag < 1.0E-4 || mag >= 10000.0) {
                    value = expFormat.format(doubleValue);
                }
            }
            if (value instanceof Displayable) {
                this.setText(((Displayable)value).getListLabel());
            } else {
                this.setText(String.valueOf(value));
            }
            this.setOpaque(true);
            if (table != null) {
                this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            }
            if (value instanceof Displayable) {
                Displayable enm = (Displayable)value;
                this.setIcon(enm.getListIcon());
                this.setDisabledIcon(enm.getListIcon());
            } else {
                this.setIcon(null);
                this.setDisabledIcon(null);
            }
            c = this;
        }
        ((Component)c).setEnabled(writable);
        return c;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        this.setText(String.valueOf(value));
        this.setIcon(null);
        this.setOpaque(false);
        this.setEnabled(true);
        return this;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof Displayable) {
            Displayable enm = (Displayable)value;
            this.setIcon(enm.getListIcon());
            this.setText(enm.getListLabel());
        } else {
            this.setIcon(null);
            this.setText(String.valueOf(value));
        }
        this.setOpaque(true);
        this.setBackground(isSelected ? Color.gray : Color.lightGray);
        return this;
    }
}

