/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.dasml.DataFormatException;
import org.das2.dasml.FormBase;
import org.das2.dasml.ParsedExpressionException;
import org.das2.dasml.Processor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommandBlock {
    private static final int NONE = 0;
    private static final int SET = 1;
    private static final int UPDATE = 2;
    private static final int IF = 4;
    private static final int ELSEIF = 8;
    private static final int INVOKE = 16;
    private static final int ALERT = 32;
    ArrayList commandList = new ArrayList();

    CommandBlock() {
    }

    CommandBlock(Element element, FormBase form) {
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int index = 0; index < childCount; ++index) {
            Node node = children.item(index);
            if (!(node instanceof Element)) continue;
            String tagName = node.getNodeName();
            if (tagName.equals("set")) {
                this.addCommand(this.processSetElement(form, (Element)node));
                continue;
            }
            if (tagName.equals("if")) {
                this.addCommand(this.processIfElement(form, (Element)node));
                continue;
            }
            if (tagName.equals("elseif")) {
                this.addCommand(this.processElseifElement(form, (Element)node));
                continue;
            }
            if (tagName.equals("else")) {
                this.addCommand(this.processElseElement(form, (Element)node));
                continue;
            }
            if (!tagName.equals("invoke")) continue;
            this.addCommand(this.processInvokeElement(form, (Element)node));
        }
    }

    private Command processSetElement(FormBase form, Element element) {
        String property = element.getAttribute("property");
        String value = element.getAttribute("value");
        if (!NameContext.QUALIFIED_NAME.matcher(property).matches()) {
            throw new IllegalArgumentException("property attribute must be a valid identifier: <set property=\"" + property + "\" ...");
        }
        return new SetCommand(property, value);
    }

    private Command processIfElement(FormBase form, Element element) {
        String test = element.getAttribute("test");
        return new IfCommand(test, element, form);
    }

    private Command processElseifElement(FormBase form, Element element) {
        String test = element.getAttribute("test");
        return new ElseIfCommand(test, element, form);
    }

    private Command processElseElement(FormBase form, Element element) {
        return new ElseCommand(element, form);
    }

    private Command processInvokeElement(FormBase form, Element element) {
        String target = element.getAttribute("method");
        String args = element.getAttribute("args");
        String[] argsArray = args.trim().length() == 0 ? new String[]{} : args.split(",");
        for (int i = 0; i < argsArray.length; ++i) {
            argsArray[i] = argsArray[i].trim();
        }
        return new InvokeCommand(target, argsArray);
    }

    public void execute(FormBase form) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException {
        Iterator iterator = this.commandList.iterator();
        int lastCommand = -1;
        boolean shouldSkip = false;
        while (iterator.hasNext()) {
            Command command = (Command)iterator.next();
            if ((command instanceof ElseIfCommand || command instanceof ElseCommand) && shouldSkip) continue;
            command.execute(form);
            if (!(command instanceof IfCommand)) continue;
            shouldSkip = ((IfCommand)command).getShouldSkip();
        }
    }

    public void appendDOMElements(Element element) {
        Document document = element.getOwnerDocument();
        Iterator i = this.commandList.iterator();
        while (i.hasNext()) {
            element.appendChild(((Command)i.next()).getDOMElement(document));
        }
    }

    void insertCommand(Command command, int index) {
        if (command.getParent() != null && command.getParent() != this) {
            command.getParent().commandList.remove(command);
        }
        command.setParent(this);
        if (index == -1) {
            this.commandList.add(command);
        } else {
            this.commandList.add(index, command);
        }
    }

    void addCommand(Command command) {
        if (command.getParent() != null && command.getParent() != this) {
            command.getParent().commandList.remove(command);
        }
        command.setParent(this);
        this.commandList.add(command);
    }

    void removeCommand(int index) {
        this.commandList.remove(index);
    }

    void removeCommand(Command command) {
        this.commandList.remove(command);
    }

    int indexOf(Command command) {
        return this.commandList.indexOf(command);
    }

    static class Identifier {
        public String text;

        public Identifier(String t) {
            this.text = t;
        }

        public String toString() {
            return this.text;
        }
    }

    static abstract class BlockCommand
    extends CommandBlock
    implements Command {
        CommandBlock parent;

        public BlockCommand() {
        }

        public BlockCommand(Element element, FormBase form) {
            super(element, form);
        }

        public void setParent(CommandBlock parent) {
            this.parent = parent;
        }

        public CommandBlock getParent() {
            return this.parent;
        }
    }

    static interface Command {
        public CommandBlock getParent();

        public void setParent(CommandBlock var1);

        public void execute(FormBase var1) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException;

        public Element getDOMElement(Document var1);
    }

    static class ElseCommand
    extends IfCommand {
        ElseCommand() {
            super("true");
        }

        ElseCommand(Element element, FormBase form) {
            super("true", element, form);
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("else");
            this.appendDOMElements(element);
            return element;
        }

        public String toString() {
            return "ELSE";
        }
    }

    static class ElseIfCommand
    extends IfCommand {
        ElseIfCommand(String test) {
            super(test);
        }

        ElseIfCommand(String test, Element element, FormBase form) {
            super(test, element, form);
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("elseif");
            element.setAttribute("test", this.test);
            this.appendDOMElements(element);
            return element;
        }

        public String toString() {
            return "ELSEIF " + this.test;
        }
    }

    static class IfCommand
    extends BlockCommand {
        String test;
        boolean shouldSkip;

        public IfCommand(String test) {
            this.test = test;
        }

        public IfCommand(String test, Element element, FormBase form) {
            super(element, form);
            this.test = test;
        }

        public boolean getShouldSkip() {
            return this.shouldSkip;
        }

        public void execute(FormBase form) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException {
            Matcher refMatcher = Processor.refPattern.matcher(this.test);
            Object value = refMatcher.matches() ? form.getDasApplication().getNameContext().get(refMatcher.group(1)) : Processor.parseValue(form.getDasApplication().getNameContext(), this.test, Boolean.TYPE);
            if (!(value instanceof Boolean)) {
                throw new DataFormatException(value + " is not a boolean");
            }
            Boolean bool = (Boolean)value;
            if (bool.booleanValue()) {
                super.execute(form);
            }
            this.shouldSkip = bool;
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("if");
            element.setAttribute("test", this.test);
            this.appendDOMElements(element);
            return element;
        }

        public String toString() {
            return "IF " + this.test;
        }
    }

    static class InvokeCommand
    implements Command {
        String target;
        String[] args;
        CommandBlock parent;

        public InvokeCommand(String target, String[] args) {
            this.target = target;
            this.args = args;
        }

        public void execute(FormBase form) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException {
            form.invoke(this.target, this.args);
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("invoke");
            element.setAttribute("method", this.target);
            if (this.args != null && this.args.length > 0) {
                String argsString = Arrays.asList(this.args).toString();
                argsString = argsString.substring(0, argsString.length() - 1);
                element.setAttribute("args", argsString);
            }
            return element;
        }

        public void setParent(CommandBlock parent) {
            this.parent = parent;
        }

        public CommandBlock getParent() {
            return this.parent;
        }

        public String toString() {
            return "INVOKE " + this.target + (this.args == null ? "[]" : Arrays.asList(this.args).toString());
        }
    }

    static class SetCommand
    implements Command {
        String id;
        String value;
        CommandBlock parent;

        SetCommand(String id, String value) {
            this.id = id;
            this.value = value;
        }

        public void execute(FormBase form) throws DasException, DataFormatException, ParsedExpressionException, InvocationTargetException, DasNameException {
            try {
                form.getDasApplication().getNameContext().set(this.id, this.value);
            }
            catch (DasPropertyException e) {
                throw new RuntimeException("Error executing command: " + this.id + "=" + this.value, e);
            }
        }

        public Element getDOMElement(Document document) {
            Element element = document.createElement("set");
            element.setAttribute("property", this.id);
            element.setAttribute("value", this.value);
            return element;
        }

        public CommandBlock getParent() {
            return this.parent;
        }

        public void setParent(CommandBlock parent) {
            this.parent = parent;
        }

        public String toString() {
            return "SET " + this.id + " = " + this.value;
        }
    }
}

