/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dasml;

import java.awt.Container;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JTextField;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasNameException;
import org.das2.DasPropertyException;
import org.das2.NameContext;
import org.das2.components.propertyeditor.Editable;
import org.das2.dasml.DefaultComponentDnDSupport;
import org.das2.dasml.FormBase;
import org.das2.dasml.FormComponent;
import org.das2.dasml.ParsedExpressionException;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DnDSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FormTextField
extends JTextField
implements Editable,
FormComponent {
    private String dasName;
    protected DnDSupport dndSupport;
    private boolean editingMode;

    public FormTextField(String name) {
        super(10);
        if (name == null) {
            name = "textfield_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    public FormTextField(Element element, FormBase form) throws DasPropertyException, DasNameException, DasException, ParsedExpressionException {
        String name = element.getAttribute("name");
        int length = Integer.parseInt(element.getAttribute("length"));
        this.setColumns(length);
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            if (!(children.item(i) instanceof Text)) continue;
            Text text = (Text)children.item(i);
            this.setText(text.getData());
            break;
        }
        try {
            this.setDasName(name);
        }
        catch (DasNameException dne) {
            DasExceptionHandler.handle((Throwable)dne);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("textfield");
        Text text = document.createTextNode(this.getText());
        element.appendChild(text);
        element.setAttribute("name", this.getDasName());
        element.setAttribute("enabled", this.isEnabled() ? "true" : "false");
        element.setAttribute("length", Integer.toString(this.getColumns()));
        return element;
    }

    public FormBase getForm() {
        FormComponent parent = (FormComponent)((Object)this.getParent());
        if (parent == null) {
            return null;
        }
        return parent.getForm();
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int x, int y, int action, MouseEvent evt) {
        return false;
    }

    public void setEditingMode(boolean b) {
        this.editingMode = b;
    }

    public boolean getEditingMode() {
        return this.editingMode;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String name) throws DasNameException {
        if (name.equals(this.dasName)) {
            return;
        }
        String oldName = this.dasName;
        this.dasName = name;
        DasApplication app = this.getDasApplication();
        if (app != null) {
            app.getNameContext().put(name, this);
            if (oldName != null) {
                app.getNameContext().remove(oldName);
            }
        }
        this.firePropertyChange("name", oldName, name);
    }

    public void deregisterComponent() {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            try {
                if (nc.get(this.getDasName()) == this) {
                    nc.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dpe) {
                IllegalStateException se = new IllegalStateException(dpe.toString());
                se.initCause(dpe);
                throw se;
            }
            catch (InvocationTargetException ite) {
                IllegalStateException se = new IllegalStateException(ite.toString());
                se.initCause(ite);
                throw se;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container p = this.getParent();
        if (p instanceof FormComponent) {
            return ((FormComponent)((Object)p)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        DasApplication app = this.getDasApplication();
        if (app != null) {
            NameContext nc = app.getNameContext();
            nc.put(this.getDasName(), this);
        }
    }
}

