/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.Units;

public class AppendTableDataSet
implements TableDataSet {
    TableDataSet[] tableDataSets;
    int[] firstIndexs;
    int[] firstTables;

    public AppendTableDataSet(TableDataSet tds1, TableDataSet tds2) {
        ArrayList<TableDataSet> tableDataSetsList = new ArrayList<TableDataSet>();
        ArrayList<Integer> firstIndexsList = new ArrayList<Integer>();
        ArrayList<Integer> firstTablesList = new ArrayList<Integer>();
        if (tds1 instanceof AppendTableDataSet && tds2 instanceof AppendTableDataSet) {
            throw new IllegalStateException("not implemented");
        }
        if (tds1 instanceof AppendTableDataSet) {
            AppendTableDataSet atds1 = (AppendTableDataSet)tds1;
            tableDataSetsList.addAll(this.box(atds1.tableDataSets));
            firstIndexsList.addAll(this.box(atds1.firstIndexs));
            firstTablesList.addAll(this.box(atds1.firstTables));
            tableDataSetsList.add(tds2);
            firstIndexsList.add(new Integer(atds1.firstIndexs[atds1.tableDataSets.length] + tds2.getXLength()));
            firstTablesList.add(new Integer(atds1.firstTables[atds1.tableDataSets.length] + tds2.getXLength()));
            this.tableDataSets = tableDataSetsList.toArray(new TableDataSet[tableDataSetsList.size()]);
            this.firstIndexs = this.unbox(firstIndexsList);
            this.firstTables = this.unbox(firstTablesList);
        } else {
            if (tds2 instanceof AppendTableDataSet) {
                throw new IllegalStateException("not implemented");
            }
            this.tableDataSets = new TableDataSet[2];
            this.tableDataSets[0] = tds1;
            this.tableDataSets[1] = tds2;
            this.firstIndexs = new int[3];
            this.firstIndexs[0] = 0;
            this.firstIndexs[1] = tds1.getXLength();
            this.firstIndexs[2] = this.firstIndexs[1] + tds2.getXLength();
            this.firstTables = new int[3];
            this.firstTables[0] = 0;
            this.firstTables[1] = tds1.tableCount();
            this.firstTables[2] = this.firstTables[1] + tds2.tableCount();
        }
    }

    private int[] unbox(List intList) {
        int[] result = new int[intList.size()];
        for (int i = 0; i < intList.size(); ++i) {
            result[i] = (Integer)intList.get(i);
        }
        return result;
    }

    private List box(int[] list) {
        ArrayList<Integer> result = new ArrayList<Integer>(list.length);
        for (int i = 0; i < list.length; ++i) {
            result.add(new Integer(list[i]));
        }
        return result;
    }

    private List box(Object[] list) {
        ArrayList<Object> result = new ArrayList<Object>(list.length);
        for (int i = 0; i < list.length; ++i) {
            result.add(list[i]);
        }
        return result;
    }

    private AppendTableDataSet(TableDataSet[] tableDataSets, int[] firstIndexs, int[] firstTables) {
        this.tableDataSets = tableDataSets;
        this.firstIndexs = firstIndexs;
    }

    private int tdsIndex(int i) {
        for (int itds = 0; itds < this.tableDataSets.length - 1; ++itds) {
            if (this.firstIndexs[itds + 1] < i) continue;
            return itds;
        }
        return this.firstIndexs.length - 1;
    }

    private int tdsTable(int itable) {
        for (int itds = 0; itds < this.tableDataSets.length - 1; ++itds) {
            if (this.firstTables[itds + 1] < itable) continue;
            return itds;
        }
        return this.firstIndexs.length - 1;
    }

    public Datum getDatum(int i, int j) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].getDatum(i - this.firstIndexs[itds], j);
    }

    public double getDouble(int i, int j, Units units) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].getDouble(i - this.firstIndexs[itds], j, units);
    }

    public double[] getDoubleScan(int i, Units units) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].getDoubleScan(i - this.firstIndexs[itds], units);
    }

    public int getInt(int i, int j, Units units) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].getInt(i - this.firstIndexs[itds], j, units);
    }

    public DataSet getPlanarView(String planeID) {
        TableDataSet[] tdsPlane = new TableDataSet[this.tableDataSets.length];
        for (int i = 0; i < this.tableDataSets.length; ++i) {
            tdsPlane[i] = (TableDataSet)this.tableDataSets[i].getPlanarView(planeID);
        }
        return new AppendTableDataSet(tdsPlane, this.firstIndexs, this.firstTables);
    }

    public String[] getPlaneIds() {
        return this.tableDataSets[0].getPlaneIds();
    }

    public Map getProperties() {
        return this.tableDataSets[0].getProperties();
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public DatumVector getScan(int i) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].getScan(i - this.firstIndexs[itds]);
    }

    public int getXLength() {
        return this.firstIndexs[this.tableDataSets.length];
    }

    public VectorDataSet getXSlice(int i) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].getXSlice(i - this.firstIndexs[itds]);
    }

    public Datum getXTagDatum(int i) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].getXTagDatum(i - this.firstIndexs[itds]);
    }

    public double getXTagDouble(int i, Units units) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].getXTagDouble(i - this.firstIndexs[itds], units);
    }

    public int getXTagInt(int i, Units units) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].getXTagInt(i - this.firstIndexs[itds], units);
    }

    public Units getXUnits() {
        return this.tableDataSets[0].getXUnits();
    }

    public int getYLength(int table) {
        int itds = this.tdsTable(table);
        return this.tableDataSets[itds].getYLength(table - this.firstTables[itds]);
    }

    public VectorDataSet getYSlice(int j, int table) {
        int itds = this.tdsTable(table);
        return this.tableDataSets[itds].getYSlice(j, table - this.firstTables[itds]);
    }

    public Datum getYTagDatum(int table, int j) {
        int itds = this.tdsTable(table);
        return this.tableDataSets[itds].getYTagDatum(j, table - this.firstTables[itds]);
    }

    public double getYTagDouble(int table, int j, Units units) {
        int itds = this.tdsTable(table);
        return this.tableDataSets[itds].getYTagDouble(j, table - this.firstTables[itds], units);
    }

    public int getYTagInt(int table, int j, Units units) {
        int itds = this.tdsTable(table);
        return this.tableDataSets[itds].getYTagInt(j, table - this.firstTables[itds], units);
    }

    public DatumVector getYTags(int table) {
        int itds = this.tdsTable(table);
        return this.tableDataSets[itds].getYTags(table - this.firstTables[itds]);
    }

    public Units getYUnits() {
        return this.tableDataSets[0].getYUnits();
    }

    public Units getZUnits() {
        return this.tableDataSets[0].getZUnits();
    }

    public int tableCount() {
        return this.firstTables[this.tableDataSets.length];
    }

    public int tableEnd(int table) {
        int itds = this.tdsTable(table);
        return this.firstIndexs[itds + 1];
    }

    public int tableOfIndex(int i) {
        int itds = this.tdsIndex(i);
        return this.tableDataSets[itds].tableOfIndex(i - this.firstIndexs[itds]) + this.firstTables[itds];
    }

    public int tableStart(int table) {
        int itds = this.tdsTable(table);
        return this.firstIndexs[itds + 1];
    }

    public Object getProperty(int table, String name) {
        int itds = this.tdsTable(table);
        return this.tableDataSets[itds].getProperty(table - this.firstTables[itds], name);
    }
}

