/*
 * Decompiled with CFR 0.152.
 */
package org.das2.dataset;

import org.das2.dataset.DataSet;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableDataSetAdapter;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetAdapter;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;

public class DataSetAdapter {
    public static final String PROPERTY_SOURCE = "adapterSource";

    public static AbstractDataSet create(DataSet ds) {
        if (ds instanceof VectorDataSet && ds.getPlaneIds().length > 2) {
            VectorDataSet vds = (VectorDataSet)ds;
            AbstractDataSet bds = (AbstractDataSet)Ops.bundle(null, (QDataSet)new Vector(vds));
            String[] planes = ds.getPlaneIds();
            for (int i = 1; i < planes.length; ++i) {
                Vector v = new Vector((VectorDataSet)vds.getPlanarView(planes[i]));
                v.putProperty("NAME", planes[i]);
                Ops.bundle((QDataSet)bds, (QDataSet)v);
            }
            bds.putProperty("DEPEND_0", (Object)new XTagsDataSet(vds));
            return bds;
        }
        if (ds instanceof VectorDataSet) {
            return new Vector((VectorDataSet)ds);
        }
        if (ds instanceof TableDataSet) {
            TableDataSet tds = (TableDataSet)ds;
            if (tds.tableCount() <= 1) {
                return new SimpleTable(tds);
            }
            return new MultipleTable(tds);
        }
        if (ds == null) {
            throw new NullPointerException("dataset is null");
        }
        throw new IllegalArgumentException("unsupported dataset type: " + ds.getClass().getName());
    }

    public static DataSet createLegacyDataSet(QDataSet ds) {
        if (ds.rank() == 1) {
            return VectorDataSetAdapter.create(ds);
        }
        if (SemanticOps.isBundle((QDataSet)ds)) {
            return VectorDataSetAdapter.createFromBundle(ds);
        }
        if (ds.rank() == 2) {
            return TableDataSetAdapter.create(ds);
        }
        if (ds.rank() == 3) {
            return TableDataSetAdapter.create(ds);
        }
        throw new IllegalArgumentException("unsupported rank: " + ds.rank());
    }

    static class MultipleTable
    extends AbstractDataSet {
        TableDataSet source;

        MultipleTable(TableDataSet source) {
            this.source = source;
            this.properties.put("JOIN_0", DDataSet.create((int[])new int[0]));
            this.properties.put("UNITS", source.getZUnits());
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
        }

        public int rank() {
            return 3;
        }

        public int length() {
            return this.source.tableCount();
        }

        public int length(int i) {
            return this.source.tableEnd(i) - this.source.tableStart(i);
        }

        public int length(int i, int j) {
            return this.source.getYLength(i);
        }

        public double value(int i, int j, int k) {
            int ts = this.source.tableStart(i);
            return this.source.getDouble(ts + j, k, this.source.getZUnits());
        }

        public Object property(String name, int i) {
            if (name.equals("DEPEND_0")) {
                return new MultiTableXTagsDataSet(this.source, this.source.tableStart(i), this.source.tableEnd(i) - this.source.tableStart(i));
            }
            if (name.equals("DEPEND_1")) {
                return new YTagsDataSet(this.source, i);
            }
            return super.property(name, i);
        }
    }

    static class SimpleTable
    extends AbstractDataSet {
        TableDataSet source;

        SimpleTable(TableDataSet source) {
            if (source.tableCount() > 1) {
                throw new IllegalArgumentException("only simple tables are supported");
            }
            this.source = source;
            this.properties.put("UNITS", source.getZUnits());
            this.properties.put("DEPEND_0", new XTagsDataSet(source));
            this.properties.put("DEPEND_1", new YTagsDataSet(source, 0));
            this.properties.put("QUBE", Boolean.TRUE);
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
        }

        public int rank() {
            return 2;
        }

        public int length(int i) {
            return this.source.getYLength(0);
        }

        public double value(int i, int j) {
            return this.source.getDouble(i, j, this.source.getZUnits());
        }

        public int length() {
            return this.source.getXLength();
        }
    }

    static class YTagsDataSet
    extends AbstractDataSet {
        TableDataSet source;
        int table;

        YTagsDataSet(TableDataSet source, int table) {
            this.source = source;
            this.table = table;
            this.properties.put("UNITS", source.getYUnits());
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getYTagDouble(this.table, i, this.source.getYUnits());
        }

        public int length() {
            return this.source.tableCount() > 0 ? this.source.getYLength(this.table) : 99;
        }
    }

    static class Vector
    extends AbstractDataSet {
        VectorDataSet source;

        Vector(VectorDataSet source) {
            this.source = source;
            this.properties.put("UNITS", source.getYUnits());
            this.properties.put("DEPEND_0", new XTagsDataSet(source));
            this.properties.put(DataSetAdapter.PROPERTY_SOURCE, source);
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getDouble(i, this.source.getYUnits());
        }

        public int length() {
            return this.source.getXLength();
        }
    }

    static class XTagsDataSet
    extends AbstractDataSet {
        DataSet source;

        XTagsDataSet(DataSet source) {
            this.source = source;
            this.properties.put("UNITS", source.getXUnits());
            Object o = source.getProperty("xMonotonic");
            if (o != null) {
                this.properties.put("MONOTONIC", o);
            }
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getXTagDouble(i, this.source.getXUnits());
        }

        public int length() {
            return this.source.getXLength();
        }
    }

    static class MultiTableXTagsDataSet
    extends AbstractDataSet {
        DataSet source;
        int offset;
        int length;

        MultiTableXTagsDataSet(DataSet source, int offset, int length) {
            this.source = source;
            this.offset = offset;
            this.length = length;
            this.properties.put("UNITS", source.getXUnits());
            Object o = source.getProperty("xMonotonic");
            if (o != null) {
                this.properties.put("MONOTONIC", o);
            }
        }

        public int rank() {
            return 1;
        }

        public double value(int i) {
            return this.source.getXTagDouble(i + this.offset, this.source.getXUnits());
        }

        public int length() {
            return this.length;
        }
    }
}

