/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.das2.graph.DasCanvasComponent;
import org.das2.util.GrannyTextRenderer;

class InfoLabel {
    JWindow window;
    JPanel label;
    GrannyTextRenderer gtr;
    JPanel containedPanel;
    JComponent glassPane;
    boolean contained = true;

    InfoLabel() {
    }

    void init(DasCanvasComponent parent) {
        Window root = (Window)SwingUtilities.getRoot(parent);
        this.window = new JWindow(root);
        this.label = new JPanel(){

            public void paintComponent(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.clearRect(0, 0, this.getWidth(), this.getHeight());
                InfoLabel.this.gtr.draw(g, 0.0f, (float)((int)InfoLabel.this.gtr.getAscent()));
            }
        };
        this.label.setOpaque(true);
        this.label.setPreferredSize(new Dimension(300, 20));
        this.window.getContentPane().add(this.label);
        this.window.pack();
        this.gtr = new GrannyTextRenderer();
        this.glassPane = (JComponent)parent.getCanvas().getGlassPane();
        this.containedPanel = new JPanel(){

            public void paintComponent(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.clearRect(0, 0, this.getWidth(), this.getHeight());
                InfoLabel.this.gtr.draw(g, 0.0f, (float)((int)InfoLabel.this.gtr.getAscent()));
            }
        };
        this.containedPanel.setVisible(false);
        this.glassPane.add(this.containedPanel);
        this.contained = true;
    }

    void setText(String text, Point p, DasCanvasComponent parent, int labelPositionX, int labelPositionY) {
        if (this.window == null) {
            this.init(parent);
        }
        if (text != null) {
            this.gtr.setString(this.containedPanel.getFont(), text);
            Rectangle rect = this.gtr.getBounds();
            int posx = p.x + labelPositionX * 3 + Math.min(labelPositionX, 0) * rect.width;
            int posy = p.y + labelPositionY * 3 + Math.min(labelPositionY, 0) * rect.height;
            Rectangle bounds = this.gtr.getBounds();
            Point p2 = new Point(posx, posy);
            SwingUtilities.convertPointFromScreen(p2, this.glassPane);
            bounds.translate(p2.x, p2.y);
            this.contained = this.glassPane.getBounds().contains(bounds);
            if (this.contained) {
                this.containedPanel.setSize(new Dimension(rect.width, rect.height));
                this.containedPanel.setLocation(p2.x, p2.y);
                this.window.setVisible(false);
                this.containedPanel.setVisible(true);
                this.containedPanel.repaint();
            } else {
                this.gtr.setString(this.label.getFont(), text);
                rect = this.gtr.getBounds();
                this.window.setSize(new Dimension(rect.width, rect.height));
                posx = p.x + labelPositionX * 3 + Math.min(labelPositionX, 0) * rect.width;
                posy = p.y + labelPositionY * 3 + Math.min(labelPositionY, 0) * rect.height;
                this.containedPanel.setVisible(false);
                this.window.setLocation(posx, posy);
                this.window.setVisible(true);
                this.window.repaint();
            }
        } else {
            this.hide(parent);
        }
    }

    void hide(DasCanvasComponent parent) {
        if (this.window == null) {
            this.init(parent);
        }
        if (this.contained) {
            this.containedPanel.setVisible(false);
        } else {
            this.window.setVisible(false);
        }
    }
}

