/*
 * Decompiled with CFR 0.152.
 */
package org.das2.event;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DomainDivider;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasDevicePosition;

public class ZoomPanMouseModule
extends MouseModule {
    DasAxis xAxis;
    DasAxis.Lock xAxisLock;
    DasAxis yAxis;
    DasAxis.Lock yAxisLock;
    Point p0;
    DatumRange xAxisRange0;
    DatumRange yAxisRange0;
    long t0;
    long tbirth;

    public ZoomPanMouseModule(DasCanvasComponent parent, DasAxis horizontalAxis, DasAxis verticalAxis) {
        super(parent);
        this.setLabel("Zoom Pan");
        this.xAxis = horizontalAxis;
        this.yAxis = verticalAxis;
        this.t0 = System.nanoTime();
        this.tbirth = System.nanoTime();
    }

    private boolean axisIsAdjustable(DasAxis axis) {
        return axis != null && (UnitsUtil.isIntervalMeasurement((Units)axis.getUnits()) || UnitsUtil.isRatioMeasurement((Units)axis.getUnits()));
    }

    private DatumRange maybeRound(DasAxis xAxis, DatumRange dr) {
        DomainDivider div = xAxis.getMinorTicksDomainDivider();
        if (div != null) {
            try {
                DatumRange drRound;
                DatumRange minDr;
                int px = 999;
                while (px > 1) {
                    div = div.finerDivider(false);
                    minDr = div.rangeContaining(dr.min());
                    px = (int)Math.ceil(Math.abs(xAxis.transform(minDr.max()) - xAxis.transform(minDr.min())));
                }
                minDr = div.rangeContaining(dr.min());
                DatumRange maxDr = div.rangeContaining(dr.max());
                Datum min = DatumRangeUtil.normalize((DatumRange)minDr, (Datum)dr.min()) < 0.5 ? minDr.min() : minDr.max();
                Datum max = DatumRangeUtil.normalize((DatumRange)maxDr, (Datum)dr.max()) < 0.5 ? maxDr.min() : maxDr.max();
                dr = drRound = new DatumRange(min, max);
            }
            catch (InconvertibleUnitsException ex) {
                // empty catch block
            }
        }
        return dr;
    }

    private Pos position(DasDevicePosition ddp, int pos, int threshold) {
        int min;
        int max = ddp.getDMaximum();
        if ((max - (min = ddp.getDMinimum())) / threshold < 3) {
            threshold = (max - min) / 3;
        }
        if (pos < min) {
            return Pos.beyondMin;
        }
        if (pos < min + threshold) {
            return Pos.min;
        }
        if (pos <= max - threshold) {
            return Pos.middle;
        }
        if (pos <= max) {
            return Pos.max;
        }
        return Pos.beyondMax;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int i;
        DatumRange dr;
        double nmax;
        double nmin;
        double xshift = 0.0;
        double yshift = 0.0;
        if (e.isControlDown() || e.isShiftDown()) {
            if (this.xAxis != null && this.yAxis != null) {
                return;
            }
            if (e.getWheelRotation() < 0) {
                nmin = -0.2;
                nmax = 0.8;
            } else {
                nmin = 0.2;
                nmax = 1.2;
            }
        } else {
            Pos ypos;
            Point ep = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.parent.getCanvas());
            Pos xpos = this.xAxis == null ? Pos._null : this.position(this.xAxis.getColumn(), ep.x, 20);
            Pos pos = ypos = this.yAxis == null ? Pos._null : this.position(this.yAxis.getRow(), ep.y, 20);
            if (e.getWheelRotation() < 0) {
                nmin = 0.1;
                nmax = 0.9;
            } else {
                nmin = -0.125;
                nmax = 1.125;
            }
            switch (xpos) {
                case min: {
                    xshift = -nmin;
                    break;
                }
                case max: {
                    xshift = nmin;
                }
            }
            switch (ypos) {
                case min: {
                    yshift = nmin;
                    break;
                }
                case max: {
                    yshift = -nmin;
                }
            }
        }
        int clickMag = 1;
        long t1 = System.nanoTime();
        long limitNanos = 40000000L;
        if ((t1 - this.t0) / (long)clickMag < limitNanos) {
            clickMag = (int)Math.floor((double)(t1 - this.t0) / (double)limitNanos);
        }
        if (clickMag == 0) {
            return;
        }
        this.t0 = System.nanoTime();
        DatumRange xdrnew = null;
        DatumRange ydrnew = null;
        if (this.axisIsAdjustable(this.xAxis)) {
            dr = this.xAxis.getDatumRange();
            for (i = 0; i < clickMag; ++i) {
                dr = this.xAxis.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)dr, (double)(nmin + xshift), (double)(nmax + xshift)) : DatumRangeUtil.rescale((DatumRange)dr, (double)(nmin + xshift), (double)(nmax + xshift));
            }
            if (!DatumRangeUtil.isAcceptable((DatumRange)(dr = this.maybeRound(this.xAxis, dr)), (boolean)this.xAxis.isLog())) {
                dr = null;
            }
            xdrnew = dr;
        }
        if (this.axisIsAdjustable(this.yAxis)) {
            dr = this.yAxis.getDatumRange();
            for (i = 0; i < clickMag; ++i) {
                dr = this.yAxis.isLog() ? DatumRangeUtil.rescaleLog((DatumRange)dr, (double)(nmin + yshift), (double)(nmax + yshift)) : DatumRangeUtil.rescale((DatumRange)dr, (double)(nmin + yshift), (double)(nmax + yshift));
            }
            if (!DatumRangeUtil.isAcceptable((DatumRange)(dr = this.maybeRound(this.yAxis, dr)), (boolean)this.yAxis.isLog())) {
                dr = null;
            }
            ydrnew = dr;
        }
        if (this.axisIsAdjustable(this.xAxis) && xdrnew == null) {
            return;
        }
        if (this.axisIsAdjustable(this.yAxis) && ydrnew == null) {
            return;
        }
        if (this.axisIsAdjustable(this.xAxis)) {
            this.xAxis.setDatumRange(xdrnew);
        }
        if (this.axisIsAdjustable(this.yAxis)) {
            this.yAxis.setDatumRange(ydrnew);
        }
        super.mouseWheelMoved(e);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.xAxis != null) {
            this.xAxisLock.unlock();
            this.xAxisLock = null;
        }
        if (this.yAxis != null) {
            this.yAxisLock.unlock();
            this.yAxisLock = null;
        }
        this.doPan(e);
        this.parent.getCanvas().getGlassPane().setCursor(null);
    }

    private void doPan(MouseEvent e) {
        DatumRange dr;
        Point p2 = e.getPoint();
        if (this.axisIsAdjustable(this.xAxis)) {
            Datum delta;
            if (this.xAxis.isLog()) {
                delta = this.xAxis.invTransform(this.p0.getX()).divide(this.xAxis.invTransform(p2.getX()));
                dr = new DatumRange(this.xAxisRange0.min().multiply(delta), this.xAxisRange0.max().multiply(delta));
            } else {
                delta = this.xAxis.invTransform(this.p0.getX()).subtract(this.xAxis.invTransform(p2.getX()));
                dr = new DatumRange(this.xAxisRange0.min().add(delta), this.xAxisRange0.max().add(delta));
            }
            dr = this.maybeRound(this.xAxis, dr);
            this.xAxis.setDatumRange(dr);
        }
        if (this.axisIsAdjustable(this.yAxis)) {
            Datum ydelta;
            if (this.yAxis.isLog()) {
                ydelta = this.yAxis.invTransform(this.p0.getY()).divide(this.yAxis.invTransform(p2.getY()));
                dr = new DatumRange(this.yAxisRange0.min().multiply(ydelta), this.yAxisRange0.max().multiply(ydelta));
            } else {
                ydelta = this.yAxis.invTransform(this.p0.getY()).subtract(this.yAxis.invTransform(p2.getY()));
                dr = new DatumRange(this.yAxisRange0.min().add(ydelta), this.yAxisRange0.max().add(ydelta));
            }
            dr = this.maybeRound(this.yAxis, dr);
            this.yAxis.setDatumRange(dr);
        }
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.doPan(e);
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.p0 = e.getPoint();
        if (this.xAxis != null) {
            this.xAxisRange0 = this.xAxis.getDatumRange();
            this.xAxisLock = this.xAxis.mutatorLock();
            this.xAxisLock.lock();
        }
        if (this.yAxis != null) {
            this.yAxisRange0 = this.yAxis.getDatumRange();
            this.yAxisLock = this.yAxis.mutatorLock();
            this.yAxisLock.lock();
        }
        this.parent.getCanvas().getGlassPane().setCursor(new Cursor(13));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Pos {
        _null,
        beyondMin,
        min,
        middle,
        max,
        beyondMax;

    }
}

