/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.system.DasLogger;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;

public class Auralizor {
    private static final int EXTERNAL_BUFFER_SIZE = 100000;
    ByteBuffer buffer;
    byte[] buf;
    SourceDataLine line = null;
    int bufferInputIndex;
    double min = -1.0;
    double max = 1.0;
    Units yUnits;
    QDataSet ds;

    void setDataSet(QDataSet ds) {
        this.ds = ds;
    }

    public void playSound() {
        QDataSet dep0 = (QDataSet)this.ds.property("DEPEND_0");
        UnitsConverter uc = UnitsConverter.getConverter((Units)SemanticOps.getUnits((QDataSet)dep0).getOffsetUnits(), (Units)Units.seconds);
        float sampleRate = (float)(1.0 / uc.convert(dep0.value(1) - dep0.value(0)));
        DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("sampleRate= " + sampleRate);
        AudioFormat audioFormat = new AudioFormat(sampleRate, 16, 1, true, true);
        this.buf = new byte[100000];
        this.buffer = ByteBuffer.wrap(this.buf);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat);
            this.line.addLineListener(this.getLineListener());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.bufferInputIndex = 0;
        this.line.start();
        int i = 0;
        int ibuf = 0;
        while (i < dep0.length()) {
            double d = this.ds.value(i++);
            int b = (int)(65536.0 * (d - this.min) / (this.max - this.min)) - 32768;
            try {
                this.buffer.putShort(ibuf, (short)b);
            }
            catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }
            if ((ibuf += 2) != 100000) continue;
            this.line.write(this.buf, 0, ibuf);
            try {
                FileChannel out = new FileOutputStream("/home/jbf/tmp/foo.bin").getChannel();
                out.write(this.buffer);
                this.buffer.flip();
            }
            catch (IOException ex) {
                Logger.getLogger(Auralizor.class.getName()).log(Level.SEVERE, null, ex);
            }
            ibuf = 0;
        }
        this.line.write(this.buf, 0, ibuf);
        try {
            FileChannel out = new FileOutputStream("/home/jbf/tmp/foo.bin").getChannel();
            out.write(this.buffer);
            this.buffer.flip();
        }
        catch (IOException ex) {
            Logger.getLogger(Auralizor.class.getName()).log(Level.SEVERE, null, ex);
        }
        ibuf = 0;
        this.line.drain();
        this.line.close();
    }

    LineListener getLineListener() {
        return new LineListener(){

            public void update(LineEvent e) {
                if (e.getType().equals(LineEvent.Type.CLOSE)) {
                    // empty if block
                }
            }
        };
    }

    public Auralizor(QDataSet ds) {
        QDataSet yrange = Ops.extent((QDataSet)ds);
        this.min = yrange.value(0);
        this.max = yrange.value(1);
        this.ds = ds;
    }
}

