/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasProperties;
import org.das2.dataset.DataSetDescriptor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;
import org.das2.datum.DomainDividerUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.event.DataRangeSelectionEvent;
import org.das2.event.DataRangeSelectionListener;
import org.das2.event.HorizontalRangeSelectorMouseModule;
import org.das2.event.MouseModule;
import org.das2.event.TimeRangeSelectionEvent;
import org.das2.event.TimeRangeSelectionListener;
import org.das2.event.VerticalRangeSelectorMouseModule;
import org.das2.event.ZoomPanMouseModule;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.DataRange;
import org.das2.graph.GraphUtil;
import org.das2.graph.TickVDescriptor;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.DasMath;
import org.das2.util.GrannyTextRenderer;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QFunction;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;

public class DasAxis
extends DasCanvasComponent
implements DataRangeSelectionListener,
TimeRangeSelectionListener,
Cloneable {
    public static final String PROP_LABEL = "label";
    public static final String PROP_LOG = "log";
    public static final String PROP_OPPOSITE_AXIS_VISIBLE = "oppositeAxisVisible";
    public static final String PROP_BOUNDS = "bounds";
    public static final String PROP_SCAN_RANGE = "scanRange";
    public static final String PROP_UNITS = "units";
    public static final String PROPERTY_TICKS = "ticks";
    private static final int MAX_TCA_LINES = 10;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int UP = 995;
    public static final int DOWN = 996;
    private static final String SCAN_PREVIOUS_LABEL = "<< scan";
    private static final String SCAN_NEXT_LABEL = "scan >>";
    protected DataRange dataRange;
    private DatumFormatter userDatumFormatter = null;
    double at_m;
    double at_b;
    private int orientation;
    private int tickDirection = 1;
    protected String axisLabel = "";
    protected TickVDescriptor tickV;
    private boolean autoTickV = true;
    private boolean ticksVisible = true;
    private boolean tickLabelsVisible = true;
    private boolean oppositeAxisVisible = false;
    protected DatumFormatter datumFormatter = DefaultDatumFormatterFactory.getInstance().defaultFormatter();
    private MouseModule zoom = null;
    private PropertyChangeListener dataRangePropertyListener;
    protected JPanel primaryInputPanel;
    protected JPanel secondaryInputPanel;
    private ScanButton scanPrevious;
    private ScanButton scanNext;
    private DatumRange scanRange;
    private boolean animated = "on".equals(DasProperties.getInstance().get("visualCues"));
    private Rectangle blLineRect;
    private Rectangle trLineRect;
    private Rectangle blTickRect;
    private Rectangle trTickRect;
    private Rectangle blLabelRect;
    private Rectangle trLabelRect;
    private Rectangle blTitleRect;
    private Rectangle trTitleRect;
    private boolean flipped;
    private EventListenerList timeRangeListenerList = null;
    private TimeRangeSelectionEvent lastProcessedEvent = null;
    private QFunction tcaFunction;
    private QDataSet tcaData = null;
    private String dataset = "";
    private boolean drawTca;
    public static final String PROPERTY_DATUMRANGE = "datumRange";
    private static boolean DEBUG_GRAPHICS = false;
    private static final Color[] DEBUG_COLORS = DEBUG_GRAPHICS ? new Color[]{Color.BLACK, Color.RED, Color.GREEN, Color.BLUE, Color.GRAY, Color.CYAN, Color.MAGENTA, Color.YELLOW} : null;
    int tickLen = 0;
    String tickLenStr = "0.66em";
    final int TICK_LABEL_GAP_MIN = 4;
    private int debugColorIndex = 0;
    private DasPlot dasPlot;
    private JMenu bookmarksMenu;
    private JMenu backMenu;
    private static final Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    protected boolean enableHistory = true;
    public static final String PROP_ENABLEHISTORY = "enableHistory";
    private static final Pattern pattern = Pattern.compile("\\([eEfF]\\d+.\\d+\\)");
    protected String formatString = "";
    public static final String PROP_FORMATSTRING = "formatString";
    protected boolean flipLabel = false;
    public static final String PROP_FLIPLABEL = "flipLabel";
    protected DatumFormatter dividerDatumFormatter = null;
    public static final String PROP_DIVIDERDATUMFORMATTER = "dividerDatumFormatter";
    protected DomainDivider minorTicksDomainDivider = null;
    public static final String PROP_MINORTICKSDOMAINDIVIDER = "minorTicksDomainDivider";
    protected DomainDivider majorTicksDomainDivider = null;
    public static final String PROP_MAJORTICKSDOMAINDIVIDER = "majorTicksDomainDivider";
    protected boolean useDomainDivider = false;
    public static final String PROP_USEDOMAINDIVIDER = "useDomainDivider";

    public DatumFormatter getUserDatumFormatter() {
        return this.userDatumFormatter;
    }

    public void setUserDatumFormatter(DatumFormatter userDatumFormatter) {
        DatumFormatter old = this.userDatumFormatter;
        this.userDatumFormatter = userDatumFormatter;
        if (old != userDatumFormatter) {
            this.updateTickV();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DasAxis.this.resize();
                DasAxis.this.repaint();
            }
        });
    }

    public DasAxis(Datum min, Datum max, int orientation) {
        this(min, max, orientation, false);
    }

    public DasAxis(DatumRange range, int orientation) {
        this(range.min(), range.max(), orientation);
    }

    public DasAxis(Datum min, Datum max, int orientation, boolean log) {
        this(orientation);
        this.dataRange = new DataRange(this, min, max, log);
        this.addListenersToDataRange(this.dataRange, this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    protected DasAxis(DataRange range, int orientation) {
        this(orientation);
        this.dataRange = range;
        this.addListenersToDataRange(range, this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    private DasAxis(int orientation) {
        this.setOpaque(false);
        this.setOrientationInternal(orientation);
        this.installMouseModules();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.backMenu = new JMenu("Back");
            this.mouseAdapter.addMenuItem(this.backMenu);
            this.bookmarksMenu = new JMenu("Bookmarks");
            this.mouseAdapter.addMenuItem(this.bookmarksMenu);
        }
        this.dataRangePropertyListener = this.createDataRangePropertyListener();
        this.setLayout(new AxisLayoutManager());
        this.maybeInitializeInputPanels();
        this.maybeInitializeScanButtons();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.scanNext.setEnabled(true);
            this.scanPrevious.setEnabled(true);
        }
        this.add(this.primaryInputPanel);
        this.add(this.secondaryInputPanel);
        try {
            this.updateTickLength();
        }
        catch (ParseException ex) {
            Logger.getLogger(DasAxis.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.addPropertyChangeListener("font", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    DasAxis.this.updateTickLength();
                }
                catch (ParseException ex) {
                    Logger.getLogger(DasAxis.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    private void addListenersToDataRange(DataRange range, PropertyChangeListener listener) {
        range.addPropertyChangeListener(PROP_LOG, listener);
        range.addPropertyChangeListener("minimum", listener);
        range.addPropertyChangeListener("maximum", listener);
        range.addPropertyChangeListener(PROPERTY_DATUMRANGE, listener);
        range.addPropertyChangeListener("history", listener);
        range.addPropertyChangeListener("favorites", listener);
    }

    public void addToFavorites(DatumRange range) {
        this.dataRange.addToFavorites(range);
        this.copyFavorites();
    }

    public void removeFromFavorites(DatumRange range) {
        this.dataRange.removeFromFavorites(range);
        this.copyFavorites();
    }

    private void copyFavorites() {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            return;
        }
        this.bookmarksMenu.removeAll();
        List favorites = this.dataRange.getFavorites();
        for (final DatumRange r : favorites) {
            AbstractAction action = new AbstractAction(r.toString()){

                public void actionPerformed(ActionEvent e) {
                    DasAxis.this.setDatumRange(r);
                }
            };
            JMenuItem menuItem = new JMenuItem(action);
            this.bookmarksMenu.add(menuItem);
        }
        this.bookmarksMenu.add(new JSeparator());
        AbstractAction action = new AbstractAction("bookmark this range"){

            public void actionPerformed(ActionEvent e) {
                DasAxis.this.addToFavorites(DasAxis.this.getDatumRange());
            }
        };
        JMenuItem addItem = new JMenuItem(action);
        this.bookmarksMenu.add(addItem);
        this.bookmarksMenu.add(new JSeparator());
        AbstractAction action2 = new AbstractAction("remove bookmark for range"){

            public void actionPerformed(ActionEvent e) {
                DasAxis.this.removeFromFavorites(DasAxis.this.getDatumRange());
            }
        };
        JMenuItem rmItem = new JMenuItem(action2);
        this.bookmarksMenu.add(rmItem);
    }

    private void copyHistory() {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            return;
        }
        if (!this.enableHistory) {
            return;
        }
        this.backMenu.removeAll();
        List history = this.dataRange.getHistory();
        int ii = 0;
        Iterator i = history.iterator();
        while (i.hasNext()) {
            final int ipop = ii++;
            DatumRange r = (DatumRange)i.next();
            AbstractAction action = new AbstractAction(r.toString()){

                public void actionPerformed(ActionEvent e) {
                    DasAxis.this.dataRange.popHistory(ipop);
                    DasAxis.this.setDataRangePrev();
                }
            };
            JMenuItem menuItem = new JMenuItem(action);
            this.backMenu.add(menuItem);
        }
    }

    public boolean isEnableHistory() {
        return this.enableHistory;
    }

    public void setEnableHistory(boolean enableHistory) {
        boolean oldEnableHistory = this.enableHistory;
        this.enableHistory = enableHistory;
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            if (!enableHistory) {
                this.getDasMouseInputAdapter().removeMenuItem(this.backMenu.getText());
            } else {
                this.getDasMouseInputAdapter().addMenuItem(this.backMenu);
            }
        }
        this.firePropertyChange(PROP_ENABLEHISTORY, oldEnableHistory, enableHistory);
    }

    private void maybeInitializeInputPanels() {
        if (this.primaryInputPanel == null) {
            this.primaryInputPanel = new JPanel();
            this.primaryInputPanel.setOpaque(false);
        }
        if (this.secondaryInputPanel == null) {
            this.secondaryInputPanel = new JPanel();
            this.secondaryInputPanel.setOpaque(false);
        }
    }

    private void maybeInitializeScanButtons() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            this.scanPrevious = new ScanButton(SCAN_PREVIOUS_LABEL);
            this.scanNext = new ScanButton(SCAN_NEXT_LABEL);
            ActionListener al = this.createScanActionListener();
            this.scanPrevious.addActionListener(al);
            this.scanNext.addActionListener(al);
            this.add(this.scanPrevious);
            this.add(this.scanNext);
        }
    }

    private ActionListener createScanActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                DasLogger.getLogger(DasLogger.GUI_LOG).fine("event " + command);
                if (command.equals(DasAxis.SCAN_PREVIOUS_LABEL)) {
                    if (DasAxis.this.scanRange == null || DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().previous())) {
                        DasAxis.this.scanPrevious();
                    }
                } else if (command.equals(DasAxis.SCAN_NEXT_LABEL) && (DasAxis.this.scanRange == null || DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().next()))) {
                    DasAxis.this.scanNext();
                }
            }
        };
    }

    private PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                Object oldValue = e.getOldValue();
                Object newValue = e.getNewValue();
                if (propertyName.equals(DasAxis.PROP_LOG)) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange(DasAxis.PROP_LOG, oldValue, newValue);
                } else if (propertyName.equals("minimum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMinimum", oldValue, newValue);
                } else if (propertyName.equals("maximum")) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange("dataMaximum", oldValue, newValue);
                } else if (propertyName.equals("favorites")) {
                    DasAxis.this.copyFavorites();
                } else if (propertyName.equals(DasAxis.PROPERTY_DATUMRANGE)) {
                    DasAxis.this.update();
                    DasAxis.this.firePropertyChange(DasAxis.PROPERTY_DATUMRANGE, oldValue, newValue);
                } else if (propertyName.equals("history") && !DasAxis.this.dataRange.valueIsAdjusting()) {
                    DasAxis.this.copyHistory();
                }
                DasAxis.this.markDirty();
            }
        };
    }

    private void installMouseModules() {
        if (this.zoom instanceof HorizontalRangeSelectorMouseModule) {
            ((HorizontalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        } else if (this.zoom instanceof VerticalRangeSelectorMouseModule) {
            ((VerticalRangeSelectorMouseModule)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        }
        if (this.isHorizontal()) {
            this.zoom = new HorizontalRangeSelectorMouseModule(this, this);
            ((HorizontalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
            ZoomPanMouseModule zoomPan = new ZoomPanMouseModule((DasCanvasComponent)this, this, null);
            this.mouseAdapter.addMouseModule(zoomPan);
            this.mouseAdapter.setSecondaryModule(zoomPan);
        } else {
            this.zoom = new VerticalRangeSelectorMouseModule(this, this);
            ((VerticalRangeSelectorMouseModule)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
            ZoomPanMouseModule zoomPan = new ZoomPanMouseModule((DasCanvasComponent)this, null, this);
            this.mouseAdapter.addMouseModule(zoomPan);
            this.mouseAdapter.setSecondaryModule(zoomPan);
        }
    }

    public void setOrientation(int orientation) {
        boolean oldIsHorizontal = this.isHorizontal();
        this.setOrientationInternal(orientation);
        if (oldIsHorizontal != this.isHorizontal()) {
            this.installMouseModules();
        }
    }

    private void setOrientationInternal(int orientation) {
        this.orientation = orientation;
        if (orientation == 1) {
            this.setTickDirection(995);
        } else if (orientation == 2) {
            this.setTickDirection(996);
        } else if (orientation == 3) {
            this.setTickDirection(4);
        } else if (orientation == 4) {
            this.setTickDirection(3);
        } else {
            throw new IllegalArgumentException("Invalid value for orientation");
        }
    }

    public void setDatumRange(DatumRange dr) {
        if (this.getUnits().isConvertableTo(dr.getUnits())) {
            this.setDataRange(dr.min(), dr.max());
        } else {
            Units oldUnits = this.getUnits();
            this.resetRange(dr);
            this.firePropertyChange(PROP_UNITS, oldUnits, dr.getUnits());
        }
    }

    public DatumRange getDatumRange() {
        return this.dataRange.getDatumRange();
    }

    protected boolean rangeIsAcceptable(DatumRange dr) {
        return dr.min().lt(dr.max());
    }

    public void setDataRange(Datum minimum, Datum maximum) {
        double max;
        double min;
        Units units = this.dataRange.getUnits();
        if (minimum.getUnits() != units) {
            minimum = minimum.convertTo(units);
            maximum = maximum.convertTo(units);
        }
        DatumRange newRange = new DatumRange(minimum, maximum);
        logger.fine("enter dasAxis.setDataRange( " + newRange + " )");
        if (!this.rangeIsAcceptable(newRange)) {
            logger.warning("invalid range ignored");
            return;
        }
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        if (this.dataRange.isLog()) {
            min = Math.log10(minimum.doubleValue(this.getUnits()));
            max = Math.log10(maximum.doubleValue(this.getUnits()));
            if (minimum.doubleValue(this.getUnits()) == 0.0) {
                min = max / 1000.0;
            }
        } else {
            min = minimum.doubleValue(this.getUnits());
            max = maximum.doubleValue(this.getUnits());
        }
        if (!this.valueIsAdjusting()) {
            this.animateChange(min0, max0, min, max);
        }
        DatumRange oldRange = this.dataRange.getDatumRange();
        this.dataRange.setRange(newRange);
        this.refreshScanButtons(false);
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public void clearHistory() {
        this.dataRange.clearHistory();
    }

    private void createAndFireRangeSelectionEvent() {
        if (this.getUnits() instanceof TimeLocationUnits) {
            logger.fine("firing rangeSelectionEvent");
            TimeRangeSelectionEvent e = new TimeRangeSelectionEvent(this, new DatumRange(this.getDataMinimum(), this.getDataMaximum()));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(e);
        }
    }

    public void setDataRangePrev() {
        logger.fine("enter dasAxis.setDataRangePrev()");
        DatumRange oldRange = this.dataRange.getDatumRange();
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        this.dataRange.setRangePrev();
        DatumRange newRange = this.dataRange.getDatumRange();
        double min1 = this.dataRange.getMinimum();
        double max1 = this.dataRange.getMaximum();
        this.animateChange(min0, max0, min1, max1);
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public void setDataRangeForward() {
        logger.fine("enter dasAxis.setDataRangeForward()");
        double min0 = this.dataRange.getMinimum();
        double max0 = this.dataRange.getMaximum();
        DatumRange oldRange = this.dataRange.getDatumRange();
        this.dataRange.setRangeForward();
        DatumRange newRange = this.dataRange.getDatumRange();
        double min1 = this.dataRange.getMinimum();
        double max1 = this.dataRange.getMaximum();
        this.animateChange(min0, max0, min1, max1);
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public void setDataRangeZoomOut() {
        logger.fine("enter dasAxis.setDataRangeZoomOut()");
        double t1 = this.dataRange.getMinimum();
        double t2 = this.dataRange.getMaximum();
        double delta = t2 - t1;
        double min = t1 - delta;
        double max = t2 + delta;
        this.animateChange(t1, t2, min, max);
        DatumRange oldRange = this.dataRange.getDatumRange();
        if (!DatumRangeUtil.isAcceptable((DatumRange)DatumRange.newDatumRange((double)min, (double)max, (Units)this.getUnits()), (boolean)this.isLog())) {
            System.err.println("zoom out limit");
            return;
        }
        this.dataRange.setRange(min, max);
        DatumRange newRange = this.dataRange.getDatumRange();
        this.update();
        this.createAndFireRangeSelectionEvent();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, newRange);
    }

    public DataRange getDataRange() {
        return this.dataRange;
    }

    protected void deviceRangeChanged() {
    }

    public Datum getDataMinimum() {
        return this.dataRange.getDatumRange().min();
    }

    public Datum getDataMaximum() {
        return this.dataRange.getDatumRange().max();
    }

    public DatumRange getRange() {
        return this.dataRange.getDatumRange();
    }

    public double getDataMaximum(Units units) {
        return this.getDataMaximum().doubleValue(units);
    }

    public double getDataMinimum(Units units) {
        return this.getDataMinimum().doubleValue(units);
    }

    public void setDataMaximum(Datum max) {
        this.dataRange.setMaximum(max);
        this.update();
    }

    public void setDataMinimum(Datum min) {
        this.dataRange.setMinimum(min);
        this.update();
    }

    public boolean isLog() {
        return this.dataRange.isLog();
    }

    public void setLog(boolean log) {
        boolean oldLog = this.isLog();
        DatumRange range = this.getDatumRange();
        this.dataRange.setLog(log);
        this.update();
        if (log != oldLog) {
            this.firePropertyChange(PROP_LOG, oldLog, log);
        }
        if (!range.equals((Object)this.getDatumRange())) {
            this.firePropertyChange(PROPERTY_DATUMRANGE, range, this.getDatumRange());
        }
    }

    public Units getUnits() {
        return this.dataRange.getUnits();
    }

    public void setUnits(Units newUnits) {
        this.dataRange.setUnits(newUnits);
    }

    public void setScanRange(DatumRange range) {
        DatumRange old = this.scanRange;
        this.scanRange = range;
        this.firePropertyChange(PROP_SCAN_RANGE, old, range);
    }

    public DatumRange getScanRange() {
        return this.scanRange;
    }

    public synchronized void resetRange(DatumRange range) {
        DatumRange oldRange = this.getDatumRange();
        if (range.getUnits() != this.getUnits()) {
            if (this.dasPlot != null) {
                this.dasPlot.invalidateCacheImage();
            }
            logger.finest("replaceRange(" + range + ")");
            this.dataRange.resetRange(range);
        } else {
            this.dataRange.setRange(range);
        }
        this.updateTickV();
        this.markDirty();
        this.firePropertyChange(PROPERTY_DATUMRANGE, oldRange, range);
        this.update();
    }

    public void setOppositeAxisVisible(boolean visible) {
        if (visible == this.oppositeAxisVisible) {
            return;
        }
        boolean oldValue = this.oppositeAxisVisible;
        this.oppositeAxisVisible = visible;
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROP_OPPOSITE_AXIS_VISIBLE, oldValue, visible);
    }

    public boolean isOppositeAxisVisible() {
        return this.oppositeAxisVisible;
    }

    public void setLabel(String t) {
        if (t == null) {
            throw new NullPointerException("axis label cannot be null");
        }
        String oldValue = this.axisLabel;
        this.axisLabel = t;
        this.update();
        this.firePropertyChange(PROP_LABEL, oldValue, t);
    }

    public String getLabel() {
        return this.axisLabel;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean getDrawTca() {
        return this.drawTca;
    }

    public void setDrawTca(boolean b) {
        boolean oldValue = this.drawTca;
        if (b && this.getOrientation() != 2) {
            throw new IllegalArgumentException("Vertical time axes cannot have annotations");
        }
        if (this.drawTca == b) {
            return;
        }
        this.drawTca = b;
        this.markDirty();
        this.update();
        this.firePropertyChange("showTca", oldValue, b);
    }

    public String getDataPath() {
        return this.dataset;
    }

    private static QFunction tcaFunction(String dataset) throws DasException {
        QFunction result;
        block10: {
            result = null;
            if (dataset.startsWith("/")) {
                throw new IllegalArgumentException("das2 legacy TCA stuff needs to be implemented");
            }
            if (dataset.startsWith("class:")) {
                try {
                    try {
                        int argPos = dataset.indexOf(58, 6);
                        String arg = null;
                        if (argPos == -1) {
                            String className = dataset.substring(6);
                            result = (QFunction)Class.forName(className).newInstance();
                            break block10;
                        }
                        String className = dataset.substring(6, argPos);
                        arg = dataset.substring(argPos + 1);
                        try {
                            result = (QFunction)Class.forName(className).getConstructor(String.class).newInstance(arg);
                        }
                        catch (Exception ex) {
                            throw new DasException(ex);
                        }
                    }
                    catch (InstantiationException ex) {
                        Logger.getLogger(DasAxis.class.getName()).log(Level.SEVERE, null, ex);
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(DasAxis.class.getName()).log(Level.SEVERE, null, ex);
                        ex.printStackTrace();
                    }
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(DasAxis.class.getName()).log(Level.SEVERE, null, ex);
                    ex.printStackTrace();
                }
            }
        }
        return result;
    }

    public void setDataPath(String dataset) {
        if (dataset == null) {
            throw new NullPointerException("null dataPath string not allowed");
        }
        String oldValue = this.dataset;
        if (dataset.equals(this.dataset)) {
            return;
        }
        this.dataset = dataset;
        if (dataset.equals("")) {
            this.tcaFunction = null;
        } else {
            try {
                this.tcaFunction = DasAxis.tcaFunction(dataset);
                if (this.tcaFunction == null) {
                    throw new IllegalArgumentException("unable to implement tca QFunction: " + dataset);
                }
            }
            catch (DasException de) {
                DasExceptionHandler.handle((Throwable)de);
            }
        }
        this.markDirty();
        this.update();
        this.firePropertyChange("dataPath", oldValue, dataset);
    }

    public void setDataSetDescriptor(DataSetDescriptor dsdAux) {
        if (dsdAux == null) {
            throw new NullPointerException("null DataSetDescriptor not allowed");
        }
        throw new IllegalArgumentException("need to implement");
    }

    public void setTcaFunction(QFunction f) {
        QFunction oldF = this.tcaFunction;
        this.tcaFunction = f;
        this.markDirty();
        this.update();
        this.firePropertyChange("dataSetDescriptor", null, null);
        this.firePropertyChange("dataPath", null, null);
        this.firePropertyChange("tcaFunction", oldF, f);
    }

    private void updateTCADataSet() {
        Units tcaUnits;
        QFunction ltcaFunction = this.tcaFunction;
        if (ltcaFunction == null) {
            return;
        }
        logger.fine("updateTCADataSet");
        double[] tickV = this.getTickV().tickV.toDoubleArray(this.getUnits());
        this.tcaData = null;
        JoinDataSet ltcaData = new JoinDataSet(2);
        ArrayDataSet ex = ArrayDataSet.copy((QDataSet)ltcaFunction.exampleInput());
        QDataSet bds = (QDataSet)ex.property("BUNDLE_0");
        if (bds == null) {
            System.err.println("no bundle descriptor, dealing with it.");
            tcaUnits = (Units)ex.property("UNITS", 0);
        } else {
            tcaUnits = (Units)bds.property("UNITS", 0);
        }
        if (!this.getUnits().isConvertableTo(tcaUnits)) {
            System.err.println("tca units are not convertable");
            return;
        }
        UnitsConverter uc = UnitsConverter.getConverter((Units)this.getUnits(), (Units)tcaUnits);
        DatumRange context = this.getDatumRange();
        context = DatumRangeUtil.union((DatumRange)context, (Datum)this.getUnits().createDatum(uc.convert(tickV[0])));
        context = DatumRangeUtil.union((DatumRange)context, (Datum)this.getUnits().createDatum(uc.convert(tickV[tickV.length - 1])));
        ex.putProperty("CONTEXT_0", 0, (Object)DataSetUtil.asDataSet((DatumRange)context));
        DRank0DataSet dx = DataSetUtil.asDataSet((Datum)this.getDatumRange().width().divide((double)this.getColumn().getWidth()));
        ex.putProperty("DELTA_PLUS", 0, (Object)dx);
        ex.putProperty("DELTA_MINUS", 0, (Object)dx);
        DDataSet dep0 = DDataSet.createRank1((int)tickV.length);
        dep0.putProperty("UNITS", (Object)this.getUnits());
        QDataSet outDescriptor = null;
        for (int i = 0; i < tickV.length; ++i) {
            ex.putValue(0, uc.convert(tickV[i]));
            QDataSet ticks = ltcaFunction.value((QDataSet)ex);
            if (outDescriptor == null) {
                outDescriptor = (QDataSet)ticks.property("BUNDLE_0");
            }
            ltcaData.join(ticks);
            dep0.putValue(i, tickV[i]);
        }
        ltcaData.putProperty("BUNDLE_1", outDescriptor);
        ltcaData.putProperty("DEPEND_0", (Object)dep0);
        this.tcaData = ltcaData;
    }

    public final int getDevicePosition() {
        if (this.orientation == 2) {
            return this.getRow().getDMaximum();
        }
        if (this.orientation == 1) {
            return this.getRow().getDMinimum();
        }
        if (this.orientation == 3) {
            return this.getColumn().getDMinimum();
        }
        return this.getColumn().getDMaximum();
    }

    public int getDLength() {
        if (this.isHorizontal()) {
            return this.getColumn().getWidth();
        }
        return this.getRow().getHeight();
    }

    public DasAxis getMasterAxis() {
        return this.dataRange.getCreator();
    }

    public void attachTo(DasAxis axis) {
        DataRange oldRange = this.dataRange;
        this.dataRange = axis.dataRange;
        oldRange.removePropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        oldRange.removePropertyChangeListener(PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener(PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        if (oldRange.isLog() != this.dataRange.isLog()) {
            this.firePropertyChange(PROP_LOG, oldRange.isLog(), this.dataRange.isLog());
        }
        this.firePropertyChange("minimum", oldRange.getMinimum(), this.dataRange.getMinimum());
        this.firePropertyChange("maximum", oldRange.getMaximum(), this.dataRange.getMaximum());
        this.copyFavorites();
        this.copyHistory();
    }

    public void detach() {
        DataRange newRange;
        this.dataRange.removePropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener(PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        this.dataRange = newRange = new DataRange(this, Datum.create((double)this.dataRange.getMinimum(), (Units)this.dataRange.getUnits()), Datum.create((double)this.dataRange.getMaximum(), (Units)this.dataRange.getUnits()), this.dataRange.isLog());
        this.dataRange.addPropertyChangeListener(PROP_LOG, this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener(PROPERTY_DATUMRANGE, this.dataRangePropertyListener);
        this.copyFavorites();
        this.copyHistory();
    }

    public boolean isAttached() {
        return this != this.getMasterAxis();
    }

    public TickVDescriptor getTickV() {
        if (this.tickV == null) {
            this.updateTickV();
        }
        return this.tickV;
    }

    public synchronized void setTickV(TickVDescriptor tickV) {
        this.checkTickV(tickV);
        this.tickV = tickV;
        if (tickV == null) {
            this.autoTickV = true;
            this.updateTickV();
        } else {
            this.autoTickV = false;
        }
        this.update();
    }

    private void checkTickV(TickVDescriptor tickV) throws IllegalArgumentException {
    }

    private void updateTickVLog() {
        GrannyTextRenderer idlt = new GrannyTextRenderer();
        idlt.setString(this.getTickLabelFont(), "10!U-10");
        int nTicksMax = this.isHorizontal() ? (int)Math.floor((double)this.getColumn().getWidth() / idlt.getWidth()) : (int)Math.floor((double)this.getRow().getHeight() / idlt.getHeight());
        nTicksMax = nTicksMax < 7 ? nTicksMax : 7;
        this.tickV = TickVDescriptor.bestTickVLogNew(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax, true);
        this.datumFormatter = this.resolveFormatter(this.tickV);
    }

    private void updateTickVLinear() {
        int nTicksMax;
        int axisSize;
        int tickSizePixels;
        if (this.isHorizontal()) {
            tickSizePixels = (int)((double)this.getFontMetrics(this.getTickLabelFont()).stringWidth("0.0000") * 1.5);
            axisSize = this.getColumn().getWidth();
            nTicksMax = axisSize / tickSizePixels;
        } else {
            tickSizePixels = this.getFontMetrics(this.getTickLabelFont()).getHeight() + 6;
            axisSize = this.getRow().getHeight();
            nTicksMax = axisSize / tickSizePixels;
        }
        nTicksMax = nTicksMax < 7 ? nTicksMax : 7;
        this.tickV = TickVDescriptor.bestTickVLinear(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax, false);
        DatumFormatter tdf = this.resolveFormatter(this.tickV);
        boolean once = true;
        while (once) {
            int tickSizePixels2;
            Rectangle maxBounds = this.getMaxBounds(tdf, this.tickV);
            if (this.isHorizontal()) {
                tickSizePixels2 = (int)((double)maxBounds.width + this.getEmSize() * 2.0);
                nTicksMax = axisSize / tickSizePixels2;
            } else {
                tickSizePixels2 = maxBounds.height;
                nTicksMax = axisSize / tickSizePixels2;
            }
            this.tickV = TickVDescriptor.bestTickVLinear(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax, true);
            this.datumFormatter = this.resolveFormatter(this.tickV);
            once = false;
        }
    }

    private DatumFormatter resolveFormatter(TickVDescriptor tickV) {
        return this.getUserDatumFormatter() == null ? tickV.getFormatter() : this.getUserDatumFormatter();
    }

    private Rectangle getMaxBounds(DatumFormatter tdf, TickVDescriptor tickV) {
        String[] granny = tdf.axisFormat(tickV.tickV, this.getDatumRange());
        GrannyTextRenderer idlt = new GrannyTextRenderer();
        Rectangle bounds = new Rectangle();
        for (int i = 0; i < granny.length; ++i) {
            idlt.setString(this.getTickLabelFont(), granny[i]);
            bounds.add(idlt.getBounds());
        }
        return bounds;
    }

    private boolean hasLabelCollisions(DatumVector major, DatumFormatter df) {
        if (major.getLength() < 2) {
            return false;
        }
        String[] granny = df.axisFormat(major, this.getDatumRange());
        GrannyTextRenderer idlt = new GrannyTextRenderer();
        Rectangle[] bounds = new Rectangle[granny.length];
        for (int i = 0; i < granny.length; ++i) {
            idlt.setString(this.getTickLabelFont(), granny[i]);
            Rectangle bound = idlt.getBounds();
            if (this.isHorizontal()) {
                bound.translate((int)this.transform(major.get(i)), 0);
                bound.width = (int)((double)bound.width + this.getEmSize());
            } else {
                bound.translate(0, (int)this.transform(major.get(i)));
                bound.height = (int)((double)bound.height + this.getEmSize() / 2.0);
            }
            bounds[i] = bound;
        }
        Rectangle bound = bounds[0];
        boolean intersects = false;
        for (int i = 1; i < bounds.length; ++i) {
            if (bounds[i].intersects(bound)) {
                intersects = true;
            }
            bound = bounds[i];
        }
        return intersects;
    }

    private boolean hasTickCollisions(DatumVector minor) {
        if (minor.getLength() < 2) {
            return false;
        }
        int x0 = (int)this.transform(minor.get(0));
        int intersects = 0;
        for (int i = 1; intersects < 8 && i < minor.getLength(); ++i) {
            int x1 = (int)this.transform(minor.get(i));
            if (x1 >= 10000) continue;
            intersects = Math.abs(x0 - x1) < 6 ? ++intersects : 0;
            x0 = x1;
        }
        return intersects >= 8;
    }

    private void updateDomainDivider() {
        DatumRange dr = this.getDatumRange();
        this.majorTicksDomainDivider = DomainDividerUtil.getDomainDivider((Datum)dr.min(), (Datum)dr.max(), (boolean)this.isLog());
        while (this.majorTicksDomainDivider.boundaryCount(dr.min(), dr.max()) > 100L) {
            this.majorTicksDomainDivider = this.majorTicksDomainDivider.coarserDivider(false);
        }
        DatumVector major = this.majorTicksDomainDivider.boundaries(dr.min(), dr.max());
        DatumVector major1 = this.majorTicksDomainDivider.finerDivider(false).boundaries(dr.min(), dr.max());
        DatumFormatter df = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
        while (!this.hasLabelCollisions(major1, df)) {
            this.majorTicksDomainDivider = this.majorTicksDomainDivider.finerDivider(false);
            if (this.majorTicksDomainDivider.boundaryCount(dr.min(), dr.max()) <= 1L) continue;
            df = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
            major = major1;
            major1 = this.majorTicksDomainDivider.finerDivider(false).boundaries(dr.min(), dr.max());
        }
        while (this.hasLabelCollisions(major, df)) {
            this.majorTicksDomainDivider = this.majorTicksDomainDivider.coarserDivider(false);
            df = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
            major = this.majorTicksDomainDivider.boundaries(dr.min(), dr.max());
        }
        while (major.getLength() < 2) {
            this.majorTicksDomainDivider = this.majorTicksDomainDivider.finerDivider(false);
            major = this.majorTicksDomainDivider.boundaries(dr.min(), dr.max());
            df = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
        }
        DomainDivider minorTickDivider = this.majorTicksDomainDivider;
        DatumVector minor = major;
        DatumVector minor1 = minorTickDivider.finerDivider(true).boundaries(dr.min(), dr.max());
        while (!this.hasTickCollisions(minor1)) {
            minorTickDivider = minorTickDivider.finerDivider(true);
            minor = minor1;
            minor1 = minorTickDivider.finerDivider(true).boundaries(dr.min(), dr.max());
        }
        minorTickDivider.boundaries(dr.min(), dr.max());
        this.minorTicksDomainDivider = minorTickDivider;
        this.tickV = TickVDescriptor.newTickVDescriptor(major, minor);
        this.dividerDatumFormatter = DomainDividerUtil.getDatumFormatter((DomainDivider)this.majorTicksDomainDivider, (DatumRange)dr);
        this.datumFormatter = this.resolveFormatter(this.tickV);
    }

    private void updateTickVDomainDivider() {
        DatumRange dr = this.getDatumRange();
        try {
            long nminor = this.minorTicksDomainDivider.boundaryCount(dr.min(), dr.max());
            if (nminor >= 1000000L) {
                return;
            }
            DatumVector major = this.majorTicksDomainDivider.boundaries(dr.min(), dr.max());
            DatumVector minor = this.minorTicksDomainDivider.boundaries(dr.min(), dr.max());
            this.tickV = TickVDescriptor.newTickVDescriptor(major, minor);
            this.tickV.datumFormatter = this.dividerDatumFormatter;
            this.datumFormatter = this.resolveFormatter(this.tickV);
        }
        catch (InconvertibleUnitsException inconvertibleUnitsException) {
            // empty catch block
        }
    }

    private void updateTickVTime() {
        DatumRange dr = this.getDatumRange();
        Datum pixel = dr.width().divide((double)this.getDLength());
        if (this.isHorizontal()) {
            String item;
            FontMetrics fm;
            int width;
            String item2;
            FontMetrics fm2;
            int width2;
            this.tickV = TickVDescriptor.bestTickVTime(dr.min().subtract(pixel), dr.max().add(pixel), 3, 8, false);
            DatumFormatter tdf = this.resolveFormatter(this.tickV);
            Rectangle bounds = this.getMaxBounds(tdf, this.tickV);
            int tickSizePixels = (int)((double)bounds.width + this.getEmSize() * 2.0);
            if (this.drawTca && (width2 = (fm2 = this.getFontMetrics(this.getTickLabelFont())).stringWidth(item2 = DasAxis.format(99999.99, "(f8.2)")) + (int)(this.getEmSize() * 2.0)) > tickSizePixels) {
                tickSizePixels = width2;
            }
            int axisSize = this.getColumn().getWidth();
            int nTicksMax = Math.max(2, axisSize / tickSizePixels);
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 2, nTicksMax, false);
            tdf = this.resolveFormatter(this.tickV);
            bounds = this.getMaxBounds(tdf, this.tickV);
            tickSizePixels = (int)(bounds.getWidth() + this.getEmSize() * 2.0);
            if (this.drawTca && (width = (fm = this.getFontMetrics(this.getTickLabelFont())).stringWidth(item = DasAxis.format(99999.99, "(f8.2)"))) > tickSizePixels) {
                tickSizePixels = width;
            }
            nTicksMax = nTicksMax > 1 ? nTicksMax : 2;
            nTicksMax = nTicksMax < 10 ? nTicksMax : 10;
            boolean overlap = true;
            while (overlap && nTicksMax > 2) {
                this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 2, nTicksMax, false);
                if (this.tickV.getMajorTicks().getLength() <= 1) {
                    System.err.println("about to assert error: " + this.tickV.getMajorTicks());
                }
                assert (this.tickV.getMajorTicks().getLength() > 1);
                tdf = this.resolveFormatter(this.tickV);
                bounds = this.getMaxBounds(tdf, this.tickV);
                tickSizePixels = (int)(bounds.getWidth() + this.getEmSize() * 2.0);
                double x0 = this.transform(this.tickV.getMajorTicks().get(0));
                double x1 = this.transform(this.tickV.getMajorTicks().get(1));
                if (x1 - x0 > (double)tickSizePixels) {
                    overlap = false;
                    continue;
                }
                --nTicksMax;
            }
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 2, nTicksMax, true);
        } else {
            int tickSizePixels = this.getFontMetrics(this.getTickLabelFont()).getHeight();
            int axisSize = this.getRow().getHeight();
            int nTicksMax = axisSize / tickSizePixels;
            nTicksMax = nTicksMax > 1 ? nTicksMax : 2;
            nTicksMax = nTicksMax < 10 ? nTicksMax : 10;
            this.tickV = TickVDescriptor.bestTickVTime(this.getDataMinimum(), this.getDataMaximum(), 3, nTicksMax, true);
        }
        this.datumFormatter = this.resolveFormatter(this.tickV);
        if (this.drawTca && this.tcaFunction != null) {
            this.updateTCADataSet();
        }
    }

    public synchronized void updateTickV() {
        if (!this.valueIsAdjusting()) {
            if (this.getTickLabelFont() == null) {
                return;
            }
            if (this.useDomainDivider) {
                this.updateDomainDivider();
            } else {
                this.majorTicksDomainDivider = null;
            }
            if (this.autoTickV) {
                TickVDescriptor oldTicks = this.tickV;
                if (this.majorTicksDomainDivider != null) {
                    this.updateTickVDomainDivider();
                } else if (this.getUnits() instanceof TimeLocationUnits) {
                    this.updateTickVTime();
                } else if (this.dataRange.isLog()) {
                    this.updateTickVLog();
                } else {
                    this.updateTickVLinear();
                }
                if (this.drawTca && this.tcaFunction != null) {
                    this.updateTCADataSet();
                }
                this.firePropertyChange(PROPERTY_TICKS, oldTicks, this.tickV);
            }
            this.repaint();
        } else if (this.autoTickV) {
            try {
                if (this.majorTicksDomainDivider != null) {
                    this.updateTickVDomainDivider();
                    if (this.drawTca && this.tcaFunction != null) {
                        this.updateTCADataSet();
                    }
                } else if (this.getUnits() instanceof TimeLocationUnits) {
                    this.updateTickVTime();
                } else if (this.dataRange.isLog()) {
                    this.updateTickVLog();
                } else {
                    this.updateTickVLinear();
                }
                this.repaint();
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        boolean drawBounds;
        TickVDescriptor tickV1;
        logger.finest("enter DasAxis.paintComponent");
        if (this.getCanvas().isValueAdjusting()) {
            return;
        }
        try {
            this.updateTickLength();
        }
        catch (ParseException ex) {
            Logger.getLogger(DasAxis.class.getName()).log(Level.SEVERE, null, ex);
        }
        logger.finest("DasAxis clip=" + graphics.getClip() + " @ " + this.getX() + "," + this.getY());
        Graphics2D g = (Graphics2D)graphics.create();
        g.translate(-this.getX(), -this.getY());
        g.setColor(this.getForeground());
        if (DEBUG_GRAPHICS) {
            g.setStroke(new BasicStroke(3.0f, 0, 0, 1.0f, new float[]{3.0f, 3.0f}, 0.0f));
            g.setColor(Color.BLUE);
            if (this.blLabelRect != null) {
                g.draw(this.blLabelRect);
            }
            g.setColor(Color.RED);
            if (this.blLineRect != null) {
                g.draw(this.blLineRect);
            }
            g.setColor(Color.GREEN);
            if (this.blTickRect != null) {
                g.draw(this.blTickRect);
            }
            g.setColor(Color.LIGHT_GRAY);
            if (this.blTitleRect != null) {
                g.draw(this.blTitleRect);
            }
            g.setColor(Color.BLUE);
            if (this.trLabelRect != null) {
                g.draw(this.trLabelRect);
            }
            g.setColor(Color.RED);
            if (this.trLineRect != null) {
                g.draw(this.trLineRect);
            }
            g.setColor(Color.GREEN);
            if (this.trTickRect != null) {
                g.draw(this.trTickRect);
            }
            g.setColor(Color.LIGHT_GRAY);
            if (this.trTitleRect != null) {
                g.draw(this.trTitleRect);
            }
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(DEBUG_COLORS[this.debugColorIndex]);
            ++this.debugColorIndex;
            if (this.debugColorIndex >= DEBUG_COLORS.length) {
                this.debugColorIndex = 0;
            }
        }
        if ((tickV1 = this.tickV) == null || tickV1.tickV.getUnits().isConvertableTo(this.getUnits())) {
            if (this.isHorizontal()) {
                this.paintHorizontalAxis(g);
            } else {
                this.paintVerticalAxis(g);
            }
        } else if (this.getCanvas().isPrintingThread()) {
            this.updateImmediately();
            g.setClip(null);
            System.err.println("calculated ticks on printing thread, this may cause problems");
            if (this.isHorizontal()) {
                this.paintHorizontalAxis(g);
            } else {
                this.paintVerticalAxis(g);
            }
        }
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.drawTca && this.getOrientation() == 2 && this.tcaData != null && this.blLabelRect != null && this.blLabelRect.intersects(clip)) {
            int position = this.getRow().getDMaximum();
            int DMin = this.getColumn().getDMinimum();
            Font tickLabelFont = this.getTickLabelFont();
            FontMetrics tickLabelFontMetrics = this.getFontMetrics(tickLabelFont);
            int tickLength = tickLabelFont.getSize() * 2 / 3;
            int tick_label_gap = tickLabelFontMetrics.stringWidth(" ");
            int lineHeight = tickLabelFont.getSize() + this.getLineSpacing();
            int baseLine = position + tickLength + tick_label_gap + tickLabelFont.getSize();
            int rightEdge = DMin - tickLabelFontMetrics.stringWidth("0000") - tick_label_gap;
            GrannyTextRenderer idlt = new GrannyTextRenderer();
            if (this.tcaData == null) {
                idlt.setString((Graphics)g, "tcaData not available");
                idlt.draw(graphics, (float)((double)rightEdge - idlt.getWidth()), (float)(baseLine += lineHeight));
            } else {
                QDataSet bds = (QDataSet)this.tcaData.property("BUNDLE_1");
                if (bds == null) {
                    System.err.println("expected TCA data to have BUNDLE dataset");
                }
                int lines = Math.min(10, this.tcaData.length(0));
                for (int i = 0; i < lines; ++i) {
                    baseLine += lineHeight;
                    if (bds == null) {
                        idlt.setString((Graphics)g, "???");
                    } else {
                        String label = (String)bds.property("LABEL", i);
                        if (label == null) {
                            idlt.setString((Graphics)g, "????");
                        } else {
                            idlt.setString((Graphics)g, label);
                        }
                    }
                    int width = (int)Math.floor(idlt.getWidth() + 0.5);
                    int leftEdge = rightEdge - width;
                    idlt.draw((Graphics)g, (float)leftEdge, (float)baseLine);
                }
            }
        }
        if (drawBounds = false) {
            Rectangle b = this.getAxisBounds();
            g.setColor(Color.GREEN);
            g.draw(new Rectangle(b.x, b.y, b.width - 1, b.height - 1));
        }
        g.dispose();
        this.getDasMouseInputAdapter().paint(graphics);
    }

    private String resolveAxisLabel() {
        String result = this.axisLabel;
        if (result.contains("%{")) {
            result = result.replaceAll("%\\{UNITS\\}", this.getUnits().toString());
            result = result.replaceAll("%\\{RANGE\\}", this.getDatumRange().toString());
            result = result.replaceAll("%\\{SCAN_RANGE\\}", String.valueOf(this.getScanRange()));
        }
        return result;
    }

    protected void paintHorizontalAxis(Graphics2D g) {
        try {
            int tickLength;
            int tickPosition;
            int i;
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            boolean bottomLine = (this.orientation == 2 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(clip);
            boolean bottomTicks = (this.orientation == 2 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(clip);
            boolean bottomTickLabels = this.orientation == 2 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(clip);
            boolean bottomLabel = this.orientation == 2 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(clip);
            boolean topLine = (this.orientation == 1 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(clip);
            boolean topTicks = (this.orientation == 1 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(clip);
            boolean topTickLabels = this.orientation == 1 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(clip);
            boolean topLabel = this.orientation == 1 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
            int topPosition = this.getRow().getDMinimum() - 1;
            int bottomPosition = this.getRow().getDMaximum();
            int DMax = this.getColumn().getDMaximum();
            int DMin = this.getColumn().getDMinimum();
            TickVDescriptor ticks = this.getTickV();
            if (bottomLine) {
                g.drawLine(DMin, bottomPosition, DMax, bottomPosition);
            }
            if (topLine) {
                g.drawLine(DMin, topPosition, DMax, topPosition);
            }
            int tickLengthMajor = this.tickLen;
            int tickLengthMinor = tickLengthMajor / 2;
            String[] labels = this.tickFormatter(ticks.tickV, this.getDatumRange());
            for (i = 0; i < ticks.tickV.getLength(); ++i) {
                Datum tick1 = ticks.tickV.get(i);
                tickPosition = (int)Math.floor(this.transform(tick1));
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMajor;
                if (bottomTicks) {
                    g.drawLine(tickPosition, bottomPosition, tickPosition, bottomPosition + tickLength);
                }
                if (bottomTickLabels) {
                    this.drawLabel(g, tick1, labels[i], i, tickPosition, bottomPosition + Math.max(0, tickLength));
                }
                if (topTicks) {
                    g.drawLine(tickPosition, topPosition, tickPosition, topPosition - tickLength);
                }
                if (!topTickLabels) continue;
                this.drawLabel(g, tick1, labels[i], i, tickPosition, topPosition - Math.max(0, tickLength) + 1);
            }
            for (i = 0; i < ticks.minorTickV.getLength(); ++i) {
                Datum tick = ticks.minorTickV.get(i);
                tickPosition = (int)Math.floor(this.transform(tick));
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMinor;
                if (bottomTicks) {
                    g.drawLine(tickPosition, bottomPosition, tickPosition, bottomPosition + tickLength);
                }
                if (!topTicks) continue;
                g.drawLine(tickPosition, topPosition, tickPosition, topPosition - tickLength);
            }
            if (!this.axisLabel.equals("")) {
                int baseline;
                int leftEdge;
                Graphics2D g2 = (Graphics2D)g.create();
                int titlePositionOffset = this.getTitlePositionOffset();
                GrannyTextRenderer gtr = new GrannyTextRenderer();
                String axislabel1 = this.resolveAxisLabel();
                gtr.setString((Graphics)g2, axislabel1);
                int titleWidth = (int)gtr.getWidth();
                g2.setFont(this.getLabelFont());
                if (bottomLabel) {
                    leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                    baseline = bottomPosition + titlePositionOffset;
                    gtr.draw((Graphics)g2, (float)leftEdge, (float)baseline);
                }
                if (topLabel) {
                    leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                    baseline = topPosition - titlePositionOffset;
                    gtr.draw((Graphics)g2, (float)leftEdge, (float)baseline);
                }
                g2.dispose();
            }
        }
        catch (InconvertibleUnitsException inconvertibleUnitsException) {
            // empty catch block
        }
    }

    protected void paintVerticalAxis(Graphics2D g) {
        try {
            int tickLength;
            int i;
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                clip = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            boolean leftLine = (this.orientation == 3 || this.oppositeAxisVisible) && this.blLineRect != null && this.blLineRect.intersects(clip);
            boolean leftTicks = (this.orientation == 3 || this.oppositeAxisVisible) && this.blTickRect != null && this.blTickRect.intersects(clip);
            boolean leftTickLabels = this.orientation == 3 && this.tickLabelsVisible && this.blLabelRect != null && this.blLabelRect.intersects(clip);
            boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("") && this.blTitleRect != null && this.blTitleRect.intersects(clip);
            boolean rightLine = (this.orientation == 4 || this.oppositeAxisVisible) && this.trLineRect != null && this.trLineRect.intersects(clip);
            boolean rightTicks = (this.orientation == 4 || this.oppositeAxisVisible) && this.trTickRect != null && this.trTickRect.intersects(clip);
            boolean rightTickLabels = this.orientation == 4 && this.tickLabelsVisible && this.trLabelRect != null && this.trLabelRect.intersects(clip);
            boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("") && this.trTitleRect != null && this.trTitleRect.intersects(clip);
            int leftPosition = this.getColumn().getDMinimum() - 1;
            int rightPosition = this.getColumn().getDMaximum();
            int DMax = this.getRow().getDMaximum();
            int DMin = this.getRow().getDMinimum();
            TickVDescriptor ticks = this.getTickV();
            if (leftLine) {
                g.drawLine(leftPosition, DMin, leftPosition, DMax);
            }
            if (rightLine) {
                g.drawLine(rightPosition, DMin, rightPosition, DMax);
            }
            int tickLengthMajor = this.tickLen;
            int tickLengthMinor = tickLengthMajor / 2;
            String[] labels = this.tickFormatter(ticks.tickV, this.getDatumRange());
            for (i = 0; i < ticks.tickV.getLength(); ++i) {
                Datum tick1 = ticks.tickV.get(i);
                int tickPosition = (int)Math.floor(this.transform(tick1) + 1.0E-4);
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMajor;
                if (leftTicks) {
                    g.drawLine(leftPosition, tickPosition, leftPosition - tickLength, tickPosition);
                }
                if (leftTickLabels) {
                    this.drawLabel(g, tick1, labels[i], i, leftPosition - Math.max(0, tickLength), tickPosition);
                }
                if (rightTicks) {
                    g.drawLine(rightPosition, tickPosition, rightPosition + tickLength, tickPosition);
                }
                if (!rightTickLabels) continue;
                this.drawLabel(g, tick1, labels[i], i, rightPosition + Math.max(0, tickLength), tickPosition);
            }
            for (i = 0; i < ticks.minorTickV.getLength(); ++i) {
                tickLength = tickLengthMinor;
                double tick1 = ticks.minorTickV.doubleValue(i, this.getUnits());
                int tickPosition = (int)Math.floor(this.transform(tick1, ticks.units) + 1.0E-4);
                if (DMin > tickPosition || tickPosition > DMax) continue;
                tickLength = tickLengthMinor;
                if (leftTicks) {
                    g.drawLine(leftPosition, tickPosition, leftPosition - tickLength, tickPosition);
                }
                if (!rightTicks) continue;
                g.drawLine(rightPosition, tickPosition, rightPosition + tickLength, tickPosition);
            }
            if (!this.axisLabel.equals("")) {
                int baseline;
                int leftEdge;
                Graphics2D g2 = (Graphics2D)g.create();
                int titlePositionOffset = this.getTitlePositionOffset();
                GrannyTextRenderer gtr = new GrannyTextRenderer();
                gtr.setString((Graphics)g2, this.resolveAxisLabel());
                int titleWidth = (int)gtr.getWidth();
                g2.setFont(this.getLabelFont());
                if (leftLabel) {
                    g2.rotate(-1.5707963267948966);
                    leftEdge = -DMax + (DMax - DMin - titleWidth) / 2;
                    baseline = leftPosition - titlePositionOffset;
                    gtr.draw((Graphics)g2, (float)leftEdge, (float)baseline);
                }
                if (rightLabel) {
                    if (this.flipLabel) {
                        g2.rotate(-1.5707963267948966);
                        leftEdge = DMin + (DMax - DMin + titleWidth) / 2;
                        baseline = rightPosition + titlePositionOffset;
                        gtr.draw((Graphics)g2, (float)(-leftEdge), (float)baseline);
                        g2.getClipBounds();
                    } else {
                        g2.rotate(1.5707963267948966);
                        leftEdge = DMin + (DMax - DMin - titleWidth) / 2;
                        baseline = -rightPosition - titlePositionOffset;
                        gtr.draw((Graphics)g2, (float)leftEdge, (float)baseline);
                    }
                }
                g2.dispose();
            }
        }
        catch (InconvertibleUnitsException inconvertibleUnitsException) {
            // empty catch block
        }
    }

    protected int getTitlePositionOffset() {
        Font tickLabelFont = this.getTickLabelFont();
        FontMetrics fm = this.getFontMetrics(tickLabelFont);
        Font labelFont = this.getLabelFont();
        int tickLength = tickLabelFont.getSize() * 2 / 3;
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(labelFont, this.axisLabel);
        int offset = this.orientation == 2 ? tickLabelFont.getSize() + tickLength + fm.stringWidth(" ") + labelFont.getSize() + labelFont.getSize() / 2 : (this.orientation == 1 ? tickLength + fm.stringWidth(" ") + labelFont.getSize() + labelFont.getSize() / 2 + (int)gtr.getDescent() : (this.orientation == 3 ? this.getColumn().getDMinimum() - this.blLabelRect.x + labelFont.getSize() / 2 + (int)gtr.getDescent() : this.trLabelRect.x + this.trLabelRect.width - this.getColumn().getDMaximum() + labelFont.getSize() / 2 + (int)(this.flipLabel ? gtr.getAscent() : gtr.getDescent())));
        if (this.getOrientation() == 2 && this.drawTca && this.tcaData != null) {
            offset += Math.min(10, this.tcaData.length(0)) * (tickLabelFont.getSize() + this.getLineSpacing());
        }
        return offset;
    }

    public int getLineSpacing() {
        return this.getTickLabelFont().getSize() / 4;
    }

    protected void drawLabel(Graphics2D g, Datum value, String label, int index, int x, int y) {
        if (!this.tickLabelsVisible) {
            return;
        }
        g.setFont(this.getTickLabelFont());
        GrannyTextRenderer idlt = new GrannyTextRenderer();
        idlt.setString((Graphics)g, label);
        int width = (int)(this.isHorizontal() ? idlt.getLineOneWidth() : idlt.getWidth());
        int height = (int)idlt.getHeight();
        int ascent = (int)idlt.getAscent();
        int tick_label_gap = this.tickLen / 2;
        if (tick_label_gap < 4) {
            tick_label_gap = 4;
        }
        if (this.orientation == 2) {
            x -= width / 2;
            y += this.getTickLabelFont().getSize() + tick_label_gap;
        } else if (this.orientation == 1) {
            x -= width / 2;
            y = (int)((double)y - ((double)tick_label_gap + idlt.getDescent()));
        } else if (this.orientation == 3) {
            x -= width + tick_label_gap;
            y += ascent - height / 2;
        } else {
            x += tick_label_gap;
            y += ascent - height / 2;
        }
        idlt.draw((Graphics)g, (float)x, (float)y);
        if (this.orientation == 2 && this.drawTca && this.tcaData != null) {
            this.drawTCAItems(g, value, x, y, width);
        }
    }

    private void drawTCAItems(Graphics g, Datum value, int x, int y, int width) {
        double limit;
        if (this.tcaData == null || this.tcaData.length() == 0) {
            return;
        }
        QDataSet dep0 = (QDataSet)this.tcaData.property("DEPEND_0");
        int baseLine = y;
        int leftEdge = x;
        int rightEdge = leftEdge + width;
        int index = DataSetUtil.closestIndex((QDataSet)dep0, (Datum)value);
        if (index < 0 || index >= this.tcaData.length()) {
            return;
        }
        double pixelSize = this.getDatumRange().width().divide((double)this.getDLength()).doubleValue(this.getUnits().getOffsetUnits());
        if (this.tcaData.length() == 0) {
            g.drawString("tca data is empty", leftEdge, baseLine);
            return;
        }
        double tcaValue = dep0.value(index);
        RankZeroDataSet xTagWidth = DataSetUtil.guessCadenceNew((QDataSet)dep0, null);
        try {
            UnitsConverter uc = UnitsConverter.getConverter((Units)SemanticOps.getUnits((QDataSet)dep0).getOffsetUnits(), (Units)this.getUnits().getOffsetUnits());
            limit = Math.max(uc.convert(xTagWidth.value()), pixelSize);
        }
        catch (InconvertibleUnitsException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        if (Math.abs(tcaValue - value.doubleValue(this.getUnits())) > limit) {
            return;
        }
        Font tickLabelFont = this.getTickLabelFont();
        FontMetrics fm = this.getFontMetrics(tickLabelFont);
        int lineHeight = tickLabelFont.getSize() + this.getLineSpacing();
        int lines = Math.min(10, this.tcaData.length(0));
        for (int i = 0; i < lines; ++i) {
            try {
                QDataSet v1 = this.tcaData.slice(index).slice(i);
                String item = DataSetUtil.getStringValue((QDataSet)v1, (double)v1.value());
                width = fm.stringWidth(item);
                leftEdge = rightEdge - width;
                g.drawString(item, leftEdge, baseLine += lineHeight);
                continue;
            }
            catch (RuntimeException ex) {
                g.drawString("except!c" + ex.getMessage(), leftEdge, baseLine);
            }
        }
    }

    public Font getTickLabelFont() {
        return this.getFont();
    }

    public void setTickLabelFont(Font tickLabelFont) {
    }

    public Font getLabelFont() {
        return this.getFont();
    }

    public void setLabelFont(Font labelFont) {
    }

    public Memento getMemento() {
        Memento result = new Memento();
        result.range = this.getDatumRange();
        if (this.isHorizontal()) {
            if (this.getColumn() != DasColumn.NULL) {
                result.dmin = this.getColumn().getDMinimum();
                result.dmax = this.getColumn().getDMaximum();
            } else {
                result.dmin = 0;
                result.dmax = 0;
            }
        } else if (this.getRow() != DasRow.NULL) {
            result.dmin = this.getRow().getDMinimum();
            result.dmax = this.getRow().getDMaximum();
        } else {
            result.dmin = 0;
            result.dmax = 0;
        }
        result.log = this.isLog();
        result.flipped = this.flipped;
        result.axis = this;
        return result;
    }

    public AffineTransform getAffineTransform(Memento memento, AffineTransform at) {
        double dmin1;
        if (at == null) {
            return null;
        }
        if (memento.log != this.isLog()) {
            return null;
        }
        if (memento.flipped != this.flipped) {
            return null;
        }
        if (!memento.range.getUnits().isConvertableTo(this.getUnits())) {
            return null;
        }
        double dmin0 = this.transform(memento.range.min());
        double dmax0 = this.transform(memento.range.max());
        double scale2 = (0.0 + (double)this.getMemento().dmin - (double)this.getMemento().dmax) / (double)(memento.dmin - memento.dmax);
        double trans2 = (double)(-1 * memento.dmin) * scale2 + (double)this.getMemento().dmin;
        if (dmin0 == 10000.0 || dmin0 == -10000.0 | dmax0 == 10000.0 | dmax0 == 10000.0) {
            System.err.println("unable to create transform");
        }
        if (!(this.isHorizontal() ^ this.flipped)) {
            double tmp = dmin0;
            dmin0 = dmax0;
            dmax0 = tmp;
        }
        if (!this.isHorizontal()) {
            dmin1 = this.getRow().getDMinimum();
            double dmax1 = this.getRow().getDMaximum();
            double scaley = (dmin0 - dmax0) / (dmin1 - dmax1);
            double transy = -1.0 * dmin1 * scaley + dmin0;
            at.translate(0.0, transy);
            at.scale(1.0, scaley);
            at.translate(0.0, trans2);
            at.scale(1.0, scale2);
        } else {
            dmin1 = this.getColumn().getDMinimum();
            double dmax1 = this.getColumn().getDMaximum();
            double scalex = (dmin0 - dmax0) / (dmin1 - dmax1);
            double transx = -1.0 * dmin1 * scalex + dmin0;
            at.translate(transx, 0.0);
            at.scale(scalex, 1.0);
            at.translate(trans2, 0.0);
            at.scale(scale2, 1.0);
        }
        if (at.getDeterminant() == 0.0) {
            return null;
        }
        return at;
    }

    public Object clone() {
        try {
            DasAxis result = (DasAxis)super.clone();
            result.dataRange = (DataRange)result.dataRange.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Assertion failure");
        }
    }

    private void setTickDirection(int direction) {
        if (direction == 995 || direction == 4) {
            this.tickDirection = -1;
        } else if (direction == 996 || direction == 3) {
            this.tickDirection = 1;
        } else {
            throw new IllegalArgumentException("Invalid tick direction");
        }
    }

    private int getMaxLabelWidth() {
        try {
            Font f = this.getTickLabelFont();
            TickVDescriptor ticks = this.getTickV();
            DatumVector tickv = ticks.tickV;
            int size = Integer.MIN_VALUE;
            for (int i = 0; i < tickv.getLength(); ++i) {
                String label = this.tickFormatter(tickv.get(i));
                GrannyTextRenderer idlt = new GrannyTextRenderer();
                idlt.setString(f, label);
                int labelSize = (int)Math.round(idlt.getWidth());
                if (labelSize <= size) continue;
                size = labelSize;
            }
            return size;
        }
        catch (InconvertibleUnitsException ex) {
            return 10;
        }
    }

    protected int getMaxLabelWidth(FontMetrics fm) {
        try {
            TickVDescriptor ticks = this.getTickV();
            DatumVector tickv = ticks.tickV;
            int size = Integer.MIN_VALUE;
            Graphics g = this.getGraphics();
            for (int i = 0; i < tickv.getLength(); ++i) {
                String label = this.tickFormatter(tickv.get(i));
                GrannyTextRenderer idlt = new GrannyTextRenderer();
                idlt.setString(g, label);
                int labelSize = (int)Math.round(idlt.getWidth());
                if (labelSize <= size) continue;
                size = labelSize;
            }
            return size;
        }
        catch (InconvertibleUnitsException ex) {
            return 10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize() {
        this.resetTransform();
        if (this.getFont() == null) {
            return;
        }
        Rectangle oldBounds = this.getBounds();
        this.setBounds(this.getAxisBounds());
        this.invalidate();
        DasAxis dasAxis = this;
        synchronized (dasAxis) {
            if (this.tickV == null || this.tickV.tickV.getUnits().isConvertableTo(this.getUnits())) {
                this.validate();
            }
        }
        this.firePropertyChange(PROP_BOUNDS, oldBounds, this.getBounds());
    }

    protected synchronized Rectangle getLabelBounds(Rectangle bounds) {
        double dmax;
        double dmin;
        if (this.getTickV() == null || !this.getTickV().tickV.getUnits().isConvertableTo(this.getUnits())) {
            return bounds;
        }
        String[] labels = this.tickFormatter(this.getTickV().tickV, this.getDatumRange());
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        Font labelFont = this.getLabelFont();
        if (this.isHorizontal()) {
            dmin = this.getColumn().getDMinimum();
            dmax = this.getColumn().getDMaximum();
        } else {
            dmin = this.getRow().getDMinimum();
            dmax = this.getRow().getDMaximum();
        }
        DatumVector ticks = this.getTickV().tickV;
        for (int i = 0; i < labels.length; ++i) {
            Datum d = ticks.get(i);
            DatumRange dr = this.getDatumRange();
            if (!DatumRangeUtil.sloppyContains((DatumRange)dr, (Datum)d)) continue;
            gtr.setString(labelFont, labels[i]);
            Rectangle rmin = gtr.getBounds();
            Rectangle rmax = new Rectangle(rmin);
            double flw = gtr.getLineOneWidth();
            int tick_label_gap = this.tickLen / 2;
            if (tick_label_gap < 5) {
                tick_label_gap = 4;
            }
            int space = tick_label_gap;
            int zeroOrPosTickLen = Math.max(0, this.tickLen);
            if (this.isHorizontal()) {
                if (this.getOrientation() == 2) {
                    rmin.translate((int)(dmin - flw / 2.0), this.getRow().bottom() + space + zeroOrPosTickLen + labelFont.getSize());
                    rmax.translate((int)(dmax - flw / 2.0), this.getRow().bottom() + space + zeroOrPosTickLen + labelFont.getSize());
                } else {
                    rmin.translate((int)(dmin - flw / 2.0), this.getRow().top() - space - zeroOrPosTickLen - (int)rmin.getHeight());
                    rmax.translate((int)(dmax - flw / 2.0), this.getRow().top() - space - zeroOrPosTickLen - (int)rmax.getHeight());
                }
                if (bounds == null) {
                    bounds = rmin;
                }
                bounds.add(rmin);
                bounds.add(rmax);
                continue;
            }
            if (this.getOrientation() == 3) {
                rmin.translate(-((int)rmin.getWidth()) - space - zeroOrPosTickLen + this.getColumn().left(), (int)(dmin + this.getEmSize() / 2.0));
                rmax.translate(-((int)rmax.getWidth()) - space - zeroOrPosTickLen + this.getColumn().left(), (int)(dmax + this.getEmSize() / 2.0));
            } else {
                rmin.translate(space + zeroOrPosTickLen + this.getColumn().right(), (int)(dmin + this.getEmSize() / 2.0));
                rmax.translate(space + zeroOrPosTickLen + this.getColumn().right(), (int)(dmax + this.getEmSize() / 2.0));
            }
            if (bounds == null) {
                bounds = rmin;
            }
            bounds.add(rmin);
            bounds.add(rmax);
        }
        return bounds;
    }

    protected Rectangle getAxisBounds() {
        try {
            this.updateTickLength();
        }
        catch (ParseException ex) {
            Logger.getLogger(DasAxis.class.getName()).log(Level.SEVERE, null, ex);
        }
        Rectangle bounds = this.isHorizontal() ? this.getHorizontalAxisBounds() : this.getVerticalAxisBounds();
        if (this.getOrientation() == 2 && this.isTickLabelsVisible() && this.drawTca && this.tcaData != null && this.tcaData.length() != 0) {
            int DMin = this.getColumn().getDMinimum();
            Font tickLabelFont = this.getTickLabelFont();
            int tick_label_gap = this.getFontMetrics(tickLabelFont).stringWidth(" ");
            int lines = Math.min(10, this.tcaData.length(0));
            int tcaHeight = (tickLabelFont.getSize() + this.getLineSpacing()) * lines;
            int maxLabelWidth = this.getMaxLabelWidth();
            bounds.height += tcaHeight;
            this.blLabelRect.height += tcaHeight;
            if (this.blTitleRect != null) {
                this.blTitleRect.y += tcaHeight;
            }
            GrannyTextRenderer idlt = new GrannyTextRenderer();
            idlt.setString(tickLabelFont, "SCET");
            int tcaLabelWidth = (int)Math.floor(idlt.getWidth() + 0.5);
            QDataSet bds = (QDataSet)this.tcaData.property("BUNDLE_1");
            for (int i = 0; i < lines; ++i) {
                String ss = bds == null ? "???" : (String)bds.property("LABEL", i);
                if (ss == null) {
                    ss = "   ";
                }
                idlt.setString(tickLabelFont, ss);
                int width = (int)Math.floor(idlt.getWidth() + 0.5);
                tcaLabelWidth = Math.max(tcaLabelWidth, width);
            }
            if ((tcaLabelWidth += 50) > 0) {
                int tcaLabelSpace = DMin - tcaLabelWidth - tick_label_gap;
                int minX = Math.min(tcaLabelSpace - maxLabelWidth / 2, bounds.x);
                int maxX = bounds.x + bounds.width;
                bounds.x = minX;
                bounds.width = maxX - minX;
                this.blLabelRect.x = minX;
                this.blLabelRect.width = maxX - minX;
            }
        }
        return bounds;
    }

    private Rectangle getHorizontalAxisBounds() {
        int height;
        int width;
        int y;
        int x;
        Font labelFont;
        int height2;
        int width2;
        int y2;
        int x2;
        boolean topLabel;
        int topPosition = this.getRow().getDMinimum() - 1;
        int bottomPosition = this.getRow().getDMaximum();
        DasColumn range = this.getColumn();
        int DMax = range.getDMaximum();
        int DMin = range.getDMinimum();
        int DWidth = DMax - DMin;
        boolean bottomTicks = this.orientation == 2 || this.oppositeAxisVisible;
        boolean bottomTickLabels = this.orientation == 2 && this.tickLabelsVisible;
        boolean bottomLabel = bottomTickLabels && !this.axisLabel.equals("");
        boolean topTicks = this.orientation == 1 || this.oppositeAxisVisible;
        boolean topTickLabels = this.orientation == 1 && this.tickLabelsVisible;
        boolean bl = topLabel = topTickLabels && !this.axisLabel.equals("");
        if (bottomTicks) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(DMin, bottomPosition, DWidth + 1, 1);
        }
        if (topTicks) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(DMin, topPosition, DWidth + 1, 1);
        }
        if (bottomTicks) {
            x2 = DMin;
            y2 = bottomPosition + 1 - Math.max(-this.tickLen, 0);
            width2 = DWidth;
            height2 = Math.abs(this.tickLen);
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, x2, y2, width2 + 1, height2);
        }
        if (topTicks) {
            x2 = DMin;
            y2 = topPosition - Math.max(0, this.tickLen);
            width2 = DWidth;
            height2 = Math.abs(this.tickLen);
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, x2, y2, width2 + 1, height2);
        }
        if (bottomTickLabels) {
            this.blLabelRect = this.getLabelBounds(new Rectangle(DMin, this.blTickRect.y, DWidth, 10));
        }
        if (topTickLabels) {
            this.trLineRect = this.getLabelBounds(new Rectangle(DMin, topPosition - 10, DWidth, 10));
        }
        if ((labelFont = this.getLabelFont()) == null) {
            return new Rectangle();
        }
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(labelFont, this.getLabel());
        int labelSpacing = (int)gtr.getHeight() + labelFont.getSize() / 2;
        if (bottomLabel) {
            x = DMin;
            y = this.blLabelRect.y + this.blLabelRect.height;
            width = DMax - DMin;
            height = labelSpacing;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (topLabel) {
            x = DMin;
            y = this.trLabelRect.y - labelSpacing;
            width = DMax - DMin;
            height = labelSpacing;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        Rectangle bounds = new Rectangle(this.orientation == 2 ? this.blLineRect : this.trLineRect);
        if (bottomTicks) {
            bounds.add(this.blLineRect);
            bounds.add(this.blTickRect);
        }
        if (bottomTickLabels) {
            bounds.add(this.blLabelRect);
        }
        if (bottomLabel) {
            bounds.add(this.blTitleRect);
        }
        if (topTicks) {
            bounds.add(this.trLineRect);
            bounds.add(this.trTickRect);
        }
        if (topTickLabels) {
            bounds.add(this.trLabelRect);
        }
        if (topLabel) {
            bounds.add(this.trTitleRect);
        }
        if (this.scanPrevious != null && this.scanNext != null) {
            Dimension prevSize = this.scanPrevious.getPreferredSize();
            Dimension nextSize = this.scanPrevious.getPreferredSize();
            int minX = Math.min(DMin - prevSize.width, bounds.x);
            int maxX = Math.max(DMax + nextSize.width, bounds.x + bounds.width);
            bounds.x = minX;
            bounds.width = maxX - minX;
        }
        return bounds;
    }

    private Rectangle getVerticalAxisBounds() {
        int height;
        int width;
        int y;
        int x;
        Font labelFont;
        int height2;
        int width2;
        int y2;
        int x2;
        boolean leftTicks = this.orientation == 3 || this.oppositeAxisVisible;
        boolean leftTickLabels = this.orientation == 3 && this.tickLabelsVisible;
        boolean leftLabel = this.orientation == 3 && !this.axisLabel.equals("");
        boolean rightTicks = this.orientation == 4 || this.oppositeAxisVisible;
        boolean rightTickLabels = this.orientation == 4 && this.tickLabelsVisible;
        boolean rightLabel = this.orientation == 4 && !this.axisLabel.equals("");
        int leftPosition = this.getColumn().getDMinimum() - 1;
        int rightPosition = this.getColumn().getDMaximum();
        int DMax = this.getRow().getDMaximum();
        int DMin = this.getRow().getDMinimum();
        int DWidth = DMax - DMin;
        if (leftTicks) {
            if (this.blLineRect == null) {
                this.blLineRect = new Rectangle();
            }
            this.blLineRect.setBounds(leftPosition, DMin, 1, DWidth + 1);
        }
        if (rightTicks) {
            if (this.trLineRect == null) {
                this.trLineRect = new Rectangle();
            }
            this.trLineRect.setBounds(rightPosition, DMin, 1, DWidth + 1);
        }
        if (leftTicks) {
            x2 = leftPosition - Math.min(0, this.tickLen);
            y2 = DMin;
            width2 = Math.abs(this.tickLen);
            height2 = DWidth;
            this.blTickRect = DasAxis.setRectangleBounds(this.blTickRect, x2, y2, width2, height2 + 1);
        }
        if (rightTicks) {
            x2 = rightPosition + 1 + Math.min(0, this.tickLen);
            y2 = DMin;
            width2 = Math.abs(this.tickLen);
            height2 = DWidth;
            this.trTickRect = DasAxis.setRectangleBounds(this.trTickRect, x2, y2, width2, height2 + 1);
        }
        if (leftTickLabels) {
            this.blLabelRect = this.getLabelBounds(new Rectangle(this.blTickRect.x - 10, DMin, 10, DWidth));
        }
        if (rightTickLabels) {
            this.trLabelRect = this.getLabelBounds(new Rectangle(this.trTickRect.x + this.trTickRect.width, DMin, 10, DWidth));
        }
        if ((labelFont = this.getLabelFont()) == null) {
            return new Rectangle();
        }
        GrannyTextRenderer gtr = new GrannyTextRenderer();
        gtr.setString(labelFont, this.getLabel());
        int labelSpacing = (int)gtr.getHeight() + labelFont.getSize() / 2;
        if (leftLabel) {
            x = this.blLabelRect.x - labelSpacing;
            y = DMin;
            width = labelSpacing;
            height = DWidth;
            this.blTitleRect = DasAxis.setRectangleBounds(this.blTitleRect, x, y, width, height);
        }
        if (rightLabel) {
            x = this.trLabelRect.x + this.trLabelRect.width;
            y = DMin;
            width = labelSpacing;
            height = DWidth;
            this.trTitleRect = DasAxis.setRectangleBounds(this.trTitleRect, x, y, width, height);
        }
        Rectangle bounds = new Rectangle(this.orientation == 3 ? this.blLineRect : this.trLineRect);
        if (leftTicks) {
            bounds.add(this.blLineRect);
            bounds.add(this.blTickRect);
        }
        if (leftTickLabels) {
            bounds.add(this.blLabelRect);
        }
        if (leftLabel) {
            bounds.add(this.blTitleRect);
        }
        if (rightTicks) {
            bounds.add(this.trLineRect);
            bounds.add(this.trTickRect);
        }
        if (rightTickLabels) {
            bounds.add(this.trLabelRect);
        }
        if (rightLabel) {
            bounds.add(this.trTitleRect);
        }
        return bounds;
    }

    private static Rectangle setRectangleBounds(Rectangle rc, int x, int y, int width, int height) {
        if (rc == null) {
            return new Rectangle(x, y, width, height);
        }
        rc.setBounds(x, y, width, height);
        return rc;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isHorizontal() {
        return this.orientation == 2 || this.orientation == 1;
    }

    public int getTickDirection() {
        return this.tickDirection;
    }

    public DatumFormatter getDatumFormatter() {
        return this.datumFormatter;
    }

    public double transform(Datum datum) {
        return this.transform(datum.doubleValue(this.getUnits()), this.getUnits());
    }

    protected double transformFast(double data, Units units) {
        if (this.dataRange.isLog()) {
            data = data <= 0.0 ? this.dataRange.getMinimum() - 3.0 : Math.log10(data);
        }
        double result = this.at_m * data + this.at_b;
        return result;
    }

    public double transform(double data, Units units) {
        if (this.isHorizontal()) {
            DasColumn range = this.getColumn();
            return this.transform(data, units, range.getDMinimum(), range.getDMaximum());
        }
        DasRow range = this.getRow();
        return this.transform(data, units, range.getDMaximum(), range.getDMinimum());
    }

    protected double transform(double data, Units units, int dmin, int dmax) {
        if (units != this.dataRange.getUnits()) {
            data = units.convertDoubleTo(this.dataRange.getUnits(), data);
        }
        double device_range = dmax - dmin;
        if (this.dataRange.isLog()) {
            data = data <= 0.0 ? -1.0E308 : Math.log10(data);
        }
        double minimum = this.dataRange.getMinimum();
        double maximum = this.dataRange.getMaximum();
        double data_range = maximum - minimum;
        double result = this.flipped ? (double)dmax - device_range * (data - minimum) / data_range : device_range * (data - minimum) / data_range + (double)dmin;
        if (result > 10000.0) {
            result = 10000.0;
        }
        if (result < -10000.0) {
            result = -10000.0;
        }
        return result;
    }

    public Datum invTransform(double idata) {
        DasDevicePosition range = this.isHorizontal() ? this.getColumn() : this.getRow();
        double alpha = (idata - (double)range.getDMinimum()) / (double)this.getDLength();
        if (!this.isHorizontal()) {
            alpha = 1.0 - alpha;
        }
        if (this.flipped) {
            alpha = 1.0 - alpha;
        }
        double minimum = this.dataRange.getMinimum();
        double maximum = this.dataRange.getMaximum();
        double data_range = maximum - minimum;
        double data = data_range * alpha + minimum;
        double resolution = data_range / (double)this.getDLength();
        if (this.dataRange.isLog()) {
            data = Math.pow(10.0, data);
            resolution = data * (Math.pow(10.0, resolution) - 1.0);
        }
        Datum result = Datum.create((double)data, (Units)this.dataRange.getUnits(), (double)resolution);
        return result;
    }

    protected String tickFormatter(Datum d) {
        return this.datumFormatter.grannyFormat(d, d.getUnits());
    }

    protected String[] tickFormatter(DatumVector tickV, DatumRange datumRange) {
        return this.datumFormatter.axisFormat(tickV, datumRange);
    }

    public void dataRangeSelected(DataRangeSelectionEvent e) {
        this.setDataRange(e.getMinimum(), e.getMaximum());
    }

    public Datum findTick(Datum xDatum, double direction, boolean minor) {
        return this.getTickV().findTick(xDatum, direction, minor);
    }

    private void animateChange(double min0, double max0, double min1, double max1) {
        if (this.animated && EventQueue.isDispatchThread()) {
            DataRange tempRange;
            logger.fine("animate axis");
            boolean drawTca0 = this.getDrawTca();
            this.setDrawTca(false);
            long t0 = System.currentTimeMillis();
            long frames = 0L;
            DataRange dataRange0 = this.dataRange;
            this.dataRange = tempRange = DataRange.getAnimationDataRange(this.dataRange.getDatumRange(), this.dataRange.isLog());
            double transitionTime = 300.0;
            double alpha = (double)(System.currentTimeMillis() - t0) / transitionTime;
            while (alpha < 1.0) {
                alpha = (double)(System.currentTimeMillis() - t0) / transitionTime;
                double[] aa = new double[]{0.0, 0.3, 0.85, 1.0};
                double[] aa1 = new double[]{0.0, 0.05, 0.9, 1.0};
                double f1 = DasMath.findex((double[])aa, (double)alpha, (int)0);
                double a1 = DasMath.interpolate((double[])aa1, (double)f1);
                double a0 = 1.0 - a1;
                tempRange.setRange(min0 * a0 + min1 * a1, max0 * a0 + max1 * a1);
                this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
                if (this.dasPlot != null) {
                    this.dasPlot.paintImmediately(0, 0, this.dasPlot.getWidth(), this.dasPlot.getHeight());
                }
                ++frames;
            }
            logger.fine("animation frames/sec= " + 1000.0 * (double)frames / transitionTime);
            this.setDrawTca(drawTca0);
            this.dataRange = dataRange0;
        }
    }

    protected void updateImmediately() {
        super.updateImmediately();
        logger.finer("updateImmadiately" + this.getDatumRange() + " " + this.isLog());
        this.resetTransform();
        this.updateTickV();
    }

    public boolean areTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean b) {
        if (this.tickLabelsVisible == b) {
            return;
        }
        boolean oldValue = this.ticksVisible;
        this.tickLabelsVisible = b;
        this.update();
        this.firePropertyChange("tickLabelsVisible", oldValue, b);
    }

    protected void installComponent() {
        super.installComponent();
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    public DasAxis createAttachedAxis() {
        return new DasAxis(this.dataRange, this.getOrientation());
    }

    public DasAxis createAttachedAxis(int orientation) {
        return new DasAxis(this.dataRange, orientation);
    }

    public void setPlot(DasPlot p) {
        this.dasPlot = p;
    }

    public void scanPrevious() {
        double days;
        Datum delta = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        if (UnitsUtil.isTimeLocation((Units)this.getDataMinimum().getUnits()) && (days = delta.doubleValue(Units.days)) > 0.5 && DasMath.modp((double)days, (double)1.0) < 0.1) {
            delta = Units.days.createDatum(Math.round(delta.doubleValue(Units.days)));
        }
        Datum tmin = this.getDataMinimum().subtract(delta);
        Datum tmax = this.getDataMaximum().subtract(delta);
        this.setDataRange(tmin, tmax);
    }

    public void scanNext() {
        double days;
        Datum delta = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        if (UnitsUtil.isTimeLocation((Units)this.getDataMinimum().getUnits()) && (days = delta.doubleValue(Units.days)) > 0.5 && DasMath.modp((double)days, (double)1.0) < 0.1) {
            delta = Units.days.createDatum(Math.round(delta.doubleValue(Units.days)));
        }
        Datum tmin = this.getDataMinimum().add(delta);
        Datum tmax = this.getDataMaximum().add(delta);
        this.setDataRange(tmin, tmax);
    }

    public Shape getActiveRegion() {
        Rectangle primaryBounds = this.primaryInputPanel.getBounds();
        primaryBounds.translate(this.getX(), this.getY());
        if (this.oppositeAxisVisible) {
            Rectangle secondaryBounds = this.secondaryInputPanel.getBounds();
            secondaryBounds.translate(this.getX(), this.getY());
            GeneralPath path = new GeneralPath(primaryBounds);
            path.setWindingRule(0);
            path.append(secondaryBounds, false);
            return path;
        }
        return primaryBounds;
    }

    public void addMouseWheelListener(MouseWheelListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseWheelListener(l);
        this.secondaryInputPanel.addMouseWheelListener(l);
    }

    public void removeMouseWheelListener(MouseWheelListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseWheelListener(l);
        this.secondaryInputPanel.removeMouseWheelListener(l);
    }

    public void addMouseListener(MouseListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseListener(l);
        this.secondaryInputPanel.addMouseListener(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseListener(l);
        this.secondaryInputPanel.removeMouseListener(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseMotionListener(l);
        this.secondaryInputPanel.addMouseMotionListener(l);
    }

    public void removeMouseMotionListener(MouseMotionListener l) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseMotionListener(l);
        this.secondaryInputPanel.removeMouseMotionListener(l);
    }

    public void timeRangeSelected(TimeRangeSelectionEvent e) {
        if (e.getSource() != this && !e.equals(this.lastProcessedEvent)) {
            this.setDatumRange(e.getRange());
            this.lastProcessedEvent = e;
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        if (this.timeRangeListenerList == null) {
            this.timeRangeListenerList = new EventListenerList();
        }
        this.timeRangeListenerList.add(TimeRangeSelectionListener.class, listener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener listener) {
        this.timeRangeListenerList.remove(TimeRangeSelectionListener.class, listener);
    }

    private synchronized void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent event) {
        if (this.timeRangeListenerList == null) {
            return;
        }
        Object[] listeners = this.timeRangeListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TimeRangeSelectionListener.class) continue;
            String logmsg = "fire event: " + this.getClass().getName() + "-->" + listeners[i + 1].getClass().getName() + " " + event;
            DasLogger.getLogger(DasLogger.GUI_LOG).fine(logmsg);
            ((TimeRangeSelectionListener)listeners[i + 1]).timeRangeSelected(event);
        }
    }

    private static String format(double d, String f) {
        String result;
        DecimalFormat form;
        int i;
        Matcher m = pattern.matcher(f);
        if (!m.matches()) {
            throw new IllegalArgumentException("\"" + f + "\" is not a valid format specifier");
        }
        int length = Integer.parseInt(f.substring(2, f.indexOf(46)));
        int fracLength = Integer.parseInt(f.substring(f.indexOf(46) + 1, f.indexOf(41)));
        char[] buf = new char[length];
        if (f.charAt(1) == 'f' || f.charAt(1) == 'F') {
            for (i = 0; i < length - fracLength - 2; ++i) {
                buf[i] = 35;
            }
            buf[i] = 48;
            buf[++i] = 46;
            ++i;
            while (i < length) {
                buf[i] = 48;
                ++i;
            }
            form = new DecimalFormat(new String(buf));
            result = form.format(d);
        } else {
            for (i = 0; i < length - fracLength - 6; ++i) {
                buf[i] = 35;
            }
            buf[i] = 48;
            buf[++i] = 46;
            ++i;
            while (i < length - 5) {
                buf[i] = 48;
                ++i;
            }
            buf[i] = 69;
            buf[i + 1] = d > -1.0 && d < 1.0 ? 45 : 43;
            buf[i + 2] = 48;
            buf[i + 3] = 48;
            form = new DecimalFormat(new String(buf));
            result = form.format(d);
        }
        if (result.length() > length) {
            Arrays.fill(buf, '*');
            return new String(buf);
        }
        while (result.length() < length) {
            result = " " + result;
        }
        return result;
    }

    public String toString() {
        String retValue = super.toString() + "(" + this.getUnits() + ")";
        return retValue;
    }

    private void refreshScanButtons(boolean reset) {
        boolean t;
        if (this.scanNext == null) {
            return;
        }
        if (this.scanRange != null && !this.scanRange.getUnits().isConvertableTo(this.getDatumRange().getUnits())) {
            this.scanRange = null;
        }
        if (reset || this.scanPrevious.hover) {
            t = this.scanRange == null || this.scanRange.intersects(this.getDatumRange().previous());
            this.scanPrevious.hover = t;
        }
        if (reset || this.scanNext.hover) {
            t = this.scanRange == null || this.scanRange.intersects(this.getDatumRange().next());
            this.scanNext.hover = t;
        }
    }

    private void updateTickLength() throws ParseException {
        double[] pos = DasDevicePosition.parseFormatStr(this.tickLenStr);
        this.tickLen = pos[0] == 0.0 ? (int)Math.round(pos[1] * this.getEmSize() + pos[2]) : (int)Math.round(pos[0] * (double)this.getRow().getHeight() + pos[1] * this.getEmSize() + pos[2]);
    }

    public String getTickLength() {
        return this.tickLenStr;
    }

    public void setTickLength(String tickLengthStr) {
        this.tickLenStr = tickLengthStr;
        try {
            this.updateTickLength();
            this.resize();
            this.repaint();
        }
        catch (ParseException ex) {
            Logger.getLogger(DasAxis.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean b) {
        this.update();
        this.flipped = b;
    }

    public String getFormat() {
        return this.formatString;
    }

    public boolean isFlipLabel() {
        return this.flipLabel;
    }

    public void setFlipLabel(boolean flipLabel) {
        boolean oldFlipLabel = this.flipLabel;
        this.flipLabel = flipLabel;
        this.repaint();
        this.firePropertyChange(PROP_FLIPLABEL, oldFlipLabel, flipLabel);
    }

    public DatumFormatter getDividerDatumFormatter() {
        return this.dividerDatumFormatter;
    }

    public void setDividerDatumFormatter(DatumFormatter dividerDatumFormatter) {
        DatumFormatter oldDividerDatumFormatter = this.dividerDatumFormatter;
        this.dividerDatumFormatter = dividerDatumFormatter;
        this.firePropertyChange(PROP_DIVIDERDATUMFORMATTER, oldDividerDatumFormatter, dividerDatumFormatter);
    }

    public DomainDivider getMinorTicksDomainDivider() {
        return this.minorTicksDomainDivider;
    }

    public void setMinorTicksDomainDivider(DomainDivider minorTicksDomainDivider) {
        DomainDivider oldMinorTicksDomainDivider = this.minorTicksDomainDivider;
        this.minorTicksDomainDivider = minorTicksDomainDivider;
        this.firePropertyChange(PROP_MINORTICKSDOMAINDIVIDER, oldMinorTicksDomainDivider, minorTicksDomainDivider);
    }

    public DomainDivider getMajorTicksDomainDivider() {
        return this.majorTicksDomainDivider;
    }

    public void setMajorTicksDomainDivider(DomainDivider majorTicksDomainDivider) {
        DomainDivider oldMajorTicksDomainDivider = this.majorTicksDomainDivider;
        this.majorTicksDomainDivider = majorTicksDomainDivider;
        this.firePropertyChange(PROP_MAJORTICKSDOMAINDIVIDER, oldMajorTicksDomainDivider, majorTicksDomainDivider);
    }

    public boolean isUseDomainDivider() {
        return this.useDomainDivider;
    }

    public void setUseDomainDivider(boolean useDomainDivider) {
        boolean oldUseDomainDivider = this.useDomainDivider;
        this.useDomainDivider = useDomainDivider;
        if (oldUseDomainDivider != useDomainDivider) {
            this.updateTickV();
        }
        this.firePropertyChange(PROP_USEDOMAINDIVIDER, oldUseDomainDivider, useDomainDivider);
    }

    public void setFormat(String formatString) {
        try {
            String oldFormatString = this.formatString;
            this.formatString = formatString;
            if (formatString.equals("")) {
                this.setUserDatumFormatter(null);
            } else {
                this.setUserDatumFormatter(this.getUnits().getDatumFormatterFactory().newFormatter(formatString));
            }
            this.updateTickV();
            this.repaint();
            this.firePropertyChange(PROP_FORMATSTRING, oldFormatString, formatString);
        }
        catch (ParseException e) {
            this.setUserDatumFormatter(null);
        }
    }

    private void resetTransform() {
        DasDevicePosition pos;
        if (this.isHorizontal() ? (pos = this.getColumn()) == DasColumn.NULL : (pos = this.getRow()) == DasRow.NULL) {
            return;
        }
        double dmin = pos.getDMinimum();
        double dmax = pos.getDMaximum();
        if (this.isFlipped()) {
            double t = dmin;
            dmin = dmax;
            dmax = t;
        }
        double[] at = GraphUtil.getSlopeIntercept(this.dataRange.getMinimum(), dmin, this.dataRange.getMaximum(), dmax);
        this.at_m = at[0];
        this.at_b = at[1];
    }

    public Lock mutatorLock() {
        return this.dataRange.mutatorLock();
    }

    public boolean valueIsAdjusting() {
        return this.dataRange.valueIsAdjusting();
    }

    private class ScanButton
    extends JButton {
        private boolean hover;
        private boolean pressed;
        private boolean nextButton;

        public ScanButton(String text) {
            this.setOpaque(true);
            this.setContentAreaFilled(false);
            this.setText(text);
            this.setFocusable(false);
            this.nextButton = DasAxis.SCAN_NEXT_LABEL.equals(text);
            this.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(2, 2, 2, 2)));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ScanButton.this.setForeground(Color.LIGHT_GRAY);
                        ScanButton.this.pressed = DasAxis.this.scanRange == null || (ScanButton.this.nextButton ? DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().next()) : DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().previous()));
                        ScanButton.this.repaint();
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        ScanButton.this.setForeground(Color.BLACK);
                        ScanButton.this.pressed = false;
                        ScanButton.this.repaint();
                    }
                }

                public void mouseEntered(MouseEvent e) {
                    ScanButton.this.hover = DasAxis.this.scanRange == null || (ScanButton.this.nextButton ? DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().next()) : DasAxis.this.scanRange.intersects(DasAxis.this.getDatumRange().previous()));
                    ScanButton.this.repaint();
                }

                public void mouseExited(MouseEvent e) {
                    ScanButton.this.hover = false;
                    ScanButton.this.repaint();
                }
            });
        }

        protected void paintComponent(Graphics g) {
            if (DasAxis.this.getCanvas().isPrintingThread()) {
                return;
            }
            if (this.hover || this.pressed) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.white);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                Object aaHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Object aaOn = RenderingHints.VALUE_ANTIALIAS_ON;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaOn);
                super.paintComponent(g2);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
            }
        }

        protected void paintBorder(Graphics g) {
            if (this.hover || this.pressed) {
                super.paintBorder(g);
            }
        }
    }

    protected class AxisLayoutManager
    implements LayoutManager {
        protected AxisLayoutManager() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            if (DasAxis.this != parent) {
                throw new IllegalArgumentException();
            }
            if (DasAxis.this.isHorizontal()) {
                this.horizontalLayout();
            } else {
                this.verticalLayout();
            }
            if (DasAxis.this.drawTca && DasAxis.this.getOrientation() == 2 && DasAxis.this.tcaData != null) {
                Rectangle bounds = DasAxis.this.primaryInputPanel.getBounds();
                int tcaHeight = (DasAxis.this.getTickLabelFont().getSize() + DasAxis.this.getLineSpacing()) * Math.min(10, DasAxis.this.tcaData.length(0));
                bounds.height += tcaHeight;
                DasAxis.this.primaryInputPanel.setBounds(bounds);
            }
        }

        protected void horizontalLayout() {
            int topPosition = DasAxis.this.getRow().getDMinimum() - 1;
            int bottomPosition = DasAxis.this.getRow().getDMaximum();
            int DMax = DasAxis.this.getColumn().getDMaximum();
            int DMin = DasAxis.this.getColumn().getDMinimum();
            boolean bottomTicks = DasAxis.this.orientation == 2 || DasAxis.this.oppositeAxisVisible;
            boolean bottomTickLabels = DasAxis.this.orientation == 2 && DasAxis.this.tickLabelsVisible;
            boolean topTicks = DasAxis.this.orientation == 1 || DasAxis.this.oppositeAxisVisible;
            boolean topTickLabels = DasAxis.this.orientation == 1 && DasAxis.this.tickLabelsVisible;
            Rectangle bottomBounds = null;
            Rectangle topBounds = null;
            Font tickLabelFont = DasAxis.this.getTickLabelFont();
            int tickSize = tickLabelFont.getSize() * 2 / 3;
            if (bottomTicks) {
                bottomBounds = new Rectangle(DMin, bottomPosition, DMax - DMin + 1, 1);
            }
            if (topTicks) {
                topBounds = new Rectangle(DMin, topPosition, DMax - DMin + 1, 1);
            }
            if (bottomTicks) {
                bottomBounds.height += tickSize;
            }
            if (topTicks) {
                topBounds.height += tickSize;
                topBounds.y -= tickSize;
            }
            int tick_label_gap = DasAxis.this.getFontMetrics(tickLabelFont).stringWidth(" ");
            if (bottomTickLabels) {
                bottomBounds.height += tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            }
            if (topTickLabels) {
                topBounds.y -= tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
                topBounds.height += tickLabelFont.getSize() * 3 / 2 + tick_label_gap;
            }
            Rectangle primaryBounds = DasAxis.this.orientation == 2 ? bottomBounds : topBounds;
            Rectangle secondaryBounds = DasAxis.this.orientation == 2 ? topBounds : bottomBounds;
            primaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                secondaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(primaryBounds);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(secondaryBounds);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
            if (DasAxis.this.scanPrevious != null && DasAxis.this.scanNext != null) {
                Dimension preferred = DasAxis.this.scanPrevious.getPreferredSize();
                int x = DMin - preferred.width - DasAxis.this.getX();
                int y = (DasAxis.this.orientation == 2 ? bottomPosition : topPosition - preferred.height) - DasAxis.this.getY();
                DasAxis.this.scanPrevious.setBounds(x, y, preferred.width, preferred.height);
                preferred = DasAxis.this.scanNext.getPreferredSize();
                x = DMax - DasAxis.this.getX();
                DasAxis.this.scanNext.setBounds(x, y, preferred.width, preferred.height);
            }
        }

        protected void verticalLayout() {
            boolean leftTicks = DasAxis.this.orientation == 3 || DasAxis.this.oppositeAxisVisible;
            boolean leftTickLabels = DasAxis.this.orientation == 3 && DasAxis.this.tickLabelsVisible;
            boolean rightTicks = DasAxis.this.orientation == 4 || DasAxis.this.oppositeAxisVisible;
            boolean rightTickLabels = DasAxis.this.orientation == 4 && DasAxis.this.tickLabelsVisible;
            int leftPosition = DasAxis.this.getColumn().getDMinimum() - 1;
            int rightPosition = DasAxis.this.getColumn().getDMaximum();
            int DMax = DasAxis.this.getRow().getDMaximum();
            int DMin = DasAxis.this.getRow().getDMinimum();
            Rectangle leftBounds = null;
            Rectangle rightBounds = null;
            Font tickLabelFont = DasAxis.this.getTickLabelFont();
            int tickSize = tickLabelFont.getSize() * 2 / 3;
            if (leftTicks) {
                leftBounds = new Rectangle(leftPosition, DMin, 1, DMax - DMin + 1);
            }
            if (rightTicks) {
                rightBounds = new Rectangle(rightPosition, DMin, 1, DMax - DMin + 1);
            }
            if (leftTicks) {
                leftBounds.width += tickSize;
                leftBounds.x -= tickSize;
            }
            if (rightTicks) {
                rightBounds.width += tickSize;
            }
            int maxLabelWidth = DasAxis.this.getMaxLabelWidth();
            int tick_label_gap = DasAxis.this.getFontMetrics(tickLabelFont).stringWidth(" ");
            if (leftTickLabels) {
                leftBounds.x -= maxLabelWidth + tick_label_gap;
                leftBounds.width += maxLabelWidth + tick_label_gap;
            }
            if (rightTickLabels) {
                rightBounds.width += maxLabelWidth + tick_label_gap;
            }
            Rectangle primaryBounds = DasAxis.this.orientation == 3 ? leftBounds : rightBounds;
            Rectangle secondaryBounds = DasAxis.this.orientation == 3 ? rightBounds : leftBounds;
            primaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            if (DasAxis.this.oppositeAxisVisible) {
                secondaryBounds.translate(-DasAxis.this.getX(), -DasAxis.this.getY());
            }
            DasAxis.this.primaryInputPanel.setBounds(primaryBounds);
            if (DasAxis.this.oppositeAxisVisible) {
                DasAxis.this.secondaryInputPanel.setBounds(secondaryBounds);
            } else {
                DasAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension();
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    public static class Memento {
        private DatumRange range;
        private int dmin;
        private int dmax;
        private boolean log;
        private boolean flipped;
        private DasAxis axis;

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + (this.range != null ? this.range.hashCode() : 0);
            hash = 29 * hash + this.dmin;
            hash = 29 * hash + this.dmax;
            hash = 29 * hash + (this.log ? 1 : 0);
            hash = 29 * hash + (this.flipped ? 1 : 0);
            hash = 29 * hash + (this.axis != null ? this.axis.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Memento)) {
                return false;
            }
            Memento m = (Memento)o;
            return this == m || this.range.equals((Object)m.range) && this.dmin == m.dmin && this.dmax == m.dmax && this.log == m.log && this.flipped == m.flipped && this.axis == m.axis;
        }

        public String toString() {
            return (this.log ? "log " : "") + this.range.toString() + " (" + DatumUtil.asOrderOneUnits((Datum)this.range.width()).toString() + ") " + (this.dmax - this.dmin) + " pixels @ " + this.dmin;
        }
    }

    public static interface Lock {
        public void lock();

        public void unlock();
    }
}

