/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.util.DasDie;

public class DasLabel
extends DasCanvasComponent {
    String text = "";
    int x = 0;
    int y = 0;
    double angle = 0.0;
    Font font = null;
    AffineTransform at = new AffineTransform();
    Rectangle bounds = null;
    final int RIGHT = 99;
    final int LEFT = 98;
    final int CENTER = 97;
    int justification = 98;
    Component parent = null;

    public DasLabel() {
    }

    public DasLabel(String text, int x, int y) {
        this();
        this.text = text;
        this.x = x;
        this.y = y;
        this.setTransform();
    }

    public void draw(Graphics2D g) {
        Font oldfont = null;
        AffineTransform oldat = null;
        if (this.font != null) {
            oldfont = g.getFont();
            g.setFont(this.font);
        }
        if (this.at != null) {
            oldat = g.getTransform();
        }
        g.setTransform(this.at);
        g.drawString(this.text, (float)this.x, (float)this.y);
        FontMetrics fm = g.getFontMetrics();
        this.bounds = fm.getStringBounds(this.text, g).getBounds();
        this.bounds.translate(this.x, this.y);
        DasDie.println((Object)this.bounds);
        if (this.font != null) {
            g.setFont(oldfont);
        }
        if (this.at != null) {
            g.setTransform(oldat);
        }
    }

    private void setTransform() {
        this.at.setToIdentity();
        this.at.translate(this.x, this.y);
        this.at.rotate(this.angle * Math.PI / 180.0);
    }

    public void setRotation(double angle) {
        this.angle = angle;
        this.setTransform();
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.setTransform();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setParent(DasCanvas parent) {
        this.parent = parent;
    }
}

