/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Editable;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.DataSetConsumer;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRendererUpdateEvent;
import org.das2.graph.DataLoader;
import org.das2.graph.XAxisDataLoader;
import org.das2.system.DasLogger;
import org.das2.util.DasExceptionHandler;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;

public abstract class Renderer
implements DataSetConsumer,
Editable,
Displayable {
    String dataSetId;
    protected QDataSet ds;
    private DasAxis.Memento xmemento;
    private DasAxis.Memento ymemento;
    DasPlot parent;
    DataLoader loader;
    protected Exception lastException;
    protected Exception renderException;
    protected int firstValidIndex = -1;
    protected int lastValidIndex = -1;
    protected static final Logger logger = DasLogger.getLogger(DasLogger.RENDERER_LOG);
    private static final String PROPERTY_ACTIVE = "active";
    private static final String PROPERTY_DATASET = "dataSet";
    private boolean dumpDataSet;
    private boolean overloading = false;
    public static final String PROP_ACTIVE = "active";
    private boolean active = true;
    public static final String PROP_LEGENDLABEL = "legendLabel";
    protected String legendLabel = "";
    protected boolean drawLegendLabel = false;
    public static final String PROP_DRAWLEGENDLABEL = "drawLegendLabel";
    protected String id = "rend";
    public static final String PROP_ID = "id";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected Renderer(DataSetDescriptor dsd) {
        this.loader = new XAxisDataLoader(this, dsd);
    }

    protected Renderer(QDataSet ds) {
        this.ds = ds;
        this.loader = null;
    }

    protected Renderer() {
        this((DataSetDescriptor)null);
    }

    public DasPlot getParent() {
        return this.parent;
    }

    public DasAxis.Memento getXmemento() {
        return this.xmemento;
    }

    public DasAxis.Memento getYmemento() {
        return this.ymemento;
    }

    public static boolean isTableDataSet(QDataSet ds) {
        return SemanticOps.isTableDataSet((QDataSet)ds);
    }

    private void updateFirstLastValid() {
        if (this.ds == null || this.ds.rank() == 0) {
            this.firstValidIndex = 0;
            this.lastValidIndex = 0;
            return;
        }
        if (SemanticOps.isTableDataSet((QDataSet)this.ds)) {
            this.firstValidIndex = 0;
            this.lastValidIndex = this.ds.length();
        } else if (SemanticOps.isSimpleBundleDataSet((QDataSet)this.ds)) {
            this.firstValidIndex = 0;
            this.lastValidIndex = this.ds.length();
        } else {
            this.firstValidIndex = -1;
            this.lastValidIndex = -1;
            QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)this.ds);
            if (wds.rank() == 1) {
                int i;
                for (i = 0; this.firstValidIndex == -1 && i < this.ds.length(); ++i) {
                    if (!(wds.value(i) > 0.0)) continue;
                    this.firstValidIndex = i;
                }
                for (i = this.ds.length() - 1; this.lastValidIndex == -1 && i >= 0; --i) {
                    if (!(wds.value(i) > 0.0)) continue;
                    this.lastValidIndex = i + 1;
                }
            } else {
                this.firstValidIndex = 0;
                this.lastValidIndex = wds.length();
            }
        }
    }

    protected void invalidateParentCacheImage() {
        if (this.parent != null) {
            this.parent.invalidateCacheImage();
        }
    }

    public QDataSet getDataSet() {
        return this.ds;
    }

    public QDataSet getConsumedDataSet() {
        return this.ds;
    }

    public boolean isDumpDataSet() {
        return this.dumpDataSet;
    }

    public void setDumpDataSet(boolean dumpDataSet) {
        this.dumpDataSet = dumpDataSet;
        if (dumpDataSet) {
            try {
                if (this.ds == null) {
                    this.setDumpDataSet(false);
                    throw new DasException("data set is null");
                }
                JFileChooser chooser = new JFileChooser();
                int xx = chooser.showSaveDialog(this.getParent());
                if (xx == 0) {
                    File file = chooser.getSelectedFile();
                    if (Renderer.isTableDataSet(this.ds)) {
                        TableUtil.dumpToAsciiStream((TableDataSet)DataSetAdapter.createLegacyDataSet(this.ds), new FileOutputStream(file));
                    } else if (this.ds instanceof VectorDataSet) {
                        VectorUtil.dumpToAsciiStream((VectorDataSet)DataSetAdapter.createLegacyDataSet(this.ds), new FileOutputStream(file));
                    } else {
                        throw new DasException("don't know how to serialize data set: " + this.ds);
                    }
                }
                this.setDumpDataSet(false);
            }
            catch (Exception e) {
                DasExceptionHandler.handle((Throwable)e);
            }
            this.dumpDataSet = dumpDataSet;
        }
    }

    public void setLastException(Exception e) {
        this.renderException = this.lastException = e;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public boolean acceptsDataSet(QDataSet ds) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSet(QDataSet ds) {
        logger.log(Level.FINE, "Renderer.setDataSet {0}: {1}", new Object[]{this.id, ds});
        QDataSet oldDs = this.ds;
        if (oldDs != ds) {
            Renderer renderer = this;
            synchronized (renderer) {
                this.updateFirstLastValid();
                this.ds = ds;
            }
            this.refresh();
            this.invalidateParentCacheImage();
            this.propertyChangeSupport.firePropertyChange(PROPERTY_DATASET, oldDs, ds);
        }
    }

    public void setException(Exception e) {
        logger.log(Level.FINE, "Renderer.setException: {0}", e);
        Exception oldException = this.lastException;
        this.renderException = this.lastException = e;
        if (this.parent != null && oldException != e) {
            this.update();
            this.invalidateParentCacheImage();
        }
    }

    public void setDataSetID(String id) throws DasException {
        if (id == null) {
            throw new NullPointerException("Null dataPath not allowed");
        }
        if (id.equals("")) {
            this.setDataSetDescriptor(null);
            return;
        }
        try {
            DataSetDescriptor dsd = DataSetDescriptor.create(id);
            this.setDataSetDescriptor(dsd);
        }
        catch (DasException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public String getDataSetID() {
        if (this.getDataSetDescriptor() == null) {
            return "";
        }
        return this.getDataSetDescriptor().getDataSetID();
    }

    protected AffineTransform getAffineTransform(DasAxis xAxis, DasAxis yAxis) {
        if (this.xmemento == null) {
            logger.fine("unable to calculate AT, because old transform is not defined.");
            return null;
        }
        AffineTransform at = new AffineTransform();
        at = xAxis.getAffineTransform(this.xmemento, at);
        at = yAxis.getAffineTransform(this.ymemento, at);
        return at;
    }

    public abstract void render(Graphics var1, DasAxis var2, DasAxis var3, ProgressMonitor var4);

    public boolean acceptContext(int x, int y) {
        return false;
    }

    protected void renderException(Graphics g, DasAxis xAxis, DasAxis yAxis, Exception e) {
        String message;
        String s;
        if (e instanceof NoDataInIntervalException) {
            s = "no data in interval";
            message = e.getMessage();
        } else {
            s = e.getMessage();
            message = "";
            if (s == null || s.length() < 10) {
                s = e.toString();
            }
        }
        if (!message.equals("")) {
            s = s + ":!c" + message;
        }
        this.parent.postMessage(this, s, 2, null, null);
    }

    public void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) throws DasException {
    }

    protected void refreshImage() {
        if (this.getParent() != null) {
            this.refresh();
        }
    }

    public void update() {
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        logger.log(Level.FINE, "Renderer.update {0}", this.id);
        if (this.parent != null) {
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            DasRendererUpdateEvent drue = new DasRendererUpdateEvent(this.parent, this);
            eventQueue.postEvent(drue);
        } else {
            logger.fine("update but parent was null");
        }
    }

    protected void updateImmediately() {
        logger.finer("entering Renderer.updateImmediately");
        if (this.parent == null || !this.parent.isDisplayable()) {
            return;
        }
        if (this.loader != null) {
            this.loader.update();
        }
        this.refresh();
    }

    protected void refresh() {
        if (!this.isActive()) {
            return;
        }
        logger.fine("entering Renderer.refresh");
        if (this.parent == null) {
            logger.fine("null parent in refresh");
            return;
        }
        if (!this.parent.isDisplayable()) {
            logger.fine("parent not displayable");
            return;
        }
        Runnable run = new Runnable(){

            public void run() {
                logger.log(Level.FINE, "update plot image for {0}", Renderer.this.id);
                DasPlot lparent = Renderer.this.parent;
                try {
                    if (lparent == null) {
                        return;
                    }
                    ProgressMonitor progressPanel = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor(Renderer.this.parent, "Rebinning data set", "updatePlotImage");
                    Renderer.this.updatePlotImage(lparent.getXAxis(), lparent.getYAxis(), progressPanel);
                    Renderer.this.xmemento = lparent.getXAxis().getMemento();
                    Renderer.this.ymemento = lparent.getYAxis().getMemento();
                    Renderer.this.renderException = null;
                    Renderer.this.lastException = null;
                }
                catch (DasException de) {
                    logger.log(Level.WARNING, "exception: {0}", de);
                    Renderer.this.ds = null;
                    Renderer.this.renderException = de;
                }
                catch (RuntimeException re) {
                    logger.log(Level.WARNING, "exception: {0}", re);
                    re.printStackTrace();
                    Renderer.this.renderException = re;
                    if (lparent != null) {
                        lparent.invalidateCacheImage();
                        lparent.repaint();
                    }
                    throw re;
                }
                logger.fine("invalidate parent cacheImage and repaint");
                lparent.invalidateCacheImage();
                lparent.repaint();
            }
        };
        boolean async = false;
        if (EventQueue.isDispatchThread()) {
            if (async) {
                new Thread(run, "updatePlotImage").start();
            } else {
                run.run();
            }
        } else {
            run.run();
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dsd) {
        if (this.loader == null) {
            logger.warning("installing loader--danger!");
            this.loader = new XAxisDataLoader(this, dsd);
        }
        if (this.loader instanceof XAxisDataLoader) {
            ((XAxisDataLoader)this.loader).setDataSetDescriptor(dsd);
            if (this.parent != null) {
                this.parent.markDirty();
                this.parent.update();
            }
        } else {
            throw new RuntimeException("loader is not based on DataSetDescriptor");
        }
        this.ds = null;
    }

    public DataLoader getDataLoader() {
        return this.loader;
    }

    public void setDataSetLoader(DataLoader loader) {
        this.loader = loader;
        if (loader != null) {
            loader.update();
        }
    }

    public DataSetDescriptor getDataSetDescriptor() {
        if (this.loader == null) {
            return null;
        }
        if (this.loader instanceof XAxisDataLoader) {
            return ((XAxisDataLoader)this.loader).getDataSetDescriptor();
        }
        return null;
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    public boolean isOverloading() {
        return this.overloading;
    }

    public void setOverloading(boolean overloading) {
        this.overloading = overloading;
        this.update();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        boolean oldValue = this.active;
        this.active = active;
        if (oldValue != active) {
            this.update();
        }
        this.propertyChangeSupport.firePropertyChange("active", oldValue, active);
    }

    public String getLegendLabel() {
        return this.legendLabel;
    }

    public void setLegendLabel(String legendLabel) {
        String oldLegendLabel = this.legendLabel;
        this.legendLabel = legendLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_LEGENDLABEL, oldLegendLabel, legendLabel);
        this.refreshImage();
    }

    public boolean isDrawLegendLabel() {
        return this.drawLegendLabel;
    }

    public void setDrawLegendLabel(boolean drawLegendLabel) {
        boolean oldDrawLegendLabel = this.drawLegendLabel;
        this.drawLegendLabel = drawLegendLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWLEGENDLABEL, oldDrawLegendLabel, drawLegendLabel);
        this.refreshImage();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String oldId = this.id;
        this.id = id;
        this.propertyChangeSupport.firePropertyChange(PROP_ID, oldId, id);
    }

    public void drawListIcon(Graphics2D g, int x, int y) {
        ImageIcon icon = (ImageIcon)this.getListIcon();
        g.drawImage(icon.getImage(), x, y, null);
    }

    public Icon getListIcon() {
        return new ImageIcon(new BufferedImage(16, 16, 2));
    }

    public String getListLabel() {
        StringBuffer l = new StringBuffer(this.getLegendLabel());
        if (this.getDataSetDescriptor() != null && l.length() > 0) {
            l.append(" (" + this.getDataSetDescriptor() + ")");
        }
        if (l.length() == 0) {
            l.append(this.getClass().getName());
        }
        return l.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }
}

