/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.Timer;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.DasProperties;
import org.das2.dataset.VectorUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.FillStyle;
import org.das2.graph.GraphUtil;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.Renderer;
import org.das2.graph.SelectionUtil;
import org.das2.system.DasLogger;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SeriesRenderer
extends Renderer {
    private DefaultPlotSymbol psym = DefaultPlotSymbol.CIRCLES;
    private double symSize = 3.0;
    private double lineWidth = 1.0;
    private boolean histogram = false;
    private PsymConnector psymConnector = PsymConnector.SOLID;
    private FillStyle fillStyle = FillStyle.STYLE_FILL;
    private int renderCount = 0;
    private int updateImageCount = 0;
    private Color color = Color.BLACK;
    private long lastUpdateMillis;
    private boolean antiAliased = "on".equals(DasProperties.getInstance().get("antiAlias"));
    private int firstIndex = -1;
    private int lastIndex = -1;
    private int firstIndex_v = -1;
    private int lastIndex_v = -1;
    private int dslen = -1;
    boolean updating = false;
    boolean unitsWarning = false;
    private static final Logger log = DasLogger.getLogger(DasLogger.GRAPHICS_LOG);
    private boolean dataSetClipped;
    Image psymImage;
    Image[] coloredPsyms;
    int cmx;
    int cmy;
    FillRenderElement fillElement = new FillRenderElement();
    ErrorBarRenderElement errorElement = new ErrorBarRenderElement();
    PsymConnectorRenderElement psymConnectorElement = new PsymConnectorRenderElement();
    PsymConnectorRenderElement[] extraConnectorElements;
    PsymRenderElement psymsElement = new PsymRenderElement();
    Shape selectionArea;
    public static final String PROPERTY_X_DELTA_PLUS = "X_DELTA_PLUS";
    public static final String PROPERTY_X_DELTA_MINUS = "X_DELTA_MINUS";
    public static final String PROPERTY_Y_DELTA_PLUS = "Y_DELTA_PLUS";
    public static final String PROPERTY_Y_DELTA_MINUS = "Y_DELTA_MINUS";
    private Color fillColor = Color.lightGray;
    private String colorByDataSetId = "";
    private DasColorBar colorBar;
    PropertyChangeListener colorBarListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                SeriesRenderer.this.update();
            }
        }
    };
    private boolean fillToReference;
    private Datum reference = Units.dimensionless.createDatum(0);
    private boolean resetDebugCounters;
    private boolean simplifyPaths = true;
    private boolean stampPsyms = true;
    public static final String PROP_STAMPPSYMS = "stampPsyms";
    private int dataSetSizeLimit = 200000;
    private double updatesPointsPerMillisecond;
    public static final String PROP_UPDATESPOINTSPERMILLISECOND = "updatesPointsPerMillisecond";
    private double renderPointsPerMillisecond;
    public static final String PROP_RENDERPOINTSPERMILLISECOND = "renderPointsPerMillisecond";
    protected boolean cadenceCheck = true;
    public static final String PROP_CADENCECHECK = "cadenceCheck";

    public SeriesRenderer() {
        this.updatePsym();
    }

    private QDataSet ytagsDataSet(QDataSet ds) {
        QDataSet vds;
        if (ds.rank() == 2 && SemanticOps.isBundle((QDataSet)ds)) {
            vds = SemanticOps.ytagsDataSet((QDataSet)ds);
        } else {
            if (ds.rank() == 2) {
                this.parent.postMessage(this, "dataset is rank 2 and not a bundle", 0, null, null);
                return null;
            }
            vds = ds;
        }
        return vds;
    }

    private QDataSet colorByDataSet(QDataSet ds) {
        QDataSet colorByDataSet1 = null;
        if (this.colorByDataSetId.length() > 0) {
            if (this.colorByDataSetId.equals("PLANE_0")) {
                colorByDataSet1 = (QDataSet)ds.property("PLANE_0");
                if (colorByDataSet1 == null && ds.rank() == 2) {
                    colorByDataSet1 = DataSetOps.unbundleDefaultDataSet((QDataSet)ds);
                }
            } else if (ds.rank() == 2) {
                colorByDataSet1 = DataSetOps.unbundle((QDataSet)ds, (String)this.colorByDataSetId);
            }
        }
        return colorByDataSet1;
    }

    private float midPoint(DasAxis axis, double d1, Units units, double delta, boolean ratiometric, double alpha) {
        float fx1 = axis.isLog() && ratiometric ? (float)axis.transform(Math.exp(Math.log(d1) + delta * alpha), units) : (float)axis.transform(d1 + delta * alpha, units);
        return fx1;
    }

    private void updatePsym() {
        int sx = 6 + (int)Math.ceil(this.symSize + 2.0 * this.lineWidth);
        int sy = 6 + (int)Math.ceil(this.symSize + 2.0 * this.lineWidth);
        double dcmx = this.lineWidth + (double)((int)Math.ceil(this.symSize / 2.0)) + 2.0;
        double dcmy = this.lineWidth + (double)((int)Math.ceil(this.symSize / 2.0)) + 2.0;
        BufferedImage image = new BufferedImage(sx, sy, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Object rendering = this.antiAliased ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
        g.setColor(this.color);
        DasPlot lparent = this.parent;
        if (lparent == null) {
            return;
        }
        g.setBackground(lparent.getBackground());
        g.setStroke(new BasicStroke((float)this.lineWidth));
        this.psym.draw(g, dcmx, dcmy, (float)this.symSize, this.fillStyle);
        this.psymImage = image;
        if (this.colorBar != null) {
            IndexColorModel model = this.colorBar.getIndexColorModel();
            this.coloredPsyms = new Image[model.getMapSize()];
            for (int i = 0; i < model.getMapSize(); ++i) {
                Color c = new Color(model.getRGB(i));
                image = new BufferedImage(sx, sy, 2);
                g = (Graphics2D)image.getGraphics();
                g.setBackground(lparent.getBackground());
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rendering);
                g.setColor(c);
                g.setStroke(new BasicStroke((float)this.lineWidth));
                this.psym.draw(g, dcmx, dcmy, (float)this.symSize, this.fillStyle);
                this.coloredPsyms[i] = image;
            }
        }
        this.cmx = (int)dcmx;
        this.cmy = (int)dcmy;
        this.update();
    }

    private void reportCount() {
    }

    private synchronized void updateFirstLast(DasAxis xAxis, DasAxis yAxis, QDataSet xds, QDataSet dataSet) {
        int index;
        int ixmax;
        int ixmin;
        QDataSet yds = dataSet;
        if (yds.rank() == 2) {
            yds = DataSetOps.slice1((QDataSet)yds, (int)0);
        }
        QDataSet wxds = SemanticOps.weightsDataSet((QDataSet)xds);
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)yds);
        DasPlot lparent = this.parent;
        if (lparent == null) {
            return;
        }
        this.dslen = xds.length();
        Boolean xMono = SemanticOps.isMonotonic((QDataSet)xds);
        if (xMono != null && xMono.booleanValue()) {
            DatumRange visibleRange = xAxis.getDatumRange();
            this.firstIndex_v = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min());
            this.lastIndex_v = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max()) + 1;
            if (lparent.isOverSize()) {
                Rectangle plotBounds = lparent.getUpdateImageBounds();
                if (plotBounds != null) {
                    visibleRange = new DatumRange(xAxis.invTransform(plotBounds.x), xAxis.invTransform(plotBounds.x + plotBounds.width));
                }
                ixmin = DataSetUtil.getPreviousIndex((QDataSet)xds, (Datum)visibleRange.min());
                ixmax = DataSetUtil.getNextIndex((QDataSet)xds, (Datum)visibleRange.max()) + 1;
            } else {
                ixmin = this.firstIndex_v;
                ixmax = this.lastIndex_v;
            }
        } else {
            ixmin = 0;
            ixmax = xds.length();
            this.firstIndex_v = ixmin;
            this.lastIndex_v = ixmax;
        }
        double x = Double.NaN;
        double y = Double.NaN;
        for (index = ixmin; index < ixmax; ++index) {
            boolean isValid;
            x = xds.value(index);
            y = yds.value(index);
            boolean bl = isValid = wds.value(index) > 0.0 && wxds.value(index) > 0.0;
            if (!isValid) continue;
            this.firstIndex = index++;
            break;
        }
        if (this.firstIndex == -1) {
            this.lastIndex = ixmax;
            this.firstIndex = ixmax;
        }
        int pointsPlotted = 0;
        for (index = this.firstIndex; index < ixmax && pointsPlotted < this.dataSetSizeLimit; ++index) {
            boolean isValid;
            y = yds.value(index);
            boolean bl = isValid = wds.value(index) > 0.0 && wxds.value(index) > 0.0;
            if (!isValid) continue;
            ++pointsPlotted;
        }
        if (index < ixmax && pointsPlotted == this.dataSetSizeLimit) {
            this.dataSetClipped = true;
        }
        this.lastIndex = index;
        logger.log(Level.FINE, "ds: {0},  firstIndex={1} to lastIndex={2}", new Object[]{this.ds, this.firstIndex, this.lastIndex});
    }

    public synchronized void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        DasPlot lparent = this.parent;
        logger.log(Level.FINE, "enter {0}.render: {1}", new Object[]{this.id, this.getDataSet()});
        logger.log(Level.FINE, "ds: {0},  drawing indeces {1} to {2}", new Object[]{this.ds, this.firstIndex, this.lastIndex});
        if (lparent == null) {
            return;
        }
        if (this.ds == null && this.lastException != null) {
            lparent.postException(this, this.lastException);
            return;
        }
        ++this.renderCount;
        this.reportCount();
        long timer0 = System.currentTimeMillis();
        QDataSet dataSet = this.getDataSet();
        if (dataSet == null) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("null data set");
            lparent.postMessage(this, "no data set", 0, null, null);
            return;
        }
        if (dataSet.rank() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("rank 0 data set");
            lparent.postMessage(this, "rank 0 data set: " + dataSet.toString(), 0, null, null);
            return;
        }
        if (dataSet.length() == 0) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("empty data set");
            lparent.postMessage(this, "empty data set", 0, null, null);
            return;
        }
        if (this.psym == DefaultPlotSymbol.NONE && this.psymConnector == PsymConnector.NONE) {
            DasLogger.getLogger(DasLogger.GRAPHICS_LOG).fine("plot symbol and symbol connector are set to none");
            lparent.postMessage(this, "plot symbol and symbol connector are set to none", 0, null, null);
            return;
        }
        QDataSet tds = null;
        QDataSet vds = null;
        boolean yaxisUnitsOkay = false;
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
        if (!SemanticOps.isTableDataSet((QDataSet)dataSet)) {
            vds = this.ytagsDataSet(this.ds);
            yaxisUnitsOkay = SemanticOps.getUnits((QDataSet)vds).isConvertableTo(yAxis.getUnits());
        } else {
            tds = dataSet;
            yaxisUnitsOkay = SemanticOps.getUnits((QDataSet)tds).isConvertableTo(yAxis.getUnits());
        }
        if (!yaxisUnitsOkay) {
            if (this.unitsWarning) {
                lparent.postMessage(this, "yaxis units changed from \"" + SemanticOps.getUnits((QDataSet)vds) + "\" to \"" + yAxis.getUnits() + "\"", 1, null, null);
            } else {
                lparent.postMessage(this, "inconvertible yaxis units", 0, null, null);
                return;
            }
        }
        if (!SemanticOps.getUnits((QDataSet)xds).isConvertableTo(xAxis.getUnits())) {
            lparent.postMessage(this, "inconvertible xaxis units", 0, null, null);
            return;
        }
        int messageCount = 0;
        logger.log(Level.FINE, "rendering points: {0}  {1}", new Object[]{this.lastIndex, this.firstIndex});
        if (this.lastIndex == -1) {
            if (messageCount++ == 0) {
                lparent.postMessage(this, "need to update first/last", 0, null, null);
            }
            this.update();
            Timer t = new Timer(200, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SeriesRenderer.this.update();
                }
            });
            t.setRepeats(false);
            t.restart();
        }
        if (this.lastIndex == this.firstIndex && this.firstValidIndex == this.lastValidIndex && messageCount++ == 0) {
            lparent.postMessage(this, "dataset contains no valid data", 0, null, null);
        }
        logger.log(Level.FINE, "render data set {0}", dataSet);
        Graphics2D graphics = (Graphics2D)g.create();
        if (this.antiAliased) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (tds != null) {
            String label;
            int j;
            if (this.extraConnectorElements == null) {
                return;
            }
            if (tds.length(0) != this.extraConnectorElements.length) {
                return;
            }
            QDataSet yds = this.ytagsDataSet(tds);
            Units yunits = SemanticOps.getUnits((QDataSet)yds);
            int maxWidth = 0;
            for (j = 0; j < tds.length(0); ++j) {
                label = String.valueOf(yunits.createDatum(yds.value(j))).trim();
                maxWidth = Math.max(maxWidth, g.getFontMetrics().stringWidth(label));
            }
            for (j = 0; j < tds.length(0); ++j) {
                vds = DataSetOps.slice1((QDataSet)tds, (int)j);
                graphics.setColor(this.color);
                if (this.extraConnectorElements[j] == null) continue;
                this.extraConnectorElements[j].render(graphics, xAxis, yAxis, vds, mon);
                label = String.valueOf(yunits.createDatum(yds.value(j))).trim();
                lparent.addToLegend(this, (ImageIcon)GraphUtil.colorIcon(this.extraConnectorElements[j].color, 5, 5), j, label);
            }
            graphics.dispose();
            return;
        }
        if (this.fillToReference) {
            this.fillElement.render(graphics, xAxis, yAxis, vds, mon);
        }
        graphics.setColor(this.color);
        log.log(Level.FINEST, "drawing psymConnector in {0}", this.color);
        int connectCount = this.psymConnectorElement.render(graphics, xAxis, yAxis, vds, mon);
        log.log(Level.FINEST, "connectCount: {0}", connectCount);
        this.errorElement.render(graphics, xAxis, yAxis, vds, mon);
        int symCount = 0;
        if (this.psym != DefaultPlotSymbol.NONE) {
            symCount = this.psymsElement.render(graphics, xAxis, yAxis, vds, mon);
            log.log(Level.FINEST, "symCount: {0}", symCount);
            mon.finished();
        }
        long milli = System.currentTimeMillis();
        long renderTime = milli - timer0;
        double dppms = (double)(this.lastIndex - this.firstIndex) / (double)renderTime;
        this.setRenderPointsPerMillisecond(dppms);
        logger.log(Level.FINER, "render: {0} total:{1} fps:{2} pts/ms:{3}", new Object[]{renderTime, milli - this.lastUpdateMillis, 1000.0 / (double)(milli - this.lastUpdateMillis), dppms});
        this.lastUpdateMillis = milli;
        if (this.dataSetClipped) {
            lparent.postMessage(this, "dataset clipped at " + this.dataSetSizeLimit + " points", 1, null, null);
        }
        if (this.lastIndex_v - this.firstIndex_v < 2 && dataSet.length() > 1 && messageCount++ == 0) {
            if (this.lastIndex_v < 2) {
                lparent.postMessage(this, "data starts after range", 0, null, null);
            } else if (this.dslen - this.firstIndex_v < 2) {
                lparent.postMessage(this, "data ends before range", 0, null, null);
            } else {
                lparent.postMessage(this, "fewer than two points visible", 0, null, null);
            }
        }
        graphics.dispose();
    }

    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis, ProgressMonitor monitor) {
        logger.log(Level.FINE, "enter {0}.updatePlotImage: {1}", new Object[]{this.id, this.getDataSet()});
        this.updating = true;
        ++this.updateImageCount;
        this.reportCount();
        try {
            super.updatePlotImage(xAxis, yAxis, monitor);
        }
        catch (DasException e) {
            throw new RuntimeException(e);
        }
        QDataSet dataSet = this.getDataSet();
        if (dataSet == null) {
            logger.fine("dataset was null");
            return;
        }
        if (dataSet.rank() == 0) {
            logger.fine("rank 0 dataset");
            return;
        }
        if (dataSet.length() == 0) {
            logger.fine("dataset was empty");
            return;
        }
        if (!this.isActive()) {
            return;
        }
        boolean plottable = false;
        QDataSet tds = null;
        QDataSet vds = null;
        QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
        if (!SemanticOps.isTableDataSet((QDataSet)dataSet)) {
            vds = this.ytagsDataSet(this.ds);
            this.unitsWarning = false;
            plottable = SemanticOps.getUnits((QDataSet)vds).isConvertableTo(yAxis.getUnits());
            if (!plottable && UnitsUtil.isRatioMeasurement((Units)SemanticOps.getUnits((QDataSet)vds)) && UnitsUtil.isRatioMeasurement((Units)yAxis.getUnits())) {
                plottable = true;
                this.unitsWarning = true;
            }
        } else {
            tds = dataSet;
            plottable = SemanticOps.getUnits((QDataSet)tds).isConvertableTo(yAxis.getUnits());
        }
        boolean bl = plottable = plottable && SemanticOps.getUnits((QDataSet)xds).isConvertableTo(xAxis.getUnits());
        if (!plottable) {
            return;
        }
        logger.fine("entering updatePlotImage");
        long t0 = System.currentTimeMillis();
        this.dataSetClipped = false;
        this.firstIndex = -1;
        this.lastIndex = -1;
        if (vds != null) {
            this.updateFirstLast(xAxis, yAxis, xds, vds);
            if (this.fillToReference) {
                this.fillElement.update(xAxis, yAxis, dataSet, monitor);
            }
            if (this.psymConnector != PsymConnector.NONE) {
                this.psymConnectorElement.update(xAxis, yAxis, dataSet, monitor);
            }
            this.errorElement.update(xAxis, yAxis, dataSet, monitor);
            this.psymsElement.update(xAxis, yAxis, dataSet, monitor);
            this.selectionArea = this.calcSelectionArea(xAxis, yAxis, xds, vds);
        } else if (tds != null) {
            this.extraConnectorElements = new PsymConnectorRenderElement[tds.length(0)];
            for (int i = 0; i < tds.length(0); ++i) {
                this.extraConnectorElements[i] = new PsymConnectorRenderElement();
                float[] colorHSV = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
                if (colorHSV[2] < 0.7f) {
                    colorHSV[2] = 0.7f;
                }
                if (colorHSV[1] < 0.7f) {
                    colorHSV[1] = 0.7f;
                }
                this.extraConnectorElements[i].color = Color.getHSBColor((float)i / 6.0f, colorHSV[1], colorHSV[2]);
                vds = DataSetOps.unbundle((QDataSet)tds, (int)i);
                if (i == 0) {
                    this.updateFirstLast(xAxis, yAxis, xds, vds);
                }
                this.extraConnectorElements[i].update(xAxis, yAxis, vds, monitor);
                if (i != 0) continue;
                this.selectionArea = this.calcSelectionArea(xAxis, yAxis, xds, vds);
            }
        } else {
            System.err.println("both tds and vds are null");
        }
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
        logger.log(Level.FINE, "done updatePlotImage in {0} ms", System.currentTimeMillis() - t0);
        this.updating = false;
        long milli = System.currentTimeMillis();
        long renderTime = milli - t0;
        double dppms = (double)(this.lastIndex - this.firstIndex) / (double)renderTime;
        this.setUpdatesPointsPerMillisecond(dppms);
    }

    private Shape calcSelectionArea(DasAxis xaxis, DasAxis yaxis, QDataSet xds, QDataSet ds) {
        Datum widthx = xaxis.isLog() ? Units.logERatio.createDatum(Math.log(xaxis.getDataMaximum(xaxis.getUnits()) - xaxis.getDataMinimum(xaxis.getUnits()))) : xaxis.getDatumRange().width();
        Datum widthy = yaxis.isLog() ? Units.logERatio.createDatum(Math.log(yaxis.getDataMaximum(yaxis.getUnits()) - yaxis.getDataMinimum(yaxis.getUnits()))) : yaxis.getDatumRange().width();
        if (xaxis.getColumn().getWidth() == 0 || yaxis.getRow().getHeight() == 0) {
            return null;
        }
        QDataSet ds2 = ds;
        if (this.unitsWarning) {
            ArrayDataSet ds3 = ArrayDataSet.copy((QDataSet)ds);
            ds3.putProperty("UNITS", (Object)yaxis.getUnits());
            ds2 = ds3;
        }
        if (ds2.rank() == 2) {
            ds2 = DataSetOps.slice1((QDataSet)ds2, (int)0);
        }
        QDataSet reduce = VectorUtil.reduce2D(xds, ds2, this.firstIndex, Math.min(this.firstIndex + 20000, this.lastIndex), widthx.divide((double)(xaxis.getColumn().getWidth() / 5)), widthy.divide((double)(yaxis.getRow().getHeight() / 5)));
        try {
            GeneralPath path = GraphUtil.getPath(xaxis, yaxis, reduce, this.histogram, true);
            Shape s = new BasicStroke(5.0f, 1, 1).createStrokedShape(path);
            return s;
        }
        catch (InconvertibleUnitsException ex) {
            return SelectionUtil.NULL;
        }
    }

    protected void installRenderer() {
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            DasPlot lparent = this.parent;
            if (lparent == null) {
                throw new IllegalArgumentException("parent not set");
            }
            DasMouseInputAdapter mouseAdapter = lparent.mouseAdapter;
            DasPlot p = lparent;
            mouseAdapter.addMouseModule(new MouseModule(p, new LengthDragRenderer(p, p.getXAxis(), p.getYAxis()), "Length"));
            CrossHairMouseModule ch = new CrossHairMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
            mouseAdapter.addMouseModule(ch);
        }
        this.updatePsym();
    }

    protected void uninstallRenderer() {
    }

    public Element getDOMElement(Document document) {
        return null;
    }

    public Icon getListIcon() {
        BufferedImage i = new BufferedImage(15, 10, 2);
        Graphics2D g = (Graphics2D)((Image)i).getGraphics();
        this.drawListIcon(g, 0, 0);
        return new ImageIcon(i);
    }

    public void drawListIcon(Graphics2D g1, int x, int y) {
        Graphics2D g = (Graphics2D)g1.create(x, y, 16, 16);
        g.setRenderingHints(DasProperties.getRenderingHints());
        DasPlot lparent = this.parent;
        if (lparent != null) {
            g.setBackground(lparent.getBackground());
        }
        if (this.color.equals(Color.white)) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(new Color(0, 0, 0, 0));
        }
        g.fillRect(0, 0, 15, 10);
        if (this.fillToReference) {
            g.setColor(this.fillColor);
            Polygon p = new Polygon(new int[]{2, 13, 13, 2}, new int[]{3, 7, 10, 10}, 4);
            g.fillPolygon(p);
        }
        g.setColor(this.color);
        Stroke stroke0 = g.getStroke();
        this.getPsymConnector().drawLine(g, 2.0, 3.0, 13.0, 7.0, 1.5f);
        g.setStroke(stroke0);
        this.psym.draw(g, 7.0, 5.0, 3.0f, this.fillStyle);
    }

    public String getListLabel() {
        return String.valueOf(this.getDataSetDescriptor());
    }

    private void refreshRender() {
        DasPlot lparent = this.parent;
        if (lparent != null) {
            lparent.invalidateCacheImage();
            lparent.repaint();
        }
    }

    public PsymConnector getPsymConnector() {
        return this.psymConnector;
    }

    public void setPsymConnector(PsymConnector p) {
        PsymConnector old = this.psymConnector;
        if (!p.equals(this.psymConnector)) {
            this.psymConnector = p;
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("psymConnector", old, p);
        }
    }

    public PlotSymbol getPsym() {
        return this.psym;
    }

    public void setPsym(PlotSymbol psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        if (psym != this.psym) {
            DefaultPlotSymbol oldValue = this.psym;
            this.psym = (DefaultPlotSymbol)psym;
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("psym", oldValue, psym);
        }
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double symSize) {
        double old = this.symSize;
        if (this.symSize != symSize) {
            this.symSize = symSize;
            this.setPsym(this.psym);
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("symSize", new Double(old), new Double(symSize));
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("null color");
        }
        Color old = this.color;
        if (!this.color.equals(color)) {
            this.color = color;
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("color", old, color);
        }
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double f) {
        double old = this.lineWidth;
        if (this.lineWidth != f) {
            this.lineWidth = f;
            this.updatePsym();
            this.refreshRender();
            this.propertyChangeSupport.firePropertyChange("lineWidth", new Double(old), new Double(f));
        }
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean old = this.antiAliased;
        this.antiAliased = antiAliased;
        this.updatePsym();
        this.refreshImage();
        this.propertyChangeSupport.firePropertyChange("antiAliased", old, antiAliased);
    }

    public boolean isHistogram() {
        return this.histogram;
    }

    public void setHistogram(boolean b) {
        boolean old = b;
        if (b != this.histogram) {
            this.histogram = b;
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("histogram", old, this.antiAliased);
        }
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color color) {
        Color old = this.fillColor;
        if (!this.fillColor.equals(color)) {
            this.fillColor = color;
            this.update();
            this.propertyChangeSupport.firePropertyChange("fillColor", old, color);
        }
    }

    public String getColorByDataSetId() {
        return this.colorByDataSetId;
    }

    public void setColorByDataSetId(String colorByDataSetId) {
        String oldVal = this.colorByDataSetId;
        this.colorByDataSetId = colorByDataSetId;
        this.update();
        this.propertyChangeSupport.firePropertyChange("colorByDataSetId", oldVal, colorByDataSetId);
    }

    public DasColorBar getColorBar() {
        return this.colorBar;
    }

    public void setColorBar(DasColorBar cb) {
        if (this.colorBar == cb) {
            return;
        }
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener(this.colorBarListener);
        }
        this.colorBar = cb;
        if (this.colorBar != null) {
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().add(this.colorBar);
            }
            this.colorBar.addPropertyChangeListener(this.colorBarListener);
        }
        this.refreshImage();
        this.updatePsym();
    }

    public boolean isFillToReference() {
        return this.fillToReference;
    }

    public void setFillToReference(boolean fillToReference) {
        boolean old = this.fillToReference;
        if (this.fillToReference != fillToReference) {
            this.fillToReference = fillToReference;
            this.update();
            this.propertyChangeSupport.firePropertyChange("fillToReference", old, fillToReference);
        }
    }

    public Datum getReference() {
        return this.reference;
    }

    public void setReference(Datum reference) {
        Datum old = this.reference;
        if (!this.reference.equals(reference)) {
            this.reference = reference;
            this.refreshImage();
            this.propertyChangeSupport.firePropertyChange("reference", old, reference);
        }
    }

    public boolean isResetDebugCounters() {
        return this.resetDebugCounters;
    }

    public void setResetDebugCounters(boolean resetDebugCounters) {
        if (resetDebugCounters) {
            this.renderCount = 0;
            this.updateImageCount = 0;
            this.update();
        }
    }

    public boolean isSimplifyPaths() {
        return this.simplifyPaths;
    }

    public void setSimplifyPaths(boolean simplifyPaths) {
        this.simplifyPaths = simplifyPaths;
        this.refreshImage();
    }

    public boolean isStampPsyms() {
        return this.stampPsyms;
    }

    public void setStampPsyms(boolean newstampPsyms) {
        boolean oldstampPsyms = this.stampPsyms;
        this.stampPsyms = newstampPsyms;
        this.propertyChangeSupport.firePropertyChange(PROP_STAMPPSYMS, oldstampPsyms, newstampPsyms);
        this.refreshImage();
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setFillStyle(FillStyle fillStyle) {
        this.fillStyle = fillStyle;
        this.updatePsym();
        this.refreshImage();
    }

    public Shape selectionArea() {
        return this.selectionArea;
    }

    public boolean acceptContext(int x, int y) {
        boolean accept = false;
        Point2D.Double dp = new Point2D.Double(x, y);
        if (this.fillToReference && this.fillElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.psymConnectorElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.extraConnectorElements != null) {
            for (int j = 0; j < this.extraConnectorElements.length; ++j) {
                if (accept || this.extraConnectorElements[j] == null || !this.extraConnectorElements[j].acceptContext(dp)) continue;
                accept = true;
            }
        }
        if (!accept && this.psymsElement.acceptContext(dp)) {
            accept = true;
        }
        if (!accept && this.errorElement.acceptContext(dp)) {
            accept = true;
        }
        return accept;
    }

    public int getDataSetSizeLimit() {
        return this.dataSetSizeLimit;
    }

    public void setDataSetSizeLimit(int dataSetSizeLimit) {
        int oldDataSetSizeLimit = this.dataSetSizeLimit;
        this.dataSetSizeLimit = dataSetSizeLimit;
        this.refreshImage();
        this.propertyChangeSupport.firePropertyChange("dataSetSizeLimit", oldDataSetSizeLimit, dataSetSizeLimit);
    }

    public double getUpdatesPointsPerMillisecond() {
        return this.updatesPointsPerMillisecond;
    }

    public void setUpdatesPointsPerMillisecond(double newupdatesPointsPerMillisecond) {
        this.updatesPointsPerMillisecond = newupdatesPointsPerMillisecond;
    }

    public double getRenderPointsPerMillisecond() {
        return this.renderPointsPerMillisecond;
    }

    public void setRenderPointsPerMillisecond(double newrenderPointsPerMillisecond) {
        this.renderPointsPerMillisecond = newrenderPointsPerMillisecond;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public boolean isCadenceCheck() {
        return this.cadenceCheck;
    }

    public void setCadenceCheck(boolean cadenceCheck) {
        boolean oldCadenceCheck = this.cadenceCheck;
        this.cadenceCheck = cadenceCheck;
        this.refreshImage();
        this.propertyChangeSupport.firePropertyChange(PROP_CADENCECHECK, oldCadenceCheck, cadenceCheck);
    }

    public boolean acceptsDataSet(QDataSet dataSet) {
        QDataSet ds1 = dataSet;
        boolean plottable = false;
        if (!SemanticOps.isTableDataSet((QDataSet)dataSet)) {
            if (!(ds1.rank() == 2 && SemanticOps.isBundle((QDataSet)ds1) || ds1.rank() == 1)) {
                logger.fine("dataset rank error");
                return false;
            }
            this.unitsWarning = false;
            plottable = true;
        } else {
            plottable = true;
        }
        return plottable;
    }

    class FillRenderElement
    implements RenderElement {
        private GeneralPath fillToRefPath1;

        FillRenderElement() {
        }

        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            if (this.fillToRefPath1 == null) {
                return 0;
            }
            g.setColor(SeriesRenderer.this.fillColor);
            g.fill(this.fillToRefPath1);
            return 0;
        }

        public void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            boolean logStep;
            double xSampleWidth;
            if (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex == 0) {
                this.fillToRefPath1 = null;
                return;
            }
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(SeriesRenderer.this.ds);
            Units xUnits = SemanticOps.getUnits((QDataSet)xds);
            Units yUnits = SemanticOps.getUnits((QDataSet)vds);
            if (SeriesRenderer.this.unitsWarning) {
                yUnits = yAxis.getUnits();
            }
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)vds);
            int pathLengthApprox = Math.max(5, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
            GeneralPath fillPath = new GeneralPath(1, pathLengthApprox);
            Datum sw = SemanticOps.guessXTagWidth((QDataSet)xds, (QDataSet)dataSet);
            if (sw != null) {
                if (UnitsUtil.isRatiometric((Units)sw.getUnits())) {
                    xSampleWidth = sw.doubleValue(Units.logERatio);
                    logStep = true;
                } else {
                    xSampleWidth = sw.doubleValue(xUnits.getOffsetUnits());
                    logStep = false;
                }
            } else {
                xSampleWidth = 1.0E37;
                logStep = false;
            }
            xSampleWidth *= 1.2;
            if (SeriesRenderer.this.reference != null && SeriesRenderer.this.reference.getUnits() != yAxis.getUnits()) {
                SeriesRenderer.this.reference = yAxis.getUnits().createDatum(SeriesRenderer.this.reference.doubleValue(SeriesRenderer.this.reference.getUnits()));
            }
            if (SeriesRenderer.this.reference == null) {
                SeriesRenderer.this.reference = yUnits.createDatum(yAxis.isLog() ? 1.0 : 0.0);
            }
            double yref = SeriesRenderer.this.reference.doubleValue(yUnits);
            double x = Double.NaN;
            double y = Double.NaN;
            double x0 = Double.NaN;
            double y0 = Double.NaN;
            float fyref = (float)yAxis.transform(yref, yUnits);
            float fx = Float.NaN;
            float fy = Float.NaN;
            float fx0 = Float.NaN;
            float fy0 = Float.NaN;
            int index = SeriesRenderer.this.firstIndex;
            x = xds.value(index);
            y = vds.value(index);
            fx = (float)xAxis.transform(x, xUnits);
            fy = (float)yAxis.transform(y, yUnits);
            if (SeriesRenderer.this.histogram) {
                float fx1 = SeriesRenderer.this.midPoint(xAxis, x, xUnits, xSampleWidth, logStep, -0.5);
                fillPath.moveTo(fx1, fyref);
                fillPath.lineTo(fx1, fy);
                fillPath.lineTo(fx, fy);
            } else {
                fillPath.moveTo(fx, fyref);
                fillPath.lineTo(fx, fy);
            }
            x0 = x;
            y0 = y;
            fx0 = fx;
            fy0 = fy;
            if (SeriesRenderer.this.psymConnector != PsymConnector.NONE || SeriesRenderer.this.fillToReference) {
                boolean ignoreCadence;
                boolean bl = ignoreCadence = !SeriesRenderer.this.cadenceCheck;
                while (index < SeriesRenderer.this.lastIndex) {
                    x = xds.value(index);
                    y = vds.value(index);
                    boolean isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
                    fx = (float)xAxis.transform(x, xUnits);
                    fy = (float)yAxis.transform(y, yUnits);
                    if (isValid) {
                        float fx1;
                        double step;
                        double d = step = logStep ? Math.log(x / x0) : x - x0;
                        if (ignoreCadence || step < xSampleWidth) {
                            if (SeriesRenderer.this.histogram) {
                                fx1 = (fx0 + fx) / 2.0f;
                                fillPath.lineTo(fx1, fy0);
                                fillPath.lineTo(fx1, fy);
                                fillPath.lineTo(fx, fy);
                            } else {
                                fillPath.lineTo(fx, fy);
                            }
                        } else if (SeriesRenderer.this.histogram) {
                            fx1 = SeriesRenderer.this.midPoint(xAxis, x0, xUnits, xSampleWidth, logStep, 0.5);
                            fillPath.lineTo(fx1, fy0);
                            fillPath.lineTo(fx1, fyref);
                            fx1 = SeriesRenderer.this.midPoint(xAxis, x, xUnits, xSampleWidth, logStep, -0.5);
                            fillPath.moveTo(fx1, fyref);
                            fillPath.lineTo(fx1, fy);
                            fillPath.lineTo(fx, fy);
                        } else {
                            fillPath.lineTo(fx0, fyref);
                            fillPath.moveTo(fx, fyref);
                            fillPath.lineTo(fx, fy);
                        }
                        x0 = x;
                        y0 = y;
                        fx0 = fx;
                        fy0 = fy;
                    }
                    ++index;
                }
            }
            fillPath.lineTo(fx0, fyref);
            this.fillToRefPath1 = fillPath;
            if (SeriesRenderer.this.simplifyPaths) {
                GeneralPath newPath = new GeneralPath(1, pathLengthApprox);
                int count = GraphUtil.reducePath(this.fillToRefPath1.getPathIterator(null), newPath);
                this.fillToRefPath1 = newPath;
                Renderer.logger.fine(String.format("reduce path(fill) in=%d  out=%d\n", SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex, count));
            }
        }

        public boolean acceptContext(Point2D.Double dp) {
            return this.fillToRefPath1 != null && this.fillToRefPath1.contains(dp);
        }
    }

    class PsymConnectorRenderElement
    implements RenderElement {
        private GeneralPath path1;
        private Color color;

        PsymConnectorRenderElement() {
        }

        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            if (vds.rank() != 1 && !SemanticOps.isBundle((QDataSet)vds)) {
                SeriesRenderer.this.renderException(g, xAxis, yAxis, new IllegalArgumentException("dataset is not rank 1"));
            }
            if (this.path1 == null) {
                return 0;
            }
            if (this.color != null) {
                g.setColor(this.color);
            }
            SeriesRenderer.this.psymConnector.draw(g, this.path1, (float)SeriesRenderer.this.lineWidth);
            return 0;
        }

        public synchronized void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            boolean ignoreCadence;
            boolean visible0;
            boolean logStep;
            double xSampleWidth;
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(dataSet);
            if (vds.rank() > 1) {
                return;
            }
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)vds);
            Units xUnits = SemanticOps.getUnits((QDataSet)xds);
            Units yUnits = SemanticOps.getUnits((QDataSet)vds);
            if (SeriesRenderer.this.unitsWarning) {
                yUnits = yAxis.getUnits();
            }
            Rectangle window = DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn());
            int buffer = (int)Math.ceil(Math.max(SeriesRenderer.this.getLineWidth(), 10.0));
            DasPlot lparent = SeriesRenderer.this.parent;
            if (lparent == null) {
                return;
            }
            window = lparent.isOverSize() ? new Rectangle(window.x - window.width / 3, window.y - buffer, 5 * window.width / 3, window.height + 2 * buffer) : new Rectangle(window.x - buffer, window.y - buffer, window.width + 2 * buffer, window.height + 2 * buffer);
            if (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex == 0) {
                this.path1 = null;
                return;
            }
            int pathLengthApprox = Math.max(5, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
            GeneralPath newPath = new GeneralPath(1, pathLengthApprox);
            Datum sw = SemanticOps.guessXTagWidth((QDataSet)xds, (QDataSet)vds);
            if (sw != null) {
                if (UnitsUtil.isRatiometric((Units)sw.getUnits())) {
                    xSampleWidth = sw.doubleValue(Units.logERatio);
                    logStep = true;
                } else {
                    xSampleWidth = sw.doubleValue(xUnits.getOffsetUnits());
                    logStep = false;
                }
            } else {
                xSampleWidth = 1.0E37;
                logStep = false;
            }
            xSampleWidth *= 1.2;
            double x = Double.NaN;
            double y = Double.NaN;
            double x0 = Double.NaN;
            double y0 = Double.NaN;
            float fx = Float.NaN;
            float fy = Float.NaN;
            float fx0 = Float.NaN;
            float fy0 = Float.NaN;
            int index = SeriesRenderer.this.firstIndex;
            x = xds.value(index);
            y = vds.value(index);
            Renderer.logger.log(Level.FINE, "firstPoint moveTo,LineTo= {0},{1}", new Object[]{x, y});
            fx = (float)xAxis.transform(x, xUnits);
            fy = (float)yAxis.transform(y, yUnits);
            boolean visible = visible0 = window.contains(fx, fy);
            if (SeriesRenderer.this.histogram) {
                float fx1 = SeriesRenderer.this.midPoint(xAxis, x, xUnits, xSampleWidth, logStep, -0.5);
                newPath.moveTo(fx1, fy);
                newPath.lineTo(fx, fy);
            } else {
                newPath.moveTo(fx, fy);
                newPath.lineTo(fx, fy);
            }
            x0 = x;
            y0 = y;
            fx0 = fx;
            fy0 = fy;
            ++index;
            boolean bl = ignoreCadence = !SeriesRenderer.this.cadenceCheck;
            while (index < SeriesRenderer.this.lastIndex) {
                x = xds.value(index);
                y = vds.value(index);
                boolean isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
                fx = (float)xAxis.transform(x, xUnits);
                fy = (float)yAxis.transform(y, yUnits);
                boolean bl2 = visible = isValid && window.intersectsLine(fx0, fy0, fx, fy);
                if (isValid) {
                    float fx1;
                    double step;
                    double d = step = logStep ? Math.log(x / x0) : x - x0;
                    if (ignoreCadence || step < xSampleWidth) {
                        if (SeriesRenderer.this.histogram) {
                            fx1 = (fx0 + fx) / 2.0f;
                            newPath.lineTo(fx1, fy0);
                            newPath.lineTo(fx1, fy);
                            newPath.lineTo(fx, fy);
                        } else if (visible) {
                            if (!visible0) {
                                newPath.moveTo(fx0, fy0);
                            }
                            newPath.lineTo(fx, fy);
                        }
                    } else if (SeriesRenderer.this.histogram) {
                        fx1 = (float)xAxis.transform(x0 + xSampleWidth / 2.0, xUnits);
                        newPath.lineTo(fx1, fy0);
                        fx1 = (float)xAxis.transform(x - xSampleWidth / 2.0, xUnits);
                        newPath.moveTo(fx1, fy);
                        newPath.lineTo(fx, fy);
                    } else if (visible) {
                        newPath.moveTo(fx, fy);
                        newPath.lineTo(fx, fy);
                    }
                    x0 = x;
                    y0 = y;
                    fx0 = fx;
                    fy0 = fy;
                    visible0 = visible;
                } else if (visible0) {
                    newPath.moveTo(fx0, fy0);
                }
                ++index;
            }
            if (!SeriesRenderer.this.histogram && SeriesRenderer.this.simplifyPaths && SeriesRenderer.this.colorByDataSetId.length() == 0) {
                this.path1 = new GeneralPath(1, pathLengthApprox);
                int count = GraphUtil.reducePath(newPath.getPathIterator(null), this.path1);
                Renderer.logger.fine(String.format("reduce path in=%d  out=%d\n", SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex, count));
            } else {
                this.path1 = newPath;
            }
        }

        public boolean acceptContext(Point2D.Double dp) {
            if (this.path1 == null) {
                return false;
            }
            Rectangle2D.Double hitbox = new Rectangle2D.Double(dp.x - 5.0, dp.y - 5.0, 10.0, 10.0);
            double[] coords = new double[6];
            PathIterator it = this.path1.getPathIterator(null);
            it.currentSegment(coords);
            double x1 = coords[0];
            double y1 = coords[1];
            it.next();
            while (!it.isDone()) {
                int segType = it.currentSegment(coords);
                if (segType == 1 && hitbox.intersectsLine(x1, y1, coords[0], coords[1])) {
                    return true;
                }
                x1 = coords[0];
                y1 = coords[1];
                it.next();
            }
            return false;
        }
    }

    class ErrorBarRenderElement
    implements RenderElement {
        GeneralPath p;

        ErrorBarRenderElement() {
        }

        public int render(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            if (this.p == null) {
                return 0;
            }
            g.draw(this.p);
            return SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex;
        }

        public synchronized void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            QDataSet vds = SeriesRenderer.this.ytagsDataSet(dataSet);
            QDataSet deltaPlusY = (QDataSet)vds.property("DELTA_PLUS");
            QDataSet deltaMinusY = (QDataSet)vds.property("DELTA_MINUS");
            this.p = null;
            if (deltaMinusY == null) {
                return;
            }
            if (deltaMinusY == null) {
                return;
            }
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
            Units xunits = SemanticOps.getUnits((QDataSet)xds);
            Units yunits = SemanticOps.getUnits((QDataSet)vds);
            if (SeriesRenderer.this.unitsWarning) {
                yunits = yAxis.getUnits();
            }
            Units yoffsetUnits = yunits.getOffsetUnits();
            this.p = new GeneralPath();
            for (int i = SeriesRenderer.this.firstIndex; i < SeriesRenderer.this.lastIndex; ++i) {
                float ix = (float)xAxis.transform(xds.value(i), xunits);
                double dp = deltaPlusY.value(i);
                double dm = deltaMinusY.value(i);
                if (!yoffsetUnits.isValid(dp) || !yoffsetUnits.isValid(dm)) continue;
                float iym = (float)yAxis.transform(vds.value(i) - dm, yunits);
                float iyp = (float)yAxis.transform(vds.value(i) + dp, yunits);
                this.p.moveTo(ix, iym);
                this.p.lineTo(ix, iyp);
            }
        }

        public boolean acceptContext(Point2D.Double dp) {
            return this.p != null && this.p.contains(dp.x - 2.0, dp.y - 2.0, 5.0, 5.0);
        }
    }

    class PsymRenderElement
    implements RenderElement {
        protected GeneralPath psymsPath;
        int[] colors;
        double[] dpsymsPath;
        int count;

        PsymRenderElement() {
        }

        private int renderStamp(Graphics2D g, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            DasPlot lparent = SeriesRenderer.this.parent;
            if (lparent == null) {
                return 0;
            }
            QDataSet colorByDataSet = null;
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                colorByDataSet = SeriesRenderer.this.colorByDataSet(SeriesRenderer.this.ds);
            }
            if (colorByDataSet != null) {
                for (int i = 0; i < this.count; ++i) {
                    int icolor = this.colors[i];
                    g.drawImage(SeriesRenderer.this.coloredPsyms[icolor], (int)this.dpsymsPath[i * 2] - SeriesRenderer.this.cmx, (int)this.dpsymsPath[i * 2 + 1] - SeriesRenderer.this.cmy, lparent);
                }
            } else {
                try {
                    for (int i = 0; i < this.count; ++i) {
                        g.drawImage(SeriesRenderer.this.psymImage, (int)this.dpsymsPath[i * 2] - SeriesRenderer.this.cmx, (int)this.dpsymsPath[i * 2 + 1] - SeriesRenderer.this.cmy, lparent);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
            }
            return this.count;
        }

        private int renderDraw(Graphics2D graphics, DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            float fsymSize = (float)SeriesRenderer.this.symSize;
            QDataSet colorByDataSet = null;
            if (SeriesRenderer.this.colorByDataSetId != null && !SeriesRenderer.this.colorByDataSetId.equals("")) {
                colorByDataSet = SeriesRenderer.this.colorByDataSet(SeriesRenderer.this.ds);
                if (colorByDataSet != null) {
                    if (colorByDataSet.length() != dataSet.length()) {
                        throw new IllegalArgumentException("colorByDataSet and dataSet do not have same length");
                    }
                } else {
                    System.err.println("why is colorByDataSetId set?");
                }
            }
            graphics.setStroke(new BasicStroke((float)SeriesRenderer.this.lineWidth));
            Color[] ccolors = null;
            if (colorByDataSet != null) {
                IndexColorModel icm = SeriesRenderer.this.colorBar.getIndexColorModel();
                ccolors = new Color[icm.getMapSize()];
                for (int j = 0; j < icm.getMapSize(); ++j) {
                    ccolors[j] = new Color(icm.getRGB(j));
                }
            }
            if (colorByDataSet != null) {
                for (int i = 0; i < this.count; ++i) {
                    graphics.setColor(ccolors[this.colors[i]]);
                    SeriesRenderer.this.psym.draw(graphics, this.dpsymsPath[i * 2], this.dpsymsPath[i * 2 + 1], fsymSize, SeriesRenderer.this.fillStyle);
                }
            } else {
                for (int i = 0; i < this.count; ++i) {
                    try {
                        SeriesRenderer.this.psym.draw(graphics, this.dpsymsPath[i * 2], this.dpsymsPath[i * 2 + 1], fsymSize, SeriesRenderer.this.fillStyle);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return this.count;
        }

        public synchronized int render(Graphics2D graphics, DasAxis xAxis, DasAxis yAxis, QDataSet vds, ProgressMonitor mon) {
            DasPlot lparent;
            if (vds.rank() != 1 && !SemanticOps.isBundle((QDataSet)vds)) {
                SeriesRenderer.this.renderException(graphics, xAxis, yAxis, new IllegalArgumentException("dataset is not rank 1"));
            }
            if ((lparent = SeriesRenderer.this.parent) == null) {
                return 0;
            }
            int i = SeriesRenderer.this.stampPsyms && !lparent.getCanvas().isPrintingThread() ? this.renderStamp(graphics, xAxis, yAxis, vds, mon) : this.renderDraw(graphics, xAxis, yAxis, vds, mon);
            return i;
        }

        public synchronized void update(DasAxis xAxis, DasAxis yAxis, QDataSet dataSet, ProgressMonitor mon) {
            double dx;
            double y;
            double x;
            QDataSet colorByDataSet1 = SeriesRenderer.this.colorByDataSet(dataSet);
            Units cunits = null;
            if (colorByDataSet1 != null) {
                cunits = SemanticOps.getUnits((QDataSet)colorByDataSet1);
            }
            int pathLengthApprox = Math.max(5, 110 * (SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) / 100);
            this.psymsPath = new GeneralPath(1, pathLengthApprox);
            this.count = 0;
            this.dpsymsPath = new double[(SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex) * 2];
            this.colors = new int[SeriesRenderer.this.lastIndex - SeriesRenderer.this.firstIndex + 2];
            int index = SeriesRenderer.this.firstIndex;
            Object tds = null;
            QDataSet vds = null;
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)dataSet);
            vds = SeriesRenderer.this.ytagsDataSet(dataSet);
            Units xUnits = SemanticOps.getUnits((QDataSet)xds);
            Units yUnits = SemanticOps.getUnits((QDataSet)vds);
            if (SeriesRenderer.this.unitsWarning) {
                yUnits = yAxis.getUnits();
            }
            if (index < SeriesRenderer.this.lastIndex) {
                x = xds.value(index);
                y = vds.value(index);
                dx = xAxis.transform(x, xUnits);
                double d = yAxis.transform(y, yUnits);
            }
            double dx0 = -99.0;
            double dy0 = -99.0;
            QDataSet wds = SemanticOps.weightsDataSet((QDataSet)vds);
            int buffer = (int)Math.ceil(Math.max(20.0, SeriesRenderer.this.getSymSize()));
            Rectangle window = DasDevicePosition.toRectangle(yAxis.getRow(), xAxis.getColumn());
            window = new Rectangle(window.x - buffer, window.y - buffer, window.width + 2 * buffer, window.height + 2 * buffer);
            DasPlot lparent = SeriesRenderer.this.parent;
            if (lparent == null) {
                return;
            }
            window = lparent.isOverSize() ? new Rectangle(window.x - window.width / 3, window.y - buffer, 5 * window.width / 3, window.height + 2 * buffer) : new Rectangle(window.x - buffer, window.y - buffer, window.width + 2 * buffer, window.height + 2 * buffer);
            int i = 0;
            while (index < SeriesRenderer.this.lastIndex) {
                block10: {
                    double dy;
                    block9: {
                        x = xds.value(index);
                        y = vds.value(index);
                        boolean isValid = wds.value(index) > 0.0 && xUnits.isValid(x);
                        dx = xAxis.transform(x, xUnits);
                        dy = yAxis.transform(y, yUnits);
                        if (!isValid || !window.contains(dx, dy)) break block9;
                        if (SeriesRenderer.this.simplifyPaths && dx == dx0 && dy == dy0) break block10;
                        this.dpsymsPath[i * 2] = dx;
                        this.dpsymsPath[i * 2 + 1] = dy;
                        if (colorByDataSet1 != null) {
                            this.colors[i] = SeriesRenderer.this.colorBar.indexColorTransform(colorByDataSet1.value(index), cunits);
                        }
                        ++i;
                    }
                    dx0 = dx;
                    dy0 = dy;
                }
                ++index;
            }
            this.count = i;
        }

        public boolean acceptContext(Point2D.Double dp) {
            if (this.dpsymsPath == null) {
                return false;
            }
            double rad = Math.max(SeriesRenderer.this.symSize, 5.0);
            for (int index = SeriesRenderer.this.firstIndex; index < SeriesRenderer.this.lastIndex; ++index) {
                int i = index - SeriesRenderer.this.firstIndex;
                if (!(dp.distance(this.dpsymsPath[i * 2], this.dpsymsPath[i * 2 + 1]) < rad)) continue;
                return true;
            }
            return false;
        }
    }

    static interface RenderElement {
        public int render(Graphics2D var1, DasAxis var2, DasAxis var3, QDataSet var4, ProgressMonitor var5);

        public void update(DasAxis var1, DasAxis var2, QDataSet var3, ProgressMonitor var4);

        public boolean acceptContext(Point2D.Double var1);
    }
}

