/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.DasException;
import org.das2.components.HorizontalSpectrogramSlicer;
import org.das2.components.VerticalSpectrogramSlicer;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetRebinner;
import org.das2.dataset.RebinDescriptor;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.CrossHairMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.HorizontalSlicerMouseModule;
import org.das2.event.LengthDragRenderer;
import org.das2.event.MouseModule;
import org.das2.event.VerticalSlicerMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasLabelAxis;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.RowRowConnector;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;

public class StackedHistogramRenderer
extends Renderer
implements TableDataSetConsumer,
PropertyChangeListener,
Displayable {
    private DasLabelAxis yAxis = null;
    private DasAxis zAxis = null;
    private RowRowConnector zAxisConnector = null;
    private DasRow littleRow = null;
    private RebinDescriptor xBins = null;
    private PeaksIndicator peaksIndicator;
    private boolean sliceRebinnedData;
    Image plotImage;
    DatumRange imageXRange;
    DatumRange imageYRange;
    static final Color GREY_PEAKS_COLOR = Color.lightGray.brighter();
    RebinListener rebinListener = new RebinListener();

    public StackedHistogramRenderer(DasPlot parent, DataSetDescriptor dsd, DasAxis zAxis, DasLabelAxis yAxis) {
        this.yAxis = yAxis;
        this.zAxis = zAxis;
        zAxis.addPropertyChangeListener(this.rebinListener);
        this.setDataSetDescriptor(dsd);
    }

    public void render(Graphics g, DasAxis xAxis, DasAxis yAxis, ProgressMonitor mon) {
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.getDataSet() == null && this.lastException != null) {
            this.renderException(g2, xAxis, yAxis, this.lastException);
        } else if (this.plotImage != null) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            Point2D.Float p = new Point2D.Float(xAxis.getColumn().getDMinimum(), yAxis.getRow().getDMinimum());
            g2.drawImage(this.plotImage, (int)(((Point2D)p).getX() + 0.5), (int)(((Point2D)p).getY() + 0.5), this.getParent());
        }
        g2.dispose();
    }

    protected void installRenderer() {
        DasCanvas canvas = this.parent.getCanvas();
        this.littleRow = new DasRow(canvas, 0.5, 0.6);
        this.zAxisConnector = new RowRowConnector(canvas, this.littleRow, this.zAxis.getRow(), this.parent.getColumn(), this.zAxis.getColumn());
        this.zAxisConnector.setVisible(false);
        canvas.add(this.zAxisConnector);
        this.yAxis.setFloppyItemSpacing(true);
        this.yAxis.setOutsidePadding(1);
        this.peaksIndicator = PeaksIndicator.MaxLines;
        DasMouseInputAdapter mouseAdapter = this.parent.getDasMouseInputAdapter();
        VerticalSpectrogramSlicer vSlicer = VerticalSpectrogramSlicer.createSlicer(this.parent, this);
        VerticalSlicerMouseModule vsl = VerticalSlicerMouseModule.create(this);
        vsl.addDataPointSelectionListener(vSlicer);
        mouseAdapter.addMouseModule(vsl);
        HorizontalSpectrogramSlicer hSlicer = HorizontalSpectrogramSlicer.createSlicer(this.parent, this);
        HorizontalSlicerMouseModule hsl = HorizontalSlicerMouseModule.create(this);
        hsl.addDataPointSelectionListener(hSlicer);
        mouseAdapter.addMouseModule(hsl);
        CrossHairMouseModule ch = new CrossHairMouseModule(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
        mouseAdapter.addMouseModule(ch);
        DasPlot p = this.parent;
        mouseAdapter.addMouseModule(new MouseModule(p, new LengthDragRenderer(p, p.getXAxis(), p.getYAxis()), "Length"));
    }

    protected void uninstallRenderer() {
    }

    public void setZAxis(DasAxis zAxis) {
        this.zAxis = zAxis;
        throw new IllegalStateException("not supported");
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public void setYAxis(DasAxis yAxis) {
        if (!(yAxis instanceof DasLabelAxis)) {
            throw new IllegalArgumentException("You can't call setYAxis for stackedHistogramPlot");
        }
        this.yAxis = (DasLabelAxis)yAxis;
        yAxis.addPropertyChangeListener(this);
    }

    public synchronized void updatePlotImage(DasAxis xAxis, DasAxis yAxis_1, ProgressMonitor monitor) throws DasException {
        super.updatePlotImage(xAxis, yAxis_1, monitor);
        Color BAR_COLOR = Color.BLACK;
        DasPlot parent1 = this.getParent();
        Cursor cursor0 = parent1.getCursor();
        parent1.setCursor(new Cursor(3));
        DasColumn column = xAxis.getColumn();
        DasRow row = this.yAxis.getRow();
        int w = column.getWidth();
        int h = row.getHeight();
        if (w == 0) {
            return;
        }
        BufferedImage plotImage1 = new BufferedImage(w, h, 1);
        Graphics2D g = plotImage1.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, plotImage1.getWidth(), plotImage1.getHeight());
        g.translate(-column.getDMinimum(), -row.getDMinimum());
        RebinDescriptor xbins = new RebinDescriptor(xAxis.getDataMinimum(), xAxis.getDataMaximum(), Math.abs(column.getWidth()) / 1 + 1, xAxis.isLog());
        this.imageXRange = xAxis.getDatumRange();
        this.imageYRange = this.yAxis.getDatumRange();
        int xDMax = column.getDMaximum();
        int xDMin = column.getDMinimum();
        QDataSet xtysData = this.getDataSet();
        if (xtysData == null) {
            this.plotImage = null;
            if (this.lastException == null) {
                this.setLastException(new DasException("null data set"));
            }
            return;
        }
        if (xtysData.length() == 0) {
            this.setLastException(new DasException("empty data set"));
            return;
        }
        Rebinner rebinner = new Rebinner();
        QDataSet data = rebinner.rebin(xtysData, xbins, null);
        QDataSet peaks = SemanticOps.getPlanarView((QDataSet)data, (String)"peaks");
        QDataSet weights = SemanticOps.weightsDataSet((QDataSet)data);
        DasLabelAxis yAxis1 = (DasLabelAxis)yAxis_1;
        int zmid = this.zAxis.getRow().getDMiddle();
        boolean haveLittleRow = false;
        QDataSet yds = SemanticOps.ytagsDataSet((QDataSet)data);
        Units yunits = SemanticOps.getUnits((QDataSet)yds);
        Units zunits = SemanticOps.getUnits((QDataSet)data);
        for (int j = 0; j < data.length(0); ++j) {
            int yBase;
            if (j == data.length(0) - 1) {
                yBase = yAxis1.getItemMin(yunits.createDatum(yds.value(j)));
                g.setColor(GREY_PEAKS_COLOR);
                g.drawLine(xDMin, yBase, xDMax, yBase);
                g.setColor(BAR_COLOR);
            }
            yBase = yAxis1.getItemMax(yunits.createDatum(yds.value(j)));
            g.setColor(Color.lightGray);
            g.drawLine(xDMin, yBase, xDMax, yBase);
            g.setColor(BAR_COLOR);
            int yBase1 = yAxis1.getItemMin(yunits.createDatum(yds.value(j)));
            double canvasHeight = ((Component)parent1).getHeight();
            if (!haveLittleRow && yBase1 <= zmid) {
                this.littleRow.setDPosition(yBase1, yBase);
                haveLittleRow = true;
                this.zAxisConnector.setVisible(true);
                this.zAxisConnector.repaint();
            }
            double[] binStarts = xbins.binStarts();
            int y0 = yBase;
            int littleRowHeight = yBase - yBase1;
            double zAxisMax = this.zAxis.getDataMaximum().doubleValue(zunits);
            double zAxisMin = this.zAxis.getDataMinimum().doubleValue(zunits);
            if (yBase1 < row.getDMinimum() || yBase > row.getDMaximum()) continue;
            for (int ibin = 0; ibin < data.length(); ++ibin) {
                double peakValue;
                int yHeight;
                int x0 = (int)xAxis.transform(binStarts[ibin], xbins.getUnits());
                double zz = data.value(ibin, j);
                if (weights.value(ibin, j) == 0.0) continue;
                int yAvg = (int)this.zAxis.transform(zz, zunits, yBase, yBase1);
                yAvg = yAvg > y0 - littleRowHeight ? yAvg : y0 - littleRowHeight;
                int n = yHeight = y0 - yAvg > 0 ? y0 - yAvg : 0;
                if (peaks != null && (peakValue = peaks.value(ibin, j)) <= zAxisMax) {
                    int yMax = (int)this.zAxis.transform(peakValue, zunits, yBase, yBase1);
                    int n2 = yMax = y0 - yMax > 0 ? yMax : y0;
                    if (this.peaksIndicator == PeaksIndicator.MaxLines) {
                        g.drawLine(x0, yMax, x0, yMax);
                    } else if (this.peaksIndicator == PeaksIndicator.GrayPeaks) {
                        g.setColor(Color.lightGray.brighter());
                        g.drawLine(x0, yMax, x0, y0);
                        g.setColor(BAR_COLOR);
                    } else if (this.peaksIndicator == PeaksIndicator.BlackPeaks) {
                        g.setColor(BAR_COLOR);
                        g.drawLine(x0, yMax, x0, y0);
                    }
                }
                if (!(zz >= zAxisMin)) continue;
                g.drawLine(x0, yAvg, x0, yAvg + yHeight);
            }
        }
        g.dispose();
        this.plotImage = plotImage1;
        parent1.setCursor(cursor0);
        this.getParent().repaint();
        if (this.sliceRebinnedData) {
            this.ds = data;
        }
    }

    public DasAxis getZAxis() {
        return this.zAxis;
    }

    public void setZTitle(String title) {
        this.getZAxis().setLabel(title);
    }

    public PeaksIndicator getPeaksIndicator() {
        return this.peaksIndicator;
    }

    public void setPeaksIndicator(PeaksIndicator peaksIndicator) {
        this.peaksIndicator = peaksIndicator;
        this.refreshImage();
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean sliceRebinnedData) {
        this.sliceRebinnedData = sliceRebinnedData;
    }

    public String getListLabel() {
        return "stacked histogram";
    }

    public Icon getListIcon() {
        return null;
    }

    public class Rebinner
    implements DataSetRebinner {
        Rebinner() {
        }

        public QDataSet rebin(QDataSet ds, RebinDescriptor x, RebinDescriptor y) throws IllegalArgumentException, DasException {
            throw new RuntimeException("Not supported, since the introduction of QDataSet into das2.");
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            StackedHistogramRenderer.this.update();
        }
    }

    public static class PeaksIndicator
    implements Enumeration,
    Displayable {
        String id;
        public static final PeaksIndicator NoPeaks = new PeaksIndicator("None");
        public static final PeaksIndicator GrayPeaks = new PeaksIndicator("Gray Peaks");
        public static final PeaksIndicator BlackPeaks = new PeaksIndicator("Black Peaks");
        public static final PeaksIndicator MaxLines = new PeaksIndicator("Lines");

        PeaksIndicator(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public String getListLabel() {
            return this.id;
        }

        public Icon getListIcon() {
            return null;
        }

        public void drawListIcon(Graphics2D g, int x, int y) {
            ImageIcon i = (ImageIcon)this.getListIcon();
            g.drawImage(i.getImage(), x, y, null);
        }
    }
}

