/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.virbo.dataset.AbstractQFunction;
import org.virbo.dataset.BundleDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QFunction;
import org.virbo.dsops.Ops;

public class SimpleDemo {
    public static void main(String[] args) throws ParseException {
        int width = 500;
        int height = 400;
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        DasCanvas canvas = new DasCanvas(width, height);
        canvas.setAntiAlias(true);
        panel.add((Component)canvas, "Center");
        QDataSet yds = Ops.sin((QDataSet)Ops.linspace((double)0.0, (double)10.0, (int)1000));
        QDataSet tds = Ops.timegen((String)"2010-01-01T00:00", (String)"1 s", (int)1000);
        QDataSet ds = Ops.link((QDataSet)tds, (QDataSet)yds);
        DasAxis xaxis = GraphUtil.guessXAxis(ds);
        DasAxis yaxis = GraphUtil.guessYAxis(ds);
        DasPlot plot = new DasPlot(xaxis, yaxis);
        Renderer r = GraphUtil.guessRenderer(ds);
        plot.addRenderer(r);
        if (r instanceof SeriesRenderer) {
            ((SeriesRenderer)r).setAntiAliased(true);
        }
        xaxis.setTcaFunction((QFunction)new AbstractQFunction(){

            public QDataSet value(QDataSet parm) {
                if (parm.rank() != 1) {
                    throw new IllegalArgumentException("rank should be 1");
                }
                parm = new JoinDataSet(parm);
                QDataSet result = this.values(parm);
                return result.slice(0);
            }

            public QDataSet values(QDataSet parms) {
                BundleDataSet outbds1 = BundleDataSet.createRank1Bundle();
                DDataSet sec = DDataSet.createRank1((int)parms.length());
                sec.putProperty("LABEL", (Object)"Sec");
                DDataSet rand = DDataSet.createRank1((int)parms.length());
                rand.putProperty("LABEL", (Object)"Rand");
                rand.putProperty("FORMAT", (Object)"%5.2f");
                DDataSet rand2 = DDataSet.createRank1((int)parms.length());
                rand2.putProperty("LABEL", (Object)"Rand2");
                rand2.putProperty("FORMAT", (Object)"%5.3f");
                for (int i = 0; i < parms.length(); ++i) {
                    QDataSet parm = parms.slice(i);
                    QDataSet time = parm.slice(0);
                    sec.putValue(i, Ops.mod((QDataSet)time, (QDataSet)DataSetUtil.asDataSet((double)3600.0, (Units)Units.seconds)).value());
                    rand.putValue(i, Ops.rand((int)1).slice(0).value());
                    rand2.putValue(Ops.rand((int)1).slice(0).value());
                }
                outbds1.bundle((QDataSet)sec);
                outbds1.bundle((QDataSet)rand);
                outbds1.bundle((QDataSet)rand2);
                return outbds1;
            }

            public QDataSet exampleInput() {
                BundleDataSet inbds = BundleDataSet.createRank0Bundle();
                DRank0DataSet dd = DataSetUtil.asDataSet((double)0.0, (Units)Units.t2000);
                dd.putProperty("LABEL", (Object)"Time");
                inbds.bundle((QDataSet)dd);
                return inbds;
            }
        });
        xaxis.setDrawTca(true);
        canvas.add(plot, DasRow.create(canvas, null, "0%+2em", "100%-4em"), DasColumn.create(canvas, null, "0%+5em", "100%-7em"));
        JFrame frame = new JFrame();
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }
}

