/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.BundleDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DRank0DataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.DataSetWrapper;
import org.virbo.dataset.GridDataSet;
import org.virbo.dataset.IDataSet;
import org.virbo.dataset.LeafTrimDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.RankZeroDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.Slice0DataSet;
import org.virbo.dataset.Slice1DataSet;
import org.virbo.dataset.Slice2DataSet;
import org.virbo.dataset.Slice3DataSet;
import org.virbo.dataset.SortDataSet;
import org.virbo.dataset.TransposeRank2DataSet;
import org.virbo.dataset.TrimDataSet;
import org.virbo.dataset.TrimStrideWrapper;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dsops.Ops;
import org.virbo.dsutil.DataSetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetOps {
    public static final int DS_LENGTH_LIMIT = 10000000;

    public static MutablePropertyDataSet makePropertiesMutable(QDataSet dataset) {
        if (dataset instanceof MutablePropertyDataSet) {
            return (MutablePropertyDataSet)dataset;
        }
        return new DataSetWrapper(dataset);
    }

    public static WritableDataSet makeWritable(QDataSet dataset) {
        if (dataset instanceof WritableDataSet) {
            return (WritableDataSet)dataset;
        }
        return DDataSet.copy(dataset);
    }

    public static MutablePropertyDataSet slice0(QDataSet ds, int index) {
        return new Slice0DataSet(ds, index, true);
    }

    public static MutablePropertyDataSet slice1(QDataSet ds, int index) {
        return new Slice1DataSet(ds, index, true, false);
    }

    public static MutablePropertyDataSet slice2(QDataSet ds, int index) {
        return new Slice2DataSet(ds, index, true);
    }

    public static MutablePropertyDataSet slice3(QDataSet ds, int index) {
        return new Slice3DataSet(ds, index, true);
    }

    public static MutablePropertyDataSet trim(QDataSet ds, int offset, int len) {
        return new TrimDataSet(ds, offset, offset + len);
    }

    public static MutablePropertyDataSet trim(QDataSet dep, int start, int stop, int stride) {
        if (dep.rank() != 1) {
            throw new IllegalArgumentException("only rank 1 supported");
        }
        QubeDataSetIterator itIn = new QubeDataSetIterator(dep);
        itIn.setIndexIteratorFactory(0, new QubeDataSetIterator.StartStopStepIteratorFactory(start, stop, stride));
        DDataSet depSlice = itIn.createEmptyDs();
        QubeDataSetIterator itOut = new QubeDataSetIterator(depSlice);
        while (itIn.hasNext()) {
            itIn.next();
            itOut.next();
            itOut.putValue(depSlice, itIn.getValue(dep));
        }
        String[] names = DataSetUtil.dimensionProperties();
        for (int i = 0; i < names.length; ++i) {
            if (dep.property(names[i]) == null) continue;
            depSlice.putProperty(names[i], dep.property(names[i]));
        }
        return depSlice;
    }

    public static QDataSet flattenRank2(QDataSet ds) {
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        QDataSet dep1 = (QDataSet)ds.property("DEPEND_1");
        DataSetBuilder builder = new DataSetBuilder(1, 100);
        DataSetBuilder xbuilder = new DataSetBuilder(1, 100);
        DataSetBuilder ybuilder = new DataSetBuilder(1, 100);
        for (int i = 0; i < ds.length(); ++i) {
            for (int j = 0; j < ds.length(i); ++j) {
                if (dep0 != null) {
                    xbuilder.putValue(-1, dep0.value(i));
                    xbuilder.nextRecord();
                }
                if (dep1 != null) {
                    ybuilder.putValue(-1, dep1.value(j));
                    ybuilder.nextRecord();
                }
                builder.putValue(-1, ds.value(i, j));
                builder.nextRecord();
            }
        }
        DDataSet zds = builder.getDataSet();
        DataSetUtil.putProperties(DataSetUtil.getProperties(ds), zds);
        if (dep1 != null && dep0 != null) {
            DDataSet xds = xbuilder.getDataSet();
            DataSetUtil.putProperties(DataSetUtil.getProperties(dep0), xds);
            DDataSet yds = ybuilder.getDataSet();
            DataSetUtil.putProperties(DataSetUtil.getProperties(dep1), yds);
            return Ops.link(xds, yds, zds);
        }
        return zds;
    }

    public static QDataSet grid(QDataSet ds) {
        GridDataSet result = new GridDataSet();
        result.add(ds);
        return result;
    }

    public static int[] removeElement(int[] array, int index) {
        int[] result = new int[array.length - 1];
        System.arraycopy(array, 0, result, 0, index);
        for (int i = index + 1; i < array.length; ++i) {
            result[i - 1] = array[i];
        }
        return result;
    }

    public static MutablePropertyDataSet leafTrim(QDataSet ds, int start, int end) {
        return new LeafTrimDataSet(ds, start, end);
    }

    public static QDataSet sort(final QDataSet ds) {
        if (ds.rank() > 1) {
            throw new IllegalArgumentException("dataset must be rank 1");
        }
        Integer[] indeces = new Integer[ds.length()];
        int i0 = 0;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        for (int i = 0; i < ds.length(); ++i) {
            if (!(wds.value(i) > 0.0)) continue;
            indeces[i0] = i;
            ++i0;
        }
        Comparator<Integer> c = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                int i1 = o1;
                int i2 = o2;
                return Double.compare(ds.value(i1), ds.value(i2));
            }
        };
        Arrays.sort(indeces, 0, i0, c);
        int[] data = new int[i0];
        for (int i = 0; i < i0; ++i) {
            data[i] = indeces[i];
        }
        IDataSet result = IDataSet.wrap(data);
        result.putProperty("NAME", "sort" + ds.length());
        return result;
    }

    public static WritableDataSet applyIndex(QDataSet ds, int idim, QDataSet sort, boolean deps) {
        DDataSet cds;
        block18: {
            int[] qube;
            block19: {
                block17: {
                    String depprop;
                    QDataSet depds;
                    if (idim > 2) {
                        throw new IllegalArgumentException("idim must be <=2 ");
                    }
                    if (ds.rank() > 3) {
                        throw new IllegalArgumentException("rank limit");
                    }
                    if (idim == 0) {
                        return DDataSet.copy(new SortDataSet(ds, sort));
                    }
                    qube = DataSetUtil.qubeDims(ds);
                    if (qube == null) {
                        throw new IllegalArgumentException("dataset is not a qube and index is not on first dimension");
                    }
                    qube[idim] = sort.length();
                    cds = DDataSet.create(qube);
                    DataSetUtil.putProperties(DataSetUtil.getProperties(ds), cds);
                    if (deps && (depds = (QDataSet)ds.property(depprop = "DEPEND_" + idim)) != null) {
                        depds = DataSetOps.applyIndex(depds, 0, sort, false);
                        cds.putProperty(depprop, depds);
                    }
                    if (idim != 0) break block17;
                    for (int i = 0; i < qube[0]; ++i) {
                        if (ds.rank() > 1) {
                            for (int j = 0; j < qube[1]; ++j) {
                                if (ds.rank() > 2) {
                                    for (int k = 0; k < qube[2]; ++k) {
                                        double d = ds.value((int)sort.value(i), j, k);
                                        cds.putValue(i, j, k, d);
                                    }
                                    continue;
                                }
                                double d = ds.value((int)sort.value(i), j);
                                cds.putValue(i, j, d);
                            }
                            continue;
                        }
                        double d = ds.value((int)sort.value(i));
                        cds.putValue(i, d);
                    }
                    break block18;
                }
                if (idim != 1) break block19;
                for (int i = 0; i < qube[0]; ++i) {
                    for (int j = 0; j < qube[1]; ++j) {
                        if (ds.rank() > 2) {
                            for (int k = 0; k < qube[2]; ++k) {
                                double d = ds.value(i, (int)sort.value(j), k);
                                cds.putValue(i, j, k, d);
                            }
                            continue;
                        }
                        double d = ds.value(i, (int)sort.value(j));
                        cds.putValue(i, j, d);
                    }
                }
                break block18;
            }
            if (idim != 2) break block18;
            for (int i = 0; i < qube[0]; ++i) {
                for (int j = 0; j < qube[1]; ++j) {
                    for (int k = 0; k < qube[2]; ++k) {
                        double d = ds.value(i, j, (int)sort.value(k));
                        cds.putValue(i, j, k, d);
                    }
                }
            }
        }
        return cds;
    }

    public static QDataSet histogram(QDataSet ds, double min, double max, double binsize) {
        int n = (int)Math.ceil((max - min) / binsize);
        MutablePropertyDataSet tags = DataSetUtil.tagGenDataSet(n, min, binsize, (Units)ds.property("UNITS"));
        tags.putProperty("NAME", ds.property("NAME"));
        tags.putProperty("LABEL", ds.property("LABEL"));
        tags.putProperty("TITLE", ds.property("TITLE"));
        tags.putProperty("TYPICAL_MAX", ds.property("TYPICAL_MAX"));
        tags.putProperty("TYPICAL_MIN", ds.property("TYPICAL_MIN"));
        int[] hits = new int[n];
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        double positiveMin = Double.MAX_VALUE;
        int count = 0;
        while (count < 10000000 && iter.hasNext()) {
            iter.next();
            double d = iter.getValue(ds);
            double w = iter.getValue(wds);
            if (!(w > 0.0)) continue;
            int ibin = (int)((d - min) / binsize);
            if (ibin >= 0 && ibin < n) {
                int n2 = ibin;
                hits[n2] = hits[n2] + 1;
            }
            if (d > 0.0 && d < positiveMin) {
                positiveMin = d;
            }
            ++count;
        }
        IDataSet result = IDataSet.wrap(hits);
        result.putProperty("DEPEND_0", tags);
        result.putProperty("count", count);
        result.putProperty("positiveMin", positiveMin);
        return result;
    }

    public static RankZeroDataSet moment(QDataSet ds) {
        double[] moment = new double[2];
        Units u = (Units)ds.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        int validCount = 0;
        int invalidCount = 0;
        double approxMean = 0.0;
        QDataSet wds = DataSetUtil.weightsDataSet(ds);
        QubeDataSetIterator iter = new QubeDataSetIterator(ds);
        while (iter.hasNext()) {
            iter.next();
            double d = iter.getValue(ds);
            double w = iter.getValue(wds);
            if (w == 0.0) {
                ++invalidCount;
                continue;
            }
            ++validCount;
            approxMean += d;
        }
        if (validCount > 0) {
            approxMean /= (double)validCount;
        }
        double mean = 0.0;
        double stddev = 0.0;
        if (validCount > 0) {
            iter = new QubeDataSetIterator(ds);
            while (iter.hasNext()) {
                iter.next();
                double d = iter.getValue(ds);
                double w = iter.getValue(wds);
                if (!(w > 0.0)) continue;
                mean += d - approxMean;
                stddev += Math.pow(d - approxMean, 2.0);
            }
            mean /= (double)validCount;
            moment[0] = mean += approxMean;
            if (validCount > 1) {
                stddev /= (double)(validCount - 1);
                moment[1] = stddev = Math.sqrt(stddev);
            } else {
                moment[1] = u.getFillDouble();
            }
        } else {
            moment[0] = u.getFillDouble();
        }
        DRank0DataSet result = DataSetUtil.asDataSet(moment[0]);
        result.putProperty("UNITS", u);
        DRank0DataSet stddevds = DataSetUtil.asDataSet(moment[1]);
        stddevds.putProperty("UNITS", u.getOffsetUnits());
        result.putProperty("stddev", stddevds);
        result.putProperty("validCount", validCount);
        result.putProperty("invalidCount", invalidCount);
        return result;
    }

    public static QDataSet transpose2(QDataSet ds) {
        return new TransposeRank2DataSet(ds);
    }

    public static Map<String, Object> sliceProperties0(int index, Map<String, Object> props) {
        String prop;
        QDataSet plane;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        QDataSet dep0 = (QDataSet)props.get("DEPEND_0");
        QDataSet dep1 = (QDataSet)props.get("DEPEND_1");
        QDataSet dep2 = (QDataSet)props.get("DEPEND_2");
        QDataSet dep3 = (QDataSet)props.get("DEPEND_3");
        String bins1 = (String)props.get("BINS_1");
        QDataSet bundle1 = (QDataSet)props.get("BUNDLE_1");
        QDataSet bundle0 = (QDataSet)props.get("BUNDLE_0");
        if (dep0 != null && dep1 != null && dep0.rank() > 1 && dep1.rank() > 1) {
            throw new IllegalArgumentException("both DEPEND_0 and DEPEND_1 have rank>1");
        }
        if (dep1 != null) {
            if (dep1 != null && dep1.rank() == 2) {
                result.put("DEPEND_0", dep1.slice(index));
            } else {
                result.put("DEPEND_0", dep1);
            }
        }
        if (dep0 != null && dep0.rank() == 1) {
            if (dep0 != null) {
                DataSetUtil.addContext(result, dep0.slice(index));
            }
        } else if (dep1 == null && props.get("DEPEND_0__" + index) == null) {
            result.put("DEPEND_0", null);
        }
        for (String ss : props.keySet()) {
            int islice;
            int iii;
            int ii = ss.indexOf("__");
            if (ii <= -1) continue;
            String hd = ss.substring(ii + 2);
            for (iii = 0; iii < hd.length() && Character.isDigit(hd.charAt(iii)); ++iii) {
            }
            if (iii <= 0 || (islice = Integer.parseInt(hd.substring(0, iii))) != index) continue;
            String slicePropName = iii < hd.length() ? ss.substring(0, ii) + "__" + hd.substring(iii + 1) : ss.substring(0, ii);
            result.put(slicePropName, props.get(ss));
        }
        if (dep2 != null) {
            if (dep2.rank() == 2) {
                result.put("DEPEND_1", dep2.slice(index));
            } else {
                result.put("DEPEND_1", dep2);
            }
        }
        if (dep3 != null) {
            if (dep3.rank() == 2) {
                result.put("DEPEND_2", dep3.slice(index));
            } else {
                result.put("DEPEND_2", dep3);
            }
        }
        if (bins1 != null) {
            result.put("BINS_0", bins1);
        }
        if (bundle1 != null) {
            result.put("BUNDLE_0", bundle1);
        }
        if (bundle0 != null) {
            QDataSet bundle0ds = bundle0.slice(index);
            result.putAll(DataSetUtil.getProperties(bundle0ds));
        }
        for (int i = 0; i < 50 && (plane = (QDataSet)props.get(prop = "PLANE_" + i)) != null; ++i) {
            if (plane.rank() < 1) {
                result.put(prop, plane);
                continue;
            }
            result.put(prop, plane.slice(index));
        }
        String[] p = new String[]{"DELTA_MINUS", "DELTA_PLUS", "WEIGHTS"};
        for (int i = 0; i < p.length; ++i) {
            QDataSet delta = (QDataSet)props.get(p[i]);
            if (delta == null || delta.rank() <= 0) continue;
            result.put(p[i], delta.slice(index));
        }
        String[] ss = DataSetUtil.dimensionProperties();
        for (int i = 0; i < ss.length; ++i) {
            Object o = props.get(ss[i]);
            if (o == null) continue;
            result.put(ss[i], o);
        }
        return result;
    }

    public static QDataSet flattenBundleDescriptor(QDataSet bundle1) {
        int nr1 = 0;
        final ArrayList<String> names = new ArrayList<String>();
        final ArrayList<Units> units = new ArrayList<Units>();
        for (int j = 0; j < bundle1.length(); ++j) {
            int rank = bundle1.length(j);
            int n = 1;
            for (int k = 0; k < rank; ++k) {
                n = (int)((double)n * bundle1.value(j, k));
            }
            nr1 += n;
            String name = (String)bundle1.property("NAME", j);
            Units unit = (Units)bundle1.property("UNITS", j);
            String bins = (String)bundle1.property("BINS_1", j);
            for (int i = 0; i < n; ++i) {
                String theName;
                String binName = null;
                if (bins != null) {
                    String[] ss = bins.split(",", -2);
                    binName = ss[i];
                }
                if ((theName = name) != null && binName != null) {
                    theName = theName + "_" + binName;
                }
                if (theName != null) {
                    names.add(theName);
                } else {
                    names.add("");
                }
                if (unit != null) {
                    units.add(unit);
                    continue;
                }
                units.add(Units.dimensionless);
            }
        }
        final int fnr1 = nr1;
        AbstractDataSet bundleDescriptor = new AbstractDataSet(){

            public int rank() {
                return 2;
            }

            public int length() {
                return fnr1;
            }

            public int length(int i) {
                return 0;
            }

            public Object property(String name, int i) {
                if (i > names.size()) {
                    throw new IllegalArgumentException("index too large:" + i);
                }
                if (name.equals("NAME")) {
                    return names.get(i);
                }
                if (name.equals("UNITS")) {
                    return units.get(i);
                }
                return null;
            }
        };
        return bundleDescriptor;
    }

    public static QDataSet unbundle(QDataSet bundleDs, String name) {
        QDataSet bundle1 = (QDataSet)bundleDs.property("BUNDLE_1");
        int ib = -1;
        int i = name.indexOf("[");
        if (i > 0) {
            name = name.substring(i);
            name = Ops.saferName(name);
        }
        if (name.matches("ch_\\d+")) {
            int ich = Integer.parseInt(name.substring(3));
            return new Slice1DataSet(bundleDs, ich, true, true);
        }
        if (bundle1 == null) {
            bundle1 = (QDataSet)bundleDs.property("DEPEND_1");
            if (bundle1 != null && bundle1.rank() > 1) {
                throw new IllegalArgumentException("high rank DEPEND_1 found where rank 1 was expected");
            }
            if (bundle1 != null) {
                Units u = SemanticOps.getUnits(bundle1);
                for (int i2 = 0; i2 < bundle1.length(); ++i2) {
                    if (!name.equals(Ops.saferName(u.createDatum(bundle1.value(i2)).toString()))) continue;
                    return DataSetOps.unbundle(bundleDs, i2);
                }
                throw new IllegalArgumentException("unable to find dataset with name \"" + name + "\" in bundle " + bundleDs);
            }
            if (bundle1 == null) {
                throw new IllegalArgumentException("expected to find BUNDLE_1 or DEPEND_1 with ordinal units.");
            }
        }
        if (bundle1 == null) {
            throw new IllegalArgumentException("unbundle called but no bundle dataset found in BUNDLE_1 or DEPEND_1");
        }
        boolean highRank = false;
        for (int j = 0; j < bundle1.length(); ++j) {
            String n1 = (String)bundle1.property("NAME", j);
            if (n1 != null) {
                n1 = Ops.saferName(n1);
            }
            if (n1 != null && n1.equals(name)) {
                ib = j;
            }
            if (bundle1.length(j) <= 0) continue;
            n1 = (String)bundle1.property("ELEMENT_NAME", j);
            if (n1 != null) {
                n1 = Ops.saferName(n1);
            }
            if (n1 == null || !n1.equals(name)) continue;
            ib = j;
            highRank = true;
            break;
        }
        if (ib == -1) {
            if (name.matches("ch_\\d+")) {
                int ich = Integer.parseInt(name.substring(3));
                if (bundle1 != null) {
                    return DataSetOps.unbundle(bundleDs, ich, false);
                }
                return DataSetOps.slice1(bundleDs, ich);
            }
            throw new IllegalArgumentException("unable to find dataset with name \"" + name + "\" in bundle " + bundleDs);
        }
        return DataSetOps.unbundle(bundleDs, ib, highRank);
    }

    public static QDataSet unbundleDefaultDataSet(QDataSet bundleDs) {
        QDataSet bundle1 = (QDataSet)bundleDs.property("BUNDLE_1");
        if (bundle1 == null && (bundle1 = (QDataSet)bundleDs.property("DEPEND_1")) != null && bundle1.rank() > 1) {
            throw new IllegalArgumentException("high rank DEPEND_1 found where rank 1 was expected");
        }
        int ids = -1;
        if (bundle1 != null) {
            for (int i = 0; i < bundle1.length(); ++i) {
                if (bundle1.property("DEPEND_0", i) != null) {
                    ids = i;
                }
                if (bundle1.property("CONTEXT_0", i) == null) continue;
                ids = i;
            }
            if (ids == -1) {
                ids = bundle1.length() - 1;
            }
        } else {
            ids = bundleDs.length(0) - 1;
        }
        return DataSetOps.unbundle(bundleDs, ids);
    }

    public static QDataSet unbundle(QDataSet bundleDs, int ib) {
        return DataSetOps.unbundle(bundleDs, ib, true);
    }

    public static QDataSet unbundle(QDataSet bundleDs, int ib, boolean highRank) {
        MutablePropertyDataSet result;
        QDataSet bundle = null;
        if (bundleDs.rank() == 2) {
            QDataSet bundle1 = (QDataSet)bundleDs.property("BUNDLE_1");
            if (bundle1 == null) {
                bundle1 = (QDataSet)bundleDs.property("DEPEND_1");
                if (bundle1 == null) {
                    return new Slice1DataSet(bundleDs, ib);
                }
                if (bundle1 != null && bundle1.rank() > 1) {
                    throw new IllegalArgumentException("high rank DEPEND_1 found where rank 1 was expected");
                }
            }
            bundle = bundle1;
        } else if (bundleDs.rank() == 1) {
            QDataSet bundle0 = (QDataSet)bundleDs.property("BUNDLE_0");
            if (bundle0 == null) {
                bundle0 = (QDataSet)bundleDs.property("DEPEND_0");
                if (bundle0 == null) {
                    throw new IllegalArgumentException("Neither BUNDLE_0 nor DEPEND_0 found on dataset passed to unbundle command.");
                }
                if (bundle0 != null && bundle0.rank() > 1) {
                    throw new IllegalArgumentException("high rank DEPEND_0 found where rank 1 was expected");
                }
                Units u = SemanticOps.getUnits(bundle0);
                if (!(u instanceof EnumerationUnits)) {
                    throw new IllegalArgumentException("dataset is not a bundle, and units of DEPEND_0 are not enumeration");
                }
            }
            bundle = bundle0;
        } else {
            throw new IllegalArgumentException("bundle must be rank 1 or rank 2");
        }
        if (ib < 0 || ib >= bundle.length()) {
            throw new IndexOutOfBoundsException("no such data set");
        }
        if (bundle.rank() == 1) {
            MutablePropertyDataSet result2 = bundleDs.rank() == 2 ? DataSetOps.slice1(bundleDs, ib) : DataSetOps.slice0(bundleDs, ib);
            Units enumunits = (Units)bundle.property("UNITS");
            if (enumunits == null) {
                enumunits = Units.dimensionless;
            }
            String label = String.valueOf(enumunits.createDatum(bundle.value(ib)));
            result2.putProperty("NAME", Ops.safeName(label));
            result2.putProperty("LABEL", label);
            return result2;
        }
        if (bundle.rank() != 2) {
            throw new IllegalArgumentException("rank limit: >2 not supported");
        }
        int len = 1;
        int j = ib;
        int is = ib;
        if (highRank) {
            Integer s = (Integer)bundle.property("START_INDEX", ib);
            if (s == null) {
                s = ib;
            }
            is = s;
            int n = 1;
            for (int k = 0; k < bundle.length(is); ++k) {
                n = (int)((double)n * bundle.value(is, k));
            }
            len = n;
            j = ib;
        }
        if (bundle.length(j) == 0 || !highRank) {
            if (bundleDs instanceof BundleDataSet) {
                QDataSet r = ((BundleDataSet)bundleDs).unbundle(j);
                QDataSet dep0 = (QDataSet)bundleDs.property("DEPEND_0");
                if (dep0 != null && r.property("DEPEND_0") == null) {
                    DataSetWrapper rc = new DataSetWrapper(r);
                    rc.putProperty("DEPEND_0", dep0);
                    return rc;
                }
                return r;
            }
            result = null;
            if (bundleDs.rank() == 1) {
                result = DataSetOps.makePropertiesMutable(bundleDs.slice(j));
            } else if (bundleDs.rank() == 2) {
                result = new Slice1DataSet(bundleDs, j, true);
            }
            String[] names1 = DataSetUtil.dimensionProperties();
            for (int i = 0; i < names1.length; ++i) {
                Object v = bundle.property(names1[i], j);
                if (v == null) continue;
                result.putProperty(names1[i], v);
            }
            Map<String, Object> props3 = DataSetUtil.getProperties(bundle, DataSetUtil.globalProperties(), null);
            for (String ss : props3.keySet()) {
                Object vv = result.property(ss);
                if (vv != null) continue;
                result.putProperty(ss, props3.get(ss));
            }
            return result;
        }
        if (bundle.length(j) == 1) {
            int last;
            int first;
            if (bundleDs.rank() == 1) {
                throw new IllegalArgumentException("not implemented for rank 0, slice is rank 1");
            }
            result = new TrimStrideWrapper(bundleDs);
            ((TrimStrideWrapper)result).setTrim(1, is, is + len, 1);
            Integer ifirst = (Integer)bundle.property("START_INDEX", j);
            if (ifirst != null) {
                first = ifirst;
                last = first + len - 1;
            } else {
                first = j;
                last = j;
            }
            Map<String, Object> props = DataSetUtil.getProperties(DataSetOps.slice0(bundle, first));
            Map<String, Object> props2 = DataSetUtil.getProperties(DataSetOps.slice0(bundle, last));
            for (String ss : props2.keySet()) {
                Object vv = props.get(ss);
                if (vv == null || vv.equals(props2.get(ss))) continue;
                props.put(ss, null);
            }
            if (bundleDs.rank() > 1) {
                if (bundle.property("DEPEND_1", first) != null && bundle.property("DEPEND_1", first) == bundle.property("DEPEND_1", last)) {
                    props.put("DEPEND_1", bundle.property("DEPEND_1", first));
                }
                if (bundle.property("BINS_1", first) != null && bundle.property("BINS_1", first).equals(bundle.property("BINS_1", last))) {
                    props.put("BINS_1", bundle.property("BINS_1", first));
                }
                if (bundle.property("BUNDLE_1", first) != null && bundle.property("BUNDLE_1", first) == bundle.property("BUNDLE_1", last)) {
                    props.put("BUNDLE_1", bundle.property("BUNDLE_1", first));
                }
            }
            Map<String, Object> props3 = DataSetUtil.getProperties(bundle, DataSetUtil.globalProperties(), null);
            for (String ss : props3.keySet()) {
                Object vv = props.get(ss);
                if (vv != null) continue;
                props.put(ss, props3.get(ss));
            }
            Object o = bundle.property("ELEMENT_NAME", j);
            if (o != null) {
                props.put("NAME", o);
            }
            if ((o = bundle.property("ELEMENT_LABEL", j)) != null) {
                props.put("LABEL", o);
            }
            DataSetUtil.putProperties(props, result);
            String[] testProps = new String[]{"DEPEND_0", "DELTA_MINUS", "DELTA_PLUS", "PLANE_0"};
            for (int i = 0; i < testProps.length; ++i) {
                String prop = testProps[i];
                Object dep0 = ((TrimStrideWrapper)result).property(prop);
                if (dep0 == null || !(dep0 instanceof String)) continue;
                try {
                    QDataSet dep0ds = DataSetOps.unbundle(bundleDs, (String)dep0);
                    ((AbstractDataSet)result).putProperty(prop, dep0ds);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("unable to find DEPEND_0 reference to \"" + dep0 + "\"");
                }
            }
            return result;
        }
        throw new IllegalArgumentException("rank limit: >2 not supported");
    }

    public static boolean isProcessAsync(String c) {
        return c.contains("fft");
    }

    public static QDataSet sprocess(String c, QDataSet fillDs, ProgressMonitor mon) {
        boolean i = true;
        Scanner s = new Scanner(c);
        s.useDelimiter("[\\(\\),]");
        while (s.hasNext()) {
            String cmd = s.next();
            if (cmd.startsWith("|slices") && cmd.length() == 7) {
                Pattern skipPattern = Pattern.compile("\\'\\'");
                ArrayList<Object> args = new ArrayList<Object>();
                while (s.hasNextInt() || s.hasNext(skipPattern)) {
                    if (s.hasNextInt()) {
                        args.add(s.nextInt());
                        continue;
                    }
                    args.add(s.next());
                }
                fillDs = Ops.slices(fillDs, args.toArray());
                continue;
            }
            if (cmd.startsWith("|slice")) {
                int dim = cmd.charAt(6) - 48;
                int idx = s.nextInt();
                if (dim == 0) {
                    if (idx >= fillDs.length()) {
                        idx = fillDs.length() - 1;
                    }
                    if (idx < 0) {
                        idx = 0;
                    }
                    fillDs = DataSetOps.slice0(fillDs, idx);
                    continue;
                }
                if (dim == 1) {
                    if (idx >= fillDs.length(0)) {
                        idx = fillDs.length(0) - 1;
                    }
                    if (idx < 0) {
                        idx = 0;
                    }
                    fillDs = DataSetOps.slice1(fillDs, idx);
                    continue;
                }
                if (dim == 2) {
                    if (idx >= fillDs.length(0, 0)) {
                        idx = fillDs.length(0, 0) - 1;
                    }
                    if (idx < 0) {
                        idx = 0;
                    }
                    fillDs = DataSetOps.slice2(fillDs, idx);
                    continue;
                }
                if (dim != 3) continue;
                if (idx >= fillDs.length(0, 0, 0)) {
                    idx = fillDs.length(0, 0, 0) - 1;
                }
                if (idx < 0) {
                    idx = 0;
                }
                fillDs = DataSetOps.slice3(fillDs, idx);
                continue;
            }
            if (cmd.equals("|nop")) continue;
            if (cmd.equals("|diff")) {
                fillDs = Ops.diff(fillDs);
                continue;
            }
            if (cmd.equals("|accum")) {
                fillDs = Ops.accum(fillDs);
                continue;
            }
            if (cmd.equals("|log10")) {
                fillDs = Ops.log10(fillDs);
                continue;
            }
            if (cmd.equals("|exp10")) {
                fillDs = Ops.exp10(fillDs);
                continue;
            }
            if (cmd.startsWith("|collapse")) {
                int dim = cmd.charAt(9) - 48;
                fillDs = Ops.reduceMean(fillDs, dim);
                continue;
            }
            if (cmd.equals("|autoHistogram")) {
                fillDs = Ops.autoHistogram(fillDs);
                continue;
            }
            if (cmd.equals("|histogram")) {
                fillDs = Ops.autoHistogram(fillDs);
                continue;
            }
            if (cmd.equals("|extent")) {
                fillDs = Ops.extent(fillDs);
                continue;
            }
            if (cmd.equals("|logHistogram")) {
                fillDs = Ops.autoHistogram(Ops.log10(fillDs));
                MutablePropertyDataSet dep0 = DDataSet.copy((QDataSet)fillDs.property("DEPEND_0"));
                QDataSet cadence = (QDataSet)dep0.property("CADENCE");
                dep0 = (MutablePropertyDataSet)Ops.pow((QDataSet)Ops.replicate(10L, dep0.length()), dep0);
                dep0.putProperty("SCALE_TYPE", "log");
                dep0.putProperty("CADENCE", cadence);
                ((MutablePropertyDataSet)fillDs).putProperty("DEPEND_0", dep0);
                continue;
            }
            if (cmd.equals("|transpose")) {
                if (fillDs.rank() == 2) {
                    fillDs = Ops.transpose(fillDs);
                    continue;
                }
                System.err.println("unable to transpose dataset, not rank 2");
                continue;
            }
            if (cmd.startsWith("|fftWindow")) {
                int size = s.nextInt();
                fillDs = Ops.fftWindow(fillDs, size);
                continue;
            }
            if (cmd.equals("|flatten")) {
                if (fillDs.rank() != 2) {
                    throw new IllegalArgumentException("only rank2 supported");
                }
                fillDs = DataSetOps.flattenRank2(fillDs);
                continue;
            }
            if (cmd.equals("|grid")) {
                if (fillDs.rank() != 2) {
                    throw new IllegalArgumentException("only rank2 supported");
                }
                fillDs = DataSetOps.grid(fillDs);
                continue;
            }
            if (cmd.equals("|magnitude")) {
                fillDs = Ops.magnitude(fillDs);
                continue;
            }
            if (cmd.equals("|pow")) {
                int idx = s.nextInt();
                fillDs = Ops.pow(fillDs, (double)idx);
                continue;
            }
            if (cmd.equals("|total")) {
                int idx = s.nextInt();
                fillDs = Ops.total(fillDs, idx);
                continue;
            }
            if (cmd.equals("|sqrt")) {
                fillDs = Ops.sqrt(fillDs);
                continue;
            }
            if (cmd.equals("|fftPower")) {
                if (fillDs.length() > 0) {
                    if (s.hasNextInt()) {
                        int len = s.nextInt();
                        fillDs = Ops.fftPower(fillDs, len, mon);
                        continue;
                    }
                    fillDs = Ops.fftPower(fillDs);
                    continue;
                }
                fillDs = Ops.fftPower(fillDs);
                continue;
            }
            if (cmd.equals("|hanning")) {
                if (fillDs.length() <= 0) continue;
                if (s.hasNextInt()) {
                    int len = s.nextInt();
                    fillDs = Ops.fftFilter(fillDs, len, Ops.FFTFilterType.Hanning);
                    continue;
                }
                throw new IllegalArgumentException("expected argument to hanning filter");
            }
            if (cmd.equals("|unbundle")) {
                String comp = s.next();
                if (comp.startsWith("'") && comp.endsWith("'")) {
                    comp = comp.substring(1, comp.length() - 1);
                }
                try {
                    int icomp = Integer.parseInt(comp);
                    fillDs = DataSetOps.unbundle(fillDs, icomp);
                }
                catch (NumberFormatException ex) {
                    fillDs = DataSetOps.unbundle(fillDs, comp);
                }
                continue;
            }
            if (cmd.equals("|negate")) {
                fillDs = Ops.negate(fillDs);
                continue;
            }
            if (cmd.equals("|cos")) {
                fillDs = Ops.cos(fillDs);
                continue;
            }
            if (cmd.equals("|sin")) {
                fillDs = Ops.sin(fillDs);
                continue;
            }
            if (cmd.equals("|toRadians")) {
                fillDs = Ops.toRadians(fillDs);
                continue;
            }
            if (cmd.equals("|toDegrees")) {
                fillDs = Ops.toDegrees(fillDs);
                continue;
            }
            if (cmd.equals("|smooth")) {
                String comp = s.next();
                int icomp = Integer.parseInt(comp);
                fillDs = Ops.smooth(fillDs, icomp);
                continue;
            }
            if (cmd.equals("")) continue;
            System.err.println("command not recognized: \"" + cmd + "\"");
        }
        return fillDs;
    }

    public static boolean changesDimensions(String c0, String c2) {
        Scanner s = new Scanner(c0);
        s.useDelimiter("[\\(\\),]");
        Scanner s2 = new Scanner(c2);
        s2.useDelimiter("[\\(\\),]");
        while (s.hasNext() && s2.hasNext()) {
            String cmd = s.next();
            if (!s2.next().equals(cmd)) {
                return true;
            }
            if (!cmd.startsWith("|slice") || cmd.length() <= 6) continue;
            s.nextInt();
            s2.nextInt();
        }
        return s.hasNext() || s2.hasNext();
    }

    public static QDataSet dependBounds(QDataSet ds) {
        QDataSet yrange;
        QDataSet xrange;
        if (ds.rank() == 2) {
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds));
            yrange = Ops.extent(SemanticOps.ytagsDataSet(ds));
        } else if (ds.rank() == 3) {
            QDataSet ds1 = ds.slice(0);
            xrange = Ops.extent(SemanticOps.xtagsDataSet(ds1));
            yrange = Ops.extent(SemanticOps.ytagsDataSet(ds1));
            for (int i = 1; i < ds.length(); ++i) {
                ds1 = ds.slice(i);
                xrange = Ops.extent(SemanticOps.xtagsDataSet(ds1), xrange);
                yrange = Ops.extent(SemanticOps.ytagsDataSet(ds1), yrange);
            }
        } else {
            throw new IllegalArgumentException("bad rank");
        }
        QDataSet result = Ops.join(xrange, yrange);
        return result;
    }

    public static boolean boundsContains(QDataSet bounds, Datum xValue, Datum yValue) {
        if (bounds.property("BINS_1") == null && bounds.property("BINS_0", 0) == null) {
            throw new IllegalArgumentException("expected BINS_1");
        }
        DatumRange xrange = DataSetUtil.asDatumRange(bounds.slice(0), true);
        DatumRange yrange = DataSetUtil.asDatumRange(bounds.slice(1), true);
        return xrange.contains(xValue) && yrange.contains(yValue);
    }
}

