/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;

public class JoinDataSet
extends AbstractDataSet {
    private static final int NO_DATASET_SIZE = 10;
    List<QDataSet> datasets;
    int rank;

    public JoinDataSet(int rank) {
        this.rank = rank;
        this.putProperty("JOIN_0", DDataSet.create(new int[0]));
        this.datasets = new ArrayList<QDataSet>();
    }

    public JoinDataSet(QDataSet ds1) {
        this(ds1.rank() + 1);
        this.join(ds1);
    }

    public static JoinDataSet copy(JoinDataSet joinDataSet) {
        JoinDataSet result = new JoinDataSet(joinDataSet.rank());
        result.datasets.addAll(joinDataSet.datasets);
        DataSetUtil.putProperties(DataSetUtil.getProperties(joinDataSet), result);
        result.putProperty("DEPEND_0", joinDataSet.property("DEPEND_0"));
        result.putProperty("JOIN_0", joinDataSet.property("JOIN_0"));
        return result;
    }

    public void joinAll(JoinDataSet ds1) {
        for (int j = 0; j < ds1.length(); ++j) {
            this.join(ds1.slice(j));
        }
        QDataSet dep0 = (QDataSet)ds1.property("DEPEND_0");
        if (dep0 != null) {
            QDataSet thisDep0 = (QDataSet)this.property("DEPEND_0");
            if (thisDep0 != null) {
                DDataSet dd1;
                DDataSet dd = (DDataSet)DDataSet.maybeCopy(thisDep0);
                if (!dd.canAppend(dd1 = (DDataSet)DDataSet.maybeCopy(dep0))) {
                    dd.grow(dd.length() + dd1.length());
                }
                dd.append(dd1);
                this.putProperty("DEPEND_0", dd);
            } else {
                throw new IllegalArgumentException("joinAll datasets one has depend_0 but other doesn't");
            }
        }
    }

    public final void join(QDataSet ds) {
        if (ds.rank() != this.rank - 1) {
            throw new IllegalArgumentException("dataset rank must be " + (this.rank - 1) + ", it is rank " + ds.rank());
        }
        this.datasets.add(ds);
    }

    public int rank() {
        return this.rank;
    }

    public double value(int i0) {
        return this.datasets.get(i0).value();
    }

    public double value(int i0, int i1) {
        return this.datasets.get(i0).value(i1);
    }

    public double value(int i0, int i1, int i2) {
        return this.datasets.get(i0).value(i1, i2);
    }

    public double value(int i0, int i1, int i2, int i3) {
        return this.datasets.get(i0).value(i1, i2, i3);
    }

    public Object property(String name, int i0) {
        String sname = name + "__" + i0;
        Object result = this.properties.get(sname);
        if (result == null) {
            return this.datasets.get(i0).property(name);
        }
        return result;
    }

    public final void putProperty(String name, Object value) {
        super.putProperty(name, value);
        if (name.equals("DEPEND_0")) {
            super.putProperty("JOIN_0", null);
        }
    }

    public int length() {
        return this.datasets.size();
    }

    public int length(int i0) {
        if (this.datasets.size() == 0 && i0 == 0) {
            return 10;
        }
        return this.datasets.get(i0).length();
    }

    public int length(int i0, int i1) {
        if (this.datasets.size() == 0 && i0 == 0) {
            return 10;
        }
        return this.datasets.get(i0).length(i1);
    }

    public int length(int i0, int i1, int i2) {
        if (this.datasets.size() == 0 && i0 == 0) {
            return 10;
        }
        return this.datasets.get(i0).length(i1, i2);
    }

    public String toString() {
        if (this.datasets.size() > 4) {
            return "JoinDataSet[" + this.datasets.size() + " datasets: " + this.datasets.get(0) + ", " + this.datasets.get(1) + ", ...]";
        }
        return "JoinDataSet[" + this.datasets.size() + " datasets: " + this.datasets + " ]";
    }

    public JoinDataSet trim(int imin, int imax) {
        JoinDataSet result = new JoinDataSet(this.rank);
        result.datasets = new ArrayList<QDataSet>(imax - imin);
        result.datasets.addAll(this.datasets.subList(imin, imax));
        result.properties.putAll(this.properties);
        QDataSet dep0 = (QDataSet)this.property("DEPEND_0");
        if (dep0 != null) {
            result.properties.put("DEPEND_0", dep0.trim(imin, imax));
        }
        return result;
    }

    public QDataSet slice(int idx) {
        QDataSet result = this.datasets.get(idx);
        if (!(result instanceof MutablePropertyDataSet)) {
            result = DataSetOps.makePropertiesMutable(result);
        }
        if (result instanceof MutablePropertyDataSet) {
            Object odep0;
            MutablePropertyDataSet mpds = (MutablePropertyDataSet)result;
            Map<String, Object> props = DataSetOps.sliceProperties0(idx, this.properties);
            if (props.size() > 0) {
                // empty if block
            }
            if ((odep0 = props.get("DEPEND_0")) != null) {
                props.put("DEPEND_0", null);
            }
            DataSetUtil.putProperties(props, mpds);
            Object dep1 = this.properties.get("DEPEND_1");
        }
        return result;
    }
}

