/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.Map;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDataSet
extends ArrayDataSet {
    long[] back;
    public static final String version = "20070529";

    public static LDataSet createRank1(int len0) {
        return new LDataSet(1, len0, 1, 1, 1);
    }

    public static LDataSet createRank2(int len0, int len1) {
        return new LDataSet(2, len0, len1, 1, 1);
    }

    public static LDataSet createRank3(int len0, int len1, int len2) {
        return new LDataSet(3, len0, len1, len2, 1);
    }

    public static LDataSet createRank4(int len0, int len1, int len2, int len3) {
        return new LDataSet(4, len0, len1, len2, len3);
    }

    public static LDataSet wrap(long[] data, int[] qube) {
        if (qube.length == 1) {
            return new LDataSet(1, qube[0], 1, 1, 1, data);
        }
        if (qube.length == 2) {
            return new LDataSet(2, qube[0], qube[1], 1, 1, data);
        }
        if (qube.length == 3) {
            return new LDataSet(3, qube[0], qube[1], qube[2], 1, data);
        }
        if (qube.length == 4) {
            return new LDataSet(4, qube[0], qube[1], qube[2], qube[3], data);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static LDataSet wrap(long[] back, int rank, int len0, int len1, int len2, int len3) {
        return new LDataSet(rank, len0, len1, len2, len3, back);
    }

    protected LDataSet(int rank, int len0, int len1, int len2, int len3) {
        this(rank, len0, len1, len2, len3, new long[len0 * len1 * len2 * len3]);
    }

    protected LDataSet(int rank, int len0, int len1, int len2, int len3, long[] back) {
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        if (rank > 1) {
            this.putProperty("QUBE", Boolean.TRUE);
        }
    }

    @Override
    protected Object getBack() {
        return this.back;
    }

    @Override
    protected void setBack(Object back) {
        this.back = (long[])back;
    }

    @Override
    public double value() {
        return this.back[0];
    }

    @Override
    public double value(int i0) {
        return this.back[i0];
    }

    @Override
    public double value(int i0, int i1) {
        return this.back[i0 * this.len1 + i1];
    }

    @Override
    public double value(int i0, int i1, int i2) {
        return this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2];
    }

    @Override
    public double value(int i0, int i1, int i2, int i3) {
        return this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3];
    }

    @Override
    public void putValue(double value) {
        this.back[0] = (long)value;
    }

    @Override
    public void putValue(int i0, double value) {
        this.back[i0] = (long)value;
    }

    @Override
    public void putValue(int i0, int i1, double value) {
        this.back[i0 * this.len1 + i1] = (long)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, double value) {
        this.back[i0 * this.len1 * this.len2 + i1 * this.len2 + i2] = (long)value;
    }

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double value) {
        this.back[i0 * this.len1 * this.len2 * this.len3 + i1 * this.len2 * this.len3 + i2 * this.len3 + i3] = (long)value;
    }

    @Override
    public void putLength(int len) {
        if (len > this.len0) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    public static LDataSet wrap(long[] back) {
        return new LDataSet(1, back.length, 1, 1, 1, back);
    }

    public static LDataSet wrap(long[] back, int nx, int ny) {
        return new LDataSet(2, nx, ny, 1, 1, back);
    }

    public static LDataSet wrap(long[] back, int nx, int ny, int nz) {
        return new LDataSet(3, nx, ny, nz, 1, back);
    }

    @Override
    public QDataSet slice(int i) {
        int nrank = this.rank - 1;
        int noff1 = i * this.len1 * this.len2 * this.len3;
        int noff2 = (i + 1) * this.len1 * this.len2 * this.len3;
        long[] newback = new long[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        Map<String, Object> props = DataSetOps.sliceProperties0(i, DataSetUtil.getProperties(this));
        props = DataSetUtil.sliceProperties(this, i, props);
        LDataSet result = new LDataSet(nrank, this.len1, this.len2, this.len3, 1, newback);
        DataSetUtil.putProperties(props, result);
        return result;
    }

    @Override
    public QDataSet trim(int start, int end) {
        int nrank = this.rank;
        int noff1 = start * this.len1 * this.len2 * this.len3;
        int noff2 = end * this.len1 * this.len2 * this.len3;
        long[] newback = new long[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        LDataSet result = new LDataSet(nrank, end - start, this.len1, this.len2, this.len3, newback);
        Map<String, Object> props = DataSetUtil.getProperties(this);
        props.remove("DEPEND_0");
        DataSetUtil.putProperties(props, result);
        QDataSet dep0 = (QDataSet)this.property("DEPEND_0");
        if (dep0 != null) {
            result.putProperty("DEPEND_0", dep0.trim(start, end));
        }
        return result;
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            return (T)this;
        }
        return super.capability(clazz);
    }
}

