/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.WritableDataSet;

public abstract class OldDataSetIterator {
    QDataSet ds;

    private OldDataSetIterator() {
    }

    public abstract boolean hasNext();

    public abstract double next();

    public abstract int getIndex(int var1);

    public static OldDataSetIterator create(QDataSet ds) {
        switch (ds.rank()) {
            case 1: {
                return new Rank1(ds);
            }
            case 2: {
                return new Rank2(ds);
            }
            case 3: {
                return new Rank3(ds);
            }
        }
        throw new IllegalArgumentException("rank not supported: " + ds.rank() + ", must be 1,2,or 3.");
    }

    public static final void putValue(WritableDataSet ds, OldDataSetIterator it, double v) {
        switch (ds.rank()) {
            case 1: {
                ds.putValue(it.getIndex(0), v);
                return;
            }
            case 2: {
                ds.putValue(it.getIndex(0), it.getIndex(1), v);
                return;
            }
            case 3: {
                ds.putValue(it.getIndex(0), it.getIndex(1), it.getIndex(2), v);
                return;
            }
        }
        throw new IllegalArgumentException("rank limit");
    }

    public static void main(String[] args) {
        double[] back = new double[20];
        for (int i = 0; i < back.length; ++i) {
            back[i] = i;
        }
        DDataSet ds = DDataSet.wrapRank2(back, 4);
        OldDataSetIterator it = OldDataSetIterator.create(ds);
        while (it.hasNext()) {
            System.err.println(it.next());
        }
    }

    static class Qube
    extends OldDataSetIterator {
        int len0;
        int len1;
        int len2;
        int n;
        int i;

        Qube(QDataSet ds) {
            int[] dims = DataSetUtil.qubeDims(ds);
            this.n = ds.length();
            for (int idim = 1; idim < dims.length; ++idim) {
                this.n *= dims[idim];
            }
            this.i = 0;
        }

        public boolean hasNext() {
            return this.i < this.n;
        }

        public double next() {
            ++this.i;
            switch (this.ds.rank()) {
                case 1: {
                    return this.ds.value(this.i);
                }
                case 2: {
                    return this.ds.value(this.i / this.len0, this.i % this.len0);
                }
                case 3: {
                    return this.ds.value(this.i / (this.len0 * this.len1), this.i % (this.len0 * this.len1) / this.len1, this.i % this.len2);
                }
            }
            throw new IllegalArgumentException("rank limit");
        }

        public int getIndex(int idim) {
            switch (this.ds.rank()) {
                case 1: {
                    return this.i;
                }
                case 2: {
                    return idim == 0 ? this.i / this.len0 : this.i % this.len0;
                }
                case 3: {
                    switch (idim) {
                        case 0: {
                            return this.i / (this.len0 * this.len1);
                        }
                        case 1: {
                            return this.i % (this.len0 * this.len1) / this.len1;
                        }
                        case 2: {
                            return this.i % this.len2;
                        }
                    }
                }
            }
            throw new IllegalArgumentException("rank limit");
        }
    }

    static class Rank3
    extends OldDataSetIterator {
        int len0;
        int len1;
        int len2;
        int index0;
        int index1;
        int index2;

        Rank3(QDataSet ds) {
            this.ds = ds;
            this.len0 = ds.length();
            this.len1 = ds.length(0);
            this.len2 = ds.length(0, 0);
            this.index0 = 0;
            this.index1 = 0;
            this.index2 = -1;
        }

        public boolean hasNext() {
            boolean lastIndex = this.index0 == this.len0 - 1 && this.index1 == this.len1 - 1 && this.index2 == this.len2 - 1;
            return this.index0 < this.len0 && !lastIndex;
        }

        private void carry() {
            this.index2 = 0;
            if (++this.index1 == this.len1) {
                this.index1 = 0;
                this.len1 = this.ds.length(++this.index0);
            }
            this.len2 = this.ds.length(this.index0, this.index1);
        }

        public double next() {
            if (++this.index2 == this.len2) {
                this.carry();
            }
            return this.ds.value(this.index0, this.index1, this.index2);
        }

        public int getIndex(int idim) {
            switch (idim) {
                case 0: {
                    return this.index0;
                }
                case 1: {
                    return this.index1;
                }
                case 2: {
                    return this.index2;
                }
            }
            return 0;
        }
    }

    static class Rank2
    extends OldDataSetIterator {
        int len0;
        int len1;
        int index0;
        int index1;

        Rank2(QDataSet ds) {
            this.ds = ds;
            this.len0 = ds.length();
            this.index0 = 0;
            this.len1 = ds.length(this.index0);
            this.index1 = -1;
        }

        public boolean hasNext() {
            return this.index0 < this.len0 && (this.index0 != this.len0 - 1 || this.index1 != this.len1 - 1);
        }

        private void carry() {
            this.index1 = 0;
            this.len1 = this.ds.length(++this.index0);
        }

        public double next() {
            if (++this.index1 == this.len1) {
                this.carry();
            }
            return this.ds.value(this.index0, this.index1);
        }

        public int getIndex(int idim) {
            switch (idim) {
                case 0: {
                    return this.index0;
                }
                case 1: {
                    return this.index1;
                }
            }
            return 0;
        }
    }

    static class Rank1
    extends OldDataSetIterator {
        int len0;
        int index0;

        Rank1(QDataSet ds) {
            this.ds = ds;
            this.len0 = ds.length();
            this.index0 = -1;
        }

        public boolean hasNext() {
            return this.index0 != this.len0 - 1;
        }

        public double next() {
            return this.ds.value(++this.index0);
        }

        public int getIndex(int idim) {
            return idim == 0 ? this.index0 : 0;
        }
    }
}

