/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import java.util.HashMap;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dsops.Ops;

public class SortDataSet
extends AbstractDataSet {
    QDataSet source;
    QDataSet sort;

    public SortDataSet(QDataSet source, QDataSet sort) {
        QDataSet dep1;
        QDataSet p0;
        this.source = source;
        this.sort = sort;
        QDataSet range = Ops.extent(sort);
        if (range.value(0) < 0.0) {
            throw new IndexOutOfBoundsException("sort index contains out-of-bounds element: " + range.value(0));
        }
        if (range.value(1) >= (double)source.length()) {
            throw new IndexOutOfBoundsException("sort index contains out-of-bounds element: " + range.value(1));
        }
        this.properties = new HashMap();
        QDataSet dep0 = (QDataSet)source.property("DEPEND_0");
        if (dep0 != null) {
            this.properties.put("DEPEND_0", new SortDataSet(dep0, sort));
        }
        if ((p0 = (QDataSet)source.property("PLANE_0")) != null) {
            this.properties.put("PLANE_0", new SortDataSet(p0, sort));
        }
        if ((dep1 = (QDataSet)source.property("DEPEND_1")) != null && dep1.rank() > 1) {
            this.properties.put("DEPEND_1", new SortDataSet(dep1, sort));
        }
        this.properties.put("UNITS", source.property("UNITS"));
        this.properties.put("VALID_MIN", source.property("VALID_MIN"));
        this.properties.put("VALID_MAX", source.property("VALID_MAX"));
        this.properties.put("FILL_VALUE", source.property("FILL_VALUE"));
    }

    public int rank() {
        return this.source.rank();
    }

    public double value(int i) {
        return this.source.value((int)this.sort.value(i));
    }

    public double value(int i0, int i1) {
        return this.source.value((int)this.sort.value(i0), i1);
    }

    public double value(int i0, int i1, int i2) {
        return this.source.value((int)this.sort.value(i0), i1, i2);
    }

    public Object property(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return this.source.property(name);
    }

    public Object property(String name, int i) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return this.source.property(name, (int)this.sort.value(i));
    }

    public int length() {
        return this.sort.length();
    }

    public int length(int i) {
        return this.source.length((int)this.sort.value(i));
    }

    public int length(int i, int j) {
        return this.source.length((int)this.sort.value(i), j);
    }
}

