/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dataset;

import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;

public class TrimStrideWrapper
extends AbstractDataSet {
    QDataSet ds;
    int[] offset;
    int[] len;
    int[] stride;
    int[] qube;

    public TrimStrideWrapper(QDataSet ds) {
        this.ds = ds;
        this.len = DataSetUtil.qubeDims(ds);
        this.qube = DataSetUtil.qubeDims(ds);
        this.offset = new int[ds.rank()];
        this.stride = new int[ds.rank()];
        for (int i = 0; i < ds.rank(); ++i) {
            this.stride[i] = 1;
        }
        this.putProperty("NAME", ds.property("NAME"));
        this.putProperty("UNITS", ds.property("UNITS"));
        this.putProperty("FILL_VALUE", ds.property("FILL_VALUE"));
        this.putProperty("VALID_MIN", ds.property("VALID_MIN"));
        this.putProperty("VALID_MAX", ds.property("VALID_MAX"));
    }

    public void setTrim(int dim, Number start, Number stop, Number stride) {
        int sstop;
        int sstart = start == null ? 0 : start.intValue();
        this.stride[dim] = stride == null ? 1 : stride.intValue();
        int n = sstop = stop == null ? this.qube[dim] : stop.intValue();
        if (sstop < 0) {
            sstop = this.qube[dim] + sstop;
        }
        if (sstart < 0) {
            sstart = this.qube[dim] + sstart;
        }
        this.offset[dim] = sstart;
        this.len[dim] = (int)Math.ceil(1.0 * (double)(sstop - sstart) / (double)this.stride[dim]);
        QDataSet dep = (QDataSet)this.ds.property("DEPEND_" + dim);
        if (dep != null && dep.rank() == 1) {
            TrimStrideWrapper depw = new TrimStrideWrapper(dep);
            depw.setTrim(0, start, stop, stride);
            this.putProperty("DEPEND_" + dim, depw);
        }
    }

    public int rank() {
        return this.ds.rank();
    }

    public double value(int i0, int i1, int i2) {
        return this.ds.value(this.offset[0] + this.stride[0] * i0, this.offset[1] + this.stride[1] * i1, this.offset[2] + this.stride[2] * i2);
    }

    public double value(int i0, int i1) {
        return this.ds.value(this.offset[0] + this.stride[0] * i0, this.offset[1] + this.stride[1] * i1);
    }

    public double value(int i0) {
        return this.ds.value(this.offset[0] + this.stride[0] * i0);
    }

    public int length(int i, int j) {
        return this.len[2];
    }

    public int length(int i) {
        return this.len[1];
    }

    public int length() {
        return this.len[0];
    }

    public Object property(String name) {
        if (name.startsWith("PLANE_")) {
            QDataSet plane = (QDataSet)this.ds.property(name);
            if (plane == null) {
                return null;
            }
            TrimStrideWrapper wrap = new TrimStrideWrapper(plane);
            wrap.setTrim(0, this.offset[0], this.len[0], this.stride[0]);
            return wrap;
        }
        return super.property(name);
    }
}

