/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsops;

import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.Slice0DataSet;
import org.virbo.dataset.TrimDataSet;
import org.virbo.dataset.WritableDataSet;

public class CoerceUtil {
    static boolean equalGeom(QDataSet ds1, QDataSet ds2) {
        int[] qube1 = DataSetUtil.qubeDims(ds1);
        int[] qube2 = DataSetUtil.qubeDims(ds2);
        if (qube1 == null || qube2 == null) {
            if (ds1.rank() == 1 && ds2.rank() == 1) {
                return ds1.length() == ds2.length();
            }
            if (ds1.length() != ds2.length()) {
                return false;
            }
            for (int i0 = 0; i0 < ds1.length(); ++i0) {
                if (CoerceUtil.equalGeom(DataSetOps.slice0(ds1, i0), DataSetOps.slice0(ds2, i0))) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < qube2.length; ++i) {
            if (qube1[i] == qube2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WritableDataSet coerce(QDataSet ds1, QDataSet ds2, boolean createResult, QDataSet[] operands) {
        if (ds1.rank() != ds2.rank() || !CoerceUtil.equalGeom(ds1, ds2)) {
            if (ds1.rank() < ds2.rank()) {
                if (ds1.rank() == 0) {
                    ds1 = CoerceUtil.increaseRank0(ds1, ds2);
                } else if (ds1.rank() == 1) {
                    ds1 = CoerceUtil.increaseRank1(ds1, ds2);
                } else {
                    if (ds1.rank() != 2) throw new IllegalArgumentException("rank limit");
                    ds1 = CoerceUtil.increaseRank2(ds1, ds2);
                }
            } else if (ds2.rank() == 0) {
                ds2 = CoerceUtil.increaseRank0(ds2, ds1);
            } else if (ds2.rank() == 1) {
                ds2 = CoerceUtil.increaseRank1(ds2, ds1);
            } else {
                if (ds2.rank() != 2) throw new IllegalArgumentException("rank limit");
                ds2 = CoerceUtil.increaseRank2(ds2, ds1);
            }
        }
        operands[0] = ds1;
        operands[1] = ds2;
        DDataSet result = null;
        if (!createResult) return result;
        int[] dims = DataSetUtil.qubeDims(ds1);
        if (dims == null) {
            dims = DataSetUtil.qubeDims(ds2);
        }
        if (dims != null) return DDataSet.create(dims);
        throw new RuntimeException("either ds1 or ds2 needs to be a qube");
    }

    static QDataSet increaseRank0(final QDataSet ds, final QDataSet ds2) {
        return new QDataSet(){

            @Override
            public int rank() {
                return ds2.rank();
            }

            @Override
            public double value() {
                return ds.value();
            }

            @Override
            public double value(int i) {
                return ds.value();
            }

            @Override
            public double value(int i0, int i1) {
                return ds.value();
            }

            @Override
            public double value(int i0, int i1, int i2) {
                return ds.value();
            }

            @Override
            public double value(int i0, int i1, int i2, int i3) {
                return ds.value();
            }

            @Override
            public Object property(String name) {
                if (name.equals("QUBE")) {
                    return ds2.property(name);
                }
                return ds.property(name);
            }

            @Override
            public Object property(String name, int i) {
                return ds.property(name);
            }

            @Override
            public int length() {
                return ds2.length();
            }

            @Override
            public int length(int i) {
                return ds2.length(i);
            }

            @Override
            public int length(int i, int j) {
                return ds2.length(i, j);
            }

            @Override
            public int length(int i, int j, int k) {
                return ds2.length(i, j, k);
            }

            @Override
            public <T> T capability(Class<T> clazz) {
                return null;
            }

            @Override
            public QDataSet slice(int i) {
                return new Slice0DataSet(this, i);
            }

            @Override
            public QDataSet trim(int start, int end) {
                return new TrimDataSet(this, start, end);
            }
        };
    }

    static QDataSet increaseRank1(final QDataSet ds, final QDataSet ds2) {
        return new QDataSet(){

            @Override
            public int rank() {
                return ds2.rank();
            }

            @Override
            public double value() {
                throw new IllegalArgumentException("rank too low");
            }

            @Override
            public double value(int i0) {
                return ds.value(i0);
            }

            @Override
            public double value(int i0, int i1) {
                return ds.value(i0);
            }

            @Override
            public double value(int i0, int i1, int i2) {
                return ds.value(i0);
            }

            @Override
            public double value(int i0, int i1, int i2, int i3) {
                return ds.value(i0);
            }

            @Override
            public Object property(String name) {
                if (name.equals("QUBE")) {
                    return ds2.property(name);
                }
                return ds.property(name);
            }

            @Override
            public Object property(String name, int i) {
                return ds.property(name, i);
            }

            @Override
            public int length() {
                return ds2.length();
            }

            @Override
            public int length(int i) {
                return ds2.length(i);
            }

            @Override
            public int length(int i, int j) {
                return ds2.length(i, j);
            }

            @Override
            public int length(int i, int j, int k) {
                return ds2.length(i, j, k);
            }

            @Override
            public <T> T capability(Class<T> clazz) {
                return null;
            }

            @Override
            public QDataSet slice(int i) {
                return new Slice0DataSet(this, i);
            }

            @Override
            public QDataSet trim(int start, int end) {
                return new TrimDataSet(this, start, end);
            }
        };
    }

    static QDataSet increaseRank2(final QDataSet ds, final QDataSet ds2) {
        return new QDataSet(){

            @Override
            public int rank() {
                return ds2.rank();
            }

            @Override
            public double value() {
                throw new IllegalArgumentException("rank too low");
            }

            @Override
            public double value(int i) {
                throw new IllegalArgumentException("rank too low");
            }

            @Override
            public double value(int i0, int i1) {
                return ds.value(i0, i1);
            }

            @Override
            public double value(int i0, int i1, int i2) {
                return ds.value(i0, i1);
            }

            @Override
            public double value(int i0, int i1, int i2, int i3) {
                return ds.value(i0, i1);
            }

            @Override
            public Object property(String name) {
                if (name.equals("QUBE")) {
                    return ds2.property(name);
                }
                return ds.property(name);
            }

            @Override
            public Object property(String name, int i) {
                return ds.property(name, i);
            }

            @Override
            public int length() {
                return ds2.length();
            }

            @Override
            public int length(int i) {
                return ds2.length(i);
            }

            @Override
            public int length(int i, int j) {
                return ds2.length(i, j);
            }

            @Override
            public int length(int i, int j, int k) {
                return ds2.length(i, j, k);
            }

            @Override
            public <T> T capability(Class<T> clazz) {
                return null;
            }

            @Override
            public QDataSet slice(int i) {
                return new Slice0DataSet(this, i);
            }

            @Override
            public QDataSet trim(int start, int end) {
                return new TrimDataSet(this, start, end);
            }
        };
    }
}

