/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.SemanticOps;
import org.virbo.dataset.WritableDataSet;
import org.virbo.dsops.Ops;
import org.virbo.dsutil.AsciiHeadersParser;
import org.virbo.dsutil.DataSetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsciiParser {
    Pattern propertyPattern = null;
    String commentPrefix = "#";
    String[] fieldNames;
    AsciiHeadersParser.BundleDescriptor bundleDescriptor;
    String[] groupNames;
    Units[] units;
    String[] fieldUnits;
    String[] fieldLabels;
    FieldParser[] fieldParsers;
    static final String numberPart = "[\\d\\.eE\\+\\-]+";
    static final String decimalRegex = "[\\d\\.eE\\+\\-]+";
    int skipLines;
    boolean skipColumnHeader = false;
    String headerDelimiter1 = null;
    int recordCountLimit = Integer.MAX_VALUE;
    int fieldCount;
    public static final Pattern NAME_COLON_VALUE_PATTERN = Pattern.compile("\\s*([a-zA-Z_].*?)\\s*\\:\\s*(.+)\\s*");
    public static final Pattern NAME_EQUAL_VALUE_PATTERN = Pattern.compile("\\s*([a-zA-Z_].*?)\\s*\\=\\s*(.+)\\s*");
    Pattern COLUMN_ID_HEADER_PATTERN = Pattern.compile("\\s*\"?([a-zA-Z][a-zA-Z _0-9]*)([\\(\\[]([a-zA-Z_\\.\\[\\-\\]0-9]*)[\\)\\]])?\"?\\s*");
    private static final Pattern COLUMN_CHANNEL_HEADER_PATTERN = Pattern.compile("\\s*\"?(([a-zA-Z_]*)(\\d*\\.?\\d*([eE]\\d+)?)\\-(\\d*\\.?\\d*([eE]\\d+)?))\"?\\s*");
    public static final String PROPERTY_FIELD_NAMES = "fieldNames";
    public static final String PROPERTY_FILE_HEADER = "fileHeader";
    public static final String PROPERTY_FIRST_RECORD = "firstRecord";
    public static final String PROPERTY_FIELD_PARSER = "fieldParser";
    public static final String DELIM_COMMA = ",";
    public static final String DELIM_TAB = "\t";
    public static final String DELIM_WHITESPACE = "\\s+";
    private static final Logger logger = Logger.getLogger("virbo.dataset.asciiparser");
    private static final int HEADER_LENGTH_LIMIT = 1000;
    StringBuffer headerBuffer = new StringBuffer();
    protected String headerDelimiter = null;
    public static final String PROP_HEADERDELIMITER = "headerDelimiter";
    public static final FieldParser DOUBLE_PARSER = new FieldParser(){

        public final double parseField(String field, int columnIndex) {
            if (field.length() == 1) {
                double d = field.charAt(0) - 48;
                return d < 0.0 || d > 9.0 ? Double.NaN : d;
            }
            return Double.parseDouble(field);
        }
    };
    public final FieldParser UNITS_PARSER = new FieldParser(){

        public final double parseField(String field, int columnIndex) throws ParseException {
            Units u = AsciiParser.this.units[columnIndex];
            return u.parse(field).doubleValue(u);
        }
    };
    private boolean keepFileHeader;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private RecordParser recordParser;
    private double fillValue = -1.0E31;
    protected double validMin = Double.NEGATIVE_INFINITY;
    public static final String PROP_VALIDMIN = "validMin";
    protected double validMax = Double.POSITIVE_INFINITY;
    public static final String PROP_VALIDMAX = "validMax";

    private AsciiParser(String[] fieldNames) {
        this.setRegexParser(fieldNames);
    }

    public final boolean isHeader(int iline, String lastLine, String thisLine, int recCount) {
        return iline < this.skipLines || this.headerDelimiter != null && recCount == 0 && (lastLine == null || !Pattern.compile(this.headerDelimiter).matcher(lastLine).find()) || this.commentPrefix != null && thisLine.startsWith(this.commentPrefix);
    }

    public String readFirstRecord(String filename) throws IOException {
        return this.readFirstRecord(new BufferedReader(new FileReader(filename)));
    }

    public String readFirstRecord(BufferedReader reader) throws IOException {
        String lastLine = null;
        int iline = 0;
        String line = reader.readLine();
        while (line != null && this.isHeader(iline, lastLine, line, 0)) {
            lastLine = line;
            line = reader.readLine();
            ++iline;
        }
        reader.close();
        return line;
    }

    public String readFirstParseableRecord(String filename) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        String lastLine = null;
        String line = ((BufferedReader)reader).readLine();
        int iline = 0;
        while (line != null && this.isHeader(iline, lastLine, line, 0)) {
            lastLine = line;
            line = ((BufferedReader)reader).readLine();
            ++iline;
        }
        DataSetBuilder builder = new DataSetBuilder(2, 100, this.recordParser.fieldCount(), 1);
        while (line != null && iline < 1000 && !this.recordParser.tryParseRecord(line, 0, builder)) {
            line = ((BufferedReader)reader).readLine();
            ++iline;
        }
        reader.close();
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int guessSkipLines(String filename, RecordParser recParser) throws IOException {
        BufferedReader reader = null;
        int currentFirstRecord = 0;
        try {
            reader = new LineNumberReader(new FileReader(filename));
            String lastLine = null;
            String line = reader.readLine();
            int iline = 0;
            while (line != null && this.isHeader(iline, lastLine, line, 0)) {
                lastLine = line;
                line = reader.readLine();
                ++iline;
            }
            int currentFieldCount = -1;
            currentFirstRecord = iline;
            int repeatCount = 0;
            while (line != null) {
                int fc = recParser.fieldCount(line);
                if (fc != currentFieldCount) {
                    currentFieldCount = fc;
                    currentFirstRecord = iline;
                    repeatCount = 1;
                } else {
                    ++repeatCount;
                }
                if (repeatCount > 50) {
                    int n = currentFirstRecord;
                    return n;
                }
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        return currentFirstRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelimParser guessSkipAndDelimParser(String filename) throws IOException {
        String header;
        boolean isRichHeader;
        BufferedReader reader = null;
        DelimParser result = null;
        try {
            int i;
            reader = new BufferedReader(new FileReader(filename));
            String lastLine = null;
            String line = reader.readLine();
            int iline = 0;
            this.headerBuffer = new StringBuffer();
            while (line != null && this.isHeader(iline, lastLine, line, 0)) {
                lastLine = line;
                if (iline < 1000) {
                    this.headerBuffer.append(line).append("\n");
                }
                line = reader.readLine();
                ++iline;
            }
            if (line == null) {
                DelimParser delimParser = null;
                return delimParser;
            }
            DelimParser p = this.guessDelimParser(line);
            LinkedList<String> lines = new LinkedList<String>();
            int parseCount = 0;
            while (iline < 1000 && line != null && parseCount < 3) {
                lines.add(line);
                line = reader.readLine();
                ++iline;
                while (lines.size() > 5) {
                    lines.remove(0);
                }
                if (line == null) continue;
                p = this.guessDelimParser(line);
                parseCount = p.tryParseRecord(line, iline, null) ? 1 : 0;
                for (i = 0; i < lines.size(); ++i) {
                    if (!p.tryParseRecord((String)lines.get(i), 0, null)) continue;
                    ++parseCount;
                }
            }
            result = p;
            for (i = 0; i < lines.size(); ++i) {
                if (p.fieldCount((String)lines.get(i)) != p.fieldCount()) continue;
                result = this.createDelimParser((String)lines.get(i), p.getDelim());
                break;
            }
        }
        finally {
            reader.close();
        }
        if (isRichHeader = AsciiParser.isRichHeader(header = this.headerBuffer.toString())) {
            try {
                this.bundleDescriptor = AsciiHeadersParser.parseMetadata(header, this.fieldNames, this.fieldLabels);
                if (this.bundleDescriptor.length() == this.fieldNames.length) {
                    for (int j = 0; j < this.bundleDescriptor.length(); ++j) {
                        String n = (String)this.bundleDescriptor.property("NAME", j);
                        if (n != null) {
                            this.fieldNames[j] = n;
                        }
                        if ((n = (String)this.bundleDescriptor.property("LABEL", j)) == null) continue;
                        this.fieldLabels[j] = n;
                    }
                } else {
                    System.err.println(String.format("rich header buffer not the same length as the dataset (%d!=%d)", this.bundleDescriptor.length(), this.fieldNames.length));
                }
            }
            catch (ParseException ex) {
                Logger.getLogger(AsciiParser.class.getName()).log(Level.SEVERE, null, ex);
            }
            result.header = header;
        }
        return result;
    }

    public DelimParser guessDelimParser(String line) throws IOException {
        String fieldSep = null;
        int tabDelimFieldCount = line.split(DELIM_TAB, -2).length;
        int commaDelimFieldCount = line.split(DELIM_COMMA, -2).length;
        int whitespaceDelimFieldCount = line.split(DELIM_WHITESPACE, -2).length;
        fieldSep = tabDelimFieldCount > 1 && tabDelimFieldCount != whitespaceDelimFieldCount ? DELIM_TAB : (commaDelimFieldCount > 1 && commaDelimFieldCount >= whitespaceDelimFieldCount / 2 ? DELIM_COMMA : DELIM_WHITESPACE);
        DelimParser result = this.createDelimParser(line, fieldSep);
        this.recordParser = result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelimParser setDelimParser(String filename, String delim) throws IOException {
        FileReader r = null;
        DelimParser result = null;
        try {
            r = new FileReader(filename);
            result = this.setDelimParser(r, delim);
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        return result;
    }

    public DelimParser setDelimParser(Reader in, String delimRegex) throws IOException {
        LineNumberReader reader = new LineNumberReader(in);
        String line = this.readFirstRecord(reader);
        reader.close();
        DelimParser result = this.createDelimParser(line, delimRegex);
        this.recordParser = result;
        return result;
    }

    public RecordParser setRegexParser(String[] fieldNames) {
        int i;
        this.fieldCount = fieldNames.length;
        this.fieldNames = fieldNames;
        this.units = new Units[this.fieldCount];
        for (int i2 = 0; i2 < this.fieldCount; ++i2) {
            this.units[i2] = Units.dimensionless;
        }
        StringBuilder regexBuf = new StringBuilder();
        regexBuf.append("\\s*");
        for (i = 0; i < this.fieldCount - 1; ++i) {
            regexBuf.append("([\\d\\.eE\\+\\-]+)[\\s+,+]\\s*");
        }
        this.fieldParsers = new FieldParser[this.fieldCount];
        for (i = 0; i < this.fieldCount; ++i) {
            this.fieldParsers[i] = DOUBLE_PARSER;
        }
        regexBuf.append("([\\d\\.eE\\+\\-]+)\\s*");
        this.recordParser = new RegexParser(regexBuf.toString());
        return this.recordParser;
    }

    public FixedColumnsParser setFixedColumnsParser(String filename, String delim) throws IOException {
        return this.setFixedColumnsParser(new FileReader(filename), delim);
    }

    public FixedColumnsParser setFixedColumnsParser(Reader in, String delim) throws IOException {
        int i;
        LineNumberReader reader = new LineNumberReader(in);
        String line = this.readFirstRecord(reader);
        reader.close();
        int col = 0;
        String[] ss = line.split(delim);
        int[] columnOffsets = new int[ss.length];
        int[] columnWidths = new int[ss.length - 1];
        this.fieldCount = ss.length;
        this.fieldParsers = new FieldParser[ss.length - 1];
        boolean rightJustified = false;
        if (ss[0].trim().length() == 0) {
            rightJustified = true;
            for (i = 0; i < ss.length - 1; ++i) {
                ss[i] = ss[i + 1];
            }
        }
        columnOffsets[0] = 0;
        if (rightJustified) {
            for (i = 1; i < ss.length; ++i) {
                col = line.indexOf(ss[i - 1], columnOffsets[i - 1]);
                columnOffsets[i] = col + ss[i - 1].length();
                columnWidths[i - 1] = columnOffsets[i] - columnOffsets[i - 1];
            }
        } else {
            for (i = 1; i < ss.length; ++i) {
                columnOffsets[i] = col = line.indexOf(ss[i], col + ss[i - 1].length());
                columnWidths[i - 1] = columnOffsets[i] - columnOffsets[i - 1];
            }
        }
        this.fieldNames = new String[this.fieldCount];
        for (i = 1; i < ss.length; ++i) {
            this.fieldParsers[i - 1] = DOUBLE_PARSER;
            this.fieldNames[i - 1] = "field" + (i - 1);
        }
        int[] co = new int[columnWidths.length];
        System.arraycopy(columnOffsets, 0, co, 0, columnWidths.length);
        this.units = new Units[this.fieldCount];
        for (int i2 = 0; i2 < this.fieldCount; ++i2) {
            this.units[i2] = Units.dimensionless;
        }
        FixedColumnsParser p = new FixedColumnsParser(co, columnWidths);
        this.recordParser = p;
        this.propertyPattern = null;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int guessFieldCount(String filename) throws FileNotFoundException, IOException {
        int j;
        int maxFieldCount = 10;
        int[] recCount = new int[10];
        StringBuilder regexBuf = new StringBuilder();
        regexBuf.append("\\s*([\\d\\.eE\\+\\-]+)");
        for (int i = 1; i < 10; ++i) {
            regexBuf.append("([\\s+,+]\\s*([\\d\\.eE\\+\\-]+))?");
        }
        regexBuf.append("\\s*");
        Pattern pat = Pattern.compile(regexBuf.toString());
        BufferedReader reader = null;
        try {
            String line;
            reader = new LineNumberReader(new FileReader(filename));
            block4: while ((line = reader.readLine()) != null) {
                Matcher m = pat.matcher(line);
                if (!m.matches()) continue;
                for (j = 1; j < m.groupCount(); j += 2) {
                    if (m.group(j) != null) continue;
                    int n = (j - 1) / 2;
                    recCount[n] = recCount[n] + 1;
                    continue block4;
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        int max = 0;
        int imax = 0;
        for (j = 1; j < 10; ++j) {
            if (recCount[j] <= max) continue;
            imax = j;
            max = recCount[j];
        }
        return imax;
    }

    public void setFieldParser(int field, FieldParser fp) {
        FieldParser oldFp = this.fieldParsers[field];
        this.fieldParsers[field] = fp;
        if (fp == this.UNITS_PARSER && UnitsUtil.isTimeLocation((Units)this.units[field])) {
            this.setPropertyPattern(null);
        }
        this.propertyChangeSupport.firePropertyChange(PROPERTY_FIELD_PARSER, oldFp, fp);
    }

    public static AsciiParser newParser(int fieldCount) {
        String[] fieldNames = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fieldNames[i] = "field" + i;
        }
        return new AsciiParser(fieldNames);
    }

    public static AsciiParser newParser(String[] fieldNames) {
        return new AsciiParser(fieldNames);
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public void setRecordCountLimit(int recordCountLimit) {
        this.recordCountLimit = recordCountLimit;
    }

    public void setPropertyPattern(Pattern propertyPattern) {
        this.propertyPattern = propertyPattern;
    }

    public void setCommentPrefix(String comment) {
        this.commentPrefix = comment;
    }

    public String getHeaderDelimiter() {
        return this.headerDelimiter;
    }

    public void setHeaderDelimiter(String headerDelimiter) {
        String oldHeaderDelimiter = this.headerDelimiter;
        this.headerDelimiter = headerDelimiter;
        this.propertyChangeSupport.firePropertyChange(PROP_HEADERDELIMITER, oldHeaderDelimiter, headerDelimiter);
    }

    public WritableDataSet readStream(Reader in, ProgressMonitor mon) throws IOException {
        return this.readStream(in, null, mon);
    }

    public WritableDataSet readStream(Reader in, String firstRecord, ProgressMonitor mon) throws IOException {
        BufferedReader reader = new BufferedReader(in);
        String line = null;
        String lastLine = null;
        int iline = 0;
        int irec = 0;
        mon.started();
        DataSetBuilder builder = new DataSetBuilder(2, 100, this.recordParser.fieldCount());
        builder.setFillValue(this.fillValue);
        builder.setValidMax(this.validMax);
        builder.setValidMin(this.validMin);
        long bytesRead = 0L;
        this.headerBuffer = new StringBuffer();
        int skipInt = this.skipLines + (this.skipColumnHeader ? 1 : 0);
        lastLine = line;
        if (firstRecord != null) {
            line = firstRecord;
            firstRecord = null;
        } else {
            line = reader.readLine();
        }
        boolean parsedMeta = false;
        while (line != null) {
            bytesRead += (long)(line.length() + 1);
            ++iline;
            if (irec == this.recordCountLimit || mon.isCancelled()) break;
            mon.setTaskProgress(bytesRead);
            if (iline % 100 == 0) {
                mon.setProgressMessage("reading line " + iline);
            }
            if (this.isHeader(iline, lastLine, line, irec)) {
                if (this.commentPrefix != null && line.startsWith(this.commentPrefix)) {
                    line = line.substring(this.commentPrefix.length());
                }
                if (this.keepFileHeader && iline < 1000) {
                    this.headerBuffer.append(line).append("\n");
                }
            } else {
                if (!parsedMeta) {
                    String header = this.headerBuffer.toString();
                    this.parseMeta(header, builder);
                    if (!AsciiParser.isRichHeader(header)) {
                        builder.putProperty(PROPERTY_FILE_HEADER, header);
                    }
                    parsedMeta = true;
                }
                try {
                    if (firstRecord == null) {
                        firstRecord = line;
                        builder.putProperty(PROPERTY_FIRST_RECORD, firstRecord);
                    }
                    if (this.recordParser.tryParseRecord(line, irec, builder)) {
                        ++irec;
                        builder.nextRecord();
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            lastLine = line;
            line = reader.readLine();
        }
        mon.finished();
        builder.putProperty("USER_PROPERTIES", new HashMap<String, Object>(builder.properties));
        return builder.getDataSet();
    }

    public static boolean isRichHeader(String header) {
        boolean doJSON = header.contains("{") && header.contains("}");
        return doJSON;
    }

    private void parseMeta(String header, DataSetBuilder builder) {
        block10: {
            boolean doJSON = AsciiParser.isRichHeader(header);
            if (doJSON) {
                try {
                    System.err.println("Parsing Rich JSON Header...");
                    this.bundleDescriptor = AsciiHeadersParser.parseMetadata(header, this.getFieldNames(), this.getFieldLabels());
                    builder.putProperty("BUNDLE_1", this.bundleDescriptor);
                    this.bundleDescriptor.property("LABEL", 1);
                    Map<String, Object> props = DataSetUtil.getProperties(this.bundleDescriptor, DataSetUtil.globalProperties(), null);
                    for (String k : props.keySet()) {
                        builder.putProperty(k, props.get(k));
                    }
                    for (int j = 0; j < this.bundleDescriptor.length(); ++j) {
                        Units u = (Units)this.bundleDescriptor.property("UNITS", j);
                        if (u == null) continue;
                        this.fieldParsers[j] = this.UNITS_PARSER;
                        this.units[j] = u;
                    }
                    if (this.bundleDescriptor.length() != this.fieldParsers.length) {
                        System.err.println("lengths check didn't work out");
                    }
                    break block10;
                }
                catch (ParseException ex) {
                    Logger.getLogger(AsciiParser.class.getName()).log(Level.SEVERE, null, ex);
                    System.err.println(ex);
                    if (this.propertyPattern != null) {
                        LinkedHashMap<String, String> userProps = new LinkedHashMap<String, String>();
                        for (String line2 : header.split("\n")) {
                            Matcher m2 = this.propertyPattern.matcher(line2);
                            if (!m2.matches()) continue;
                            userProps.put(m2.group(1).trim(), m2.group(2).trim());
                        }
                        builder.putProperty("USER_PROPERTIES", userProps);
                    }
                    break block10;
                }
            }
            if (this.propertyPattern != null) {
                LinkedHashMap<String, String> userProps = new LinkedHashMap<String, String>();
                for (String line2 : header.split("\n")) {
                    Matcher m2 = this.propertyPattern.matcher(line2);
                    if (!m2.matches()) continue;
                    userProps.put(m2.group(1).trim(), m2.group(2).trim());
                }
                builder.putProperty("USER_PROPERTIES", userProps);
            }
        }
    }

    public Map<String, String> getRichFields() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.bundleDescriptor != null) {
            for (int i = 0; i < this.bundleDescriptor.length(); ++i) {
                String name = (String)this.bundleDescriptor.property("ELEMENT_NAME", i);
                if (name == null || result.containsKey(name)) continue;
                String label = (String)this.bundleDescriptor.property("ELEMENT_LABEL", i);
                int rank = this.bundleDescriptor.length(i);
                int len = 0;
                if (rank > 0) {
                    len = 1;
                    for (int j = 0; j < rank; ++j) {
                        len *= (int)this.bundleDescriptor.value(i, j);
                    }
                }
                if (len == 0) {
                    result.put(name + ": field" + i, label);
                    continue;
                }
                result.put(name + ": field" + i + "-field" + (i + len), label);
                i = i + len - 1;
            }
        }
        return result;
    }

    private static String[] split(String string, String regex) {
        String[] ss = string.trim().split(regex);
        if (string.endsWith(regex)) {
            String[] ss1 = new String[ss.length + 1];
            System.arraycopy(ss, 0, ss1, 0, ss.length);
            ss1[ss1.length - 1] = "";
            ss = ss1;
        }
        return ss;
    }

    private DelimParser createDelimParser(String line, String fieldSep) {
        int i;
        String[] ss = AsciiParser.split(line.trim(), fieldSep);
        this.fieldCount = ss.length;
        this.fieldParsers = new FieldParser[this.fieldCount];
        this.units = new Units[this.fieldCount];
        this.fieldNames = new String[this.fieldCount];
        this.fieldLabels = new String[this.fieldCount];
        this.fieldUnits = new String[this.fieldCount];
        boolean isColumnHeaders = true;
        for (i = 0; i < ss.length; ++i) {
            String n;
            this.units[i] = Units.dimensionless;
            this.fieldParsers[i] = DOUBLE_PARSER;
            Matcher m = this.COLUMN_ID_HEADER_PATTERN.matcher(ss[i]);
            if (m.matches()) {
                n = m.group(1).trim();
                if (n.length() != 3 || !n.equalsIgnoreCase("nan")) {
                    char ch;
                    this.fieldLabels[i] = n;
                    this.fieldNames[i] = Ops.safeName(this.fieldLabels[i]);
                    this.fieldUnits[i] = m.group(3);
                    if (this.fieldUnits[i] == null) continue;
                    this.fieldUnits[i] = this.fieldUnits[i].trim();
                    if (this.fieldUnits[i].length() <= 2 || Character.isLetter(ch = this.fieldUnits[i].charAt(0))) continue;
                    this.fieldLabels[i] = this.fieldLabels[i] + m.group(2);
                    this.fieldUnits[i] = null;
                    continue;
                }
                if (isColumnHeaders) {
                    logger.log(Level.FINEST, "parsed line appears to contain NaN''s, and is not a column header because of field #{0}: {1}", new Object[]{i, ss[i]});
                }
                isColumnHeaders = false;
                continue;
            }
            m = COLUMN_CHANNEL_HEADER_PATTERN.matcher(ss[i]);
            if (m.matches() && m.group(3).length() > 0 && m.group(5).length() > 0) {
                this.fieldLabels[i] = n = m.group(1).trim();
                this.fieldNames[i] = m.group(2).length() > 0 ? n.replaceAll("-", "_") : "ch_" + n.replaceAll("-", "_");
                this.fieldUnits[i] = null;
                continue;
            }
            if (isColumnHeaders) {
                logger.log(Level.FINEST, "first parsed line does not appear to be column header because of field #{0}: {1}", new Object[]{i, ss[i]});
            }
            isColumnHeaders = false;
        }
        if (!isColumnHeaders) {
            for (i = 0; i < this.fieldCount; ++i) {
                if (this.fieldNames[i] != null) continue;
                this.fieldNames[i] = "field" + i;
            }
        } else {
            this.skipColumnHeader = true;
        }
        DelimParser recordParser1 = new DelimParser(this.fieldParsers.length, fieldSep);
        this.propertyPattern = null;
        return recordParser1;
    }

    public FixedColumnsParser setFixedColumnsParser(int[] columnOffsets, int[] columnWidths, FieldParser[] parsers) {
        FixedColumnsParser result = new FixedColumnsParser(columnOffsets, columnWidths);
        this.recordParser = result;
        this.fieldParsers = parsers;
        this.fieldNames = new String[result.fieldCount];
        this.units = new Units[result.fieldCount];
        for (int i = 0; i < result.fieldCount; ++i) {
            this.fieldNames[i] = "field" + i;
            this.units[i] = Units.dimensionless;
        }
        return result;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public String[] getFieldLabels() {
        if (this.fieldLabels == null) {
            this.fieldLabels = new String[this.fieldNames.length];
        }
        for (int i = 0; i < this.fieldLabels.length; ++i) {
            if (this.fieldLabels[i] != null) continue;
            this.fieldLabels[i] = this.fieldNames[i];
        }
        return this.fieldLabels;
    }

    public String[] getFieldUnits() {
        return this.fieldUnits;
    }

    public WritableDataSet readFile(String filename, ProgressMonitor mon) throws IOException {
        long size = new File(filename).length();
        mon.setTaskSize(size);
        return this.readStream(new FileReader(filename), null, mon);
    }

    public static void printAndResetMain(DelimParser dp, String parse, String[] fields) {
        System.err.println("" + parse);
        dp.splitRecord(parse, fields);
        for (int i = 0; i < fields.length; ++i) {
            System.err.println(String.format("%3d %s", i, fields[i]));
            fields[i] = null;
        }
    }

    public static void main(String[] args) throws Exception {
        TimeParser tp = TimeParser.create((String)"%{ignore} %y %m %d %{ignore} %H");
        System.err.println(tp.parse("JF 09 12 02 xxx 04").getTimeDatum());
        AsciiParser parser = AsciiParser.newParser(5);
        DelimParser dp = parser.guessDelimParser("1,2,3,4,5");
        String[] fields = new String[5];
        AsciiParser.printAndResetMain(dp, "1, 2 ,3,4,\"154\"", fields);
        AsciiParser.printAndResetMain(dp, "1,2,3,4,5", fields);
        AsciiParser.printAndResetMain(dp, "\"foo\",1,3,4,5", fields);
        AsciiParser.printAndResetMain(dp, "1,\"foo\",3,4,5", fields);
        AsciiParser.printAndResetMain(dp, "1,\"fo,o\",3,4,5", fields);
        AsciiParser.printAndResetMain(dp, "1, \"fo,o\" ,3,4,5", fields);
        AsciiParser.printAndResetMain(dp, "1, \"he said \"\"boo\"\"!\" ,3,4,\"154\"", fields);
        AsciiParser.printAndResetMain(dp, "1, 2 ,3,4,\"154\"", fields);
        System.err.println("great stuff");
        String file = "/media/mini/data.backup/examples/dat/sarah/2490lintest90005.raw";
        AsciiParser parser2 = AsciiParser.newParser(5);
        parser2.setPropertyPattern(Pattern.compile("\\s*(.+)\\s*\\:\\s*(.+)\\s*"));
        long t0 = System.currentTimeMillis();
        WritableDataSet ds = parser2.readFile(file, (ProgressMonitor)new NullProgressMonitor());
        System.out.println("" + (System.currentTimeMillis() - t0));
        System.out.println(ds.property("Frequency"));
        System.out.println(ds.value(0));
        System.out.flush();
        parser2 = AsciiParser.newParser(5);
        parser2.setSkipLines(30);
        DelimParser rec = parser2.guessDelimParser(parser2.readFirstRecord(file));
        parser2.setPropertyPattern(Pattern.compile("\\s*(.+)\\s*\\:\\s*(.+)\\s*"));
        long t02 = System.currentTimeMillis();
        WritableDataSet ds2 = parser2.readFile(file, (ProgressMonitor)new NullProgressMonitor());
        System.out.println("" + (System.currentTimeMillis() - t02));
        System.out.println(ds2.property("Frequency"));
        for (int j = 0; j < parser2.fieldCount; ++j) {
            System.out.print(ds2.value(0, j) + " ");
        }
        System.out.println();
        System.out.flush();
    }

    public AsciiParser() {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isKeepFileHeader() {
        return this.keepFileHeader;
    }

    public void setKeepFileHeader(boolean keepHeader) {
        boolean oldKeepHeader = this.keepFileHeader;
        this.keepFileHeader = keepHeader;
        this.propertyChangeSupport.firePropertyChange("keepHeader", oldKeepHeader, keepHeader);
    }

    public RecordParser getRecordParser() {
        return this.recordParser;
    }

    public void setRecordParser(RecordParser recordParser) {
        RecordParser oldRecordParser = this.recordParser;
        this.recordParser = recordParser;
        this.propertyChangeSupport.firePropertyChange("recordParser", oldRecordParser, recordParser);
    }

    public Units getUnits(int index) {
        if (this.units[index] == Units.dimensionless && this.fieldUnits[index] != null && this.fieldUnits[index].length() > 0) {
            return SemanticOps.lookupUnits(this.fieldUnits[index]);
        }
        return this.units[index];
    }

    public void setUnits(int index, Units units) {
        this.units[index] = units;
        this.propertyChangeSupport.firePropertyChange("units", null, null);
    }

    public int getFieldIndex(String string) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        int icol = -1;
        if (Pattern.matches("field[0-9]+", string)) {
            icol = Integer.parseInt(string.substring(5));
        } else if (Pattern.matches("[0-9]+", string)) {
            icol = Integer.parseInt(string);
        }
        if (icol >= this.fieldCount) {
            throw new IllegalArgumentException("bad column parameter: the record parser only expects " + this.fieldCount + " columns");
        }
        return icol;
    }

    public double getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(double fillValue) {
        double oldFillValue = this.fillValue;
        this.fillValue = fillValue;
        this.propertyChangeSupport.firePropertyChange("fillValue", new Double(oldFillValue), new Double(fillValue));
    }

    public double getValidMin() {
        return this.validMin;
    }

    public void setValidMin(double validMin) {
        double oldValidMin = this.validMin;
        this.validMin = validMin;
        this.propertyChangeSupport.firePropertyChange(PROP_VALIDMIN, oldValidMin, validMin);
    }

    public double getValidMax() {
        return this.validMax;
    }

    public void setValidMax(double validMax) {
        double oldValidMax = this.validMax;
        this.validMax = validMax;
        this.propertyChangeSupport.firePropertyChange(PROP_VALIDMAX, oldValidMax, validMax);
    }

    public final class FixedColumnsParser
    implements RecordParser {
        int[] columnOffsets;
        int[] columnWidths;
        private int fieldCount;

        public FixedColumnsParser(int[] columnOffsets, int[] columnWidths) {
            this.columnOffsets = columnOffsets;
            this.columnWidths = columnWidths;
            this.fieldCount = columnOffsets.length;
        }

        public int fieldCount() {
            return this.fieldCount;
        }

        public final boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            boolean[] fails = new boolean[this.fieldCount];
            int okayCount = 0;
            int failCount = 0;
            int tryCount = 0;
            for (int i = 0; i < this.fieldCount; ++i) {
                ++tryCount;
                try {
                    double d = AsciiParser.this.fieldParsers[i].parseField(line.substring(this.columnOffsets[i], this.columnOffsets[i] + this.columnWidths[i]), i);
                    ++okayCount;
                    if (builder == null) continue;
                    builder.putValue(irec, i, d);
                    continue;
                }
                catch (NumberFormatException ex) {
                    ++failCount;
                    fails[i] = true;
                    continue;
                }
                catch (ParseException ex) {
                    ++failCount;
                    fails[i] = true;
                }
            }
            if (failCount > 0) {
                System.err.println("error(s) parsing record number " + irec + ": ");
                System.err.println(line);
                char[] lineMarker = new char[this.columnOffsets[this.fieldCount - 1] + this.columnWidths[this.fieldCount - 1]];
                for (int i = 0; i < this.fieldCount; ++i) {
                    if (!fails[i]) continue;
                    for (int j = 0; j < this.columnWidths[i]; ++j) {
                        lineMarker[j + this.columnOffsets[i]] = 45;
                    }
                }
                System.err.println(new String(lineMarker));
            }
            return failCount < tryCount && (okayCount > 1 || failCount < 3);
        }

        public int fieldCount(String line) {
            return line.split("\\s*").length;
        }

        public String[] fields(String line) {
            String[] result = new String[this.fieldCount];
            for (int i = 0; i < this.fieldCount; ++i) {
                result[i] = line.substring(this.columnOffsets[i], this.columnOffsets[i] + this.columnWidths[i]);
            }
            return result;
        }

        public boolean splitRecord(String line, String[] fields) {
            if (line.length() >= this.columnOffsets[this.fieldCount - 1] + this.columnWidths[this.fieldCount - 1]) {
                for (int i = 0; i < this.fieldCount; ++i) {
                    fields[i] = line.substring(this.columnOffsets[i], this.columnOffsets[i] + this.columnWidths[i]);
                }
                return true;
            }
            return false;
        }
    }

    public final class RegexParser
    implements RecordParser {
        Pattern recordPattern;
        int fieldCount;

        public RegexParser(String regex) {
            this.recordPattern = Pattern.compile(regex);
            this.fieldCount = this.recordPattern.matcher("").groupCount();
        }

        public int fieldCount() {
            return this.fieldCount;
        }

        public final boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            Matcher m;
            if (this.recordPattern != null && (m = this.recordPattern.matcher(line)).matches()) {
                try {
                    boolean allInvalid = true;
                    for (int i = 0; i < this.fieldCount; ++i) {
                        try {
                            String parseable = m.group(i + 1);
                            double d = AsciiParser.this.fieldParsers[i].parseField(parseable, i);
                            if (builder != null) {
                                builder.putValue(irec, i, d);
                            }
                            allInvalid = false;
                            continue;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    return !allInvalid;
                }
                catch (ParseException ex) {
                    return false;
                }
            }
            return false;
        }

        public int fieldCount(String line) {
            return line.split("\\s*").length;
        }

        public String[] fields(String line) {
            Matcher m = this.recordPattern.matcher(line);
            String[] fields = new String[m.groupCount() - 1];
            for (int i = 0; i < this.fieldCount; ++i) {
                fields[i] = m.group(i + 1);
            }
            return fields;
        }

        public boolean splitRecord(String line, String[] fields) {
            Matcher m = this.recordPattern.matcher(line);
            if (m.matches()) {
                for (int i = 0; i < this.fieldCount; ++i) {
                    fields[i] = m.group(i + 1);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "RegexParser regex=" + this.recordPattern + "";
        }
    }

    public final class DelimParser
    implements RecordParser {
        int fieldCount;
        String delimRegex;
        Pattern delimPattern;
        boolean[] doParseField;
        public String header = null;

        public DelimParser(int fieldCount, String delim) {
            this.fieldCount = fieldCount;
            this.doParseField = new boolean[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                this.doParseField[i] = true;
            }
            this.delimRegex = delim;
            this.delimPattern = Pattern.compile(delim);
            this.header = "";
        }

        public String getDelim() {
            return this.delimRegex;
        }

        public boolean tryParseRecord(String line, int irec, DataSetBuilder builder) {
            int j = 0;
            int okayCount = 0;
            int failCount = 0;
            int tryCount = 0;
            boolean ipos = false;
            if (this.fieldCount != AsciiParser.this.fieldParsers.length) {
                return false;
            }
            String[] ss = new String[this.fieldCount];
            if (!this.splitRecord(line, ss)) {
                return false;
            }
            for (j = 0; j < this.fieldCount; ++j) {
                ++tryCount;
                if (!this.doParseField[j]) continue;
                String parseable = ss[j];
                try {
                    double d = AsciiParser.this.fieldParsers[j].parseField(parseable, j);
                    if (builder != null) {
                        builder.putValue(irec, j, d);
                    }
                    ++okayCount;
                    continue;
                }
                catch (ParseException e) {
                    ++failCount;
                    if (builder == null) continue;
                    builder.putValue(irec, j, -1.0E31);
                    continue;
                }
                catch (NumberFormatException e) {
                    ++failCount;
                    if (builder == null) continue;
                    builder.putValue(irec, j, -1.0E31);
                }
            }
            return failCount < tryCount && (okayCount > 1 || failCount < 3);
        }

        public int fieldCount() {
            return this.fieldCount;
        }

        public int fieldCount(String line) {
            return this.fields(line).length;
        }

        public void setSkipField(int ifield, boolean skip) {
            this.doParseField[ifield] = !skip;
        }

        public String[] fields(String line) {
            String[] many = new String[1000];
            this.splitRecord(line, many);
            int count = 0;
            for (int i = 0; i < many.length; ++i) {
                if (many[i] != null) continue;
                count = i;
                break;
            }
            String[] ss = new String[count];
            System.arraycopy(many, 0, ss, 0, count);
            return ss;
        }

        public boolean splitRecord(String input, String[] fields) {
            int index = 0;
            int ifield = 0;
            Matcher m = this.delimPattern.matcher(input);
            boolean tabDelim = this.delimPattern.pattern().equals(AsciiParser.DELIM_TAB);
            char quote = '\"';
            int len = input.length();
            int index0 = index;
            int qend = -1;
            while (ifield < fields.length && index < len) {
                while (index < len && !tabDelim && Character.isWhitespace(input.charAt(index))) {
                    ++index;
                }
                if (index == len) break;
                if (input.charAt(index) == quote) {
                    index0 = ++index;
                    int i1 = input.indexOf(quote, index);
                    if (i1 == -1) {
                        System.err.println("unclosed quote: " + input);
                        continue;
                    }
                    while (i1 + 1 < input.length() && input.charAt(i1 + 1) == quote) {
                        if ((i1 = input.indexOf(quote, i1 + 2)) != -1) continue;
                        throw new IllegalArgumentException("unclosed quote");
                    }
                    index = i1 + 1;
                    qend = i1;
                    if (index != len) continue;
                    fields[ifield] = input.substring(index0, qend);
                    ++ifield;
                    continue;
                }
                if (m.find(index)) {
                    if (qend == -1) {
                        index0 = index;
                    }
                    index = m.start();
                    if (qend == -1) {
                        fields[ifield] = input.substring(index0, index);
                    } else {
                        if (qend < index0) {
                            return false;
                        }
                        fields[ifield] = input.substring(index0, qend).replaceAll("\"\"", "\"");
                        qend = -1;
                    }
                    index0 = index = m.end();
                    ++ifield;
                    continue;
                }
                if (ifield == fields.length - 1) {
                    fields[ifield] = qend == -1 ? input.substring(index0) : input.substring(index0, qend);
                    ++ifield;
                    index = len;
                    continue;
                }
                fields[ifield] = input.substring(index0);
                return false;
            }
            return ifield == fields.length && index == len;
        }

        public String toString() {
            return "AsciiParser.DelimParser: regex=" + this.delimRegex;
        }
    }

    public static interface FieldParser {
        public double parseField(String var1, int var2) throws ParseException;
    }

    public static interface RecordParser {
        public boolean tryParseRecord(String var1, int var2, DataSetBuilder var3);

        public int fieldCount();

        public int fieldCount(String var1);

        public String[] fields(String var1);

        public boolean splitRecord(String var1, String[] var2);
    }
}

