/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.IndexGenDataSet;
import org.virbo.dataset.JoinDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.dsops.Ops;
import org.virbo.math.fft.ComplexArray;
import org.virbo.math.fft.GeneralFFT;

public class FFTUtil {
    public static QDataSet fftPower(GeneralFFT fft, QDataSet vds) {
        return FFTUtil.fftPower(fft, vds, FFTUtil.getWindowUnity(vds.length()));
    }

    public static QDataSet window(QDataSet ds, int size) {
        JoinDataSet jds = new JoinDataSet(2);
        JoinDataSet dep1 = new JoinDataSet(2);
        int idx = 0;
        DDataSet ttags = DDataSet.createRank1(ds.length() / size);
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 == null) {
            dep0 = Ops.dindgen(ds.length());
        }
        ttags.putProperty("UNITS", SemanticOps.getUnits(dep0));
        DDataSet offsets = null;
        boolean qube = true;
        while (idx + size < ds.length()) {
            DDataSet offsets1 = DDataSet.createRank1(size);
            for (int i = 0; i < size; ++i) {
                offsets1.putValue(i, dep0.value(idx + i) - dep0.value(idx));
                if (offsets != null && offsets.value(i) != offsets1.value(i)) {
                    qube = false;
                }
                offsets = offsets1;
            }
            offsets1.putProperty("UNITS", SemanticOps.getUnits(dep0).getOffsetUnits());
            jds.join(DataSetOps.trim(ds, idx, size));
            dep1.join(offsets1);
            ttags.putValue(idx / size, dep0.value(idx));
            idx += size;
        }
        jds.putProperty("DEPEND_0", ttags);
        if (qube) {
            jds.putProperty("DEPEND_1", offsets);
        } else {
            jds.putProperty("DEPEND_1", dep1);
        }
        return jds;
    }

    public static QDataSet getWindowUnity(final int size) {
        AbstractDataSet unity = new AbstractDataSet(){

            public int rank() {
                return 1;
            }

            public int length() {
                return size;
            }

            public double value(int i) {
                return 1.0;
            }
        };
        return unity;
    }

    public static QDataSet getWindow10PercentEdgeCosine(int size) {
        int i;
        int n = size;
        int maxlim = 410;
        int lim = Math.min(n / 10, maxlim);
        double[] ww = new double[n];
        double step = Math.PI / (double)lim;
        for (i = 0; i < lim; ++i) {
            ww[i] = (1.0 - Math.cos(step * (double)i)) / 2.0;
            ww[n - i - 1] = ww[i];
        }
        for (i = lim; i < size - lim; ++i) {
            ww[i] = 1.0;
        }
        return DDataSet.wrap(ww);
    }

    public static QDataSet getWindowHanning(int size) {
        int n = size;
        int maxlim = 410;
        double[] ww = new double[n];
        int halfsize = size / 2;
        for (int k = 0; k < size; ++k) {
            ww[k] = 1.0 + Math.cos(Math.PI * 2 * (double)(k - halfsize) / (double)size);
        }
        return DDataSet.wrap(ww);
    }

    public static QDataSet fftPower(GeneralFFT fft, QDataSet vds, QDataSet weights) {
        double binsize;
        QDataSet xtags;
        Units xUnits;
        double[] yreal = new double[fft.size()];
        for (int i = 0; i < fft.size(); ++i) {
            yreal[i] = vds.value(i) * weights.value(i);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        QDataSet dep0 = (QDataSet)vds.property("DEPEND_0");
        if (dep0 == null) {
            dep0 = new IndexGenDataSet(vds.length());
        }
        if ((xUnits = (Units)(xtags = FFTUtil.getFrequencyDomainTags(dep0)).property("UNITS")).isConvertableTo(Units.hertz)) {
            UnitsConverter uc = xUnits.getConverter(Units.hertz);
            binsize = 2.0 * uc.convert(xtags.value(xtags.length() / 2)) / (double)fft.size();
        } else {
            binsize = 2.0 * xtags.value(xtags.length() / 2) / (double)fft.size();
        }
        DDataSet result = DDataSet.createRank1(xtags.length() / 2 - 1);
        QDataSet powTags = FFTUtil.getFrequencyDomainTagsForPower(dep0);
        for (int i = 1; i < xtags.length() / 2; ++i) {
            result.putValue(i - 1, 4.0 * ComplexArray.magnitude2(ca, i) / binsize);
        }
        result.putProperty("DEPEND_0", powTags);
        return result;
    }

    public static QDataSet getFrequencyDomainTagsForPower(QDataSet dep0) {
        QDataSet xtags = FFTUtil.getFrequencyDomainTags(dep0);
        Units xUnits = (Units)xtags.property("UNITS");
        DDataSet powTags = DDataSet.createRank1(xtags.length() / 2 - 1);
        for (int i = 1; i < xtags.length() / 2; ++i) {
            powTags.putValue(i - 1, xtags.value(i));
        }
        powTags.putProperty("UNITS", xUnits);
        return powTags;
    }

    public static ComplexArray.Double fft(GeneralFFT fft, QDataSet vds) {
        double[] yreal = new double[vds.length()];
        for (int i = 0; i < vds.length(); ++i) {
            yreal[i] = vds.value(i);
        }
        ComplexArray.Double ca = ComplexArray.newArray(yreal);
        fft.transform(ca);
        return ca;
    }

    public static double[] getFrequencyDomainTags(double fs, int size) {
        int i;
        double[] result = new double[size];
        int n = size;
        int n21 = n / 2 + 1;
        for (i = 0; i < n21; ++i) {
            result[i] = fs / (double)n * (double)i;
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = fs / (double)n * (double)(n21 - n + i);
        }
        return result;
    }

    public static QDataSet getFrequencyDomainTags(QDataSet timeDomainTags) {
        int i;
        Units timeUnit = (Units)timeDomainTags.property("UNITS");
        if (timeUnit == null) {
            timeUnit = Units.dimensionless;
        }
        QDataSet x = timeDomainTags;
        double[] result = new double[x.length()];
        result[0] = 0.0;
        double T = x.value(1) - x.value(0);
        int n = x.length();
        int n21 = n / 2 + 1;
        Units frequencyUnit = UnitsUtil.getInverseUnit((Units)timeUnit.getOffsetUnits());
        if (T > 0.5 && frequencyUnit == Units.megaHertz) {
            frequencyUnit = Units.kiloHertz;
            T /= 1000.0;
        }
        for (i = 0; i < n21; ++i) {
            result[i] = (double)i / ((double)n * T);
        }
        for (i = 0; i < n21 - 2; ++i) {
            result[i + n21] = (double)(n21 - n + i) / ((double)n * T);
        }
        DDataSet r = DDataSet.wrap(result);
        r.putProperty("UNITS", frequencyUnit);
        return r;
    }
}

