/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dsutil.ValuesTreeModel;

public class PropertiesTreeModel
extends DefaultTreeModel {
    QDataSet ds;
    String dsLabel;
    MutableTreeNode mroot;

    public PropertiesTreeModel(QDataSet ds, int valuesSizeLimit) {
        this(null, ds, valuesSizeLimit);
    }

    public PropertiesTreeModel(String prefix, QDataSet ds, int valuesSizeLimit) {
        super(new DefaultMutableTreeNode((prefix == null ? "" : prefix) + DataSetUtil.toString(ds)));
        this.mroot = (MutableTreeNode)this.root;
        this.ds = ds;
        Map<String, Object> properties = DataSetUtil.getProperties(ds);
        for (String key : properties.keySet()) {
            MutableTreeNode nextChild;
            int i;
            Object value = properties.get(key);
            if (key.equals("BUNDLE_1") && value instanceof QDataSet) {
                QDataSet bdsd = (QDataSet)value;
                String svalue = "";
                if (bdsd.length() > 0) {
                    svalue = svalue + bdsd.property("NAME", 0);
                }
                for (i = 1; i < bdsd.length(); ++i) {
                    svalue = svalue + "," + bdsd.property("NAME", i);
                }
                nextChild = new DefaultMutableTreeNode("" + key + "=" + svalue);
            } else if (value instanceof QDataSet) {
                PropertiesTreeModel model = new PropertiesTreeModel(key + "=", (QDataSet)value, valuesSizeLimit);
                nextChild = (MutableTreeNode)model.getRoot();
            } else if (value.getClass().isArray()) {
                value.getClass().getComponentType();
                ArrayList<Object> list = new ArrayList<Object>();
                int nn = Math.min(Array.getLength(value), 5);
                for (i = 0; i < nn; ++i) {
                    list.add(Array.get(value, i));
                }
                if (Array.getLength(value) > 5) {
                    list.add("...");
                }
                nextChild = new DefaultMutableTreeNode("" + key + "=" + list);
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                nextChild = (MutableTreeNode)new MapTreeModel(key + " (map)", (Map)value).getRoot();
            } else {
                Units u;
                String svalue = String.valueOf(value);
                if (value instanceof Number && (key.equals("VALID_MIN") || key.equals("VALID_MAX") || key.equals("TYPICAL_MIN") || key.equals("TYPICAL_MAX")) && (u = (Units)properties.get("UNITS")) != null && UnitsUtil.isTimeLocation((Units)u)) {
                    svalue = u.isValid(((Number)value).doubleValue()) ? u.createDatum((Number)value).toString() + " (" + svalue + ")" : "fill (" + svalue + ")";
                }
                nextChild = new DefaultMutableTreeNode("" + key + "=" + svalue);
            }
            this.mroot.insert(nextChild, this.mroot.getChildCount());
        }
        if (ds.rank() > 0) {
            DefaultMutableTreeNode values = new DefaultMutableTreeNode("values");
            ValuesTreeModel.valuesTreeNode("value(", values, ds, valuesSizeLimit);
            this.mroot.insert(values, this.mroot.getChildCount());
        }
    }

    class MapTreeModel
    extends DefaultTreeModel {
        MapTreeModel(Object root, Map values) {
            super(new DefaultMutableTreeNode(root));
            MutableTreeNode mrt = (MutableTreeNode)this.getRoot();
            Iterator i$ = values.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry o;
                Map.Entry val = o = i$.next();
                mrt.insert(new DefaultMutableTreeNode("" + val.getKey() + "=" + val.getValue()), mrt.getChildCount());
            }
        }
    }
}

