/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.dsutil;

import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.FormatStringFormatter;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import test.BundleBinsDemo;

public class QDataSetTableModel
extends AbstractTableModel {
    QDataSet ds;
    QDataSet wds;
    QDataSet bundle1;
    QDataSet dep0;
    QDataSet dep1;
    int dep0Offset;
    int colCount;
    Units[] units;
    String[] labels;
    DatumFormatter[] df;

    public QDataSetTableModel(QDataSet ds) {
        this.ds = ds;
        this.wds = DataSetUtil.weightsDataSet(ds);
        this.dep0 = (QDataSet)ds.property("DEPEND_0");
        this.dep0Offset = this.dep0 == null ? 0 : 1;
        this.bundle1 = (QDataSet)ds.property("BUNDLE_1");
        this.dep1 = (QDataSet)ds.property("DEPEND_1");
        this.colCount = this.dep0Offset;
        this.colCount = ds.rank() == 1 ? ++this.colCount : (this.colCount += ds.length() == 0 ? 0 : ds.length(0));
        this.units = new Units[this.colCount];
        this.labels = new String[this.colCount];
        this.df = new DatumFormatter[this.colCount];
        int i = 0;
        if (this.dep0 != null) {
            this.units[i] = SemanticOps.getUnits(this.dep0);
            this.df[i] = this.units[i].getDatumFormatterFactory().defaultFormatter();
            this.labels[i] = (String)this.dep0.property("LABEL");
            ++i;
        }
        if (this.bundle1 != null) {
            for (int j = 0; j < this.bundle1.length(); ++j) {
                int k;
                int n = 1;
                for (k = 0; k < this.bundle1.length(j); ++k) {
                    n = (int)((double)n * this.bundle1.value(j, k));
                }
                for (k = 0; k < n; ++k) {
                    String format;
                    this.units[i] = (Units)this.bundle1.property("UNITS", j);
                    if (this.units[i] == null) {
                        this.units[i] = Units.dimensionless;
                    }
                    this.df[i] = (format = (String)this.bundle1.property("FORMAT", j)) == null ? this.units[i].getDatumFormatterFactory().defaultFormatter() : this.getDataFormatter(format, this.units[i]);
                    this.labels[i] = (String)this.bundle1.property("LABEL", j);
                    if (this.labels[i] == null) {
                        this.labels[i] = (String)this.bundle1.property("NAME", j);
                    }
                    ++i;
                }
            }
        } else if (this.dep1 != null) {
            Units dep1Units = SemanticOps.getUnits(this.dep1);
            if (dep1Units == null) {
                dep1Units = Units.dimensionless;
            }
            for (int k = 0; k < this.dep1.length(); ++k) {
                this.units[i] = SemanticOps.getUnits(ds);
                this.df[i] = this.units[i].getDatumFormatterFactory().defaultFormatter();
                this.labels[i] = dep1Units.createDatum(this.dep1.value(k)).toString();
                ++i;
            }
        }
        if (this.ds.rank() == 1) {
            this.labels[i] = (String)this.ds.property("LABEL");
            if (this.labels[i] == null) {
                this.labels[i] = "data";
            }
            this.units[i] = SemanticOps.getUnits(ds);
            this.df[i] = this.units[i].getDatumFormatterFactory().defaultFormatter();
            if (!this.identifiesUnits(this.labels[i], this.units[i])) {
                int n = i;
                this.labels[n] = this.labels[n] + " (" + this.units[i] + ")";
            }
            ++i;
        }
        for (i = 0; i < this.units.length; ++i) {
            if (this.units[i] == null) {
                this.units[i] = Units.dimensionless;
                this.df[i] = this.units[i].getDatumFormatterFactory().defaultFormatter();
            }
            if (this.labels[i] != null) continue;
            this.labels[i] = "col " + i;
        }
    }

    private DatumFormatter getDataFormatter(String df, Units u) {
        try {
            if (!df.contains("%")) {
                df = "%" + df;
            }
            return new FormatStringFormatter(df, false);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            return u.getDatumFormatterFactory().defaultFormatter();
        }
    }

    private boolean identifiesUnits(String s, Units u) {
        return s.contains(String.valueOf(u));
    }

    public int getRowCount() {
        return this.ds.length();
    }

    public int getColumnCount() {
        return this.colCount;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < this.dep0Offset) {
            Datum d = this.units[columnIndex].createDatum(this.dep0.value(rowIndex));
            return this.df[columnIndex].format(d, this.units[columnIndex]);
        }
        if (this.ds.rank() == 1) {
            if (this.wds.value(rowIndex) == 0.0) {
                return "fill (" + this.ds.value(rowIndex) + ")";
            }
            Datum d = this.units[columnIndex].createDatum(this.ds.value(rowIndex));
            return this.df[columnIndex].format(d, this.units[columnIndex]);
        }
        if (this.ds.rank() == 2) {
            if (this.wds.value(rowIndex, columnIndex - this.dep0Offset) == 0.0) {
                return "fill (" + this.ds.value(rowIndex, columnIndex - this.dep0Offset) + ")";
            }
            Datum d = this.units[columnIndex].createDatum(this.ds.value(rowIndex, columnIndex - this.dep0Offset));
            return this.df[columnIndex].format(d, this.units[columnIndex]);
        }
        return "?????";
    }

    public TableColumnModel getTableColumnModel() {
        DefaultTableColumnModel result = new DefaultTableColumnModel();
        QDataSet bds = (QDataSet)this.ds.property("BUNDLE_1");
        if (bds != null) {
            bds = DataSetOps.flattenBundleDescriptor(bds);
        }
        for (int i = 0; i < this.colCount; ++i) {
            TableColumn c = new TableColumn(i);
            Units u = null;
            if (i < this.dep0Offset) {
                c.setHeaderValue(this.dep0.property("LABEL"));
                u = (Units)this.dep0.property("UNITS");
            } else {
                c.setHeaderValue(this.labels[i]);
                u = bds == null ? (Units)this.ds.property("UNITS") : (Units)bds.property("UNITS", i - this.dep0Offset);
            }
            c.setPreferredWidth(u != null && UnitsUtil.isTimeLocation((Units)u) ? 150 : 80);
            c.setMinWidth(u != null && UnitsUtil.isTimeLocation((Units)u) ? 130 : 80);
            result.addColumn(c);
        }
        return result;
    }

    public String getColumnName(int i) {
        if (i < this.dep0Offset) {
            return (String)this.dep0.property("LABEL");
        }
        return this.labels[i];
    }

    public static void main(String[] args) {
        QDataSet ds = BundleBinsDemo.demo1();
        QDataSetTableModel m = new QDataSetTableModel(ds);
        JTable t = new JTable();
        t.setModel(m);
        t.setColumnModel(m.getTableColumnModel());
        JFrame frame = new JFrame();
        frame.getContentPane().add(t);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

