/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.autoplot.html.AsciiTableMaker;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParserCallback
extends HTMLEditorKit.ParserCallback {
    int state;
    int tableCount = -1;
    int itable = 0;
    String stable = null;
    boolean inTable = false;
    List<String> currentRow;
    String currentField;
    int fieldCount = -1;
    boolean inField = false;
    boolean inRow = false;
    String fieldText = "";
    boolean isHeader = false;
    int icolspan;
    AsciiTableMaker ascii = new AsciiTableMaker();
    List<String> tables = new ArrayList<String>();

    void setTable(String name) {
        this.stable = name;
        try {
            this.itable = Integer.parseInt(name);
        }
        catch (NumberFormatException ex) {
            this.itable = -1;
        }
    }

    @Override
    public void handleText(char[] data, int pos) {
        if (this.inField) {
            this.fieldText = this.fieldText + new String(data);
            if (this.fieldText.length() > 30) {
                this.fieldText = this.fieldText.substring(0, 27) + "...";
            }
        }
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t == HTML.Tag.TABLE) {
            ++this.tableCount;
            String tableName = (String)a.getAttribute("id");
            if (tableName == null) {
                tableName = "" + this.tableCount;
            }
            this.tables.add(tableName);
            if (this.itable > -1) {
                if (this.tableCount == this.itable) {
                    this.inTable = true;
                }
            } else if (this.stable.equals(a.getAttribute("id"))) {
                this.inTable = true;
            }
        } else if (this.inTable) {
            if (t == HTML.Tag.TR) {
                this.currentRow = new ArrayList<String>();
                this.inRow = true;
            } else if (t == HTML.Tag.TH) {
                String colspan = (String)a.getAttribute(HTML.Attribute.COLSPAN);
                this.icolspan = colspan != null ? Integer.parseInt(colspan) : 1;
                this.inField = true;
                this.fieldText = "";
                this.isHeader = true;
            } else if (t == HTML.Tag.TD) {
                this.inField = true;
                this.fieldText = "";
                this.isHeader = false;
            }
        }
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        if (t == HTML.Tag.TABLE) {
            if (this.inTable) {
                this.inTable = false;
            }
        } else if (this.inTable) {
            if (t == HTML.Tag.TR) {
                this.inRow = false;
                if (this.fieldCount == -1) {
                    this.fieldCount = this.currentRow.size();
                }
                if (this.currentRow.size() != this.fieldCount) {
                    System.err.println("skipping row because of field count");
                }
                if (this.isHeader) {
                    this.ascii.addHeader(this.currentRow);
                } else {
                    this.ascii.addRecord(this.currentRow);
                }
            } else if (t == HTML.Tag.TH) {
                this.inField = false;
                this.currentRow.add(this.fieldText);
                for (int i = 1; i < this.icolspan; ++i) {
                    this.currentRow.add(this.fieldText);
                }
                this.fieldText = "";
            } else if (t == HTML.Tag.TD) {
                this.inField = false;
                this.currentRow.add(this.fieldText);
                this.fieldText = "";
            }
        }
    }

    public QDataSet getDataSet() {
        DDataSet result = this.ascii.getDataSet();
        if (this.itable == -1) {
            result.putProperty("NAME", (Object)this.stable);
        }
        return result;
    }

    public List<String> getTables() {
        return new ArrayList<String>(this.tables);
    }
}

