/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.autoplot.html.HtmlTableParser;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.AbstractDataSourceFactory;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTableParserFactory
extends AbstractDataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new HtmlTableParser(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "column=", "the name (or number) of the column to plot"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "table=", "the table name (or number) of the table"));
            return result;
        }
        return Collections.emptyList();
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        URISplit split = URISplit.parse((String)surl);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        if (params.get("column") == null) {
            return true;
        }
        return params.get("table") == null;
    }
}

