/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.ascii;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.EnumerationDatumFormatter;
import org.das2.datum.format.FormatStringFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.datum.format.TimeDatumFormatterFactory;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONException;
import org.json.JSONObject;
import org.virbo.dataset.BundleDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.SemanticOps;
import org.virbo.datasource.AbstractDataSourceFormat;

public class AsciiTableDataSourceFormat
extends AbstractDataSourceFormat {
    private DatumFormatter getTimeFormatter(String ft) {
        DatumFormatter tformat;
        String ft0 = ft;
        if ((ft = ft.toLowerCase()).equals("iso8601")) {
            tformat = TimeDatumFormatterFactory.getInstance().defaultFormatter();
        } else if (ft0.startsWith("%") || ft.startsWith("$")) {
            if (ft0.startsWith("$")) {
                ft0 = ft0.replaceAll("\\$", "%");
            }
            try {
                tformat = new TimeDatumFormatter(ft0);
            }
            catch (ParseException ex) {
                Logger.getLogger(AsciiTableDataSourceFormat.class.getName()).log(Level.SEVERE, null, ex);
                ex.printStackTrace();
                try {
                    tformat = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%S");
                }
                catch (ParseException ex1) {
                    throw new RuntimeException(ex1);
                }
            }
        } else {
            try {
                if (ft.equals("day")) {
                    tformat = new TimeDatumFormatter("%Y-%m-%d");
                } else if (ft.equals("hour")) {
                    tformat = new TimeDatumFormatter("%Y-%m-%dT%H:%MZ");
                } else if (ft.startsWith("min")) {
                    tformat = new TimeDatumFormatter("%Y-%m-%dT%H:%MZ");
                } else if (ft.startsWith("sec")) {
                    tformat = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%SZ");
                } else if (ft.startsWith("millisec")) {
                    tformat = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%S.%{milli}Z");
                } else if (ft.startsWith("microsec")) {
                    tformat = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%S.%{milli}%{micro}Z");
                } else {
                    System.err.println("not implemented: " + ft);
                    tformat = new TimeDatumFormatter("%Y-%m-%dT%H:%M:%S");
                }
            }
            catch (ParseException ex) {
                ex.printStackTrace();
                tformat = TimeDatumFormatterFactory.getInstance().defaultFormatter();
            }
        }
        return tformat;
    }

    private DatumFormatter getDataFormatter(String df, Units u) {
        try {
            if (!df.contains("%")) {
                df = "%" + df;
            }
            return new FormatStringFormatter(df, false);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            return u.getDatumFormatterFactory().defaultFormatter();
        }
    }

    private void maybeOutputProperty(PrintWriter out, QDataSet data, String property) {
        Object v = data.property(property);
        if (v != null) {
            out.println("# " + property + ": " + v);
        }
    }

    private void jsonProp(JSONObject jo1, QDataSet ds, String prop, int i) throws JSONException {
        Object o = ds.property(prop, i);
        if (o != null) {
            if (o instanceof QDataSet) {
                jo1.put(prop, (Object)o.toString());
            } else if (o instanceof Number) {
                jo1.put(prop, (Object)((Number)o));
            } else {
                jo1.put(prop, (Object)String.valueOf(o));
            }
        }
    }

    private void formatBundleDesc(PrintWriter out, QDataSet bundleDesc) throws JSONException {
        JSONObject jo = new JSONObject();
        for (int i = 0; i < bundleDesc.length(); ++i) {
            String name = (String)bundleDesc.property("NAME", i);
            if (name == null) {
                System.err.println("unnamed dataset!");
                name = "field" + i;
            }
            JSONObject jo1 = new JSONObject();
            this.jsonProp(jo1, bundleDesc, "LABEL", i);
            this.jsonProp(jo1, bundleDesc, "UNITS", i);
            this.jsonProp(jo1, bundleDesc, "VALID_MIN", i);
            this.jsonProp(jo1, bundleDesc, "VALID_MAX", i);
            this.jsonProp(jo1, bundleDesc, "FILL_VALUE", i);
            this.jsonProp(jo1, bundleDesc, "DEPEND_0", i);
            this.jsonProp(jo1, bundleDesc, "START_INDEX", i);
            this.jsonProp(jo1, bundleDesc, "DIMENSION", i);
            jo.put(name, (Object)jo1);
        }
        String json = jo.toString(3);
        String[] lines = json.split("\n");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            sb.append("# ").append(lines[i]).append("\n");
        }
        out.print(sb.toString());
    }

    private void formatBundle(PrintWriter out, QDataSet data, ProgressMonitor mon) {
        int i;
        QDataSet bundleDesc = (QDataSet)data.property("BUNDLE_1");
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        String head = this.getParam("header", "");
        if (bundleDesc != null && "rich".equals(head)) {
            try {
                this.formatBundleDesc(out, bundleDesc);
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
        } else {
            this.maybeOutputProperty(out, data, "TITLE");
        }
        DatumFormatter tf = this.getTimeFormatter(this.getParam("timeformat", "ISO8601"));
        String df = this.getParam("format", "");
        DatumFormatter[] formats = new DatumFormatter[data.length(0)];
        Units[] uu = new Units[data.length(0)];
        if (bundleDesc == null) {
            throw new IllegalArgumentException("expected to find bundleDesc in dataset!");
        }
        int jj = 0;
        for (i = 0; i < bundleDesc.length(); ++i) {
            String ff;
            jj = i;
            uu[jj] = (Units)bundleDesc.property("UNITS", i);
            if (uu[jj] == null) {
                uu[jj] = Units.dimensionless;
            }
            formats[jj] = !(uu[jj] instanceof EnumerationUnits) ? (df.equals("") ? ((ff = (String)bundleDesc.property("FORMAT", jj)) == null ? uu[jj].createDatum(data.value(0, jj)).getFormatter() : this.getDataFormatter(ff, uu[jj])) : this.getDataFormatter(df, uu[jj])) : uu[jj].createDatum(data.value(0, jj)).getFormatter();
            if (formats[jj] instanceof EnumerationDatumFormatter) {
                // empty if block
            }
            ++jj;
        }
        if (bundleDesc != null) {
            if (dep0 != null) {
                String l = (String)dep0.property("LABEL");
                if (l == null) {
                    l = Units.t2000.isConvertableTo(SemanticOps.getUnits((QDataSet)dep0)) ? "time(UTC)" : "dep0";
                }
                out.print(" " + l + ", ");
            }
            for (i = 0; i < bundleDesc.length(); ++i) {
                int k;
                String l1 = (String)bundleDesc.property("LABEL", i);
                if (l1 == null && (l1 = (String)bundleDesc.property("NAME", i)) == null) {
                    throw new IllegalArgumentException("unnamed dataset in bundle at index " + i);
                }
                if (l1.trim().length() == 0) {
                    Units u1 = (Units)bundleDesc.property("UNITS", i);
                    l1 = u1 != null && Units.t2000.isConvertableTo(u1) ? "time(UTC)" : "field" + i;
                }
                int nelements = 1;
                for (k = 0; k < bundleDesc.length(i); ++k) {
                    nelements = (int)((double)nelements * bundleDesc.value(i, k));
                }
                for (k = 0; k < nelements; ++k) {
                    out.print(l1);
                    if (i == bundleDesc.length() - 1 && k == nelements - 1) {
                        out.print("\n");
                        continue;
                    }
                    out.print(", ");
                }
            }
        }
        DatumFormatter cf0 = tf;
        Units u0 = null;
        if (dep0 != null) {
            u0 = (Units)dep0.property("UNITS");
            if (u0 == null) {
                u0 = Units.dimensionless;
            }
            if (!UnitsUtil.isTimeLocation((Units)u0) && dep0.length() > 0) {
                cf0 = df.equals("") ? u0.createDatum(dep0.value(0)).getFormatter() : this.getDataFormatter(df, uu[jj]);
            }
        }
        mon.setTaskSize((long)data.length());
        mon.started();
        for (int i2 = 0; i2 < data.length(); ++i2) {
            int j;
            mon.setTaskProgress((long)i2);
            if (mon.isCancelled()) break;
            if (dep0 != null) {
                out.print("" + cf0.format(u0.createDatum(dep0.value(i2))) + ", ");
            }
            for (j = 0; j < data.length(i2) - 1; ++j) {
                out.print(formats[j].format(uu[j].createDatum(data.value(i2, j)), uu[j]) + ", ");
            }
            out.println(formats[j].format(uu[j].createDatum(data.value(i2, j)), uu[j]));
        }
        mon.finished();
    }

    private void formatRank2(PrintWriter out, QDataSet data, ProgressMonitor mon) {
        DatumFormatter df;
        QDataSet dep1 = (QDataSet)data.property("DEPEND_1");
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        Object format = null;
        String head = this.getParam("header", "");
        if ("rich".equals(head)) {
            try {
                BundleDataSet bds = BundleDataSet.createRank1Bundle();
                DDataSet ds = DDataSet.createRank1((int)1);
                ds.putProperty("TITLE", data.property("TITLE"));
                ds.putProperty("LABEL", data.property("LABEL"));
                ds.putProperty("NAME", data.property("NAME"));
                ds.putProperty("UNITS", data.property("UNITS"));
                ds.putProperty("VALID_MAX", data.property("VALID_MAX"));
                ds.putProperty("VALID_MIN", data.property("VALID_MIN"));
                ds.putProperty("FILL_VALUE", data.property("FILL_VALUE"));
                ds.putProperty("START_INDEX", (Object)1);
                ds.putProperty("DIMENSION", (Object)data.length(0));
                bds.bundle((QDataSet)ds);
                this.formatBundleDesc(out, (QDataSet)bds.property("BUNDLE_1"));
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
        } else {
            this.maybeOutputProperty(out, data, "TITLE");
        }
        Units u = (Units)data.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if (u != Units.dimensionless && !"rich".equals(head)) {
            this.maybeOutputProperty(out, data, "UNITS");
        }
        if (dep1 != null) {
            int i;
            Units dep1units;
            out.print("#");
            if (dep0 != null) {
                String l = (String)dep0.property("LABEL");
                if (l == null) {
                    l = Units.t2000.isConvertableTo(SemanticOps.getUnits((QDataSet)dep0)) ? "time(UTC)" : "dep0";
                }
                out.print(l + ", ");
            }
            if ((dep1units = (Units)dep1.property("UNITS")) == null) {
                dep1units = Units.dimensionless;
            }
            for (i = 0; i < dep1.length() - 1; ++i) {
                out.print(dep1units == null ? "" + dep1.value(i) : dep1units.createDatum(dep1.value(i)) + ", ");
            }
            out.println((Object)(dep1units == null ? "" + dep1.value(i) : dep1units.createDatum(dep1.value(i))));
        }
        Units u0 = null;
        if (dep0 != null && (u0 = (Units)dep0.property("UNITS")) == null) {
            u0 = Units.dimensionless;
        }
        mon.setTaskSize((long)data.length());
        mon.started();
        String ft = this.getParam("tformat", "ISO8601");
        DatumFormatter tf = ft.equals("") ? Units.us2000.getDatumFormatterFactory().defaultFormatter() : this.getTimeFormatter(ft);
        String dfs = this.getParam("format", "");
        DatumFormatter datumFormatter = df = dfs.equals("") ? u.getDatumFormatterFactory().defaultFormatter() : this.getDataFormatter(dfs, u);
        DatumFormatter cf0 = dep0 == null ? null : (UnitsUtil.isTimeLocation((Units)u0) ? tf : df);
        DatumFormatter cf1 = UnitsUtil.isTimeLocation((Units)u) ? tf : df;
        for (int i = 0; i < data.length(); ++i) {
            int j;
            mon.setTaskProgress((long)i);
            if (mon.isCancelled()) break;
            if (dep0 != null) {
                out.print("" + cf0.format(u0.createDatum(dep0.value(i)), u0) + ", ");
            }
            for (j = 0; j < data.length(i) - 1; ++j) {
                out.print(cf1.format(u.createDatum(data.value(i, j)), u) + ", ");
            }
            out.println(cf1.format(u.createDatum(data.value(i, j)), u));
        }
        mon.finished();
    }

    private String dataSetLabel(QDataSet ds, String deft) {
        String name = (String)ds.property("NAME");
        if (name == null || name.equals("")) {
            name = deft;
        }
        String label = name;
        Units units = (Units)ds.property("UNITS");
        if (units != null && units != Units.dimensionless) {
            label = label + " (" + units + ")";
        }
        return label;
    }

    private void formatRank1(PrintWriter out, QDataSet data, ProgressMonitor mon) {
        DatumFormatter df;
        String l;
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        Units u0 = null;
        ArrayList<QDataSet> planes = new ArrayList<QDataSet>();
        ArrayList<Units> planeUnits = new ArrayList<Units>();
        String head = this.getParam("header", "");
        if ("rich".equals(head)) {
            try {
                BundleDataSet bds = BundleDataSet.createRank1Bundle();
                DDataSet ds = DDataSet.createRank1((int)1);
                ds.putProperty("TITLE", data.property("TITLE"));
                ds.putProperty("LABEL", data.property("LABEL"));
                ds.putProperty("NAME", data.property("NAME"));
                ds.putProperty("UNITS", data.property("UNITS"));
                ds.putProperty("VALID_MAX", data.property("VALID_MAX"));
                ds.putProperty("VALID_MIN", data.property("VALID_MIN"));
                ds.putProperty("FILL_VALUE", data.property("FILL_VALUE"));
                this.formatBundleDesc(out, (QDataSet)bds.property("BUNDLE_1"));
            }
            catch (JSONException ex) {
                ex.printStackTrace();
            }
        } else {
            this.maybeOutputProperty(out, data, "TITLE");
        }
        StringBuilder buf = new StringBuilder();
        if (dep0 != null) {
            l = this.dataSetLabel(dep0, "dep0");
            buf.append(", ").append(l);
            u0 = (Units)dep0.property("UNITS");
            if (u0 == null) {
                u0 = Units.dimensionless;
            }
        }
        l = this.dataSetLabel(data, "data");
        buf.append(", ").append(l);
        Units u = (Units)data.property("UNITS");
        if (u == null) {
            u = Units.dimensionless;
        }
        if (!"rich".equals(head)) {
            this.maybeOutputProperty(out, data, "TITLE");
            if (u != Units.dimensionless) {
                this.maybeOutputProperty(out, data, "UNITS");
            }
        }
        for (int i = 0; i < 50; ++i) {
            QDataSet plane = (QDataSet)data.property("PLANE_" + i);
            if (plane == null) continue;
            planes.add(plane);
            planeUnits.add((Units)plane.property("UNITS"));
            if (planeUnits.get(i) == null) {
                planeUnits.add(i, Units.dimensionless);
            }
            l = this.dataSetLabel(plane, "data" + i);
            buf.append(", ").append(l);
        }
        out.println(buf.substring(2));
        mon.setTaskSize((long)data.length());
        mon.started();
        String ft = this.getParam("tformat", "ISO8601");
        DatumFormatter tf = ft.equals("") ? Units.us2000.getDatumFormatterFactory().defaultFormatter() : this.getTimeFormatter(ft);
        String dfs = this.getParam("format", "");
        DatumFormatter datumFormatter = df = dfs.equals("") ? u.getDatumFormatterFactory().defaultFormatter() : this.getDataFormatter(dfs, u);
        DatumFormatter cf0 = dep0 == null ? null : (UnitsUtil.isTimeLocation((Units)u0) ? tf : df);
        DatumFormatter cf1 = UnitsUtil.isTimeLocation((Units)u) ? tf : df;
        for (int i = 0; i < data.length(); ++i) {
            mon.setTaskProgress((long)i);
            if (mon.isCancelled()) break;
            if (dep0 != null) {
                out.print("" + cf0.format(u0.createDatum(dep0.value(i)), u0) + ", ");
            }
            out.print(cf1.format(u.createDatum(data.value(i)), u));
            for (int j = 0; j < planes.size(); ++j) {
                out.print(", " + cf1.format(((Units)planeUnits.get(j)).createDatum(((QDataSet)planes.get(j)).value(i)), (Units)planeUnits.get(j)));
            }
            out.println();
        }
        mon.finished();
    }

    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws IOException {
        this.setUri(uri);
        PrintWriter out = new PrintWriter(new File(this.getResourceURI()));
        String head = this.getParam("header", "");
        if (!"rich".equals(head)) {
            out.println("# Generated by Autoplot on " + new Date());
        }
        if (data.rank() == 2) {
            if (SemanticOps.isBundle((QDataSet)data)) {
                this.formatBundle(out, data, mon);
            } else {
                this.formatRank2(out, data, mon);
            }
        } else if (data.rank() == 1) {
            this.formatRank1(out, data, mon);
        } else {
            throw new IllegalArgumentException("only rank 1 and rank 2 data are supported");
        }
        out.close();
    }
}

