/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.virbo.qstream.AsciiTransferType;
import org.virbo.qstream.TransferType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsciiTimeTransferType
extends AsciiTransferType {
    Units units;
    DatumFormatter formatter;

    public AsciiTimeTransferType(int sizeBytes, Units units) {
        super(sizeBytes, false);
        this.units = units;
        try {
            this.formatter = sizeBytes <= 24 ? TimeDatumFormatter.DEFAULT : (sizeBytes <= 27 ? new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z')") : (sizeBytes <= 30 ? new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS'Z')") : new TimeDatumFormatter("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSSSSS'Z')")));
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void write(double d, ByteBuffer buffer) {
        try {
            int c;
            String s = this.units.isFill(d) ? "**************************************************".substring(0, this.sizeBytes) : this.formatter.format(this.units.createDatum(d));
            byte[] bak = s.getBytes("US-ASCII");
            buffer.put(bak, 0, c);
            for (c = Math.min(s.length(), this.sizeBytes - 1); c < this.sizeBytes; ++c) {
                buffer.put((byte)32);
            }
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(AsciiTimeTransferType.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public double read(ByteBuffer buffer) {
        try {
            byte[] bytes = new byte[this.sizeBytes];
            buffer.get(bytes);
            String str = new String(bytes, "US-ASCII").trim();
            double result = TimeUtil.create((String)str).doubleValue(this.units);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static TransferType getByName(String name, Map<String, Object> properties) {
        Pattern p = Pattern.compile("time(\\d+)");
        Matcher m = p.matcher(name);
        if (m.matches()) {
            Units units = (Units)properties.get("UNITS");
            if (units == null) {
                throw new IllegalArgumentException("Units need to be in properties");
            }
            return new AsciiTimeTransferType(Integer.parseInt(m.group(1)), units);
        }
        return null;
    }

    @Override
    public String name() {
        return "time" + this.sizeBytes;
    }
}

