/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.qstream;

import java.text.ParseException;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.virbo.dataset.SemanticOps;
import org.virbo.qstream.SerializeDelegate;
import org.virbo.qstream.XMLSerializeDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DatumRangeSerializeDelegate
implements SerializeDelegate,
XMLSerializeDelegate {
    public String format(Object o) {
        DatumRange dr = (DatumRange)o;
        Units u = dr.getUnits();
        if (UnitsUtil.isTimeLocation((Units)u)) {
            return "time:" + o;
        }
        return o.toString();
    }

    public Object parse(String typeId, String s) throws ParseException {
        if (s.startsWith("time:")) {
            return DatumRangeUtil.parseTimeRange((String)s.substring(5));
        }
        try {
            if (!(s.contains(" ") || s.contains("E+") || s.contains("e+"))) {
                s = s.replaceAll("\\+", " ");
            }
            return DatumRangeUtil.parseTimeRange((String)s);
        }
        catch (ParseException e) {
            int i = s.trim().lastIndexOf(" ");
            if (i == -1) {
                return DatumRangeUtil.parseDatumRange((String)s, (Units)Units.dimensionless);
            }
            String sunits = s.substring(i).trim();
            try {
                Double d = Double.parseDouble(sunits);
                return DatumRangeUtil.parseDatumRange((String)s, (Units)Units.dimensionless);
            }
            catch (NumberFormatException ex) {
                Units u = SemanticOps.lookupUnits((String)sunits);
                return DatumRangeUtil.parseDatumRange((String)s, (Units)u);
            }
        }
    }

    public String typeId(Class clas) {
        return "datumRange";
    }

    public Element xmlFormat(Document doc, Object o) {
        DatumRange dr = (DatumRange)o;
        Element result = doc.createElement(this.typeId(o.getClass()));
        result.setAttribute("units", dr.getUnits().toString());
        result.setAttribute("value", dr.toString());
        return result;
    }

    public Object xmlParse(Element e) throws ParseException {
        String sunits = e.getAttribute("units");
        Units u = SemanticOps.lookupUnits((String)sunits);
        String s = e.getAttribute("value");
        return DatumRangeUtil.parseDatumRange((String)s, (Units)u);
    }
}

