/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.zip.Deflater;

public class DeflaterChannel
implements WritableByteChannel {
    private boolean closed = false;
    private WritableByteChannel out;
    private Deflater deflater;
    private ByteBuffer buf;
    private byte[] inBuf;

    public DeflaterChannel(WritableByteChannel out) {
        this.out = out;
        byte[] array = new byte[4096];
        this.buf = ByteBuffer.wrap(array);
        this.deflater = new Deflater();
    }

    public void flush() throws IOException {
        int byteCount;
        this.deflater.finish();
        while ((byteCount = this.deflater.deflate(this.buf.array())) != 0) {
            this.buf.position(0).limit(byteCount);
            while (this.buf.hasRemaining()) {
                this.out.write(this.buf);
            }
        }
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.closed = true;
            this.out.close();
            this.out = null;
            this.deflater.end();
            this.deflater = null;
            this.buf = null;
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public synchronized int write(ByteBuffer src) throws IOException {
        int length;
        int offset;
        byte[] inBuf;
        if (src.hasArray()) {
            inBuf = src.array();
            offset = src.arrayOffset();
            length = src.remaining();
            src.position(src.position() + src.remaining());
        } else {
            if (this.inBuf == null) {
                this.inBuf = new byte[4096];
            }
            inBuf = this.inBuf;
            offset = 0;
            length = Math.min(inBuf.length, src.remaining());
            src.get(inBuf, 0, length);
        }
        this.deflater.setInput(inBuf, offset, length);
        while (!this.deflater.needsInput()) {
            int byteCount = this.deflater.deflate(this.buf.array());
            this.buf.position(0).limit(byteCount);
            while (this.buf.hasRemaining()) {
                this.out.write(this.buf);
            }
        }
        return length;
    }
}

