/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.awt.Component;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.monitor.CancelledOperationException;

public class KeyChain {
    private static KeyChain instance;
    private Map<String, String> keys = new HashMap<String, String>();
    private Component parent = null;

    public static synchronized KeyChain getDefault() {
        if (instance == null) {
            instance = new KeyChain();
        }
        return instance;
    }

    public String getUserInfo(URI uri) throws CancelledOperationException {
        try {
            return this.getUserInfo(uri.toURL());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getUserInfo(URL url) throws CancelledOperationException {
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            return null;
        }
        return this.getUserInfo(url, userInfo);
    }

    public void setParentGUI(Component c) {
        this.parent = c;
    }

    public String getUserInfo(URL url, String userInfo) throws CancelledOperationException {
        String hash;
        String storedUserInfo;
        if (userInfo == null) {
            return null;
        }
        String userName = null;
        String[] ss = userInfo.split(":", -2);
        if (!ss[0].equals("user") && (userName = ss[0]).contains("%40")) {
            userName = userName.replaceAll("%40", "@");
            StringBuilder userInfob = new StringBuilder(userName);
            for (int i = 1; i < ss.length; ++i) {
                userInfob.append(":").append(ss[i]);
            }
            userInfo = userInfob.toString();
        }
        if ((storedUserInfo = this.keys.get(hash = url.getProtocol() + "://" + (userName != null ? userName + "@" : "") + url.getHost())) != null) {
            return storedUserInfo;
        }
        String proto = url.getProtocol();
        if (ss.length < 2 || ss[1].length() == 0 || userInfo.endsWith(":pass") || userInfo.endsWith(":password")) {
            if (!FileSystemSettings.hasAllPermission() || !"true".equals(System.getProperty("java.awt.headless"))) {
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 1));
                panel.add(new JLabel(url.getHost()));
                JSeparator sep = new JSeparator(0);
                sep.setPreferredSize(new Dimension(0, 16));
                panel.add(sep);
                panel.add(new JLabel("Username:"));
                JTextField userTf = new JTextField();
                if (!ss[0].equals("user")) {
                    userTf.setText(userName);
                }
                panel.add(userTf);
                panel.add(new JLabel("Password:"));
                JPasswordField passTf = new JPasswordField();
                if (ss.length > 1 && !ss[1].equals("pass") && !ss[1].equals("password")) {
                    passTf.setText(ss[1]);
                }
                panel.add(passTf);
                int r = JOptionPane.showConfirmDialog(this.parent, panel, proto + " Authentication Required", 2, 3, null);
                if (0 == r) {
                    char[] pass = passTf.getPassword();
                    storedUserInfo = userTf.getText() + ":" + new String(pass);
                    this.keys.put(hash, storedUserInfo);
                    return storedUserInfo;
                }
                if (2 == r) {
                    throw new CancelledOperationException();
                }
            } else {
                return userInfo;
            }
        }
        return userInfo;
    }

    public void clearUserPassword(URI uri) {
        try {
            this.clearUserPassword(uri.toURL());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(KeyChain.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void clearUserPassword(URL url) {
        String hash;
        String storedUserInfo;
        String userInfo = url.getUserInfo();
        if (userInfo == null) {
            return;
        }
        String userName = null;
        String[] ss = userInfo.split(":", -2);
        if (!ss[0].equals("user")) {
            userName = ss[0];
        }
        if ((storedUserInfo = this.keys.get(hash = url.getProtocol() + "://" + (userName != null ? userName + "@" : "") + url.getHost())) != null) {
            this.keys.remove(hash);
        }
    }

    public URI resolveUserInfo(URI root) throws CancelledOperationException {
        try {
            String userInfo = this.getUserInfo(root);
            URI newuri = new URI(root.getScheme(), userInfo, root.getHost(), root.getPort(), root.getPath(), root.getQuery(), root.getFragment());
            return newuri;
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String hideUserInfo(URI root) {
        String userInfo = root.getUserInfo();
        int i = userInfo.indexOf(":");
        if (i > -1) {
            userInfo = userInfo.substring(0, i) + ":*****";
        }
        try {
            URI uri = new URI(root.getScheme(), userInfo, root.getHost(), root.getPort(), root.getPath(), root.getQuery(), root.getFragment());
            return uri.toString();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) throws MalformedURLException, CancelledOperationException {
        KeyChain.getDefault().getUserInfo(new URL("ftp://jbf@localhost/"));
    }
}

