/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.Base64;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemSettings;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.HttpFileSystem;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class WebFileObject
extends FileObject {
    WebFileSystem wfs;
    String pathname;
    File localFile;
    Date modifiedDate;
    boolean isRoot;
    boolean isFolder;
    Map<String, String> metadata;
    boolean isFolderResolved = false;

    public boolean canRead() {
        return true;
    }

    synchronized void maybeLoadMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = this.wfs.protocol.getMetadata(this);
        }
    }

    public FileObject[] getChildren() throws IOException {
        if (!this.isFolder) {
            throw new IllegalArgumentException(this.toString() + "is not a folder");
        }
        String[] list = this.wfs.listDirectory(this.pathname);
        FileObject[] result = new FileObject[list.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new WebFileObject(this.wfs, list[i], new Date(System.currentTimeMillis()));
        }
        return result;
    }

    public InputStream getInputStream(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (this.wfs.protocol != null) {
            FileSystem.logger.log(Level.FINE, "get inputstream from {0}", this.wfs.protocol);
            return this.wfs.protocol.getInputStream(this, monitor);
        }
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        if (!this.localFile.exists()) {
            File partFile = new File(this.localFile.toString() + ".part");
            this.wfs.downloadFile(this.pathname, this.localFile, partFile, monitor);
        }
        FileSystem.logger.log(Level.FINE, "read local file {0}", this.localFile);
        return new FileInputStream(this.localFile);
    }

    public FileObject getParent() {
        return new WebFileObject(this.wfs, this.wfs.getLocalName(this.localFile.getParentFile()), new Date(System.currentTimeMillis()));
    }

    public long getSize() {
        if (this.isFolder) {
            throw new IllegalArgumentException("is a folder");
        }
        return this.localFile.length();
    }

    public boolean isData() {
        return !this.isFolder;
    }

    public boolean isFolder() {
        if (this.isFolderResolved) {
            return this.isFolder;
        }
        throw new RuntimeException("IOException in constructor prevented us from resolving");
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Date lastModified() {
        return this.modifiedDate;
    }

    protected File getLocalFile() {
        return this.localFile;
    }

    public boolean exists() {
        if (this.localFile != null && this.localFile.exists()) {
            return true;
        }
        try {
            if (this.wfs.protocol != null) {
                this.maybeLoadMetadata();
                return "true".equals(this.metadata.get("exist"));
            }
            Logger.getLogger("das2.filesystem").info("This implementation of WebFileObject.exists() is not optimal");
            File partFile = new File(this.localFile.toString() + ".part");
            this.wfs.downloadFile(this.pathname, this.localFile, partFile, new NullProgressMonitor());
            return this.localFile.exists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected WebFileObject(WebFileSystem wfs, String pathname, Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        this.wfs = wfs;
        this.pathname = pathname;
        this.isFolderResolved = false;
        if (!wfs.isAppletMode()) {
            this.localFile = new File(wfs.getLocalRoot(), pathname);
            if (FileSystem.settings().getPersistence() == FileSystemSettings.Persistence.SESSION) {
                this.localFile.deleteOnExit();
            }
            try {
                if (!this.localFile.canRead()) {
                    if (!pathname.endsWith(".zip") && !pathname.endsWith(".ZIP") && wfs.isDirectory(pathname)) {
                        FileSystemUtil.maybeMkdirs(this.localFile);
                        this.isFolder = true;
                        if ("".equals(pathname)) {
                            this.isRoot = true;
                        }
                    } else {
                        this.isFolder = false;
                    }
                } else {
                    this.isFolder = this.localFile.isDirectory();
                    this.modifiedDate = new Date(this.localFile.lastModified());
                }
                this.isFolderResolved = true;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.isFolderResolved = false;
            }
        }
    }

    public String toString() {
        return "[" + this.wfs + "]" + this.getNameExt();
    }

    public String getNameExt() {
        return this.pathname;
    }

    public ReadableByteChannel getChannel(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        InputStream in = this.getInputStream(monitor);
        return Channels.newChannel(in);
    }

    public File getFile(ProgressMonitor monitor) throws FileNotFoundException, IOException {
        Date remoteDate;
        if (this.wfs.isAppletMode()) {
            throw new SecurityException("getFile cannot be used with applets.");
        }
        boolean download = false;
        if (monitor == null) {
            throw new NullPointerException("monitor may not be null");
        }
        if (this.wfs instanceof HttpFileSystem) {
            URL url = this.wfs.getURL(this.getNameExt());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            String userInfo = null;
            try {
                userInfo = KeyChain.getDefault().getUserInfo(url);
            }
            catch (CancelledOperationException ex) {
                throw new FileSystem.FileSystemOfflineException("user cancelled credentials");
            }
            if (userInfo != null) {
                String encode = Base64.encodeBytes(userInfo.getBytes());
                connection.setRequestProperty("Authorization", "Basic " + encode);
            }
            try {
                connection.connect();
                remoteDate = new Date(connection.getLastModified());
            }
            catch (IOException ex) {
                if (!((HttpFileSystem)this.wfs).isOffline()) {
                    throw ex;
                }
                remoteDate = new Date(0L);
            }
        } else {
            remoteDate = new Date(this.localFile.lastModified());
        }
        if (this.localFile.exists()) {
            Date localFileLastModified = new Date(this.localFile.lastModified());
            if (remoteDate.after(localFileLastModified)) {
                FileSystem.logger.log(Level.INFO, "remote file is newer than local copy of {0}, download.", this.getNameExt());
                download = true;
            }
        } else {
            download = true;
        }
        if (download) {
            try {
                FileSystem.logger.log(Level.FINE, "downloading file {0}", this.getNameExt());
                if (!this.localFile.getParentFile().exists()) {
                    FileSystemUtil.maybeMkdirs(this.localFile.getParentFile());
                }
                File partFile = new File(this.localFile.toString() + ".part");
                this.wfs.downloadFile(this.pathname, this.localFile, partFile, monitor);
                FileSystem.logger.log(Level.FINE, "downloaded local file has date {0}", new Date(this.localFile.lastModified()));
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException ex) {
                if (ex.getMessage() != null && ex.getMessage().contains("Forbidden")) {
                    throw ex;
                }
                if (this.wfs instanceof HttpFileSystem && !(ex instanceof InterruptedIOException) && this.wfs.isOffline()) {
                    ex.printStackTrace();
                    throw new FileSystem.FileSystemOfflineException("not found in local cache: " + this.getNameExt());
                }
                throw ex;
            }
            finally {
                monitor.finished();
            }
        }
        return this.localFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal() {
        if (this.wfs.isAppletMode()) {
            return false;
        }
        boolean download = false;
        if (this.localFile.exists()) {
            WebFileSystem webFileSystem = this.wfs;
            synchronized (webFileSystem) {
                long localFileLastAccessed = this.wfs.getLastAccessed(this.getNameExt());
                if (System.currentTimeMillis() - localFileLastAccessed > 60000L) {
                    try {
                        Date remoteDate;
                        if (this.wfs instanceof HttpFileSystem) {
                            URL url = this.wfs.getURL(this.getNameExt());
                            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                            connection.setRequestMethod("HEAD");
                            connection.connect();
                            remoteDate = new Date(connection.getLastModified());
                        } else {
                            remoteDate = new Date(this.localFile.lastModified());
                        }
                        Date localFileLastModified = new Date(this.localFile.lastModified());
                        if (remoteDate.after(localFileLastModified)) {
                            FileSystem.logger.info("remote file is newer than local copy of " + this.getNameExt() + ", download.");
                            download = true;
                        }
                        this.wfs.markAccess(this.getNameExt());
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
            }
        }
        download = true;
        return !download;
    }
}

