/*
 * Decompiled with CFR 0.152.
 */
package org.das2.jythoncompletion.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HTMLDocView
extends JEditorPane {
    private HTMLEditorKit htmlKit;

    public HTMLDocView(Color bgColor) {
        this.setEditable(false);
        this.setFocusable(false);
        this.setBackground(bgColor);
        this.setMargin(new Insets(0, 3, 3, 3));
    }

    public void setContent(final String content, final String reference) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringReader in = new StringReader("<HTML><BODY>" + content + "</BODY></HTML>");
                try {
                    Document doc = HTMLDocView.this.getDocument();
                    doc.remove(0, doc.getLength());
                    HTMLDocView.this.getEditorKit().read(in, HTMLDocView.this.getDocument(), 0);
                    HTMLDocView.this.setCaretPosition(0);
                    if (reference != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                HTMLDocView.this.scrollToReference(reference);
                            }
                        });
                    } else {
                        HTMLDocView.this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        });
    }

    protected EditorKit createDefaultEditorKit() {
        if (this.htmlKit == null) {
            this.htmlKit = new HTMLEditorKit();
            this.setEditorKit(this.htmlKit);
            if (this.htmlKit.getStyleSheet().getStyleSheets() != null) {
                return this.htmlKit;
            }
            StyleSheet css = new StyleSheet();
            Font f = this.getFont();
            css.addRule(new StringBuffer("body { font-size: ").append(f.getSize()).append("; font-family: ").append(f.getName()).append("; }").toString());
            css.addStyleSheet(this.htmlKit.getStyleSheet());
            this.htmlKit.setStyleSheet(css);
        }
        return this.htmlKit;
    }
}

