/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.jythonsupport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.adapter.PyObjectAdapter;
import org.python.util.InteractiveInterpreter;
import org.virbo.datasource.DataSetURI;
import org.virbo.jythonsupport.JythonOps;
import org.virbo.jythonsupport.PyQDataSetAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonUtil {
    public static InteractiveInterpreter createInterpreter(boolean sandbox) throws IOException {
        if (PySystemState.cachedir == null) {
            System.setProperty("python.cachedir", System.getProperty("user.home") + "/autoplot_data/pycache");
        }
        PySystemState pySys = new PySystemState();
        URL jarUrl = InteractiveInterpreter.class.getResource("/glob.py");
        if (jarUrl != null) {
            String jarFile = jarUrl.toString();
            if (jarFile.startsWith("jar:") && jarFile.contains("!")) {
                int i = jarFile.indexOf("!");
                String jar = jarFile.substring(9, i);
                pySys.path.insert(0, (PyObject)new PyString(jar));
            }
        } else {
            System.err.println("Not adding Lib stuff!!!  See https://sourceforge.net/tracker/index.php?func=detail&aid=3134982&group_id=199733&atid=970682");
        }
        InteractiveInterpreter interp = new InteractiveInterpreter(null, pySys);
        Py.getAdapter().addPostClass((PyObjectAdapter)new PyQDataSetAdapter());
        URL imports = JythonOps.class.getResource("imports.py");
        if (imports == null) {
            throw new RuntimeException("unable to locate imports.py on classpath");
        }
        interp.execfile(imports.openStream(), "imports.py");
        return interp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pythonLint(URI uri, List<String> errs) throws IOException {
        BufferedReader reader = null;
        File src = DataSetURI.getFile((URI)uri, (ProgressMonitor)new NullProgressMonitor());
        try {
            reader = new LineNumberReader(new BufferedReader(new FileReader(src)));
            String vnarg = "\\s*([a-zA-Z_][a-zA-Z0-9_]*)\\s*";
            Pattern assign = Pattern.compile(vnarg + "=.*");
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true);
            String line = ((LineNumberReader)reader).readLine();
            while (line != null) {
                Matcher m = assign.matcher(line);
                if (m.matches()) {
                    String vname = m.group(1);
                    try {
                        PyObject po = interp.eval(vname);
                        errs.add("" + ((LineNumberReader)reader).getLineNumber() + ": " + vname + "=" + po.__repr__());
                    }
                    catch (PyException ex) {
                        // empty catch block
                    }
                }
                line = ((LineNumberReader)reader).readLine();
            }
            reader.close();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(JythonUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return errs.size() > 0;
    }

    public static Map getLocals(BufferedReader reader) throws IOException {
        String s = reader.readLine();
        Pattern assignPattern = Pattern.compile("\\s*([_a-zA-Z][_a-zA-Z0-9]*)\\s*=.*(#(.*))?");
        Pattern defPattern = Pattern.compile("def .*");
        boolean inDef = false;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        boolean haveResult = false;
        while (s != null) {
            Matcher m;
            Matcher defm;
            if (!inDef) {
                defm = defPattern.matcher(s);
                if (defm.matches()) {
                    inDef = true;
                }
            } else if (s.length() > 0 && !Character.isWhitespace(s.charAt(0))) {
                defm = defPattern.matcher(s);
                inDef = defm.matches();
            }
            if (!inDef && (m = assignPattern.matcher(s)).matches()) {
                if (m.group(3) != null) {
                    result.put(m.group(1), m.group(3));
                } else {
                    result.put(m.group(1), s);
                }
            }
            s = reader.readLine();
        }
        reader.close();
        return result;
    }

    public static String removeSideEffects(BufferedReader reader) throws IOException {
        String s = reader.readLine();
        Pattern assignPattern = Pattern.compile("\\s*([_a-zA-Z][_a-zA-Z0-9]*)\\s*=.*(#(.*))?");
        Pattern defPattern = Pattern.compile("def .*");
        Pattern importPattern1 = Pattern.compile("from .*");
        Pattern importPattern2 = Pattern.compile("import .*");
        boolean inDef = false;
        StringBuilder result = new StringBuilder();
        boolean haveResult = false;
        while (s != null) {
            Matcher defm;
            boolean sideEffect = true;
            if (!inDef) {
                defm = defPattern.matcher(s);
                if (defm.matches()) {
                    inDef = true;
                    sideEffect = false;
                }
            } else if (s.length() > 0 && !Character.isWhitespace(s.charAt(0)) && (inDef = (defm = defPattern.matcher(s)).matches())) {
                sideEffect = false;
            }
            if (!inDef) {
                Matcher m = assignPattern.matcher(s);
                if (m.matches()) {
                    sideEffect = false;
                } else if (importPattern1.matcher(s).matches()) {
                    sideEffect = false;
                } else if (importPattern2.matcher(s).matches()) {
                    sideEffect = false;
                }
            }
            if (!sideEffect) {
                result.append(s).append("\n");
            }
            s = reader.readLine();
        }
        reader.close();
        return result.toString();
    }
}

