/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.jythonsupport.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.python.util.PythonInterpreter;

public class EditorAnnotationsSupport {
    public static final String ANNO_ERROR = "error";
    public static final String ANNO_PROGRAM_COUNTER = "programCounter";
    public static final String ANNO_WARNING = "warning";
    private JTextPane editorPanel;
    PythonInterpreter interp;
    SortedMap<Integer, Annotation> annotations = new TreeMap<Integer, Annotation>();

    EditorAnnotationsSupport(JTextPane editorPanel) {
        this.editorPanel = editorPanel;
        editorPanel.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                EditorAnnotationsSupport.this.clearAnnotations(e.getOffset());
            }

            public void removeUpdate(DocumentEvent e) {
                EditorAnnotationsSupport.this.clearAnnotations(e.getOffset());
            }

            public void changedUpdate(DocumentEvent e) {
                EditorAnnotationsSupport.this.clearAnnotations(e.getOffset());
            }
        });
        editorPanel.setToolTipText("this will contain annotations");
    }

    private synchronized void addStyles(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style s1 = doc.addStyle(ANNO_ERROR, def);
        StyleConstants.setBackground(s1, Color.PINK);
        Style s2 = doc.addStyle(ANNO_PROGRAM_COUNTER, def);
        StyleConstants.setBackground(s2, Color.GREEN.brighter().brighter());
        Style s3 = doc.addStyle(ANNO_WARNING, def);
        StyleConstants.setBackground(s3, Color.YELLOW);
    }

    public void clearAnnotations() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Style def = StyleContext.getDefaultStyleContext().getStyle("default");
                StyledDocument doc = EditorAnnotationsSupport.this.editorPanel.getStyledDocument();
                doc.setCharacterAttributes(0, doc.getLength(), def, true);
            }
        });
        this.annotations = new TreeMap<Integer, Annotation>();
    }

    public void clearAnnotations(int pos) {
        final Annotation ann = this.annotationAt(pos);
        if (ann != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Style def = StyleContext.getDefaultStyleContext().getStyle("default");
                    StyledDocument doc = EditorAnnotationsSupport.this.editorPanel.getStyledDocument();
                    doc.setCharacterAttributes(ann.offset, ann.len, def, true);
                    EditorAnnotationsSupport.this.annotations.remove(ann.offset);
                }
            });
        }
    }

    private Annotation annotationAt(int offset) {
        SortedMap<Integer, Annotation> head = this.annotations.headMap(offset);
        if (head.size() == 0) {
            return null;
        }
        int annoOffset = head.lastKey();
        Annotation ann = (Annotation)this.annotations.get(annoOffset);
        if (ann.len > offset - ann.offset) {
            return ann;
        }
        return null;
    }

    public void annotateLine(int line, String name, String text) throws BadLocationException {
        this.annotateLine(line, name, text, null);
    }

    public void annotateLine(final int line, final String name, final String text, final PythonInterpreter interp) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int i1;
                int i0;
                StyledDocument doc = EditorAnnotationsSupport.this.editorPanel.getStyledDocument();
                Element root = EditorAnnotationsSupport.this.editorPanel.getDocument().getDefaultRootElement();
                if (line < 1 || line > root.getElementCount() + 1) {
                    throw new IllegalArgumentException("no such line: " + line);
                }
                if (line <= root.getElementCount()) {
                    i0 = root.getElement(line - 1).getStartOffset();
                    i1 = root.getElement(line - 1).getEndOffset();
                } else {
                    i0 = Math.max(0, doc.getLength() - 2);
                    i1 = doc.getLength();
                }
                EditorAnnotationsSupport.this.annotateChars(i0, i1, name, text, interp);
            }
        });
    }

    public void annotateChars(final int i0, final int i1, final String name, final String text, final PythonInterpreter interp) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StyledDocument doc = EditorAnnotationsSupport.this.editorPanel.getStyledDocument();
                Element root = EditorAnnotationsSupport.this.editorPanel.getDocument().getDefaultRootElement();
                Style style = doc.getStyle(name);
                if (style == null) {
                    EditorAnnotationsSupport.this.addStyles(doc);
                    style = doc.getStyle(name);
                }
                doc.setParagraphAttributes(i0, i1 - i0, StyleContext.getDefaultStyleContext().getStyle("default"), false);
                doc.setCharacterAttributes(i0, i1 - i0, style, true);
                Annotation ann = new Annotation();
                ann.len = i1 - i0;
                ann.offset = i0;
                ann.text = text;
                EditorAnnotationsSupport.this.annotations.put(ann.offset, ann);
                EditorAnnotationsSupport.this.interp = interp;
            }
        });
    }

    private String htmlify(String text) {
        StringBuffer buff = new StringBuffer();
        buff.append("<html>");
        String[] ss = text.split("\n", -2);
        for (int i = 0; i < ss.length - 1; ++i) {
            buff.append(ss[i] + "<br>");
        }
        buff.append(ss[ss.length - 1]);
        buff.append("</html>");
        return buff.toString();
    }

    public String getToolTipText(MouseEvent me) {
        int offset = this.editorPanel.viewToModel(me.getPoint());
        if (this.editorPanel.getSelectionStart() < offset && offset < this.editorPanel.getSelectionEnd()) {
            String eval = this.editorPanel.getSelectedText();
            if (this.interp != null) {
                try {
                    String peek = this.interp.eval(eval).toString();
                    return peek;
                }
                catch (Exception ex) {
                    return "" + ex.toString();
                }
            }
        }
        if (offset > 0) {
            Annotation ann = this.annotationAt(offset);
            if (ann != null) {
                return this.htmlify(ann.text);
            }
            return null;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 250);
    }

    private static class Annotation {
        String text;
        int offset;
        int len;

        private Annotation() {
        }
    }
}

