/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.jythonsupport.ui;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import org.python.core.PyObject;
import org.virbo.jythonsupport.PyQDataSet;
import org.virbo.jythonsupport.ui.EditorAnnotationsSupport;
import org.virbo.qstream.SimpleStreamFormatter;
import org.virbo.qstream.StreamException;

public class EditorTextPane
extends JTextPane {
    private EditorAnnotationsSupport support = new EditorAnnotationsSupport(this);

    public EditorTextPane() {
        final UndoManager undo = new UndoManager();
        this.getDocument().addUndoableEditListener(undo);
        this.getActionMap().put("undo", new AbstractAction(undo.getUndoPresentationName()){

            public void actionPerformed(ActionEvent e) {
                if (undo.canUndo()) {
                    undo.undo();
                }
            }
        });
        this.getActionMap().put("redo", new AbstractAction(undo.getRedoPresentationName()){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getActionMap().put("biggerFont", new AbstractAction("Text Size Bigger"){

            public void actionPerformed(ActionEvent e) {
                Font f = EditorTextPane.this.getFont();
                float size = f.getSize2D();
                float step = size < 14.0f ? 1.0f : 2.0f;
                EditorTextPane.this.setFont(f.deriveFont(Math.min(40.0f, size + step)));
            }
        });
        this.getActionMap().put("smallerFont", new AbstractAction("Text Size Smaller"){

            public void actionPerformed(ActionEvent e) {
                Font f = EditorTextPane.this.getFont();
                float size = f.getSize2D();
                float step = size < 14.0f ? 1.0f : 2.0f;
                EditorTextPane.this.setFont(f.deriveFont(Math.max(4.0f, size - step)));
            }
        });
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.getInputMap().put(KeyStroke.getKeyStroke(90, tk.getMenuShortcutKeyMask()), "undo");
        this.getInputMap().put(KeyStroke.getKeyStroke(89, tk.getMenuShortcutKeyMask()), "redo");
        this.getInputMap().put(KeyStroke.getKeyStroke(61, tk.getMenuShortcutKeyMask()), "biggerFont");
        this.getInputMap().put(KeyStroke.getKeyStroke(45, tk.getMenuShortcutKeyMask()), "smallerFont");
    }

    public String getToolTipText(MouseEvent event) {
        return this.support.getToolTipText(event);
    }

    public void setEditorAnnotationsSupport(EditorAnnotationsSupport support) {
        this.support = support;
    }

    public EditorAnnotationsSupport getEditorAnnotationsSupport() {
        return this.support;
    }

    void plot(String doThis) {
        if (this.support.interp == null) {
            JOptionPane.showMessageDialog(this, "Session is not running.  There must be an active debugger to plot variables.");
            return;
        }
        try {
            PyObject po = this.support.interp.eval(doThis);
            if (po instanceof PyQDataSet) {
                try {
                    PyQDataSet pds = (PyQDataSet)po;
                    File tmpDir = File.createTempFile("autoplot", ".qds").getParentFile();
                    File tmpfile = new File(tmpDir, "autoplot.qds");
                    String cmd = "plot( 'file:" + tmpfile.toString() + "' );";
                    new SimpleStreamFormatter().format(pds.getQDataSet(), (OutputStream)new FileOutputStream(tmpfile), true);
                    Socket s = new Socket("localhost", 12345);
                    OutputStream out = s.getOutputStream();
                    out.write((cmd + "\n").getBytes());
                    out.close();
                }
                catch (StreamException ex) {
                    Logger.getLogger(EditorTextPane.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    if (ex instanceof ConnectException) {
                        JOptionPane.showMessageDialog(this, "<html>Unable to connect to socket 12345.  Start a second Autoplot and enable the Server feature.</html>");
                        return;
                    }
                    Logger.getLogger(EditorTextPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Selected item is not a dataset");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Selected item caused exception: " + e.toString());
        }
    }

    public void loadFile(File f) throws FileNotFoundException, IOException {
        BufferedReader r = null;
        try {
            StringBuffer buf = new StringBuffer();
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String s = r.readLine();
            while (s != null) {
                buf.append(s + "\n");
                s = r.readLine();
            }
            Document d = this.getDocument();
            d.remove(0, d.getLength());
            d.insertString(0, buf.toString(), null);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }
}

