/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource.wav;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.datasource.AbstractDataSourceFactory;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.wav.WavDataSource2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WavDataSourceFactory
extends AbstractDataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new WavDataSource2(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws IOException, UnsupportedAudioFileException {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "offset=", "offset in seconds"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "length=", "length in seconds"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "channel=", "channel number"));
        } else if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_VALUE)) {
            String paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (paramName.equals("channel")) {
                int channels = this.getChannels(cc.resourceURI, mon);
                for (int i = 0; i < channels; ++i) {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "" + i));
                }
            } else {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<double>"));
            }
        }
        return result;
    }

    private int getChannels(URI uri, ProgressMonitor mon) throws IOException, UnsupportedAudioFileException {
        File wavFile = DataSetURI.getFile((URI)uri, (ProgressMonitor)mon);
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(wavFile);
        AudioFormat audioFormat = fileFormat.getFormat();
        return audioFormat.getChannels();
    }
}

