/*
 * Decompiled with CFR 0.152.
 */
package gsfc.nssdc.cdf;

import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.CDFException;
import gsfc.nssdc.cdf.CDFObject;
import gsfc.nssdc.cdf.Variable;
import gsfc.nssdc.cdf.util.CDFUtils;
import gsfc.nssdc.cdf.util.Epoch;
import gsfc.nssdc.cdf.util.Epoch16;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Vector;

public class CDFData
implements CDFObject,
CDFConstants {
    private Variable _myVar;
    private Object _data = null;
    private Object _dataArray = null;
    private long id;
    private long cdfID;
    private long numValues;
    private long numElements;
    private long numDims;
    private String dataSignature;
    private long dataType;
    private int nDims = 0;
    private int[] dimSizes;
    private long recStart;
    private long recCount;
    private long recInterval;
    private long[] dimIndices;
    private long[] dimCounts;
    private long[] dimIntervals;

    public Object getData() {
        return this._dataArray;
    }

    public int getnDims() {
        return this.nDims;
    }

    public int[] getDimSizes() {
        return this.dimSizes;
    }

    public long getRecStart() {
        return this.recStart;
    }

    public long getRecCount() {
        return this.recCount;
    }

    public long getRecInterval() {
        return this.recInterval;
    }

    public long[] getDimIndices() {
        return this.dimIndices;
    }

    public long[] getDimCounts() {
        return this.dimCounts;
    }

    public long[] getDimIntervals() {
        return this.dimIntervals;
    }

    private CDFData(Variable variable) {
        this._myVar = variable;
        this.id = this._myVar.getID();
        this.cdfID = this._myVar.getMyCDF().getID();
        this.dataType = this._myVar.getDataType();
        this.numElements = this._myVar.getNumElements();
        this.numDims = this._myVar.getNumDims();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final CDFData get(Variable variable, long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3) throws CDFException {
        Variable variable2 = variable;
        synchronized (variable2) {
            CDFData cDFData = new CDFData(variable);
            cDFData.recStart = l;
            cDFData.recCount = l2;
            cDFData.recInterval = l3;
            if (variable.getNumDims() > 0L) {
                cDFData.dimIndices = lArray;
                cDFData.dimCounts = lArray2;
                cDFData.dimIntervals = lArray3;
            } else {
                cDFData.dimIndices = new long[]{0L};
                cDFData.dimCounts = new long[]{0L};
                cDFData.dimIntervals = new long[]{0L};
            }
            cDFData.initDimAndSizes();
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            Vector<String> vector7 = new Vector<String>();
            Vector<String> vector8 = new Vector<String>();
            Vector<String> vector9 = new Vector<String>();
            Vector<String> vector10 = new Vector<String>();
            cDFData.buildDataObject();
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector10.addElement("cdfID");
            vector10.addElement("J");
            vector.addElement(vector10);
            vector.addElement(new Long(57L));
            vector2.addElement("id");
            vector2.addElement("J");
            vector.addElement(vector2);
            vector.addElement(new Long(79L));
            vector3.addElement("recStart");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector.addElement(new Long(80L));
            vector4.addElement("recCount");
            vector4.addElement("J");
            vector.addElement(vector4);
            vector.addElement(new Long(81L));
            vector5.addElement("recInterval");
            vector5.addElement("J");
            vector.addElement(vector5);
            vector.addElement(new Long(82L));
            vector6.addElement("dimIndices");
            vector6.addElement("[J");
            vector.addElement(vector6);
            vector.addElement(new Long(83L));
            vector7.addElement("dimCounts");
            vector7.addElement("[J");
            vector.addElement(vector7);
            vector.addElement(new Long(84L));
            vector8.addElement("dimIntervals");
            vector8.addElement("[J");
            vector.addElement(vector8);
            vector.addElement(new Long(1007L));
            vector.addElement(new Long(67L));
            vector9.addElement("_data");
            vector9.addElement("Ljava/lang/Object;");
            vector.addElement(vector9);
            vector.addElement(new Long(1000L));
            cDFData._myVar.getMyCDF().executeCommand(cDFData, vector);
            cDFData.arrayify();
            return cDFData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final CDFData put(Variable variable, long l, long l2, long l3, long[] lArray, long[] lArray2, long[] lArray3, Object object) throws CDFException {
        Variable variable2 = variable;
        synchronized (variable2) {
            String string = object.getClass().getName();
            switch ((int)variable.getDataType()) {
                case 51: 
                case 52: {
                    if (string.indexOf("java.lang.String") != -1 || string.indexOf("[B") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 1: 
                case 41: {
                    if (string.indexOf("[B") != -1 || string.indexOf("Byte") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 2: 
                case 11: {
                    if (string.indexOf("[S") != -1 || string.indexOf("Short") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 4: 
                case 12: {
                    if (string.indexOf("[I") != -1 || string.indexOf("Integer") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 14: {
                    if (string.indexOf("[J") != -1 || string.indexOf("Long") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 21: 
                case 44: {
                    if (string.indexOf("[F") != -1 || string.indexOf("Float") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 22: 
                case 31: 
                case 45: {
                    if (string.indexOf("[D") != -1 || string.indexOf("Double") != -1) break;
                    throw new CDFException(-2112L);
                }
                case 32: {
                    if (string.indexOf("[D") != -1) break;
                }
            }
            CDFData cDFData = new CDFData(variable);
            cDFData._dataArray = object;
            cDFData.recStart = l;
            cDFData.recCount = l2;
            cDFData.recInterval = l3;
            cDFData.dimIndices = lArray;
            cDFData.dimCounts = lArray2;
            cDFData.dimIntervals = lArray3;
            cDFData.initDimAndSizes();
            cDFData.vectorize();
            cDFData.dataSignature = CDFUtils.getSignature(cDFData._data);
            Vector<Serializable> vector = new Vector<Serializable>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            Vector<String> vector5 = new Vector<String>();
            Vector<String> vector6 = new Vector<String>();
            Vector<String> vector7 = new Vector<String>();
            Vector<String> vector8 = new Vector<String>();
            Vector<String> vector9 = new Vector<String>();
            Vector<String> vector10 = new Vector<String>();
            vector.addElement(new Long(1005L));
            vector.addElement(new Long(1L));
            vector10.addElement("cdfID");
            vector10.addElement("J");
            vector.addElement(vector10);
            vector.addElement(new Long(57L));
            vector2.addElement("id");
            vector2.addElement("J");
            vector.addElement(vector2);
            vector.addElement(new Long(79L));
            vector3.addElement("recStart");
            vector3.addElement("J");
            vector.addElement(vector3);
            vector.addElement(new Long(80L));
            vector4.addElement("recCount");
            vector4.addElement("J");
            vector.addElement(vector4);
            vector.addElement(new Long(81L));
            vector5.addElement("recInterval");
            vector5.addElement("J");
            vector.addElement(vector5);
            vector.addElement(new Long(82L));
            vector6.addElement("dimIndices");
            vector6.addElement("[J");
            vector.addElement(vector6);
            vector.addElement(new Long(83L));
            vector7.addElement("dimCounts");
            vector7.addElement("[J");
            vector.addElement(vector7);
            vector.addElement(new Long(84L));
            vector8.addElement("dimIntervals");
            vector8.addElement("[J");
            vector.addElement(vector8);
            vector.addElement(new Long(1008L));
            vector.addElement(new Long(67L));
            vector9.addElement("_data");
            vector9.addElement("Ljava/lang/Object;");
            vector.addElement(vector9);
            vector.addElement(new Long(1000L));
            cDFData._myVar.getMyCDF().executeCommand(cDFData, vector);
            return cDFData;
        }
    }

    private long product(int[] nArray, int n, int n2) {
        long l = 1L;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] <= 1) continue;
            l *= (long)nArray[i];
        }
        return l;
    }

    private void arrayify() throws CDFException {
        if (this.nDims <= 1) {
            if (this.dataType == 51L || this.dataType == 52L) {
                if (this.nDims == 0) {
                    this._dataArray = new String((byte[])this._data);
                } else {
                    this.buildDataArray();
                    int n = 0;
                    byte[] byArray = new byte[(int)this.numElements];
                    for (int i = 0; i < this.dimSizes[0]; ++i) {
                        System.arraycopy(this._data, n, byArray, 0, (int)this.numElements);
                        Array.set(this._dataArray, i, new String(byArray));
                        n = (int)((long)n + this.numElements);
                    }
                }
            } else {
                this._dataArray = this._data;
            }
        } else {
            int n;
            this.buildDataArray();
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            for (n = 1; n < this.nDims - 1; ++n) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray[n] = this.product(this.dimSizes, n, this.nDims);
                nArray[n] = 0;
            }
            n = 0;
            Object object = this._dataArray;
            while ((long)n < this.numValues) {
                int n2;
                if (n != 0) {
                    for (n2 = 0; n2 < this.nDims - 1; ++n2) {
                        boolean bl;
                        boolean bl2 = bl = (long)n % lArray[n2] == 0L;
                        if (bl) {
                            int n3 = n2;
                            nArray[n3] = nArray[n3] + 1;
                            objectArray2[n2] = object = Array.get(object, nArray[n2]);
                            for (int i = n2 + 1; i < this.nDims - 1; ++i) {
                                nArray[i] = 0;
                                objectArray2[i] = Array.get(objectArray2[i - 1], 0);
                            }
                            break;
                        }
                        object = objectArray2[n2];
                    }
                }
                for (n2 = 0; n2 < this.dimSizes[this.nDims - 2]; ++n2) {
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            byte[] byArray = new byte[(int)this.numElements];
                            objectArray = new String[this.dimSizes[this.nDims - 1]];
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                System.arraycopy(this._data, n, byArray, 0, (int)this.numElements);
                                ((String[])objectArray)[i] = new String(byArray);
                                n = (int)((long)n + this.numElements);
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            objectArray = new byte[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 2: 
                        case 11: {
                            objectArray = new short[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 4: 
                        case 12: {
                            objectArray = new int[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 14: {
                            objectArray = new long[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 21: 
                        case 44: {
                            objectArray = new float[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 22: 
                        case 31: 
                        case 45: {
                            objectArray = new double[this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            break;
                        }
                        case 32: {
                            objectArray = new double[2 * this.dimSizes[this.nDims - 1]];
                            System.arraycopy(this._data, n, objectArray, 0, 2 * this.dimSizes[this.nDims - 1]);
                            n += 2 * this.dimSizes[this.nDims - 1];
                            break;
                        }
                    }
                    Array.set(objectArray2[this.nDims - 2], n2, objectArray);
                }
            }
        }
    }

    private void vectorize() throws CDFException {
        if (this.nDims <= 1) {
            if (this.dataType == 51L || this.dataType == 52L) {
                String string = this._dataArray.getClass().getName();
                if (string.indexOf("[B") == -1) {
                    int n = 0;
                    if (this.nDims == 0) {
                        this._data = new byte[(int)this.numElements];
                        int n2 = 0;
                        while ((long)n2 < this.numElements) {
                            ((byte[])this._data)[n2] = 32;
                            ++n2;
                        }
                        System.arraycopy(((String)this._dataArray).getBytes(), 0, this._data, 0, ((String)this._dataArray).length());
                    } else {
                        this.buildDataObject();
                        for (int i = 0; i < this.dimSizes[0]; ++i) {
                            System.arraycopy(((String[])this._dataArray)[i].getBytes(), 0, this._data, n, ((String[])this._dataArray)[i].length());
                            n = (int)((long)n + this.numElements);
                        }
                    }
                } else {
                    this._data = this._dataArray;
                }
            } else {
                this._data = this._dataArray;
            }
        } else {
            int n;
            this.buildDataObject();
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            for (n = 1; n < this.nDims - 1; ++n) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray[n] = this.product(this.dimSizes, n, this.nDims);
                nArray[n] = 0;
            }
            n = 0;
            Object object = this._dataArray;
            while ((long)n < this.numValues) {
                int n3;
                int n4;
                if (n != 0) {
                    for (n4 = 0; n4 < this.nDims - 1; ++n4) {
                        boolean bl;
                        boolean bl2 = bl = (long)n % lArray[n4] == 0L;
                        if (bl) {
                            int n5 = n4;
                            nArray[n5] = nArray[n5] + 1;
                            objectArray2[n4] = object = Array.get(object, nArray[n4]);
                            for (n3 = n4 + 1; n3 < this.nDims - 1; ++n3) {
                                nArray[n3] = 0;
                                objectArray2[n3] = Array.get(objectArray2[n3 - 1], nArray[n3]);
                            }
                            break;
                        }
                        object = objectArray2[n4];
                    }
                }
                block16: for (n4 = 0; n4 < this.dimSizes[this.nDims - 2]; ++n4) {
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            objectArray = (String[])Array.get(objectArray2[this.nDims - 2], n4);
                            for (n3 = 0; n3 < this.dimSizes[this.nDims - 1]; ++n3) {
                                if (((String[])objectArray)[n3] != null) {
                                    System.arraycopy(((String[])objectArray)[n3].getBytes(), 0, this._data, n, ((String[])objectArray)[n3].length());
                                }
                                n = (int)((long)n + this.numElements);
                            }
                            continue block16;
                        }
                        case 1: 
                        case 41: {
                            objectArray = (byte[])Array.get(objectArray2[this.nDims - 2], n4);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 2: 
                        case 11: {
                            objectArray = new short[this.dimSizes[this.nDims - 1]];
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n4);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 4: 
                        case 12: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n4);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 14: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n4);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 21: 
                        case 44: {
                            objectArray = (float[])Array.get(objectArray2[this.nDims - 2], n4);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 22: 
                        case 31: 
                        case 45: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n4);
                            System.arraycopy(objectArray, 0, this._data, n, this.dimSizes[this.nDims - 1]);
                            n += this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                        case 32: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n4);
                            System.arraycopy(objectArray, 0, this._data, n, 2 * this.dimSizes[this.nDims - 1]);
                            n += 2 * this.dimSizes[this.nDims - 1];
                            continue block16;
                        }
                    }
                }
            }
        }
    }

    private void initDimAndSizes() {
        this.numValues = 1L;
        if (this._dataArray != null) {
            this.nDims = this._dataArray.getClass().getName().lastIndexOf("[") + 1;
            if (this._dataArray.getClass().isArray()) {
                Object object = this._dataArray;
                this.dimSizes = new int[this.nDims];
                for (int i = 0; i < this.nDims; ++i) {
                    this.dimSizes[i] = Array.getLength(object);
                    this.numValues *= (long)this.dimSizes[i];
                    object = Array.get(object, 0);
                }
            } else {
                this.dimSizes = new int[1];
                this.dimSizes[0] = 1;
            }
            this.numValues *= this.numElements;
        } else {
            int n;
            int n2;
            this.nDims = this.recCount > 1L ? 1 : 0;
            int n3 = this.dimCounts.length;
            if (n3 == 1) {
                if (this.dimCounts[0] > 1L) {
                    ++this.nDims;
                }
            } else {
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    if (this.dimCounts[n] <= 1L) continue;
                    ++this.nDims;
                }
            }
            this.dimSizes = new int[this.nDims];
            if (this.nDims == 1) {
                this.dimSizes[0] = this.recCount > 1L ? (int)this.recCount : (int)this.dimCounts[0];
            } else if (this.recCount > 1L) {
                n2 = 0;
                this.dimSizes[0] = (int)this.recCount;
                n = 0;
                while ((long)n < this.numDims) {
                    if (this.dimCounts[n] > 1L) {
                        this.dimSizes[++n2] = (int)this.dimCounts[n];
                    }
                    ++n;
                }
            } else {
                n2 = -1;
                n = 0;
                while ((long)n < this.numDims) {
                    if (this.dimCounts[n] > 1L) {
                        this.dimSizes[++n2] = (int)this.dimCounts[n];
                    }
                    ++n;
                }
            }
            if (this.nDims > 0) {
                for (n2 = 0; n2 < this.nDims; ++n2) {
                    this.numValues *= (long)this.dimSizes[n2];
                }
            }
            this.numValues *= this.numElements;
        }
    }

    private void buildDataArray() throws CDFException {
        int[] nArray = new int[this.nDims - 1];
        System.arraycopy(this.dimSizes, 0, nArray, 0, this.nDims - 1);
        String string = null;
        switch ((int)this._myVar.getDataType()) {
            case 51: 
            case 52: {
                string = "java.lang.String";
                nArray = this.dimSizes;
                break;
            }
            case 1: 
            case 41: {
                string = "[B";
                break;
            }
            case 2: 
            case 11: {
                string = "[S";
                break;
            }
            case 4: 
            case 12: {
                string = "[I";
                break;
            }
            case 14: {
                string = "[J";
                break;
            }
            case 21: 
            case 44: {
                string = "[F";
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                string = "[D";
                break;
            }
            case 32: {
                string = "[D";
                break;
            }
        }
        try {
            Class<?> clazz = Class.forName(string);
            this._dataArray = Array.newInstance(clazz, nArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CDFException(-2022L);
        }
    }

    private void buildDataObject() throws CDFException {
        int n = (int)this._myVar.getDataType();
        Object object = null;
        if (this._myVar.checkPadValueExistence()) {
            object = this._myVar.getPadValue();
        }
        switch (n) {
            case 51: 
            case 52: {
                this.dataSignature = "[B";
                this._data = new byte[(int)this.numValues];
                if (object == null) {
                    int n2 = 0;
                    while ((long)n2 < this.numValues) {
                        ((byte[])this._data)[n2] = n == 51 ? new Character(' ').toString().getBytes()[0] : new Character(' ').toString().getBytes()[0];
                        ++n2;
                    }
                } else {
                    byte[] byArray = ((String)object).getBytes();
                    int n3 = byArray.length;
                    int n4 = 0;
                    int n5 = 0;
                    while ((long)n4 < this.numValues) {
                        if (n5 == n3) {
                            n5 = 0;
                        }
                        ((byte[])this._data)[n4] = byArray[n5];
                        ++n4;
                        ++n5;
                    }
                }
                break;
            }
            case 1: 
            case 41: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[B";
                    this._data = new byte[(int)this.numValues];
                    if (object == null) {
                        int n6 = 0;
                        while ((long)n6 < this.numValues) {
                            ((byte[])this._data)[n6] = n == 1 ? (byte)0 : 0;
                            ++n6;
                        }
                    } else {
                        int n7 = 0;
                        while ((long)n7 < this.numValues) {
                            ((byte[])this._data)[n7] = (Byte)object;
                            ++n7;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Byte;";
                if (object == null) {
                    if (n == 1) {
                        this._data = new Byte(0);
                        break;
                    }
                    this._data = new Byte(0);
                    break;
                }
                this._data = new Byte((Byte)object);
                break;
            }
            case 2: 
            case 11: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[S";
                    this._data = new short[(int)this.numValues];
                    if (object == null) {
                        int n8 = 0;
                        while ((long)n8 < this.numValues) {
                            ((short[])this._data)[n8] = n == 2 ? (short)0 : 0;
                            ++n8;
                        }
                    } else {
                        int n9 = 0;
                        while ((long)n9 < this.numValues) {
                            ((short[])this._data)[n9] = (Short)object;
                            ++n9;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Short;";
                if (object == null) {
                    if (n == 2) {
                        this._data = new Short(0);
                        break;
                    }
                    this._data = new Short(0);
                    break;
                }
                this._data = new Short((Short)object);
                break;
            }
            case 4: 
            case 12: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[I";
                    this._data = new int[(int)this.numValues];
                    if (object == null) {
                        int n10 = 0;
                        while ((long)n10 < this.numValues) {
                            ((int[])this._data)[n10] = n == 4 ? 0 : 0;
                            ++n10;
                        }
                    } else {
                        int n11 = 0;
                        while ((long)n11 < this.numValues) {
                            ((int[])this._data)[n11] = (Integer)object;
                            ++n11;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Integer;";
                if (object == null) {
                    if (n == 4) {
                        this._data = new Integer(0);
                        break;
                    }
                    this._data = new Integer(0);
                    break;
                }
                this._data = new Integer((Integer)object);
                break;
            }
            case 14: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[J";
                    this._data = new long[(int)this.numValues];
                    if (object == null) {
                        int n12 = 0;
                        while ((long)n12 < this.numValues) {
                            ((long[])this._data)[n12] = 0L;
                            ++n12;
                        }
                    } else {
                        int n13 = 0;
                        while ((long)n13 < this.numValues) {
                            ((long[])this._data)[n13] = (Long)object;
                            ++n13;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Long;";
                if (object == null) {
                    this._data = new Long(0L);
                    break;
                }
                this._data = new Long((Long)object);
                break;
            }
            case 21: 
            case 44: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[F";
                    this._data = new float[(int)this.numValues];
                    if (object == null) {
                        int n14 = 0;
                        while ((long)n14 < this.numValues) {
                            ((float[])this._data)[n14] = n == 21 ? 0.0f : 0.0f;
                            ++n14;
                        }
                    } else {
                        int n15 = 0;
                        while ((long)n15 < this.numValues) {
                            ((float[])this._data)[n15] = ((Float)object).floatValue();
                            ++n15;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Float;";
                if (object == null) {
                    if (n == 21) {
                        this._data = new Float(0.0f);
                        break;
                    }
                    this._data = new Float(0.0f);
                    break;
                }
                this._data = new Float(((Float)object).floatValue());
                break;
            }
            case 22: 
            case 31: 
            case 45: {
                if (this.numValues > 1L) {
                    this.dataSignature = "[D";
                    this._data = new double[(int)this.numValues];
                    if (object == null) {
                        int n16 = 0;
                        while ((long)n16 < this.numValues) {
                            ((double[])this._data)[n16] = n == 22 ? 0.0 : (n == 45 ? 0.0 : 0.0);
                            ++n16;
                        }
                    } else {
                        int n17 = 0;
                        while ((long)n17 < this.numValues) {
                            ((double[])this._data)[n17] = (Double)object;
                            ++n17;
                        }
                    }
                    break;
                }
                this.dataSignature = "Ljava/lang/Double;";
                if (object == null) {
                    if (n == 22) {
                        this._data = new Double(0.0);
                        break;
                    }
                    if (n == 45) {
                        this._data = new Double(0.0);
                        break;
                    }
                    this._data = new Double(0.0);
                    break;
                }
                this._data = new Double((Double)object);
                break;
            }
            case 32: {
                this.dataSignature = "[D";
                this._data = new double[2 * (int)this.numValues];
                if (object == null) {
                    int n18 = 0;
                    while ((long)n18 < this.numValues) {
                        ((double[])this._data)[2 * n18] = 0.0;
                        ((double[])this._data)[2 * n18 + 1] = 0.0;
                        ++n18;
                    }
                } else {
                    int n19 = 0;
                    while ((long)n19 < this.numValues) {
                        ((double[])this._data)[2 * n19] = ((double[])object)[0];
                        ((double[])this._data)[2 * n19 + 1] = ((double[])object)[1];
                        ++n19;
                    }
                }
                break;
            }
        }
    }

    public void dumpData() {
        if (this.nDims <= 1) {
            if (this.nDims == 0) {
                if (this._myVar.getDataType() == 31L) {
                    Double d = (Double)this._dataArray;
                    System.out.println(Epoch.encode(d));
                } else if (this._myVar.getDataType() == 32L) {
                    double[] dArray = (double[])this._dataArray;
                    System.out.println(Epoch16.encode(dArray));
                } else {
                    System.out.println(this._dataArray.toString());
                }
            } else {
                System.out.print("[");
                switch ((int)this._myVar.getDataType()) {
                    case 51: 
                    case 52: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((String[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 1: 
                    case 41: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((byte[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((short[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 11: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            if (((short[])this._dataArray)[i] >= 0) {
                                System.out.print(((short[])this._dataArray)[i]);
                                continue;
                            }
                            short s = (short)(((short[])this._dataArray)[i] + 256);
                            System.out.print(s);
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((int[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 12: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            if (((int[])this._dataArray)[i] >= 0) {
                                System.out.print(((int[])this._dataArray)[i]);
                                continue;
                            }
                            int n = ((int[])this._dataArray)[i] + 65536;
                            System.out.print(n);
                        }
                        break;
                    }
                    case 14: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            if (((long[])this._dataArray)[i] >= 0L) {
                                System.out.print(((long[])this._dataArray)[i]);
                                continue;
                            }
                            long l = ((long[])this._dataArray)[i] + 0x100000000L;
                            System.out.print(l);
                        }
                        break;
                    }
                    case 21: 
                    case 44: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((float[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 22: 
                    case 45: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(((double[])this._dataArray)[i]);
                        }
                        break;
                    }
                    case 31: {
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            System.out.print(Epoch.encode(((double[])this._dataArray)[i]));
                        }
                        break;
                    }
                    case 32: {
                        double[] dArray = new double[2];
                        for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                            if (i > 0) {
                                System.out.print(",");
                            }
                            dArray[0] = ((double[])this._dataArray)[2 * i];
                            dArray[1] = ((double[])this._dataArray)[2 * i + 1];
                            System.out.print(Epoch16.encode(dArray));
                        }
                        break;
                    }
                }
                System.out.println("]");
            }
        } else {
            int n;
            Object[] objectArray = null;
            Object[] objectArray2 = new Object[this.nDims - 1];
            int[] nArray = new int[this.nDims - 1];
            long[] lArray = new long[this.nDims - 1];
            objectArray2[0] = this._dataArray;
            nArray[0] = 0;
            lArray[0] = this.product(this.dimSizes, 0, this.nDims);
            for (n = 1; n < this.nDims - 1; ++n) {
                objectArray2[n] = Array.get(objectArray2[n - 1], 0);
                lArray[n] = this.product(this.dimSizes, n, this.nDims);
                nArray[n] = 0;
            }
            n = 0;
            Object object = this._dataArray;
            while ((long)n < lArray[0]) {
                int n2;
                int n3;
                if (n != 0) {
                    for (n3 = 0; n3 < this.nDims - 1; ++n3) {
                        boolean bl;
                        boolean bl2 = bl = (long)n % lArray[n3] == 0L;
                        if (bl) {
                            int n4 = n3;
                            nArray[n4] = nArray[n4] + 1;
                            objectArray2[n3] = object = Array.get(object, nArray[n3]);
                            for (n2 = n3 + 1; n2 < this.nDims - 1; ++n2) {
                                nArray[n2] = 0;
                                objectArray2[n2] = Array.get(objectArray2[n2 - 1], nArray[n2]);
                            }
                            break;
                        }
                        object = objectArray2[n3];
                    }
                }
                for (n3 = 0; n3 < this.dimSizes[this.nDims - 2]; ++n3) {
                    System.out.print("[");
                    switch ((int)this._myVar.getDataType()) {
                        case 51: 
                        case 52: {
                            objectArray = (String[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(objectArray[n2]);
                            }
                            break;
                        }
                        case 1: 
                        case 41: {
                            objectArray = (byte[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((byte[])objectArray)[n2]);
                            }
                            break;
                        }
                        case 2: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((short[])objectArray)[n2]);
                            }
                            break;
                        }
                        case 11: {
                            objectArray = (short[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                if (((short[])objectArray)[n2] >= 0) {
                                    System.out.print(((short[])objectArray)[n2]);
                                    continue;
                                }
                                short s = (short)(((short[])objectArray)[n2] + 256);
                                System.out.print(s);
                            }
                            break;
                        }
                        case 4: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((int[])objectArray)[n2]);
                            }
                            break;
                        }
                        case 12: {
                            objectArray = (int[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                if (((int[])objectArray)[n2] >= 0) {
                                    System.out.print(((int[])objectArray)[n2]);
                                    continue;
                                }
                                int n5 = ((int[])objectArray)[n2] + 65536;
                                System.out.print(n5);
                            }
                            break;
                        }
                        case 14: {
                            objectArray = (long[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                if (((long[])objectArray)[n2] >= 0L) {
                                    System.out.print(((long[])objectArray)[n2]);
                                    continue;
                                }
                                long l = ((long[])objectArray)[n2] + 0x100000000L;
                                System.out.print(l);
                            }
                            break;
                        }
                        case 21: 
                        case 44: {
                            objectArray = (float[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((float[])objectArray)[n2]);
                            }
                            break;
                        }
                        case 22: 
                        case 45: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(((double[])objectArray)[n2]);
                            }
                            break;
                        }
                        case 31: {
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (n2 = 0; n2 < this.dimSizes[this.nDims - 1]; ++n2) {
                                if (n2 > 0) {
                                    System.out.print(",");
                                }
                                System.out.print(Epoch.encode(((double[])objectArray)[n2]));
                            }
                            break;
                        }
                        case 32: {
                            double[] dArray = new double[2];
                            objectArray = (double[])Array.get(objectArray2[this.nDims - 2], n3);
                            for (int i = 0; i < this.dimSizes[this.nDims - 1]; ++i) {
                                if (i > 0) {
                                    System.out.print(",");
                                }
                                dArray[0] = ((double[])objectArray)[2 * i];
                                dArray[1] = ((double[])objectArray)[2 * i + 1];
                                System.out.print(Epoch16.encode(dArray));
                            }
                            break;
                        }
                    }
                    System.out.println("]");
                    n += this.dimSizes[this.nDims - 1];
                }
            }
        }
    }

    public void dump() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        System.err.println("Data dump for " + this._myVar + ": ");
        stringBuffer.append(CDFUtils.getStringDataType(this._myVar.getDataType()));
        stringBuffer.append("/");
        stringBuffer.append(this._myVar.getNumElements());
        int n2 = 12 - stringBuffer.length();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(" ");
        }
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer.setLength(0);
        stringBuffer2.append(String.valueOf(this.nDims));
        stringBuffer2.append(":[");
        for (n = 0; n < this.nDims; ++n) {
            if (n > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimSizes[n]));
        }
        stringBuffer2.append("]\t");
        stringBuffer2.append(String.valueOf(this.recStart));
        stringBuffer2.append("/");
        stringBuffer2.append(String.valueOf(this.recCount));
        stringBuffer2.append("/");
        stringBuffer2.append(String.valueOf(this.recInterval));
        stringBuffer2.append("/[");
        for (n = 0; n < this.dimIndices.length; ++n) {
            if (n > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimIndices[n]));
        }
        stringBuffer2.append("]/[");
        for (n = 0; n < this.dimCounts.length; ++n) {
            if (n > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimCounts[n]));
        }
        stringBuffer2.append("]/[");
        for (n = 0; n < this.dimIntervals.length; ++n) {
            if (n > 0) {
                stringBuffer2.append(",");
            }
            stringBuffer2.append(String.valueOf(this.dimIntervals[n]));
        }
        stringBuffer2.append("]/");
        stringBuffer2.append(this._dataArray.getClass().getName());
        System.err.println(stringBuffer2.toString());
        this.dumpData();
    }

    public String getName() {
        return "Data";
    }

    public void rename(String string) throws CDFException {
    }

    public void delete() throws CDFException {
    }
}

