/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdaweb;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.autoplot.cdaweb.CDAWebDB;
import org.jdesktop.layout.GroupLayout;

public class CDAWebDataSetIdDialog
extends JDialog {
    boolean isCancelled = false;
    private JButton cancelButton;
    private JList dsList;
    private JCheckBox filterCheckBox;
    private JTextField filterTF;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton okButton;

    public CDAWebDataSetIdDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public void refresh() {
        CDAWebDB db = CDAWebDB.getInstance();
        Map<String, String> ids = db.getServiceProviderIds();
        String filter = "";
        if (this.filterCheckBox.isSelected()) {
            filter = this.filterTF.getText().toLowerCase();
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (Map.Entry<String, String> e : ids.entrySet()) {
            if (!e.getKey().toLowerCase().contains(filter) && !e.getValue().toLowerCase().contains(filter)) continue;
            model.addElement(e.getKey() + ": " + e.getValue());
        }
        this.dsList.setModel(model);
    }

    public String getSelectedItem() {
        String sel = (String)this.dsList.getSelectedValue();
        int i = sel.indexOf(":");
        return sel.substring(0, i);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.filterCheckBox = new JCheckBox();
        this.filterTF = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.dsList = new JList();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Select the dataset to work with:");
        this.filterCheckBox.setText("Filter");
        this.filterCheckBox.setToolTipText("Simple filter on ID and description");
        this.filterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CDAWebDataSetIdDialog.this.filterCheckBoxActionPerformed(evt);
            }
        });
        this.filterTF.setToolTipText("filter on ID and description");
        this.filterTF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CDAWebDataSetIdDialog.this.filterTFActionPerformed(evt);
            }
        });
        this.filterTF.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                CDAWebDataSetIdDialog.this.filterTFKeyTyped(evt);
            }
        });
        this.dsList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Refreshing Database, should be just a few seconds..."};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.dsList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.dsList);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CDAWebDataSetIdDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CDAWebDataSetIdDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 684, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.okButton, -2, 57, -2).add(15, 15, 15)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.filterCheckBox).addPreferredGap(0).add((Component)this.filterTF, -1, 611, Short.MAX_VALUE).add(24, 24, 24)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addContainerGap(495, Short.MAX_VALUE)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 339, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.filterTF, -2, -1, -2).add((Component)this.filterCheckBox)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.okButton).add((Component)this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void filterCheckBoxActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void filterTFActionPerformed(ActionEvent evt) {
        this.refresh();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.isCancelled = false;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.isCancelled = true;
        this.setVisible(false);
    }

    private void filterTFKeyTyped(KeyEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CDAWebDataSetIdDialog.this.filterCheckBox.setSelected(true);
                CDAWebDataSetIdDialog.this.refresh();
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CDAWebDataSetIdDialog dialog = new CDAWebDataSetIdDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    void setFilter(String filter) {
        this.filterTF.setText(filter);
        if (filter.length() > 0) {
            this.filterCheckBox.setSelected(true);
        }
    }

    String getFilter() {
        return this.filterTF.getText();
    }
}

