/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdaweb;

import gov.nasa.gsfc.voyager.cdf.CDF;
import gov.nasa.gsfc.voyager.cdf.CDFFactory;
import java.io.File;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.autoplot.cdaweb.CDAWebDB;
import org.autoplot.cdaweb.CDAWebDataSource;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.cdf.CdfUtil;
import org.virbo.datasource.CompletionContext;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.DefaultTimeSeriesBrowse;
import org.virbo.datasource.FileSystemUtil;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDAWebDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new CDAWebDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        CDAWebDB.getInstance().maybeRefresh(mon);
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>(10);
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "ds="));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "id="));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "timerange="));
            return ccresult;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String param = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (param.equals("ds")) {
                Map<String, String> dss = CDAWebDB.getInstance().getServiceProviderIds();
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>(dss.size());
                for (String ds : dss.keySet()) {
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, ds, (DataSourceFactory)this, null, ds, ds, false);
                    ccresult.add(cc1);
                }
                return ccresult;
            }
            if (param.equals("timerange")) {
                URISplit split = URISplit.parse((String)cc.surl);
                LinkedHashMap params = URISplit.parseParams((String)split.params);
                String ds = ((String)params.get("ds")).toUpperCase();
                if (ds != null) {
                    DatumRange dr;
                    CDAWebDB db = CDAWebDB.getInstance();
                    String tr = db.getTimeRange(ds);
                    String tmpl = db.getNaming(ds);
                    String base = db.getBaseUrl(ds);
                    FileSystem fs = FileSystem.create((URI)new URI(base));
                    FileStorageModelNew fsm = FileStorageModelNew.create((FileSystem)fs, (String)tmpl);
                    String[] names = fsm.getNamesFor(dr = DatumRangeUtil.parseTimeRangeValid((String)tr));
                    String name = names.length > 1 ? names[1] : names[0];
                    DatumRange one = fsm.getRangeFor(name);
                    ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                    String key = one.toString().replaceAll(" ", "+");
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, (DataSourceFactory)this, null, key, key, true);
                    ccresult.add(cc1);
                    return ccresult;
                }
            } else if (param.equals("id")) {
                URISplit split = URISplit.parse((String)cc.surl);
                LinkedHashMap params = URISplit.parseParams((String)split.params);
                String ds = ((String)params.get("ds")).toUpperCase();
                if (ds != null) {
                    CDF cdf;
                    String master = CDAWebDB.getInstance().getMasterFile(ds.toLowerCase(), mon);
                    File f = FileSystemUtil.doDownload((String)master, (ProgressMonitor)mon);
                    try {
                        cdf = CDFFactory.getCDF((String)f.toString());
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException(ex);
                    }
                    Map result = CdfUtil.getPlottable((CDF)cdf, (boolean)true, (int)4);
                    ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                    for (String key : result.keySet()) {
                        CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, (DataSourceFactory)this, null, key, (String)result.get(key), true);
                        ccresult.add(cc1);
                    }
                    return ccresult;
                }
            }
        }
        return new ArrayList<CompletionContext>(){};
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new DefaultTimeSeriesBrowse();
        }
        return null;
    }

    public boolean reject(String surl, ProgressMonitor mon) {
        URISplit split = URISplit.parse((String)surl);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        if (!(params.containsKey("ds") && params.containsKey("id") && params.containsKey("timerange"))) {
            return true;
        }
        String tr = (String)params.get("timerange");
        if (tr == null) {
            return true;
        }
        tr = tr.replaceAll("\\+", " ");
        try {
            DatumRangeUtil.parseTimeRange((String)tr);
        }
        catch (ParseException ex) {
            return true;
        }
        if (((String)params.get("id")).equals("")) {
            return true;
        }
        return ((String)params.get("ds")).equals("");
    }
}

