/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.fits;

import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.das2.util.monitor.ProgressMonitor;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;
import org.eso.fits.FitsKeyword;
import org.eso.fits.FitsMatrix;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.FDataSet;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.MetadataModel;
import org.virbo.fits.FitsDataSourceFactory;
import org.virbo.fits.FitsMetadataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitsDataSource
extends AbstractDataSource {
    FitsDataSource(URI uri) {
        super(uri);
    }

    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        FDataSet result;
        int rank;
        int ihdu = 0;
        Map<String, Integer> plottable = FitsDataSourceFactory.getPlottable(this.resourceURI, mon);
        String name = (String)this.getParams().get("arg_0");
        if (name != null) {
            ihdu = plottable.get(name);
        }
        FitsFile file = new FitsFile(this.getFile(mon));
        FitsHDUnit hdu = file.getHDUnit(ihdu);
        FitsMatrix dm = (FitsMatrix)hdu.getData();
        int[] naxis = dm.getNaxis();
        double[] crval = dm.getCrval();
        double[] crpix = dm.getCrpix();
        double[] cdelt = dm.getCdelt();
        float[] fdata = new float[dm.getNoValues()];
        dm.getFloatValues(0, dm.getNoValues(), fdata);
        if (naxis.length == 3) {
            naxis = new int[]{naxis[2], naxis[0], naxis[1]};
        }
        if ((rank = (result = FDataSet.wrap((float[])fdata, (int[])naxis)).rank()) == 2) {
            MutablePropertyDataSet xx = DataSetUtil.tagGenDataSet((int)naxis[0], (double)(crval[0] - cdelt[0] * crpix[0]), (double)cdelt[0]);
            xx.putProperty("NAME", (Object)"axis0");
            result.putProperty("DEPEND_0", (Object)xx);
            xx = DataSetUtil.tagGenDataSet((int)naxis[1], (double)(crval[1] - cdelt[1] * crpix[1]), (double)cdelt[1]);
            xx.putProperty("NAME", (Object)"axis1");
            result.putProperty("DEPEND_1", (Object)xx);
            return DataSetOps.transpose2((QDataSet)result);
        }
        MutablePropertyDataSet xx = DataSetUtil.tagGenDataSet((int)naxis[2], (double)(crval[1] - cdelt[0] * crpix[0]), (double)cdelt[0]);
        xx.putProperty("NAME", (Object)"axis0");
        result.putProperty("DEPEND_2", (Object)xx);
        xx = DataSetUtil.tagGenDataSet((int)naxis[1], (double)(crval[1] - cdelt[1] * crpix[1]), (double)cdelt[1]);
        xx.putProperty("NAME", (Object)"axis1");
        result.putProperty("DEPEND_1", (Object)xx);
        xx = DataSetUtil.indexGenDataSet((int)naxis[0]);
        xx.putProperty("NAME", (Object)"bundle");
        result.putProperty("DEPEND_0", (Object)xx);
        return result;
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        int ihdu = 0;
        Map<String, Integer> plottable = FitsDataSourceFactory.getPlottable(this.uri, mon);
        String name = (String)this.getParams().get("arg_0");
        if (name != null) {
            ihdu = plottable.get(name);
        }
        FitsFile file = new FitsFile(this.getFile(mon));
        FitsHDUnit hdu = file.getHDUnit(ihdu);
        FitsMatrix dm = (FitsMatrix)hdu.getData();
        HashMap<String, Object> meta = new HashMap<String, Object>();
        Enumeration e = hdu.getHeader().getKeywords();
        while (e.hasMoreElements()) {
            Object val;
            FitsKeyword key = (FitsKeyword)e.nextElement();
            switch (key.getType()) {
                case 3: {
                    val = key.getBool();
                    break;
                }
                case 1: {
                    val = key.getComment();
                    break;
                }
                case 6: {
                    val = key.getDate();
                    break;
                }
                case 4: {
                    val = key.getInt();
                    break;
                }
                case 0: {
                    val = "NONE";
                    break;
                }
                case 5: {
                    val = key.getReal();
                    break;
                }
                case 2: {
                    val = key.getString();
                    break;
                }
                default: {
                    val = "????";
                }
            }
            meta.put(key.getName(), val);
        }
        return meta;
    }

    public MetadataModel getMetadataModel() {
        return new FitsMetadataModel();
    }
}

