/*
 * Decompiled with CFR 0.152.
 */
package org.virbo.datasource.wav;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.virbo.binarydatasource.BufferDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.dataset.QubeDataSetIterator;
import org.virbo.dataset.WritableDataSet;
import org.virbo.datasource.DataSourceFormat;
import org.virbo.datasource.URISplit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WavDataSourceFormat
implements DataSourceFormat {
    private ByteBuffer formatRank1(QDataSet data, ProgressMonitor mon, Map<String, String> params) {
        QDataSet dep0 = null;
        String type = params.get("type");
        int dep0Len = 0;
        int typeSize = BufferDataSet.byteCount((Object)type);
        int recSize = typeSize * (dep0Len + 1);
        int size = data.length() * recSize;
        ByteBuffer result = ByteBuffer.allocate(size);
        result.order("big".equals(params.get("byteOrder")) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        BufferDataSet ddata = BufferDataSet.makeDataSet((int)1, (int)recSize, (int)(dep0Len * typeSize), (int)data.length(), (int)1, (int)1, (int)1, (ByteBuffer)result, (Object)type);
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        while (it.hasNext()) {
            it.next();
            it.putValue((WritableDataSet)ddata, it.getValue(data));
        }
        if (dep0 != null) {
            BufferDataSet ddep0 = BufferDataSet.makeDataSet((int)1, (int)recSize, (int)(0 * typeSize), (int)data.length(), (int)1, (int)1, (int)1, (ByteBuffer)result, (Object)type);
            it = new QubeDataSetIterator(dep0);
            while (it.hasNext()) {
                it.next();
                it.putValue((WritableDataSet)ddep0, it.getValue(dep0));
            }
        }
        return result;
    }

    private ByteBuffer formatRank2(QDataSet data, ProgressMonitor mon, Map<String, String> params) {
        String type = params.get("type");
        int dep0Len = 0;
        int typeSize = BufferDataSet.byteCount((Object)type);
        int recSize = typeSize * (dep0Len + 1);
        int channels = data.length(0);
        int size = data.length() * recSize * channels;
        ByteBuffer result = ByteBuffer.allocate(size);
        result.order("big".equals(params.get("byteOrder")) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        BufferDataSet ddata = BufferDataSet.makeDataSet((int)2, (int)recSize, (int)(dep0Len * typeSize), (int)data.length(), (int)data.length(0), (int)1, (int)1, (ByteBuffer)result, (Object)type);
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        while (it.hasNext()) {
            it.next();
            it.putValue((WritableDataSet)ddata, it.getValue(data));
        }
        return result;
    }

    public static InputStream newInputStream(final ByteBuffer buf) {
        return new InputStream(){

            public synchronized int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get();
            }

            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                len = Math.min(len, buf.remaining());
                buf.get(bytes, off, len);
                return len;
            }
        };
    }

    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws IOException {
        ByteBuffer buf;
        AudioFormat outDataFormat;
        URISplit split = URISplit.parse((String)uri);
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        float samplesPerSecond = 8000.0f;
        if (dep0 != null && dep0.length() > 0) {
            Units u = (Units)dep0.property("UNITS");
            u = u == null ? Units.dimensionless : u.getOffsetUnits();
            UnitsConverter uc = u.getConverter(Units.seconds);
            double periodSeconds = uc.convert(dep0.value(1) - dep0.value(0));
            samplesPerSecond = Math.round(1.0 / periodSeconds);
        }
        if (data.rank() == 1) {
            outDataFormat = new AudioFormat(samplesPerSecond, 16, 1, true, false);
        } else if (data.rank() == 2) {
            outDataFormat = new AudioFormat(samplesPerSecond, 16, data.length(0), true, false);
        } else {
            throw new IllegalArgumentException("only rank 1 and rank 2 datasets supported");
        }
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("type", "short");
        params2.put("byteOrder", "little");
        if (data.rank() == 1) {
            buf = this.formatRank1(data, (ProgressMonitor)new NullProgressMonitor(), params2);
        } else if (data.rank() == 2) {
            buf = this.formatRank2(data, (ProgressMonitor)new NullProgressMonitor(), params2);
        } else {
            throw new IllegalArgumentException("only rank 1 and rank 2 datasets supported");
        }
        AudioInputStream inFileAIS = new AudioInputStream(WavDataSourceFormat.newInputStream(buf), outDataFormat, buf.capacity());
        File outFile = new File(split.resourceUri);
        if (AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, inFileAIS)) {
            int i = AudioSystem.write(inFileAIS, AudioFileFormat.Type.WAVE, outFile);
            inFileAIS.close();
            return;
        }
        throw new IllegalArgumentException("System doesn't support format to WAVE");
    }
}

