/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum;

import org.das2.datum.Basis;
import org.das2.datum.Datum;
import org.das2.datum.NumberUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;

public class LocationUnits
extends NumberUnits {
    Units offsetUnits;
    Basis basis;

    public LocationUnits(String id, String description, Units offsetUnits, Basis basis) {
        super(id, description);
        this.offsetUnits = offsetUnits;
        this.basis = basis;
    }

    public Units getOffsetUnits() {
        return this.offsetUnits;
    }

    public Basis getBasis() {
        return this.basis;
    }

    public Datum add(Number a, Number b, Units bUnits) {
        if (bUnits instanceof LocationUnits) {
            throw new IllegalArgumentException("You can't add " + this + " to " + bUnits + ", they both identify a location in a space");
        }
        Units offsetUnits = this.getOffsetUnits();
        if (bUnits != offsetUnits) {
            UnitsConverter uc = Units.getConverter(bUnits, offsetUnits);
            b = uc.convert(b);
        }
        return this.createDatum(LocationUnits.add(a, b));
    }

    public Datum divide(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("multiplication of locationUnits");
    }

    public Datum multiply(Number a, Number b, Units bUnits) {
        throw new IllegalArgumentException("division of locationUnits");
    }

    public Datum subtract(Number a, Number b, Units bUnits) {
        if (bUnits instanceof LocationUnits) {
            if (this != bUnits) {
                b = bUnits.getConverter(this).convert(b);
            }
            return this.getOffsetUnits().createDatum(LocationUnits.subtract(a, b));
        }
        if (bUnits != this.getOffsetUnits()) {
            b = bUnits.getConverter(this.getOffsetUnits()).convert(b);
        }
        return this.createDatum(LocationUnits.subtract(a, b));
    }
}

