/*
 * Decompiled with CFR 0.152.
 */
package org.das2.datum.format;

import java.util.IllegalFormatException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DefaultDatumFormatter;

public class FormatStringFormatter
extends DefaultDatumFormatter {
    private String format;
    private boolean units;
    private boolean integer;
    private static final Logger logger = Logger.getLogger("org.das2.datum.format");

    public FormatStringFormatter(String formatStr, boolean units) {
        if (!formatStr.contains("%")) {
            throw new IllegalArgumentException("formatStr doesn't contain percent (%)");
        }
        this.format = formatStr;
        this.units = units;
        try {
            String s = String.format(this.format, 0.0);
            logger.log(Level.FINEST, "format string results in {0}", s);
            this.integer = false;
        }
        catch (IllegalFormatException ex) {
            this.integer = true;
        }
    }

    public String format(Datum datum) {
        String s = this.format(datum, datum.getUnits());
        if (this.units) {
            s = s + " " + datum.getUnits().toString();
        }
        return s;
    }

    public String format(Datum datum, Units units) {
        if (UnitsUtil.isTimeLocation(datum.getUnits())) {
            throw new IllegalArgumentException("times not formatted");
        }
        if (this.integer) {
            return String.format(this.format, (int)datum.doubleValue(units));
        }
        return String.format(this.format, datum.doubleValue(units));
    }

    public String toString() {
        return String.format("FormatStringFormatter(%s)", this.format);
    }
}

