/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdaweb;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.cdaweb.CDAWebDB;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.fsm.FileStorageModelNew;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;
import org.virbo.cdf.CdfJavaDataSource;
import org.virbo.cdf.CdfVirtualVars;
import org.virbo.dataset.ArrayDataSet;
import org.virbo.dataset.DataSetUtil;
import org.virbo.dataset.MutablePropertyDataSet;
import org.virbo.dataset.QDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURI;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.datasource.DataSourceRegistry;
import org.virbo.datasource.MetadataModel;
import org.virbo.datasource.URISplit;
import org.virbo.datasource.capability.TimeSeriesBrowse;
import org.virbo.metatree.IstpMetadataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDAWebDataSource
extends AbstractDataSource {
    public static final String PARAM_ID = "id";
    public static final String PARAM_DS = "ds";
    public static final String PARAM_TIMERANGE = "timerange";
    Map<String, Object> metadata;
    DatumRange tr;
    String ds;
    String param;

    public CDAWebDataSource(URI uri) {
        super(uri);
        String timerange = this.getParam(PARAM_TIMERANGE, "2010-01-17").replaceAll("\\+", " ");
        try {
            this.tr = DatumRangeUtil.parseTimeRange((String)timerange);
        }
        catch (ParseException ex) {
            Logger.getLogger(CDAWebDataSource.class.getName()).log(Level.SEVERE, null, ex);
            throw new IllegalArgumentException(ex);
        }
        this.ds = this.getParam(PARAM_DS, "ac_k0_epm");
        this.param = this.getParam("arg_0", null);
        if (this.param == null) {
            this.param = this.getParam(PARAM_ID, "H_lo");
        }
        if (this.param == null) {
            throw new IllegalArgumentException("param not specified");
        }
    }

    private DataSourceFactory getDelegateFactory() {
        DataSourceFactory cdfFileDataSourceFactory = DataSourceRegistry.getInstance().getSource("cdfj");
        return cdfFileDataSourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        ArrayList problems;
        CDAWebDB db = CDAWebDB.getInstance();
        mon.started();
        MutablePropertyDataSet result = null;
        MutablePropertyDataSet accum = null;
        try {
            mon.setProgressMessage("refreshing database");
            try {
                db.maybeRefresh((ProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                mon.setProgressMessage("unable to connect via ftp");
                Thread.sleep(1000L);
                throw ex;
            }
            boolean webService = false;
            String[] files = null;
            String tmpl = db.getNaming(this.ds.toUpperCase());
            String base = db.getBaseUrl(this.ds.toUpperCase());
            FileSystem fs = FileSystem.create((URI)new URI(base));
            FileStorageModelNew fsm = FileStorageModelNew.create((FileSystem)fs, (String)tmpl);
            files = webService ? db.getFilesAndRanges(this.ds.toUpperCase(), this.tr) : fsm.getBestNamesFor(this.tr, (ProgressMonitor)new NullProgressMonitor());
            DataSourceFactory cdfFileDataSourceFactory = this.getDelegateFactory();
            mon.setTaskSize((long)(files.length * 10));
            mon.started();
            mon.setProgressMessage("get metadata");
            this.getMetadata(mon);
            mon.started();
            String virtual = (String)this.metadata.get("VIRTUAL");
            DatumRange range = null;
            for (int i = 0; i < files.length && !mon.isCancelled(); ++i) {
                DatumRange range1 = null;
                String file = files[i];
                String[] ss = file.split("\\|");
                if (webService) {
                    file = ss[0];
                    range1 = DatumRangeUtil.parseTimeRange((String)(ss[1] + " to " + ss[2]));
                }
                mon.setTaskProgress((long)(i * 10));
                mon.setProgressMessage("load " + file);
                SubTaskMonitor t1 = SubTaskMonitor.create((ProgressMonitor)mon, (long)(i * 10), (long)((i + 1) * 10));
                MutablePropertyDataSet ds1 = null;
                if (virtual != null && !virtual.equals("")) {
                    int nc = 0;
                    ArrayList<MutablePropertyDataSet> comps = new ArrayList<MutablePropertyDataSet>();
                    String function = (String)this.metadata.get("FUNCTION");
                    if (function == null) {
                        function = (String)this.metadata.get("FUNCT");
                    }
                    if (function == null) throw new IllegalArgumentException("The virtual variable " + this.param + " cannot be plotted because the function is not identified");
                    String comp = (String)this.metadata.get("COMPONENT_" + nc);
                    while (comp != null) {
                        HashMap<String, String> fileParams = new HashMap<String, String>(this.getParams());
                        fileParams.remove(PARAM_TIMERANGE);
                        fileParams.remove(PARAM_DS);
                        fileParams.put(PARAM_ID, comp);
                        URI file1 = webService ? new URI(file + "?" + URISplit.formatParams(fileParams)) : fs.getRootURI().resolve(file + "?" + URISplit.formatParams(fileParams));
                        CdfJavaDataSource dataSource = (CdfJavaDataSource)cdfFileDataSourceFactory.getDataSource(file1);
                        ds1 = (MutablePropertyDataSet)dataSource.getDataSet((ProgressMonitor)t1);
                        comps.add(ds1);
                        comp = (String)this.metadata.get("COMPONENT_" + ++nc);
                    }
                    try {
                        Map qmetadata = new IstpMetadataModel().properties(this.metadata);
                        ds1 = (MutablePropertyDataSet)CdfVirtualVars.execute((Map)qmetadata, (String)function, comps, (ProgressMonitor)mon);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new IllegalArgumentException("The virtual variable " + this.param + " cannot be plotted because the function is not supported: " + function);
                    }
                } else {
                    HashMap fileParams = new HashMap(this.getParams());
                    fileParams.remove(PARAM_TIMERANGE);
                    fileParams.remove(PARAM_DS);
                    URI file1 = webService ? new URI(file + "?" + URISplit.formatParams(fileParams)) : fs.getRootURI().resolve(file + "?" + URISplit.formatParams(fileParams));
                    System.err.println("loading " + file1);
                    CdfJavaDataSource dataSource = (CdfJavaDataSource)cdfFileDataSourceFactory.getDataSource(file1);
                    ds1 = (MutablePropertyDataSet)dataSource.getDataSet((ProgressMonitor)t1, this.metadata);
                }
                if (result == null && accum == null) {
                    DatumRange datumRange = range = webService ? range1 : fsm.getRangeFor(files[i]);
                    if (files.length == 1) {
                        result = ds1;
                        continue;
                    }
                    accum = ArrayDataSet.maybeCopy((QDataSet)ds1);
                    accum.grow(accum.length() * files.length * 11 / 10);
                    continue;
                }
                ArrayDataSet ads1 = ArrayDataSet.maybeCopy((Class)accum.getComponentType(), (QDataSet)ds1);
                if (accum.canAppend(ads1)) {
                    accum.append(ads1);
                } else {
                    accum.grow(accum.length() + ads1.length() * (files.length - i));
                    accum.append(ads1);
                }
                range = DatumRangeUtil.union((DatumRange)range, (DatumRange)(webService ? range1 : fsm.getRangeFor(files[i])));
            }
            if (result == null) {
                result = accum;
            }
            if (result != null && result.rank() == 2) {
                QDataSet labels = (QDataSet)result.property("DEPEND_1");
                String labelVar = (String)this.metadata.get("LABL_PTR_1");
                if (labels == null && labelVar != null) {
                    String master = db.getMasterFile(this.ds.toLowerCase(), mon);
                    DataSource labelDss = this.getDelegateFactory().getDataSource(DataSetURI.getURI((String)(master + "?" + labelVar)));
                    MutablePropertyDataSet labelDs = (MutablePropertyDataSet)labelDss.getDataSet((ProgressMonitor)new NullProgressMonitor());
                    if (labelDs != null) {
                        if (labelDs.rank() > 1 && labelDs.length() == 1) {
                            labelDs = labelDs.slice(0);
                        }
                        result.putProperty("DEPEND_1", (Object)labelDs);
                    }
                }
            }
            if (result != null) {
                MutablePropertyDataSet dep0 = (MutablePropertyDataSet)result.property("DEPEND_0");
                if (dep0 != null && range != null) {
                    Units dep0units = (Units)dep0.property("UNITS");
                    dep0.putProperty("TYPICAL_MIN", (Object)range.min().doubleValue(dep0units));
                    dep0.putProperty("TYPICAL_MAX", (Object)range.max().doubleValue(dep0units));
                }
                HashMap<String, String> user = new HashMap<String, String>();
                for (int i = 0; i < Math.min(files.length, 10); ++i) {
                    user.put("delegate_" + i, fs.toString() + files[i]);
                }
                if (files.length >= 10) {
                    user.put("delegate_10", files.length - 10 + " more files from " + base + "/" + tmpl);
                }
                result.putProperty("USER_PROPERTIES", user);
            }
        }
        finally {
            mon.finished();
        }
        if (result == null || DataSetUtil.validate(result, problems = new ArrayList())) return result;
        throw new Exception("calculated dataset is not well-formed: " + this.uri);
    }

    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        if (this.metadata == null) {
            CDAWebDB db = CDAWebDB.getInstance();
            String master = db.getMasterFile(this.ds.toLowerCase(), mon);
            DataSource cdf = this.getDelegateFactory().getDataSource(DataSetURI.getURI((String)(master + "?" + this.param)));
            this.metadata = cdf.getMetadata(mon);
        }
        return this.metadata;
    }

    public MetadataModel getMetadataModel() {
        return new IstpMetadataModel();
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new TimeSeriesBrowse(){

                public void setTimeRange(DatumRange dr) {
                    CDAWebDataSource.this.tr = dr;
                }

                public DatumRange getTimeRange() {
                    return CDAWebDataSource.this.tr;
                }

                public void setTimeResolution(Datum d) {
                }

                public Datum getTimeResolution() {
                    return null;
                }

                public String getURI() {
                    return "vap+cdaweb:ds=" + CDAWebDataSource.this.ds + "&id=" + CDAWebDataSource.this.param + "&timerange=" + CDAWebDataSource.this.tr.toString().replace(" ", "+");
                }

                public void setURI(String suri) throws ParseException {
                    URISplit split = URISplit.parse((String)suri);
                    LinkedHashMap params = URISplit.parseParams((String)split.params);
                    CDAWebDataSource.this.tr = DatumRangeUtil.parseTimeRange((String)((String)params.get(CDAWebDataSource.PARAM_TIMERANGE)));
                }
            };
        }
        return null;
    }

    public static void main(String[] args) throws URISyntaxException, Exception {
        CDAWebDataSource dss = new CDAWebDataSource(new URI("vap+cdaweb:file:///foo.xml?ds=cl_sp_fgm&id=B_mag&timerange=2001-10-10"));
        QDataSet ds = dss.getDataSet((ProgressMonitor)new NullProgressMonitor());
        System.err.println(ds);
    }
}

